/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.helper;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.imsc.dmw.consts.ImpTarCloudEnum;
import kd.imsc.dmw.helper.license.LicenseHelper;

public class PermissionHelper {
    private static final Log logger = LogFactory.getLog(PermissionHelper.class);
    private static final String LICENCES_KEY = "i_t_l_p";

    public static boolean hasPermission(String entityNumber, String permItem) {
        if (StringUtils.isEmpty((String)entityNumber)) {
            return false;
        }
        String appId = EntityMetadataCache.getDataEntityType((String)entityNumber).getAppId();
        return PermissionServiceHelper.checkPermission((Long)UserServiceHelper.getCurrentUserId(), (String)appId, (String)entityNumber, (String)permItem);
    }

    public static QFilter buildImpTargetQFilter(IFormView formView) {
        QFilter qFilter;
        Boolean value;
        String key;
        Set<Map.Entry<String, Boolean>> entries;
        ImpTarCloudEnum[] values;
        if (formView == null) {
            return null;
        }
        String licenceKey = formView.getPageCache().get(LICENCES_KEY);
        if (StringUtils.isNotEmpty((String)licenceKey)) {
            return QFilter.of((String)licenceKey, (Object[])new Object[0]);
        }
        ArrayList<String> allowList = new ArrayList<String>(4);
        ArrayList<String> cloudList = new ArrayList<String>(4);
        ArrayList<String> featureList = new ArrayList<String>(4);
        block5: for (ImpTarCloudEnum value2 : values = ImpTarCloudEnum.values()) {
            switch (value2.getType()) {
                case 0: {
                    allowList.add(value2.getCode());
                    continue block5;
                }
                case 1: {
                    cloudList.add(value2.getCode());
                    continue block5;
                }
                case 2: {
                    featureList.add(value2.getCode());
                    continue block5;
                }
            }
        }
        QFilter filter = null;
        if (CollectionUtils.isNotEmpty(allowList)) {
            logger.info("Check Base {}", allowList);
            filter = new QFilter("cloud", "in", allowList);
        }
        if (CollectionUtils.isNotEmpty(cloudList)) {
            Map<String, Boolean> licenceMap = LicenseHelper.checkLicenseByModules(cloudList);
            logger.info("Check License {}", (Object)JSON.toJSONString(licenceMap));
            if (licenceMap != null && !licenceMap.isEmpty()) {
                ArrayList<String> keyList = new ArrayList<String>(licenceMap.size());
                entries = licenceMap.entrySet();
                for (Map.Entry<String, Boolean> entry : entries) {
                    key = entry.getKey();
                    value = entry.getValue();
                    if (value == null || !value.booleanValue()) continue;
                    keyList.add(key);
                }
                if (CollectionUtils.isNotEmpty(keyList)) {
                    qFilter = new QFilter("checkgroup", "=", (Object)String.valueOf(1)).and("cloud", "in", keyList);
                    if (filter == null) {
                        filter = qFilter;
                    } else {
                        filter.or(qFilter);
                    }
                }
            }
        }
        if (CollectionUtils.isNotEmpty(featureList)) {
            Map<String, Boolean> groupMap = LicenseHelper.checkLicenseByGroups(cloudList);
            logger.info("Check feature {}", (Object)JSON.toJSONString(groupMap));
            if (groupMap != null && !groupMap.isEmpty()) {
                ArrayList<String> keyList = new ArrayList<String>(groupMap.size());
                entries = groupMap.entrySet();
                for (Map.Entry<String, Boolean> entry : entries) {
                    key = entry.getKey();
                    value = entry.getValue();
                    if (value == null || !value.booleanValue()) continue;
                    keyList.add(key);
                }
                if (CollectionUtils.isNotEmpty(keyList)) {
                    qFilter = new QFilter("checkgroup", "=", (Object)String.valueOf(2)).and("cloud", "in", keyList);
                    if (filter == null) {
                        filter = qFilter;
                    } else {
                        filter.or(qFilter);
                    }
                }
            }
        }
        if (filter != null) {
            formView.getPageCache().put(LICENCES_KEY, filter.toString());
        }
        return filter;
    }
}

