/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.helper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imsc.dmw.engine.multiimport.model.FieldMappingModel;
import kd.imsc.dmw.engine.multiimport.model.ImportTargetInfoModel;
import kd.imsc.dmw.engine.multiimport.model.ViewSchemeBaseInfoModel;
import kd.imsc.dmw.engine.multiimport.model.ViewSchemeMappingInfoModel;
import kd.imsc.dmw.enums.SelectValueEnum;
import kd.imsc.dmw.errorcode.DmwImptException;
import kd.imsc.dmw.helper.TemplateMappingHelper;
import kd.imsc.dmw.utils.DynamicObjectUtils;
import kd.imsc.dmw.utils.StringUtil;
import kd.imsc.dmw.utils.StringUtils;

public class SchemeDataPackageTransHelper {
    private static final Map<String, String> useStatusMap = new HashMap<String, String>(4);
    private static final Map<String, String> sharedStatusMap = new HashMap<String, String>(4);

    private SchemeDataPackageTransHelper() {
    }

    public static DynamicObject guideToDetails(DynamicObject guideDynamicObject, Map<String, DynamicObject> schemeFieldMappingConfig, String modelInfo, long id, OperationStatus operation) {
        DynamicObject schemeDataPackage = id != 0L ? BusinessDataServiceHelper.loadSingle((Object)id, (String)"dmw_impscheme") : DynamicObjectUtils.buildDynamicObject("dmw_impscheme");
        if (schemeDataPackage == null) {
            return null;
        }
        SchemeDataPackageTransHelper.setDetailsHeader(schemeDataPackage, guideDynamicObject, operation);
        if (modelInfo != null && !modelInfo.isEmpty()) {
            schemeDataPackage.set("modelinfo_tag", (Object)modelInfo);
        }
        DynamicObjectCollection entryList = schemeDataPackage.getDynamicObjectCollection("entryentity");
        if (id != 0L) {
            entryList.clear();
        }
        SchemeDataPackageTransHelper.setDetailsEntryEntity(entryList, schemeFieldMappingConfig);
        return schemeDataPackage;
    }

    private static void setDetailsHeader(DynamicObject schemeDataPackage, DynamicObject guideHeader, OperationStatus operation) {
        if (schemeDataPackage == null || guideHeader == null) {
            return;
        }
        if (guideHeader.containsProperty("billno")) {
            schemeDataPackage.set("number", (Object)guideHeader.getString("billno"));
        } else {
            String number = DynamicObjectUtils.autoNumber(schemeDataPackage, "dmw_impscheme", null);
            if (number == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8f6c\u5316\u6570\u636e\u5305\u65f6\u751f\u6210\u65b9\u6848\u7f16\u7801\u5931\u8d25\uff01", (String)"SchemeDataPackageTransHelper_0", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            }
            schemeDataPackage.set("number", (Object)number);
        }
        if (!guideHeader.containsProperty("billname")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8f6c\u5316\u6570\u636e\u5305\u65f6\u672a\u627e\u5230\u65b9\u6848\u540d\u79f0\uff01", (String)"SchemeDataPackageTransHelper_1", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        }
        schemeDataPackage.set("name", (Object)guideHeader.getString("billname"));
        if (guideHeader.containsProperty("usestatus")) {
            String useStatus = SchemeDataPackageTransHelper.transUseStatus(guideHeader.getString("usestatus"));
            schemeDataPackage.set("enable", (Object)(useStatus == null ? "1" : useStatus));
        }
        schemeDataPackage.set("status", (Object)"C");
        if (guideHeader.containsProperty("sharestatus")) {
            String sharedStatus = SchemeDataPackageTransHelper.transSharedStatus(guideHeader.getString("sharestatus"));
            schemeDataPackage.set("shared", (Object)(sharedStatus == null ? "0" : sharedStatus));
        }
        if (guideHeader.containsProperty("schemedesc")) {
            schemeDataPackage.set("desc", (Object)guideHeader.getString("schemedesc"));
        }
        if (!guideHeader.containsProperty("targetobjs")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8f6c\u5316\u6570\u636e\u5305\u65f6\u672a\u627e\u5230\u4e1a\u52a1\u5bf9\u8c61\uff01", (String)"SchemeDataPackageTransHelper_2", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        }
        DynamicObjectCollection dynamicObjectCollection = guideHeader.getDynamicObjectCollection("targetobjs");
        DynamicObjectCollection bizDataCollection = schemeDataPackage.getDynamicObjectCollection("tarmeta");
        DynamicObjectCollection collection = SchemeDataPackageTransHelper.transMulDynamic(dynamicObjectCollection, bizDataCollection);
        schemeDataPackage.set("tarmeta", (Object)collection);
        long currUserId = RequestContext.get().getCurrUserId();
        Date date = new Date();
        if (OperationStatus.EDIT.equals((Object)operation)) {
            schemeDataPackage.set("modifier", (Object)currUserId);
            schemeDataPackage.set("modifytime", (Object)date);
        } else {
            schemeDataPackage.set("creator", (Object)currUserId);
            schemeDataPackage.set("modifier", (Object)currUserId);
            schemeDataPackage.set("createtime", (Object)date);
            schemeDataPackage.set("modifytime", (Object)date);
            if ("0".equals(schemeDataPackage.getString("enable"))) {
                schemeDataPackage.set("disabler", (Object)currUserId);
                schemeDataPackage.set("disabledate", (Object)date);
            }
        }
    }

    private static void setDetailsEntryEntity(DynamicObjectCollection entryList, Map<String, DynamicObject> schemeFieldMappingConfig) {
        if (entryList == null || schemeFieldMappingConfig == null) {
            return;
        }
        Set<String> formIdSet = schemeFieldMappingConfig.keySet();
        List<ImportTargetInfoModel> infoModelList = SchemeDataPackageTransHelper.getTargetFromId(formIdSet);
        StringBuilder errorMsg = new StringBuilder();
        for (ImportTargetInfoModel infoModel : infoModelList) {
            DynamicObject guideEntry = schemeFieldMappingConfig.get(infoModel.getFormId());
            DynamicObject detailEntry = entryList.addNew();
            SchemeDataPackageTransHelper.addDetailsRow(detailEntry, guideEntry, infoModel.getId());
            DynamicObjectCollection subEntityDataList = guideEntry.getDynamicObjectCollection("entryentity");
            for (DynamicObject subEntityData : subEntityDataList) {
                if (!StringUtil.isNotEmpty(subEntityData.get("formula")) || !StringUtil.isEmpty(subEntityData.get("formula_tag"))) continue;
                errorMsg.append(String.format(ResManager.loadKDString((String)"%1$s\u5bf9\u8c61\u7b2c%2$s\u884c\u201c%3$s\u201d\u7684\u8ba1\u7b97\u516c\u5f0f\u914d\u7f6e\u5f02\u5e38\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e\u516c\u5f0f\u3002", (String)"SchemeDataPackageTransHelper_5", (String)"imsc-dmw-platform", (Object[])new Object[0]), infoModel.getName(), subEntityData.getInt("seq"), subEntityData.getString("stdfieldname"))).append("\n");
            }
        }
        if (errorMsg.length() > 0) {
            throw new KDBizException(errorMsg.toString());
        }
    }

    private static void addDetailsRow(DynamicObject detailEntry, DynamicObject guideEntry, Long formId) {
        if (detailEntry == null || guideEntry == null || formId == null) {
            return;
        }
        detailEntry.set("billentity", (Object)formId);
        if (guideEntry.containsProperty("mul_template_sheet_combo")) {
            detailEntry.set("sourcesheet", (Object)guideEntry.getString("mul_template_sheet_combo"));
        }
        if (guideEntry.containsProperty("sheet_rele_combo")) {
            detailEntry.set("relpropname", (Object)guideEntry.getString("sheet_rele_combo"));
        }
        if (guideEntry.containsProperty("std_import_way")) {
            detailEntry.set("importtype", (Object)guideEntry.getString("std_import_way"));
        }
        if (guideEntry.containsProperty("std_import_rele")) {
            detailEntry.set("replacekeyfield", (Object)guideEntry.getString("std_import_rele"));
        }
        DynamicObjectCollection subEntryCollection = detailEntry.getDynamicObjectCollection("subentryentity");
        DynamicObjectCollection subEntityDataList = guideEntry.getDynamicObjectCollection("entryentity");
        if (!ObjectUtils.isEmpty((Object)subEntityDataList)) {
            SchemeDataPackageTransHelper.setDetailsSubEntryEntity(subEntryCollection, subEntityDataList);
        }
    }

    private static void setDetailsSubEntryEntity(DynamicObjectCollection subEntryCollection, DynamicObjectCollection subEntityDataList) {
        if (subEntryCollection == null || ObjectUtils.isEmpty((Object)subEntityDataList)) {
            return;
        }
        for (DynamicObject subEntryData : subEntityDataList) {
            DynamicObject data = subEntryCollection.addNew();
            if (subEntryData.containsProperty("stdpartname")) {
                data.set("stdpartname", (Object)subEntryData.getString("stdpartname"));
            }
            if (subEntryData.containsProperty("stdfieldname")) {
                data.set("fieldname", (Object)subEntryData.getString("stdfieldname"));
            }
            if (subEntryData.containsProperty("stdfieldid")) {
                data.set("fieldnumber", (Object)subEntryData.getString("stdfieldid"));
            }
            if (subEntryData.containsProperty("stdfieldrequired")) {
                data.set("mustinput", (Object)subEntryData.getString("stdfieldrequired"));
            }
            if (subEntryData.containsProperty("sheetfield")) {
                data.set("textfield", (Object)subEntryData.getString("sheetfield"));
            }
            if (subEntryData.containsProperty("selectvalue")) {
                data.set("selectvalue", (Object)subEntryData.getString("selectvalue"));
            }
            if (subEntryData.containsProperty("formuladesc")) {
                data.set("formuladesc", (Object)subEntryData.getString("formuladesc"));
            }
            if (!subEntryData.containsProperty("formula")) continue;
            data.set("formula", (Object)subEntryData.getString("formula"));
            data.set("formula_tag", (Object)subEntryData.getString("formula_tag"));
        }
    }

    private static String transUseStatus(String key) {
        return key == null ? null : useStatusMap.get(key);
    }

    private static String transSharedStatus(String key) {
        return key == null ? null : sharedStatusMap.get(key);
    }

    private static DynamicObjectCollection transMulDynamic(DynamicObjectCollection collection, DynamicObjectCollection bizDataCollection) {
        DynamicObjectCollection result = new DynamicObjectCollection();
        if (collection == null || collection.isEmpty()) {
            return result;
        }
        collection.forEach(e -> {
            DynamicObject dynamicObject = bizDataCollection.addNew();
            dynamicObject.set("fbasedataid", (Object)e.getDynamicObject("fbasedataid"));
            result.add((Object)dynamicObject);
        });
        return result;
    }

    private static List<ImportTargetInfoModel> getTargetFromId(Set<String> numberSet) {
        if (ObjectUtils.isEmpty(numberSet)) {
            return Collections.emptyList();
        }
        QFilter filter = new QFilter("target_formid", "in", numberSet);
        Object[] dynamicObjects = BusinessDataServiceHelper.load((String)"dmw_importtarget", (String)"id,targetformid,name,order", (QFilter[])new QFilter[]{filter}, (String)"order asc");
        if (ObjectUtils.isEmpty((Object[])dynamicObjects)) {
            return Collections.emptyList();
        }
        ArrayList<ImportTargetInfoModel> result = new ArrayList<ImportTargetInfoModel>(dynamicObjects.length);
        for (Object dynamicObject : dynamicObjects) {
            ImportTargetInfoModel infoModel = new ImportTargetInfoModel();
            infoModel.setId(dynamicObject.getLong("id"));
            infoModel.setFormId(dynamicObject.getString("target_formid"));
            infoModel.setOrder(dynamicObject.getInt("order"));
            infoModel.setName(dynamicObject.getString("name"));
            result.add(infoModel);
        }
        return result;
    }

    public static void handleFilePackage(Map<String, Object> attachmentpanelap, DynamicObject schemeData) {
        if (schemeData == null || ObjectUtils.isEmpty(attachmentpanelap)) {
            return;
        }
        attachmentpanelap.put("billPkId", schemeData.get("id"));
        attachmentpanelap.put("entityNum", "dmw_impscheme");
        attachmentpanelap.put("billno", "dmw_impscheme");
        attachmentpanelap.put("creator", schemeData.get("creator"));
        attachmentpanelap.put("createdate", schemeData.get("createtime"));
        attachmentpanelap.put("attachmentpanel", "attachmentpanelap");
    }

    public static DynamicObject getSchemeDetailByPkId(long pkid) {
        if (pkid == 0L) {
            return null;
        }
        return BusinessDataServiceHelper.loadSingle((Object)pkid, (String)"dmw_impscheme");
    }

    public static ViewSchemeBaseInfoModel schemeDetailToGuideBaseInfoParse(long pkId) {
        DynamicObject detailObj = SchemeDataPackageTransHelper.getSchemeDetailByPkId(pkId);
        return SchemeDataPackageTransHelper.schemeDetailBaseInfoParse(pkId, detailObj);
    }

    public static ViewSchemeBaseInfoModel schemeDetailBaseInfoParse(long pkId, DynamicObject detailObj) {
        if (detailObj == null) {
            return null;
        }
        ViewSchemeBaseInfoModel infoModel = new ViewSchemeBaseInfoModel();
        infoModel.setNumber(detailObj.getString("number"));
        infoModel.setName(detailObj.getString("name"));
        infoModel.setTargetObjs(detailObj.get("tarmeta"));
        infoModel.setUseStatus(useStatusMap.get(detailObj.getString("enable")));
        infoModel.setShare(sharedStatusMap.get(detailObj.getString("shared")));
        infoModel.setDesc(detailObj.getString("desc"));
        infoModel.setTemplateInfo(detailObj.getString("modelinfo_tag"));
        List attachList = AttachmentServiceHelper.getAttachments((String)"dmw_impscheme", (Object)pkId, (String)"attachmentpanelap", (boolean)false);
        if (attachList != null && !attachList.isEmpty()) {
            infoModel.setAttachMap((Map)attachList.get(0));
        }
        return infoModel;
    }

    public static Map<String, ViewSchemeMappingInfoModel> schemeMappingInfoModelParse(long pkId) {
        DynamicObject detailObj = SchemeDataPackageTransHelper.getSchemeDetailByPkId(pkId);
        return SchemeDataPackageTransHelper.getSchemeMappingInfoModelMap(detailObj, false);
    }

    public static Map<String, ViewSchemeMappingInfoModel> getSchemeMappingInfoModelMap(DynamicObject detailObj, boolean buildList) {
        if (detailObj == null) {
            return new HashMap<String, ViewSchemeMappingInfoModel>(1);
        }
        DynamicObjectCollection targetCollection = detailObj.getDynamicObjectCollection("entryentity");
        if (targetCollection == null || targetCollection.isEmpty()) {
            return new HashMap<String, ViewSchemeMappingInfoModel>(1);
        }
        HashMap<String, ViewSchemeMappingInfoModel> result = new HashMap<String, ViewSchemeMappingInfoModel>(8);
        for (DynamicObject targetDyObj : targetCollection) {
            String targetName = targetDyObj.getDynamicObject("billentity").getString("target_formid");
            ViewSchemeMappingInfoModel infoModel = SchemeDataPackageTransHelper.detailMappingInfoModel(targetDyObj, buildList);
            result.put(targetName, infoModel);
        }
        return result;
    }

    private static ViewSchemeMappingInfoModel detailMappingInfoModel(DynamicObject targetDy, boolean buildList) {
        ViewSchemeMappingInfoModel infoModel = new ViewSchemeMappingInfoModel();
        infoModel.setMulSheets(targetDy.getString("sourcesheet"));
        infoModel.setSheetReleValue(targetDy.getString("relpropname"));
        infoModel.setImportWay(targetDy.getString("importtype"));
        infoModel.setKeyFields(targetDy.getString("replacekeyfield"));
        DynamicObjectCollection mappingDyCollection = targetDy.getDynamicObjectCollection("subentryentity");
        if (mappingDyCollection != null) {
            HashMap<String, String> fieldMap = new HashMap<String, String>(16);
            ArrayList<FieldMappingModel> fieldMappingModelList = new ArrayList<FieldMappingModel>(16);
            HashMap<String, Map<String, String>> formulaDescMap = new HashMap<String, Map<String, String>>(16);
            for (DynamicObject mappingdy : mappingDyCollection) {
                String formulaDesc;
                String textField = mappingdy.getString("textfield");
                if (StringUtils.isNotEmpty(textField)) {
                    fieldMap.put(mappingdy.getString("fieldnumber"), textField);
                }
                if (StringUtils.isNotEmpty(formulaDesc = mappingdy.getString("formuladesc"))) {
                    HashMap<String, String> map = new HashMap<String, String>(3);
                    String selectValue = mappingdy.getString("selectvalue");
                    if (StringUtils.isEmpty(selectValue)) {
                        selectValue = SelectValueEnum.SOURCEFIELD.getValue();
                    }
                    map.put("selectvalue", selectValue);
                    map.put("formuladesc", formulaDesc);
                    map.put("formula", mappingdy.getString("formula"));
                    map.put("formula_tag", mappingdy.getString("formula_tag"));
                    formulaDescMap.put(mappingdy.getString("fieldnumber"), map);
                }
                if (!buildList) continue;
                FieldMappingModel fieldMappingValue = new FieldMappingModel();
                fieldMappingValue.setStdFieldId(mappingdy.getString("fieldnumber"));
                fieldMappingValue.setStdPartName(mappingdy.getString("stdpartname"));
                fieldMappingValue.setStdFieldName(mappingdy.getString("fieldname"));
                fieldMappingValue.setNull("1".equals(mappingdy.getString("mustinput")));
                fieldMappingValue.setSheetField(mappingdy.getString("textfield"));
                fieldMappingModelList.add(fieldMappingValue);
            }
            infoModel.setFieldMappingValue(fieldMap);
            infoModel.setFormulaDescMap(formulaDescMap);
            if (buildList) {
                infoModel.setFieldMappingModelList(fieldMappingModelList);
            }
        }
        return infoModel;
    }

    public static DynamicObject schemeDetailBaseInfoToDyObj(ViewSchemeBaseInfoModel baseInfoModel) throws DmwImptException {
        if (baseInfoModel == null) {
            return null;
        }
        DynamicObject baseDyObj = BusinessDataServiceHelper.newDynamicObject((String)"dmw_importschemeguide");
        baseDyObj.set("billname", (Object)baseInfoModel.getName());
        baseDyObj.set("usestatus", (Object)"disable");
        baseDyObj.set("sharestatus", (Object)"private");
        baseDyObj.set("schemedesc", (Object)baseInfoModel.getDesc());
        SchemeDataPackageTransHelper.buildSchemeTargetCollection((MulBasedataDynamicObjectCollection)baseDyObj.get("targetobjs"), baseInfoModel.getTarget());
        return baseDyObj;
    }

    private static void buildSchemeTargetCollection(MulBasedataDynamicObjectCollection result, List<String> formIdList) throws DmwImptException {
        if (formIdList == null || formIdList.isEmpty()) {
            return;
        }
        for (String formId : formIdList) {
            DynamicObject tDyObj = TemplateMappingHelper.getImportTargetDyByFormId(formId);
            if (tDyObj == null) {
                throw new DmwImptException(String.format(ResManager.loadKDString((String)"\u65b9\u6848\u4fe1\u606f\u4e2d\u5b58\u5728\u4e0d\u652f\u6301[%1$s]\u7684\u76ee\u6807\u4e1a\u52a1\u5bf9\u8c61\u3002", (String)"SchemeDataPackageTransHelper_3", (String)"imsc-dmw-platform", (Object[])new Object[0]), formId), 2001);
            }
            DynamicObject dynamicObject = result.addNew();
            dynamicObject.set("fbasedataid", (Object)tDyObj);
        }
    }

    public static Map<String, DynamicObject> buildSchemeMapToDyCollection(Map<String, ViewSchemeMappingInfoModel> mapInfoModel) throws DmwImptException {
        if (mapInfoModel == null || mapInfoModel.isEmpty()) {
            throw new DmwImptException(ResManager.loadKDString((String)"\u65e0\u4efb\u4f55\u7684\u76ee\u6807\u4e1a\u52a1\u5bf9\u8c61\u6620\u5c04\u5173\u7cfb", (String)"SchemeDataPackageTransHelper_4", (String)"imsc-dmw-platform", (Object[])new Object[0]), 2001);
        }
        HashMap<String, DynamicObject> targetMap = new HashMap<String, DynamicObject>(mapInfoModel.size());
        for (Map.Entry<String, ViewSchemeMappingInfoModel> entry : mapInfoModel.entrySet()) {
            targetMap.put(entry.getKey(), SchemeDataPackageTransHelper.buildTargetMapDyObj(entry.getValue()));
        }
        return targetMap;
    }

    private static DynamicObject buildTargetMapDyObj(ViewSchemeMappingInfoModel mapInfoValue) {
        List<FieldMappingModel> fieldMappingModelList;
        DynamicObject targetMapDyObj = BusinessDataServiceHelper.newDynamicObject((String)"dmw_schemefieldmapping");
        targetMapDyObj.set("mul_template_sheet_combo", (Object)mapInfoValue.getMulSheets());
        if (StringUtils.isNotEmpty(mapInfoValue.getSheetReleValue())) {
            targetMapDyObj.set("sheet_rele_combo", (Object)mapInfoValue.getSheetReleValue());
        }
        if (StringUtils.isNotEmpty(mapInfoValue.getImportWay())) {
            targetMapDyObj.set("std_import_way", (Object)mapInfoValue.getImportWay());
        }
        if (StringUtils.isNotEmpty(mapInfoValue.getKeyFields())) {
            targetMapDyObj.set("std_import_rele", (Object)mapInfoValue.getKeyFields());
        }
        if ((fieldMappingModelList = mapInfoValue.getFieldMappingModelList()) == null || fieldMappingModelList.isEmpty()) {
            return targetMapDyObj;
        }
        DynamicObjectCollection collection = targetMapDyObj.getDynamicObjectCollection("entryentity");
        for (FieldMappingModel model : fieldMappingModelList) {
            DynamicObject dynamicObject = collection.addNew();
            dynamicObject.set("stdfieldid", (Object)model.getStdFieldId());
            dynamicObject.set("stdpartname", (Object)model.getStdPartName());
            dynamicObject.set("stdfieldname", (Object)model.getStdFieldName());
            dynamicObject.set("stdfieldrequired", (Object)(!model.isNull() ? null : "1"));
            dynamicObject.set("sheetfield", (Object)model.getSheetField());
        }
        return targetMapDyObj;
    }

    static {
        useStatusMap.put("enable", "1");
        useStatusMap.put("disable", "0");
        useStatusMap.put("1", "enable");
        useStatusMap.put("0", "disable");
        sharedStatusMap.put("public", "1");
        sharedStatusMap.put("private", "0");
        sharedStatusMap.put("1", "public");
        sharedStatusMap.put("0", "private");
    }
}

