/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.helper;

import java.util.List;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.filter.FilterUtil;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.list.ListShowParameter;
import kd.bos.util.StringUtils;

public class ShowFormHelper {
    private static final String PERM_IGNORE_CHECKAPP = "PERM_IGNORE_CHECKAPP";

    public static BillShowParameter showForm(String formId, Long pkid, CloseCallBack closeCallBack, ShowType showType, OperationStatus operationStatus, Map<String, Object> customParams) {
        if (StringUtils.isEmpty((String)formId)) {
            throw new KDBizException(ResManager.loadKDString((String)"showFrom exception : \u83b7\u53d6\u4e0d\u5230\u8868\u5355\u6807\u8bc6\uff0c\u65e0\u6cd5\u6784\u5efa\u8868\u5355\uff01", (String)"ShowFormHelper_0", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        }
        BillShowParameter fsp = new BillShowParameter();
        if (showType == null) {
            showType = ShowType.Default;
        }
        fsp.getOpenStyle().setShowType(showType);
        if (pkid != null) {
            fsp.setPkId((Object)pkid);
        }
        fsp.setFormId(formId);
        fsp.setShowTitle(false);
        if (operationStatus != null) {
            fsp.setStatus(operationStatus);
        }
        if (closeCallBack != null) {
            fsp.setCloseCallBack(closeCallBack);
        }
        if (!ObjectUtils.isEmpty(customParams)) {
            fsp.setCustomParams(customParams);
        }
        return fsp;
    }

    public static FormShowParameter showFrom(String formId, CloseCallBack closeCallBack, ShowType showType, OperationStatus operationStatus, Map<String, Object> customParams) {
        if (StringUtils.isEmpty((String)formId)) {
            throw new KDBizException(ResManager.loadKDString((String)"showFrom exception : \u83b7\u53d6\u4e0d\u5230\u8868\u5355\u6807\u8bc6\uff0c\u65e0\u6cd5\u6784\u5efa\u8868\u5355\u3002", (String)"ShowFormHelper_1", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        }
        FormShowParameter fsp = new FormShowParameter();
        if (showType == null) {
            showType = ShowType.Default;
        }
        fsp.getOpenStyle().setShowType(showType);
        fsp.setFormId(formId);
        fsp.setShowTitle(false);
        if (operationStatus != null) {
            fsp.setStatus(operationStatus);
        }
        if (closeCallBack != null) {
            fsp.setCloseCallBack(closeCallBack);
        }
        if (!ObjectUtils.isEmpty(customParams)) {
            fsp.setCustomParams(customParams);
        }
        return fsp;
    }

    public static ListShowParameter showListForm(String formId, CloseCallBack closeCallBack, ShowType showType, Map<String, Object> customParams) {
        ListShowParameter lsp = new ListShowParameter();
        lsp.getOpenStyle().setShowType(showType);
        lsp.setBillFormId(formId);
        FormConfig listFormConfig = FormMetadataCache.getListFormConfig((String)formId);
        String f7ListFormId = listFormConfig.getF7ListFormId();
        lsp.setFormId(f7ListFormId);
        lsp.setLookUp(true);
        lsp.setShowUsed(true);
        lsp.setHasRight(true);
        lsp.setShowApproved(true);
        lsp.setShowTitle(false);
        List filters = FilterUtil.buildDataPermissionFilter((String)formId, (boolean)lsp.isShowUsed(), (boolean)lsp.isShowApproved());
        lsp.getListFilterParameter().getQFilters().addAll(filters);
        StyleCss inlineStyleCss = new StyleCss();
        inlineStyleCss.setHeight("580px");
        inlineStyleCss.setWidth("960px");
        lsp.getOpenStyle().setInlineStyleCss(inlineStyleCss);
        if (closeCallBack != null) {
            lsp.setCloseCallBack(closeCallBack);
        }
        if (!ObjectUtils.isEmpty(customParams)) {
            lsp.setCustomParams(customParams);
        }
        return lsp;
    }

    public static FormShowParameter viewDetail(IFormView view, String formId, Object pk) {
        BaseShowParameter parameter = new BaseShowParameter();
        String pkId = String.valueOf(pk);
        String pageId = view.getPageId();
        FormConfig formConfig = FormMetadataCache.getFormConfig((String)formId);
        parameter.setParentFormId(view.getFormShowParameter().getParentFormId());
        parameter.getOpenStyle().setShowType(formConfig.getViewShowType());
        if (formConfig.getViewShowType() != ShowType.Modal) {
            parameter.getOpenStyle().setTargetKey("tabap");
        }
        parameter.setFormId(formId);
        parameter.setPkId((Object)pkId);
        parameter.setBillStatus(BillOperationStatus.VIEW);
        parameter.setPageId(pageId + pkId);
        parameter.setCustomParam(PERM_IGNORE_CHECKAPP, (Object)Boolean.TRUE);
        return parameter;
    }
}

