/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.helper;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.service.DispatchServiceHelper;
import kd.bos.mservice.svc.expt.ExportServiceImpl;
import kd.bos.web.actions.export.ExportActionResult;
import kd.imsc.dmw.engine.multiimport.model.ExcelFieldInfoModel;
import kd.imsc.dmw.engine.multiimport.model.StdTemplateReadInfoModel;
import kd.imsc.dmw.errorcode.DmwImptException;
import kd.imsc.dmw.utils.ImptFileUtils;
import org.apache.commons.io.FileUtils;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class StdTemplateReadHelper {
    private static final Log logger = LogFactory.getLog(StdTemplateReadHelper.class);

    private StdTemplateReadHelper() {
    }

    public static String pushBillTemplate(String billFormId, String billName) {
        if (StringUtils.isEmpty((CharSequence)billFormId)) {
            return "";
        }
        LocalDate now = LocalDate.now();
        String ctxPath = RequestContext.get().getClientFullContextPath();
        String fileName = String.format(ResManager.loadKDString((String)"\u6570\u636e\u6a21\u677f_", (String)"StdTemplateReadHelper_0", (String)"imsc-dmw-platform", (Object[])new Object[0]), billName);
        fileName = fileName.replace(' ', '_');
        try {
            return ctxPath + (ctxPath.endsWith("/") ? "" : "/") + "form/export.do?templateid=" + 0 + "&formid=" + billFormId + "&plugin=&filename=" + URLEncoder.encode(fileName + "_" + billName + "_" + String.format("%02d", now.getMonthValue()) + String.format("%02d", now.getDayOfMonth()) + ".xlsx", "UTF-8") + "&extenddata=null&routeappid=dmw&a=templateId";
        }
        catch (IOException e) {
            return "";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static StdTemplateReadInfoModel getStdImportSchemeTemplate(String formId, String targetName) throws DmwImptException {
        try (SXSSFWorkbook workbook = StdTemplateReadHelper.getStdImportTemplateStream(formId, targetName);){
            if (workbook == null) {
                throw new DmwImptException(String.format(ResManager.loadKDString((String)"\u5168\u91cf\u6807\u51c6\u6a21\u677f\u83b7\u53d6\u5931\u8d25:%s", (String)"StdTemplateReadHelper_1", (String)"imsc-dmw-platform", (Object[])new Object[0]), formId), 3001);
            }
            SXSSFSheet sheet = workbook.getSheetAt(0);
            StdTemplateReadInfoModel stdTemplateReadInfoModel = new StdTemplateReadInfoModel();
            List<ExcelFieldInfoModel> bPartInfoList = StdTemplateReadHelper.parseExcelFieldInfoModel(sheet, 0);
            List<ExcelFieldInfoModel> bPartKeyList = StdTemplateReadHelper.parseExcelFieldInfoModel(sheet, 2);
            List<ExcelFieldInfoModel> bPartNameList = StdTemplateReadHelper.parseExcelFieldInfoModel(sheet, 3);
            stdTemplateReadInfoModel.setPartFieldList(bPartInfoList);
            stdTemplateReadInfoModel.setKeyFieldList(bPartKeyList);
            stdTemplateReadInfoModel.setNameFieldList(bPartNameList);
            StdTemplateReadInfoModel stdTemplateReadInfoModel2 = stdTemplateReadInfoModel;
            return stdTemplateReadInfoModel2;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new DmwImptException(String.format(ResManager.loadKDString((String)"\u5168\u91cf\u6807\u51c6\u6a21\u677f\u83b7\u53d6\u5931\u8d25,\u5f02\u5e38\u4fe1\u606f\u4e3a: %1$s", (String)"StdTemplateReadHelper_2", (String)"imsc-dmw-platform", (Object[])new Object[0]), e, e.getMessage()), (Throwable)e, 3001);
        }
    }

    private static List<ExcelFieldInfoModel> parseExcelFieldInfoModel(SXSSFSheet sheet, int rowIndex) throws DmwImptException {
        if (sheet == null) {
            return new ArrayList<ExcelFieldInfoModel>(0);
        }
        int firstRowNum = sheet.getFirstRowNum();
        int lastRowNum = sheet.getLastRowNum();
        if (firstRowNum > rowIndex || lastRowNum < rowIndex) {
            throw new DmwImptException("Read Row Index Out Of Bound!", 3001);
        }
        SXSSFRow row = sheet.getRow(rowIndex);
        if (row == null) {
            throw new DmwImptException("Read Row does not exist!", 3001);
        }
        ArrayList<ExcelFieldInfoModel> infoModels = new ArrayList<ExcelFieldInfoModel>();
        int firstCellNum = row.getFirstCellNum();
        short lastCellNum = row.getLastCellNum();
        for (int i = firstCellNum; i < lastCellNum; ++i) {
            String cellValue;
            SXSSFCell cell = row.getCell(i);
            if (cell == null || StringUtils.isEmpty((CharSequence)(cellValue = cell.toString()))) continue;
            ExcelFieldInfoModel model = new ExcelFieldInfoModel();
            model.setRow(rowIndex);
            model.setColumn(i);
            model.setValue(cellValue.trim());
            infoModels.add(model);
        }
        return infoModels;
    }

    public static SXSSFWorkbook getStdImportTemplateStream(String formId, String targetName) throws DmwImptException {
        try {
            LocalDate now = LocalDate.now();
            ExportServiceImpl exportService = new ExportServiceImpl();
            String type = "dmw";
            String exportId = "";
            String temId = "0";
            boolean fillParent = false;
            String fileName = URLEncoder.encode(targetName + "_" + String.format("%02d", now.getMonthValue()) + String.format("%02d", now.getDayOfMonth()) + ".xlsx", "UTF-8");
            long startTime = System.currentTimeMillis();
            String routeAppId = (String)DispatchServiceHelper.invokeBOSService((String)"FormService", (String)"getAppId", (Object[])new Object[]{formId});
            ExportActionResult exportActionResult = exportService.doExportAction(type, exportId, temId, fillParent, routeAppId, formId, fileName, null, null);
            logger.info("\u83b7\u53d6\u5168\u91cf\u6a21\u677f \u8017\u65f6 {}ms", (Object)(System.currentTimeMillis() - startTime));
            if (exportActionResult == null || !exportActionResult.isSuccess()) {
                String errorMsg = exportActionResult != null ? exportActionResult.getError() : "";
                errorMsg = String.format(ResManager.loadKDString((String)"\u5168\u91cf\u6807\u51c6\u6a21\u677f\u83b7\u53d6\u5931\u8d25:%s", (String)"StdTemplateReadHelper_1", (String)"imsc-dmw-platform", (Object[])new Object[0]), errorMsg);
                throw new DmwImptException(errorMsg, 3001);
            }
            return exportActionResult.getWorkbook();
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new DmwImptException(String.format(ResManager.loadKDString((String)"\u5168\u91cf\u6807\u51c6\u6a21\u677f\u83b7\u53d6\u5931\u8d25,\u5f02\u5e38\u4fe1\u606f\u4e3a: %1$s", (String)"StdTemplateReadHelper_2", (String)"imsc-dmw-platform", (Object[])new Object[0]), e, e.getMessage()), (Throwable)e, 3001);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static File writeStdImportTemplateData(String formId, String targetName, List<ExcelFieldInfoModel> excelModelList) throws DmwImptException {
        if (excelModelList == null) return null;
        if (excelModelList.isEmpty()) {
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)formId)) return null;
        if (StringUtils.isEmpty((CharSequence)targetName)) {
            return null;
        }
        String dirName = String.format("%s_%s", formId, String.valueOf(System.currentTimeMillis()));
        try (SXSSFWorkbook workbook = StdTemplateReadHelper.getStdImportTemplateStream(formId, targetName);){
            boolean newFile;
            SXSSFSheet sheetAt = workbook.getSheetAt(0);
            if (sheetAt == null) {
                throw new DmwImptException(String.format(ResManager.loadKDString((String)"\u5168\u91cf\u6807\u51c6\u6a21\u677f\u83b7\u53d6\u5931\u8d25:%s", (String)"StdTemplateReadHelper_1", (String)"imsc-dmw-platform", (Object[])new Object[0]), formId), 3001);
            }
            for (ExcelFieldInfoModel excelModel : excelModelList) {
                SXSSFCell cell;
                int rowIndex = excelModel.getRow();
                int columnIndex = excelModel.getColumn();
                String value = excelModel.getValue();
                SXSSFRow row = sheetAt.getRow(rowIndex);
                if (row == null) {
                    row = sheetAt.createRow(rowIndex);
                }
                if ((cell = row.getCell(columnIndex)) == null) {
                    cell = row.createCell(columnIndex);
                }
                cell.setCellValue(value);
                if (StringUtils.isNotEmpty((CharSequence)excelModel.getComment())) continue;
            }
            File downloadDir = ImptFileUtils.createTempDir(dirName);
            File dFile = new File(downloadDir.getAbsolutePath() + File.separator + formId + "_" + targetName + "_" + System.currentTimeMillis() + ".xlsx");
            if (dFile.exists()) {
                FileUtils.delete((File)dFile);
            }
            if (!(newFile = dFile.createNewFile())) {
                throw new DmwImptException(ResManager.loadKDString((String)"\u5199\u5165\u5168\u91cf\u6570\u636e\u6a21\u677f\u5931\u8d25", (String)"StdTemplateReadHelper_3", (String)"imsc-dmw-platform", (Object[])new Object[0]), 3001);
            }
            try (FileOutputStream fos = new FileOutputStream(dFile);){
                workbook.write((OutputStream)fos);
            }
            File file = dFile;
            return file;
        }
        catch (IOException e) {
            throw new DmwImptException(ResManager.loadKDString((String)"\u5199\u5165\u5168\u91cf\u6570\u636e\u6a21\u677f\u5931\u8d25", (String)"StdTemplateReadHelper_3", (String)"imsc-dmw-platform", (Object[])new Object[0]), (Throwable)e, 3001);
        }
    }
}

