/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.helper.checker;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imsc.dmw.engine.multiimport.model.ExcelFieldInfoModel;
import kd.imsc.dmw.errorcode.DmwImptException;
import kd.imsc.dmw.helper.checker.IDataChecker;

public class FieldValuePreChecker
implements IDataChecker<Map<String, List<ExcelFieldInfoModel>>> {
    private static final Log logger = LogFactory.getLog(FieldValuePreChecker.class);

    @Override
    public void dataCheck(Map<String, List<ExcelFieldInfoModel>> listMap) throws DmwImptException {
        String msg;
        logger.info("\u5217\u540d\u503c\u91cd\u590d\u6216\u4e3a\u7a7a\u524d\u7f6e\u68c0\u67e5\u5668\u5f00\u59cb\u68c0\u67e5");
        if (listMap == null || listMap.isEmpty()) {
            throw new DmwImptException(ResManager.loadKDString((String)"\u6587\u4ef6\u4f20\u5165\u5f02\u5e38\uff0c\u9875\u7b7e\u4e3a\u7a7a\u6216\u8005\u5f02\u5e38\u3002", (String)"FieldValuePreChecker_11", (String)"imsc-dmw-platform", (Object[])new Object[0]), 500);
        }
        StringBuilder msgBuilder = new StringBuilder();
        Set<Map.Entry<String, List<ExcelFieldInfoModel>>> entries = listMap.entrySet();
        ArrayList<String> valueList = new ArrayList<String>(16);
        StringBuilder sameFieldBuilder = new StringBuilder();
        for (Map.Entry<String, List<ExcelFieldInfoModel>> entry : entries) {
            String key = entry.getKey();
            if (StringUtils.isEmpty((CharSequence)key)) {
                msgBuilder.append(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u9875\u7b7e\u540d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FieldValuePreChecker_12", (String)"imsc-dmw-platform", (Object[])new Object[0]), key)).append("\r\n");
                continue;
            }
            if (key.contains(".")) {
                msgBuilder.append(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u9875\u7b7e\u540d[%1$s]\u4e2d\u7684\u7279\u6b8a\u5b57\u7b26\u3010.\u3011\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"FieldValuePreChecker_13", (String)"imsc-dmw-platform", (Object[])new Object[0]), key)).append("\r\n");
                continue;
            }
            if (key.contains(",")) {
                msgBuilder.append(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u9875\u7b7e\u540d[%1$s]\u4e2d\u7684\u7279\u6b8a\u5b57\u7b26\u3010,\u3011\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"FieldValuePreChecker_14", (String)"imsc-dmw-platform", (Object[])new Object[0]), key)).append("\r\n");
                continue;
            }
            List<ExcelFieldInfoModel> values = entry.getValue();
            if (values.stream().anyMatch(v -> StringUtils.isEmpty((CharSequence)v.getValue()))) {
                msgBuilder.append(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u5728\u9875\u7b7e\u3010%s\u3011\u7b2c\u4e00\u884c\u7ef4\u62a4\u5b57\u6bb5\u540d\u79f0\u3002", (String)"FieldValuePreChecker_15", (String)"imsc-dmw-platform", (Object[])new Object[0]), key)).append("\r\n");
                continue;
            }
            if (values.stream().anyMatch(v -> v.getValue().contains("."))) {
                msgBuilder.append(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u9875\u7b7e\u3010%s\u3011\u7b2c\u4e00\u884c\u7684\u7279\u6b8a\u5b57\u7b26\u3010.\u3011\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"FieldValuePreChecker_16", (String)"imsc-dmw-platform", (Object[])new Object[0]), key)).append("\r\n");
                continue;
            }
            if (values.stream().anyMatch(v -> v.getValue().contains(","))) {
                msgBuilder.append(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u9875\u7b7e\u3010%s\u3011\u7b2c\u4e00\u884c\u7684\u7279\u6b8a\u5b57\u7b26\u3010,\u3011\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"FieldValuePreChecker_17", (String)"imsc-dmw-platform", (Object[])new Object[0]), key)).append("\r\n");
                continue;
            }
            valueList.clear();
            for (ExcelFieldInfoModel model : values) {
                String value = model.getValue();
                if (valueList.contains(value)) {
                    sameFieldBuilder.append(ResManager.loadKDString((String)"\u9875\u7b7e\u3010%1$s\u3011%2$s\u5b57\u6bb5", (String)"FieldValuePreChecker_18", (String)"imsc-dmw-platform", (Object[])new Object[]{key, value})).append("\uff0c");
                    continue;
                }
                valueList.add(value);
            }
        }
        String sameFieldStr = sameFieldBuilder.toString();
        if (StringUtils.isNotEmpty((CharSequence)sameFieldStr)) {
            String subSameFieldStr = sameFieldStr.substring(0, sameFieldStr.lastIndexOf("\uff0c"));
            msgBuilder.append(ResManager.loadKDString((String)"\u5b58\u5728\u540c\u9875\u7b7e\u4e0b\u540d\u79f0\u76f8\u540c\u7684\u5b57\u6bb5", (String)"FieldValuePreChecker_19", (String)"imsc-dmw-platform", (Object[])new Object[0])).append("\uff08").append(subSameFieldStr).append("\uff09\uff0c").append(ResManager.loadKDString((String)"\u5c06\u65e0\u6cd5\u8fdb\u884c\u5b57\u6bb5\u6620\u5c04\u548c\u53d6\u503c\uff0c\u8bf7\u8c03\u6574\u540e\u518d\u4e0a\u4f20\u6587\u4ef6\u3002", (String)"FieldValuePreChecker_20", (String)"imsc-dmw-platform", (Object[])new Object[0])).append("\r\n");
        }
        if (StringUtils.isNotEmpty((CharSequence)(msg = msgBuilder.toString()))) {
            logger.info("Check Data msg {}", (Object)msg);
            throw new DmwImptException(msg, 500);
        }
    }
}

