/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.helper.eas;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imsc.dmw.engine.eas.core.config.isc.impl.IscServiceImpl;
import kd.imsc.dmw.errorcode.DmwBizException;
import kd.imsc.dmw.utils.DbUtil;

public class EasQueryHelper {
    public static List<Map<String, Object>> queryEasData(Long dbLinkId, String sql) throws DmwBizException {
        IscServiceImpl service = new IscServiceImpl(dbLinkId);
        String templateSql = DbUtil.buildPaginationSql(sql);
        String countSql = DbUtil.changeCountSql(sql);
        return service.pageQuery(templateSql, countSql, null, null, 1000L);
    }

    public static List<Map<String, Object>> queryEasData(Long dbLinkId, String templateSql, String countSql) throws DmwBizException {
        IscServiceImpl service = new IscServiceImpl(dbLinkId);
        return service.pageQuery(templateSql, countSql, null, null, 1000L);
    }

    public static String saveXhData(String tableName, List<Map<String, Object>> allEasData, String[] xhFieldNames, String[] easFieldNames) {
        ArrayList<DynamicObject> xhDataList = new ArrayList<DynamicObject>(10);
        DynamicObject[] existXhData = BusinessDataServiceHelper.load((String)tableName, (String)"number", (QFilter[])new QFilter[0]);
        ArrayList<String> existNumber = new ArrayList<String>(8);
        ArrayList<String> dulNumber = new ArrayList<String>(8);
        for (DynamicObject a : existXhData) {
            existNumber.add(a.getString("number"));
        }
        for (Map map : allEasData) {
            DynamicObject xhData = BusinessDataServiceHelper.newDynamicObject((String)tableName);
            for (int i = 0; i < easFieldNames.length; ++i) {
                String easField;
                String string = easField = map.get(easFieldNames[i]) != null ? map.get(easFieldNames[i]) : "";
                if (existNumber.contains(easField.toString())) {
                    dulNumber.add(easField.toString());
                }
                xhData.set(xhFieldNames[i], (Object)easField);
            }
            xhData.set("status", (Object)"C");
            xhData.set("enable", (Object)"1");
            xhDataList.add(xhData);
        }
        QFilter qFilter = new QFilter("number", "in", dulNumber);
        DeleteServiceHelper.delete((String)tableName, (QFilter[])qFilter.toArray());
        try (TXHandle tXHandle = TX.required();){
            try {
                int batchSize = 1000;
                int numBatches = (int)Math.ceil((double)xhDataList.size() / (double)batchSize);
                for (int i = 0; i < numBatches; ++i) {
                    int start = i * batchSize;
                    int end = Math.min(start + batchSize, xhDataList.size());
                    List batch = xhDataList.subList(start, end);
                    SaveServiceHelper.save((DynamicObject[])batch.toArray(new DynamicObject[0]));
                }
            }
            catch (Exception ex) {
                String string = ResManager.loadKDString((String)"\u67e5\u8be2\u7684EAS\u6570\u636e\u4fdd\u5b58\u51fa\u9519\u3002", (String)"EasQueryHelper_0", (String)"imsc-dmw-platform", (Object[])new Object[0]);
                if (tXHandle != null) {
                    if (var10_14 != null) {
                        try {
                            tXHandle.close();
                        }
                        catch (Throwable throwable) {
                            var10_14.addSuppressed(throwable);
                        }
                    } else {
                        tXHandle.close();
                    }
                }
                return string;
            }
        }
        return "";
    }

    public static void dbLinkTestClick(DynamicObject dbLink, IFormView view) {
        IscServiceImpl iscService = new IscServiceImpl((Long)dbLink.getPkValue());
        Map<String, Object> result = iscService.testConnect();
        if (!((Boolean)result.get("success")).booleanValue()) {
            String msgTpl = ResManager.loadKDString((String)"\u8fde\u63a5\u5931\u8d25\uff0c\u539f\u56e0\u4e3a:%s", (String)"EasQueryHelper_1", (String)"imsc-dmw-platform", (Object[])new Object[0]);
            String msg = String.format(msgTpl, result.get("message"));
            view.setVisible(Boolean.TRUE, new String[]{"errormsgkey"});
            view.showErrorNotification(msg);
            return;
        }
        view.setVisible(Boolean.FALSE, new String[]{"errormsgkey"});
        view.showSuccessNotification(ResManager.loadKDString((String)"\u6d4b\u8bd5\u8fde\u63a5\u6210\u529f", (String)"EasQueryHelper_2", (String)"imsc-dmw-platform", (Object[])new Object[0]));
    }
}

