/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.helper.license;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.imsc.dmw.helper.license.LicenseDomainHelper;

public class LicenseHelper {
    private static final Log logger = LogFactory.getLog(LicenseHelper.class);

    public static Map<String, Boolean> checkLicenseByGroups(List<String> groupNumbers) {
        return LicenseHelper.checkLicense("2", groupNumbers);
    }

    public static Map<String, Boolean> checkLicenseByModules(List<String> moduleNumbers) {
        return LicenseHelper.checkLicense("1", moduleNumbers);
    }

    private static Map<String, Boolean> checkLicense(String checkType, List<String> checkNumbers) {
        if (null == checkNumbers || checkNumbers.isEmpty()) {
            return null;
        }
        Map checkResultMap = LicenseServiceHelper.validateLicDate();
        if (null == checkResultMap || checkResultMap.getOrDefault("expire", Boolean.TRUE).booleanValue()) {
            logger.info("\u672a\u80fd\u68c0\u6d4b\u5230\u6709\u6548\u8bb8\u53ef\u6216\u8bb8\u53ef\u5df2\u8fc7\u671f\uff01");
            return null;
        }
        HashSet<String> checkCodes = new HashSet<String>(16);
        checkNumbers.forEach(bizAppNumber -> checkCodes.add(bizAppNumber.toUpperCase()));
        logger.info("\u5f00\u59cb\u8c03\u7528\u5e73\u53f0\u63a5\u53e3\u6821\u9a8c\u8d2d\u4e70\u6a21\u5757\u4fe1\u606f\u3002");
        Map<String, LicenseCheckResult> licenseCheckResultMap = null;
        licenseCheckResultMap = "2".equals(checkType) ? LicenseHelper.checkPerformGroups(checkCodes) : LicenseHelper.checkPerformModules(checkCodes);
        if (licenseCheckResultMap.isEmpty()) {
            logger.warn("\u901a\u8fc7\u8bb8\u53ef\u68c0\u6d4b\u5bf9\u5e94\u6a21\u5757\u662f\u5426\u8d2d\u4e70\u8fd4\u56de\u7ed3\u679c\u5f02\u5e38\uff0c\u8bf7\u786e\u8ba4\u63a5\u53e3\u662f\u5426\u6b63\u5e38\uff01");
            return null;
        }
        HashMap<String, Boolean> checkResult = new HashMap<String, Boolean>();
        for (String bizAppNumber2 : checkNumbers) {
            LicenseCheckResult licenseCheckResult = licenseCheckResultMap.getOrDefault(bizAppNumber2.toUpperCase(), null);
            if (null == licenseCheckResult) {
                licenseCheckResult = licenseCheckResultMap.getOrDefault(bizAppNumber2, null);
            }
            checkResult.put(bizAppNumber2, null != licenseCheckResult && licenseCheckResult.getHasLicense() != false);
        }
        return checkResult;
    }

    private static Map<String, LicenseCheckResult> checkPerformGroups(Set<String> groupNumbers) {
        HashMap<String, LicenseCheckResult> licenseCheckResults = new HashMap<String, LicenseCheckResult>(4);
        if (!CollectionUtils.isEmpty(groupNumbers)) {
            groupNumbers.stream().distinct().forEach(t -> {
                LicenseCheckResult licenseCheckResult = new LicenseDomainHelper().checkPerformGroup((String)t, true);
                licenseCheckResults.put((String)t, licenseCheckResult);
            });
        }
        return licenseCheckResults;
    }

    private static Map<String, LicenseCheckResult> checkPerformModules(Set<String> moduleNumbers) {
        HashMap<String, LicenseCheckResult> licenseCheckResults = new HashMap<String, LicenseCheckResult>(4);
        if (!CollectionUtils.isEmpty(moduleNumbers)) {
            moduleNumbers.stream().distinct().forEach(t -> {
                LicenseCheckResult licenseCheckResult = new LicenseDomainHelper().checkPerformModule((String)t, true);
                licenseCheckResults.put((String)t, licenseCheckResult);
            });
        }
        return licenseCheckResults;
    }
}

