/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.helper.lock;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.MutexFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.imsc.dmw.helper.lock.MutexLockHelper;

public class MutexLockUtils {
    private static final Log logger = LogFactory.getLog(MutexLockUtils.class);
    private static final String OP = "migrateCheckOp";
    private static final int COUNT = 0;

    public static void doLock(Collection<String> needLockIds) {
        HashMap<String, Object> fails = new HashMap<String, Object>(8);
        logger.info("\u52a0\u9501" + JSONObject.toJSONString(needLockIds));
        if (CollectionUtils.isEmpty(needLockIds)) {
            return;
        }
        Boolean isGetLock = MutexLockUtils.getlock(needLockIds, fails);
        if (!isGetLock.booleanValue()) {
            StringBuilder builder = MutexLockUtils.buildErrorMessage(fails);
            logger.error("\u52a0\u9501\u5931\u8d25");
            throw new KDBizException(builder.toString());
        }
    }

    private static StringBuilder buildErrorMessage(Map<String, Object> fails) {
        String billType = (String)fails.get("billType");
        Set ids = (Set)fails.get("ids");
        StringBuilder builder = new StringBuilder();
        Map<Long, String> userMaps = MutexLockUtils.getUsers(billType, ids);
        Map<Long, String> billNos = MutexLockUtils.getBillNoMap(billType, ids);
        for (Long id : ids) {
            Map lockMap = MutexFactory.createDataMutex().getLockInfo(String.valueOf(id), "check", billType);
            if (lockMap == null || lockMap.isEmpty()) continue;
            Long userId = Long.parseLong((String)lockMap.get("userid"));
            String name = userMaps.get(userId);
            StringBuilder message = new StringBuilder(billNos.get(id));
            String endMsg = ResManager.loadKDString((String)"\u6b63\u5728PC\u7aef\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"UserguideEASEditPlugin_27", (String)"imsc-dmw-platform", (Object[])new Object[0]);
            message.append(':').append(name).append(endMsg);
            builder.append((CharSequence)message);
        }
        return builder;
    }

    private static Map<Long, String> getUsers(String billType, Set<Long> ids) {
        ArrayList<Long> userList = new ArrayList<Long>(16);
        for (Long id : ids) {
            Map lockMap = MutexFactory.createDataMutex().getLockInfo(String.valueOf(id), "check", billType);
            if (lockMap == null || lockMap.isEmpty()) continue;
            String userId = (String)lockMap.get("userid");
            userList.add(Long.valueOf(userId));
        }
        HashMap<Long, String> userMaps = new HashMap<Long, String>(16);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bos_user", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", userList)});
        for (DynamicObject ob : query) {
            userMaps.put((Long)ob.get("id"), (String)ob.get("name"));
        }
        return userMaps;
    }

    private static Map<Long, String> getBillNoMap(String billType, Set<Long> ids) {
        HashMap<Long, String> billNos = new HashMap<Long, String>(16);
        DynamicObjectCollection query = QueryServiceHelper.query((String)billType, (String)"id,number", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        for (DynamicObject ob : query) {
            billNos.put((Long)ob.get("id"), (String)ob.get("number"));
        }
        return billNos;
    }

    private static Boolean getlock(Collection<String> needLockIds, Map<String, Object> failMap) {
        HashMap<String, Set<Long>> successIds = new HashMap<String, Set<Long>>(16);
        Map<String, Map<String, Set<Long>>> params = MutexLockUtils.buildLockParam(needLockIds);
        HashSet<Long> failIdSet = new HashSet<Long>(8);
        try {
            for (Map.Entry<String, Map<String, Set<Long>>> param : params.entrySet()) {
                String mutexLockFail;
                failMap.put("billType", param.getKey());
                successIds.putIfAbsent(param.getKey(), new HashSet(16));
                Map<String, Set<Long>> value = param.getValue();
                Set<Long> ids = value.get("isReEntry");
                Set<Long> idsTwo = value.get("isNotReEntry");
                if (ids != null && !ids.isEmpty()) {
                    logger.info("\u52a0\u53ef\u91cd\u5165\u9501:" + JSONObject.toJSONString(ids));
                    mutexLockFail = ResManager.loadKDString((String)"\u7f51\u7edc\u4e92\u65a5\u9501\u52a0\u9501\u5931\u8d25\u3002", (String)"MutexLockUtils_0", (String)"imsc-dmw-platform", (Object[])new Object[0]);
                    MutexLockHelper.requireMutex(param.getKey(), ids, OP, false, failIdSet, successIds, mutexLockFail);
                }
                if (idsTwo == null || idsTwo.isEmpty()) continue;
                if (ids != null) {
                    idsTwo.removeAll(ids);
                }
                logger.info("\u52a0\u4e0d\u53ef\u91cd\u5165\u9501:" + JSONObject.toJSONString(idsTwo));
                mutexLockFail = ResManager.loadKDString((String)"\u7f51\u7edc\u4e92\u65a5\u9501\u52a0\u9501\u5931\u8d25\u3002", (String)"MutexLockUtils_0", (String)"imsc-dmw-platform", (Object[])new Object[0]);
                MutexLockHelper.requireMutex(param.getKey(), idsTwo, OP, true, failIdSet, successIds, mutexLockFail);
            }
            logger.info("\u52a0\u9501\u6210\u529f" + JSONObject.toJSONString(successIds));
            return Boolean.TRUE;
        }
        catch (Exception e) {
            failMap.put("ids", failIdSet);
            logger.error("\u7f51\u7edc\u4e92\u65a5\u9501\u52a0\u9501\u5931\u8d25", (Throwable)e);
            for (Map.Entry param : successIds.entrySet()) {
                Set value = (Set)param.getValue();
                MutexLockHelper.batchRelease((String)param.getKey(), value, OP);
            }
            return Boolean.FALSE;
        }
    }

    private static Map<String, Map<String, Set<Long>>> buildLockParam(Collection<String> needLockIds) {
        HashMap<String, Map<String, Set<Long>>> params = new HashMap<String, Map<String, Set<Long>>>(16);
        for (String lockKey : needLockIds) {
            String[] split = lockKey.split("&&");
            String billType = split[0];
            Long id = Long.valueOf(split[1]);
            params.putIfAbsent(billType, new HashMap(16));
            if (split.length > 2 && "isReEntry".equals(split[2])) {
                ((Map)params.get(billType)).putIfAbsent("isReEntry", new HashSet(16));
                ((Set)((Map)params.get(billType)).get("isReEntry")).add(id);
                continue;
            }
            if (split.length <= 2 || !"isNotReEntry".equals(split[2])) continue;
            ((Map)params.get(billType)).putIfAbsent("isNotReEntry", new HashSet(16));
            ((Set)((Map)params.get(billType)).get("isNotReEntry")).add(id);
        }
        return params;
    }

    public static void releaseLock(Collection<String> releaseLockIds) {
        Map<String, Map<String, Set<Long>>> params = MutexLockUtils.buildLockParam(releaseLockIds);
        for (Map.Entry<String, Map<String, Set<Long>>> param : params.entrySet()) {
            HashSet<Long> all = new HashSet<Long>(16);
            Map<String, Set<Long>> value = param.getValue();
            HashSet ids = value.get("isReEntry");
            HashSet idsTwo = value.get("isNotReEntry");
            all.addAll(ids == null ? new HashSet(1) : ids);
            all.addAll(idsTwo == null ? new HashSet(1) : idsTwo);
            if (all == null || all.isEmpty()) continue;
            MutexLockHelper.batchRelease(param.getKey(), all, OP);
        }
        logger.info("\u91ca\u653e\u9501\u6210\u529f");
    }
}

