/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.mservice;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.imsc.dmw.errorcode.DmwBizException;

public class DeleteMigSchemeEntryServiceImpl
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(DeleteMigSchemeEntryServiceImpl.class);

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult upgradeResult = new UpgradeResult();
        upgradeResult.setSuccess(true);
        StringBuilder msg = new StringBuilder(ResManager.loadKDString((String)"EAS\u8fc1\u79fb\u65b9\u6848\u5f00\u59cb\u5347\u7ea7", (String)"DeleteMigSchemeEntryServiceImpl_0", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        try (TXHandle handle = TX.requiresNew();){
            try {
                this.deleteEntry(upgradeResult, msg);
                this.updateEntry();
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                handle.markRollback();
                throw new DmwBizException(e.getMessage(), (Throwable)e);
            }
        }
        msg.append('\n').append(ResManager.loadKDString((String)"EAS\u8fc1\u79fb\u65b9\u6848\u5347\u7ea7\u7ed3\u675f", (String)"DeleteMigSchemeEntryServiceImpl_1", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        return upgradeResult;
    }

    public void deleteEntry(UpgradeResult upgradeResult, StringBuilder msg) {
        String sqlSelect = "SELECT fentryid,fid FROM t_dmw_scheme_eas_entry WHERE FModel != 0 OR FAREA != 0";
        ArrayList<Long> idList = new ArrayList<Long>(8);
        try (DataSet idDataSet = DB.queryDataSet((String)DeleteMigSchemeEntryServiceImpl.class.getName(), (DBRoute)DBRoute.of((String)"imsc"), (String)sqlSelect);){
            while (idDataSet.hasNext()) {
                Row row = idDataSet.next();
                idList.add(row.getLong("fid"));
            }
            if (idList.isEmpty()) {
                return;
            }
            String sqlDelete = "DELETE FROM t_dmw_scheme_eas_entry WHERE fentryid IN (SELECT fentryid FROM t_dmw_scheme_eas_entry WHERE FModel != 0 OR FAREA != 0)";
            boolean isSuccess = DB.execute((DBRoute)DBRoute.of((String)"imsc"), (String)sqlDelete, (Object[])new Object[0]);
            if (!isSuccess) {
                upgradeResult.setSuccess(false);
                String traceId = RequestContext.get().getTraceId();
                upgradeResult.setErrorInfo(String.format(ResManager.loadKDString((String)"EAS\u8fc1\u79fb\u65b9\u6848\u5220\u9664\u9886\u57df\u3001\u6a21\u5757\u5206\u5f55\u884c\u6570\u636e\u5931\u8d25\uff0ctracdid: [%s],\u8bf7\u67e5\u8be2monitor\u65e5\u5fd7\u5206\u6790\u8be6\u60c5", (String)"DeleteMigSchemeEntryServiceImpl_2", (String)"imsc-dmw-platform", (Object[])new Object[0]), traceId));
            } else {
                msg.append('\n').append(ResManager.loadKDString((String)"EAS\u8fc1\u79fb\u65b9\u6848\u5220\u9664\u9886\u57df\u3001\u6a21\u5757\u5206\u5f55\u884c\u6570\u636e\u6210\u529f", (String)"DeleteMigSchemeEntryServiceImpl_3", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            }
            upgradeResult.setLog(msg.toString());
        }
    }

    public void updateEntry() {
        ArrayList<Long> idListUpdate = new ArrayList<Long>(8);
        String sqlSelectNotin = "SELECT FID FROM t_dmw_scheme_eas where fid not in (SELECT fid FROM t_dmw_scheme_eas_entry WHERE fsortnumexec!=0 GROUP BY fid)";
        try (DataSet idUpdateDataSet = DB.queryDataSet((String)DeleteMigSchemeEntryServiceImpl.class.getName(), (DBRoute)DBRoute.of((String)"imsc"), (String)sqlSelectNotin);){
            while (idUpdateDataSet.hasNext()) {
                Row row = idUpdateDataSet.next();
                idListUpdate.add(row.getLong("fid"));
            }
            if (!idListUpdate.isEmpty()) {
                this.updateEntryDefNum(idListUpdate);
                this.updateEntryExecNum(idListUpdate);
            }
        }
    }

    public void updateEntryDefNum(List<Long> idListUpdate) {
        StringBuilder sqlUpdate = new StringBuilder("UPDATE t_dmw_scheme_eas_entry SET fsortnumdefault=? WHERE fentryid=? and fid in (");
        for (int i = 0; i < idListUpdate.size(); ++i) {
            if (i != idListUpdate.size() - 1) {
                sqlUpdate.append(idListUpdate.get(i)).append(',');
                continue;
            }
            sqlUpdate.append(idListUpdate.get(i)).append(')');
        }
        Map<String, String> migObjIdDefNumMap = this.getMigObjIdDefNumMap();
        Map<String, Map<String, String>> entryMigObjMap = this.getEntryMigObjMap();
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(8);
        for (Map.Entry<String, Map<String, String>> entry : entryMigObjMap.entrySet()) {
            String entryId = entry.getKey();
            String migObjId = entry.getValue().get("fmigrateobject");
            String sortNumDef = migObjIdDefNumMap.get(migObjId) != null ? migObjIdDefNumMap.get(migObjId) : "";
            paramList.add(new Object[]{sortNumDef, Long.valueOf(entryId)});
        }
        DB.executeBatch((DBRoute)DBRoute.of((String)"imsc"), (String)sqlUpdate.toString(), paramList);
    }

    /*
     * WARNING - void declaration
     */
    public void updateEntryExecNum(List<Long> idListUpdate) {
        Map<String, Map<String, String>> entryMigObjMap = this.getEntryMigObjMap();
        Comparator valueComparator = Map.Entry.comparingByValue();
        HashMap entryExecNumMap = new HashMap(8);
        for (int i = 0; i < idListUpdate.size(); ++i) {
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            for (Map.Entry<String, Map<String, String>> entry : entryMigObjMap.entrySet()) {
                String entryId = entry.getKey();
                String schemeId = entry.getValue().get("fid");
                String defSortNum = entry.getValue().get("fsortnumdefault");
                if (!schemeId.equals(idListUpdate.get(i).toString())) continue;
                treeMap.put(entryId, defSortNum);
            }
            LinkedList sortedList = new LinkedList(treeMap.entrySet());
            Collections.sort(sortedList, valueComparator);
            if (sortedList.isEmpty()) continue;
            int n = 1;
            entryExecNumMap.put(((Map.Entry)sortedList.get(0)).getKey(), n);
            for (int j = 1; j < sortedList.size(); ++j) {
                void var8_11;
                Map.Entry entryPre = (Map.Entry)sortedList.get(j - 1);
                Map.Entry entry = (Map.Entry)sortedList.get(j);
                if (Objects.equals(entry.getValue(), entryPre.getValue())) {
                    entryExecNumMap.put(entry.getKey(), (int)var8_11);
                    continue;
                }
                entryExecNumMap.put(entry.getKey(), (int)(++var8_11));
            }
        }
        String sqlUpdate = "UPDATE t_dmw_scheme_eas_entry SET fsortnumexec=? WHERE fentryid=?";
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(8);
        for (Map.Entry<String, Map<String, String>> entry : entryExecNumMap.entrySet()) {
            String entryId = entry.getKey();
            Integer sortNum = (Integer)((Object)entry.getValue());
            paramList.add(new Object[]{sortNum, Long.valueOf(entryId)});
        }
        DB.executeBatch((DBRoute)DBRoute.of((String)"imsc"), (String)sqlUpdate, paramList);
    }

    public Map<String, String> getMigObjIdDefNumMap() {
        List<Map<String, String>> migObjMapList = this.getMigObjMapList();
        Map<String, String> moduleIdNumMap = this.getModuleIdNumMap();
        Map<String, String> migObjIdNumMap = migObjMapList.get(0);
        Map<String, String> migObjIdGroupMap = migObjMapList.get(1);
        HashMap<String, String> migObjIdDefNumMap = new HashMap<String, String>(8);
        for (Map.Entry<String, String> entry : migObjIdGroupMap.entrySet()) {
            String migObjId = entry.getKey();
            String groupId = entry.getValue();
            StringBuilder groupSortNum = new StringBuilder(moduleIdNumMap.get(groupId));
            StringBuilder objSortnum = new StringBuilder(migObjIdNumMap.get(migObjId));
            StringBuilder sortnumDefault = groupSortNum.append('.').append(this.getThreeDigit(objSortnum));
            migObjIdDefNumMap.put(migObjId, sortnumDefault.toString());
        }
        return migObjIdDefNumMap;
    }

    public String getThreeDigit(StringBuilder objSortNum) {
        switch (objSortNum.length()) {
            case 1: {
                objSortNum.insert(0, "00");
                break;
            }
            case 2: {
                objSortNum.insert(0, "0");
                break;
            }
        }
        return String.valueOf(objSortNum);
    }

    public Map<String, String> getModuleIdNumMap() {
        HashMap<String, String> map = new HashMap<String, String>(8);
        String sqlSelect = "SELECT fid,fsortnum FROM t_dmw_module";
        try (DataSet idDataSet = DB.queryDataSet((String)DeleteMigSchemeEntryServiceImpl.class.getName(), (DBRoute)DBRoute.of((String)"imsc"), (String)sqlSelect);){
            while (idDataSet.hasNext()) {
                Row row = idDataSet.next();
                map.put(row.getString("fid"), row.getString("fsortnum"));
            }
        }
        return map;
    }

    public List<Map<String, String>> getMigObjMapList() {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>(8);
        HashMap<String, String> mapIdNum = new HashMap<String, String>(8);
        HashMap<String, String> mapIdGroup = new HashMap<String, String>(8);
        String sqlSelect = "SELECT fid,fsortnum,fgroupid FROM t_dmw_migration_easobject";
        try (DataSet idDataSet = DB.queryDataSet((String)DeleteMigSchemeEntryServiceImpl.class.getName(), (DBRoute)DBRoute.of((String)"imsc"), (String)sqlSelect);){
            while (idDataSet.hasNext()) {
                Row row = idDataSet.next();
                mapIdNum.put(row.getString("fid"), row.getString("fsortnum"));
                mapIdGroup.put(row.getString("fid"), row.getString("fgroupid"));
            }
            list.add(mapIdNum);
            list.add(mapIdGroup);
        }
        return list;
    }

    public Map<String, Map<String, String>> getEntryMigObjMap() {
        HashMap<String, Map<String, String>> entryMigObjMap = new HashMap<String, Map<String, String>>(8);
        String sqlSelect = "SELECT fentryid,fmigrateobject,fsortnumdefault,fsortnumexec,fid FROM t_dmw_scheme_eas_entry";
        try (DataSet idDataSet = DB.queryDataSet((String)DeleteMigSchemeEntryServiceImpl.class.getName(), (DBRoute)DBRoute.of((String)"imsc"), (String)sqlSelect);){
            while (idDataSet.hasNext()) {
                HashMap<String, String> map = new HashMap<String, String>(4);
                Row row = idDataSet.next();
                map.put("fmigrateobject", row.getString("fmigrateobject"));
                map.put("fsortnumdefault", row.getString("fsortnumdefault"));
                map.put("fsortnumexec", row.getString("fsortnumexec"));
                map.put("fid", row.getString("fid"));
                entryMigObjMap.put(row.getString("fentryid"), map);
            }
        }
        return entryMigObjMap;
    }
}

