/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.mservice;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.imsc.dmw.utils.DateUtils;
import kd.imsc.dmw.utils.StringUtils;

public class EASMigrateServiceImpl {
    private static final Log logger = LogFactory.getLog(EASMigrateServiceImpl.class);

    public Map<String, Object> getControlDateByOrg(String bizScope, List<Long> orgIds) {
        logger.info("\u5fae\u670d\u52a1\u8fc1\u79fb\u53cd\u7ed3\u8d26\u63a7\u5236\u5f00\u59cb  \u4e1a\u52a1\u9886\u57df\uff1a{}", (Object)bizScope);
        if (StringUtils.isBlank(bizScope)) {
            return EASMigrateServiceImpl.fail(ResManager.loadKDString((String)"\u53c2\u6570bizScope \u4e3a\u7a7a", (String)"EASMigrateServiceImpl_0", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        }
        if (CollectionUtils.isEmpty(orgIds)) {
            return EASMigrateServiceImpl.fail(ResManager.loadKDString((String)"\u53c2\u6570orgIds \u4e3a\u7a7a", (String)"EASMigrateServiceImpl_1", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        }
        QFilter qFilter = new QFilter("bizscope", "=", (Object)bizScope).and("orgs.fbasedataid.id", "in", orgIds);
        DynamicObjectCollection objs = QueryServiceHelper.query((String)"dmw_migration_control", (String)"bizscope,orgs.fbasedataid.id,deadline,id", (QFilter[])new QFilter[]{qFilter});
        Map<String, Object> returnMap = EASMigrateServiceImpl.success();
        returnMap.put("data", new HashMap());
        if (CollectionUtils.isNotEmpty((Collection)objs)) {
            Map<Long, String> collect = objs.stream().collect(Collectors.toMap(o -> o.getLong("orgs.fbasedataid.id"), o -> DateUtils.format((Date)o.getDate("deadline"), (String)"yyyy-MM-dd"), (v1, v2) -> this.dealMultiValue((String)v1, (String)v2)));
            ((Map)returnMap.get("data")).putAll(collect);
        }
        Map data = (Map)returnMap.get("data");
        orgIds.stream().forEach(o -> {
            if (!data.containsKey(o)) {
                data.put(o, null);
            }
        });
        returnMap.put("data", data);
        return returnMap;
    }

    private String dealMultiValue(String v1, String v2) {
        if (kd.bos.util.StringUtils.isBlank((String)v1)) {
            return v1;
        }
        return v2;
    }

    public static Map<String, Object> success() {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        result.put("success", Boolean.TRUE);
        result.put("status", "1");
        return result;
    }

    public static Map<String, Object> fail(String msg) {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        result.put("success", Boolean.FALSE);
        result.put("status", "0");
        result.put("message", msg);
        return result;
    }
}

