/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.mservice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.imsc.dmw.utils.StringUtil;

public class MigObjEasObjectUpgradeServiceImpl
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(MigObjEasObjectUpgradeServiceImpl.class);
    private static final String INIT_UPDATE_MIGRATE_OBJ = "update t_dmw_migration_easobject set feasobjectname = ?,feasobjectid = ? where fid = ?;";
    private static final String SELECT_EAS_OBJ = "select fid,fpkid,fbasedataid  from  t_dmw_easobject_sources";
    private static final String SELECT_MIGRATE_OBJ = "select fid,feasobjectname,feasobjectid  from  t_dmw_migration_easobject WHERE";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult upgradeResult = new UpgradeResult();
        upgradeResult.setSuccess(true);
        HashMap<Long, List<Long>> easObjMap = new HashMap<Long, List<Long>>(16);
        HashMap<Long, String> iscObjNameMapping = new HashMap<Long, String>(16);
        MigObjEasObjectUpgradeServiceImpl.selectData(easObjMap, iscObjNameMapping);
        List<Object[]> params = MigObjEasObjectUpgradeServiceImpl.buildParams(easObjMap, iscObjNameMapping);
        MigObjEasObjectUpgradeServiceImpl.updateMigrateObj(params);
        return upgradeResult;
    }

    private static void updateMigrateObj(List<Object[]> params) {
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                if (params != null && !params.isEmpty()) {
                    DB.executeBatch((DBRoute)DBRoute.of((String)"imsc"), (String)INIT_UPDATE_MIGRATE_OBJ, params);
                }
            }
            catch (Exception e) {
                logger.error("update t_dmw_migration_easobject iscObj fail,", (Throwable)e);
                txHandle.markRollback();
                throw e;
            }
        }
    }

    private static void selectData(Map<Long, List<Long>> easObjMap, Map<Long, String> iscObjNameMapping) {
        try (DataSet idDataSet = DB.queryDataSet((String)MigObjEasObjectUpgradeServiceImpl.class.getName(), (DBRoute)DBRoute.of((String)"imsc"), (String)SELECT_EAS_OBJ);){
            HashSet<Long> iscObjids = new HashSet<Long>(16);
            while (idDataSet.hasNext()) {
                Row easObj = idDataSet.next();
                Long fbasedataid = easObj.getLong("fbasedataid");
                Long fid = easObj.getLong("fid");
                easObjMap.putIfAbsent(fid, new ArrayList(16));
                List<Long> longs = easObjMap.get(fid);
                longs.add(fbasedataid);
                iscObjids.add(fbasedataid);
            }
            SqlBuilder sqlBuilder = new SqlBuilder();
            sqlBuilder.append("select fid,fname from t_isc_dataschema_l where flocaleid = 'zh_CN' and ", new Object[0]);
            sqlBuilder.appendIn("fid", iscObjids.toArray());
            try (DataSet iscDataSet = DB.queryDataSet((String)MigObjEasObjectUpgradeServiceImpl.class.getName(), (DBRoute)DBRoute.of((String)"eip"), (SqlBuilder)sqlBuilder);){
                while (iscDataSet.hasNext()) {
                    Row next = iscDataSet.next();
                    iscObjNameMapping.put(next.getLong("fid"), next.getString("fname"));
                }
            }
        }
    }

    private static List<Object[]> buildParams(Map<Long, List<Long>> easObjMap, Map<Long, String> map) {
        ArrayList<Object[]> params = new ArrayList<Object[]>(16);
        SqlBuilder migrateObjBuilder = new SqlBuilder();
        migrateObjBuilder.append(SELECT_MIGRATE_OBJ, new Object[0]).appendIn("fid", easObjMap.keySet().toArray());
        try (DataSet migrateObjDataSet = DB.queryDataSet((String)MigObjEasObjectUpgradeServiceImpl.class.getName(), (DBRoute)DBRoute.of((String)"imsc"), (SqlBuilder)migrateObjBuilder);){
            while (migrateObjDataSet.hasNext()) {
                Row next = migrateObjDataSet.next();
                Long fid = next.getLong("fid");
                String easObjectName = next.getString("feasobjectname");
                String easObjectId = next.getString("feasobjectid");
                StringBuilder easObjIdBuild = new StringBuilder();
                StringBuilder easObjNameBuild = new StringBuilder();
                List<Long> iscObjIds = easObjMap.get(fid);
                for (Long iscObjId : iscObjIds) {
                    easObjIdBuild.append(iscObjId).append(';');
                    String name = map.get(iscObjId);
                    if (!StringUtil.isNotEmpty(name)) continue;
                    easObjNameBuild.append(name).append(';');
                }
                if (StringUtil.isEmpty(easObjectName)) {
                    easObjectName = StringUtil.strDeleteLast(easObjNameBuild.toString());
                }
                if (StringUtil.isEmpty(easObjectId)) {
                    easObjectId = StringUtil.strDeleteLast(easObjIdBuild.toString());
                }
                ArrayList<Object> list = new ArrayList<Object>(16);
                list.add(easObjectName);
                list.add(easObjectId);
                list.add(fid);
                params.add(list.toArray());
            }
        }
        return params;
    }
}

