/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.plugin.formplugin.datacollect;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.url.UrlService;
import kd.imsc.dmw.engine.multiimport.MultiImportServiceTaskImpl;
import kd.imsc.dmw.engine.multiimport.helper.ImportServiceManagerHelper;
import kd.imsc.dmw.engine.multiimport.helper.MultiImpTaskHelper;
import kd.imsc.dmw.enums.MultiImpTaskStatusEnum;
import kd.imsc.dmw.helper.MultiImpAttachmentHelper;
import kd.imsc.dmw.helper.MultiImpSchemeHelper;
import kd.imsc.dmw.plugin.formplugin.datacollect.ProjectAllBaseUtil;
import kd.imsc.dmw.plugin.formplugin.datacollect.ProjectAuthFormUtil;
import kd.imsc.dmw.plugin.formplugin.datacollect.impt.ImportUtil;
import kd.imsc.dmw.plugin.formplugin.datacollect.upload.UploadUtil;
import kd.imsc.dmw.utils.CommonUtils;
import kd.imsc.dmw.utils.DynamicObjectUtils;
import kd.imsc.dmw.utils.FileUtils;
import kd.imsc.dmw.utils.StringUtil;
import kd.imsc.dmw.utils.StringUtils;
import kd.imsc.imbd.formplugin.AbstractImbdBdEditPlugin;

public class ProjectDetailBase
extends AbstractImbdBdEditPlugin
implements CellClickListener {
    private static final String CACHE_FAST_MANDATE_SELECT = "fastMandateSelectRow";
    private static final String REFRESH = "refresh";

    public void registerListener(EventObject e) {
        Toolbar importToolbar;
        super.registerListener(e);
        Toolbar toolbar = (Toolbar)this.getView().getControl("toolbar_collectnresultent");
        if (toolbar != null) {
            toolbar.addItemClickListener((ItemClickListener)this);
        }
        if ((importToolbar = (Toolbar)this.getView().getControl("toolbar_importresultentry")) != null) {
            importToolbar.addItemClickListener((ItemClickListener)this);
        }
        EntryGrid importResultEntry = (EntryGrid)this.getControl("importresultentry");
        importResultEntry.addCellClickListener((CellClickListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setCollectResultLabel();
        this.hideViewLogOp();
    }

    public void cellClick(CellClickEvent evt) {
        String fieldKey = evt.getFieldKey();
        if ("filename".equals(fieldKey)) {
            this.doDownloadSrcFile();
        } else if ("errorfile".equals(fieldKey)) {
            this.doDownloadErrorFile();
        }
    }

    public void cellDoubleClick(CellClickEvent evt) {
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String key;
        super.confirmCallBack(e);
        switch (key = e.getCallBackId()) {
            case "editreportor": {
                if (e.getResult() != MessageBoxResult.Yes) break;
                this.showUserF7TreeList();
                break;
            }
            case "taskurging": {
                if (e.getResult() != MessageBoxResult.Yes) break;
                this.taskUrging();
                break;
            }
            case "taskpermission": {
                if (e.getResult() == MessageBoxResult.Yes) {
                    this.fastMandate();
                    break;
                }
                this.getView().getPageCache().put(CACHE_FAST_MANDATE_SELECT, null);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        super.closedCallBack(e);
        switch (actionId = e.getActionId()) {
            case "taskassign": {
                this.getView().invokeOperation(REFRESH);
                break;
            }
            case "editreportor": {
                ListSelectedRowCollection rowColl = (ListSelectedRowCollection)e.getReturnData();
                this.editProjectDetailReportorUser(rowColl);
                break;
            }
            case "dataupload": {
                this.getView().invokeOperation(REFRESH);
                break;
            }
            case "dataimport": 
            case "importingCallBack": {
                this.getView().invokeOperation(REFRESH);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        AbstractOperate operate = (AbstractOperate)e.getSource();
        String key = operate.getOperateKey();
        if ("taskcancel".equals(key) || "taskfinish".equals(key)) {
            int[] selectRows = ((EntryGrid)this.getControl("collectresultentry")).getSelectRows();
            if (!CommonUtils.isNull(selectRows)) {
                ArrayList<Long> collectEntryIdList = new ArrayList<Long>(selectRows.length);
                for (int rowIndex : selectRows) {
                    collectEntryIdList.add(this.getModel().getEntryRowEntity("collectresultentry", rowIndex).getLong("id"));
                }
                operate.getOption().setVariableValue("selectentryid", SerializationUtils.toJsonString(collectEntryIdList));
            }
        } else if ("dataenable".equals(key) || "canceldataconfirm".equals(key)) {
            int[] selectRows = ((EntryGrid)this.getControl("importresultentry")).getSelectRows();
            if (!CommonUtils.isNull(selectRows)) {
                ArrayList<Long> importEntryIdList = new ArrayList<Long>(selectRows.length);
                for (int rowIndex : selectRows) {
                    importEntryIdList.add(this.getModel().getEntryRowEntity("importresultentry", rowIndex).getLong("id"));
                }
                operate.getOption().setVariableValue("selectimportentryid", SerializationUtils.toJsonString(importEntryIdList));
            }
        } else if ("dataupload".equals(key)) {
            this.checkCanUpload(e);
        } else if ("dataimport".equals(key)) {
            this.checkCanImport(e);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        boolean isSuccess;
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        boolean bl = isSuccess = e.getOperationResult() != null && e.getOperationResult().isSuccess();
        if (isSuccess) {
            switch (key) {
                case "taskassign": {
                    ArrayList<Long> detailIdList = new ArrayList<Long>(1);
                    detailIdList.add(this.getModel().getDataEntity().getLong("id"));
                    ProjectAuthFormUtil.showProjectAuthByDetailId(this.getView(), (IFormPlugin)this, detailIdList);
                    break;
                }
                case "editreportor": {
                    int[] selectRows = ((EntryGrid)this.getControl("collectresultentry")).getSelectRows();
                    if (selectRows.length > 1) {
                        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("editreportor", (IFormPlugin)this);
                        this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5df2\u9009\u62e9%s\u884c\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u4fee\u6539\u63d0\u62a5\u8d1f\u8d23\u4eba\uff1f", (String)"ProjectDetailBase_2", (String)"imsc-dmw-platform", (Object[])new Object[0]), selectRows.length), "", MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
                        break;
                    }
                    if (selectRows.length == 1) {
                        this.showUserF7TreeList();
                        break;
                    }
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5904\u7406\u7684\u6570\u636e\u884c\u3002", (String)"ProjectDetailBase_16", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                    break;
                }
                case "templatedown": {
                    long detailId = this.getModel().getDataEntity().getLong("id");
                    if (detailId <= 0L) break;
                    Object dataType = this.getModel().getValue("datatype");
                    int rowIndex = (Integer)this.getModel().getValue("entryseq");
                    if ("2".equals(dataType)) {
                        Object impScheme = this.getModel().getValue("impscheme");
                        long impSchemeId = DynamicObjectUtils.getPkValue((DynamicObject)impScheme);
                        ProjectAllBaseUtil.downloadImportTemplateByScheme(this.getView(), impSchemeId, rowIndex);
                        break;
                    }
                    String formId = DynamicObjectUtils.getStrPkValue(this.getModel().getDataEntity(), "dataobjid");
                    long templateId = DynamicObjectUtils.getPkValue(this.getModel().getDataEntity(), "datatemplateid");
                    try {
                        ProjectAllBaseUtil.downloadImportTemplate(this.getView(), formId, templateId, rowIndex);
                        break;
                    }
                    catch (IOException ex) {
                        throw new KDBizException((Throwable)ex, new ErrorCode("", ex.getMessage()), new Object[0]);
                    }
                }
                case "dataupload": {
                    this.showDataUploadPanel();
                    break;
                }
                case "dataimport": {
                    Object dataType = this.getModel().getValue("datatype");
                    if ("2".equals(dataType)) {
                        this.dataImportByScheme();
                        break;
                    }
                    this.showDataImportPanel();
                    break;
                }
                case "dataimportlog": {
                    this.showDataImportLog();
                    break;
                }
                case "taskcancel": 
                case "taskenable": 
                case "taskfinish": 
                case "canceltaskfinish": {
                    this.setCollectResultLabel();
                    break;
                }
                case "importrefresh": {
                    this.getView().invokeOperation(REFRESH);
                    break;
                }
                case "taskurging": {
                    int[] selectRowIndexs = ((EntryGrid)this.getControl("collectresultentry")).getSelectRows();
                    this.showTaskUrgingConfirm(selectRowIndexs);
                    break;
                }
                case "downloaderrorfile": {
                    this.doDownloadErrorFile();
                    break;
                }
                case "viewerrorlog": {
                    this.showDataImportLog();
                    break;
                }
                case "datacancel": 
                case "dataenable": 
                case "dataconfirm": 
                case "canceldataconfirm": {
                    this.hideViewLogOp();
                    break;
                }
                case "taskpermission": {
                    EntryGrid entryEntity = (EntryGrid)this.getControl("collectresultentry");
                    String tip = CommonUtils.isNull(entryEntity.getSelectRows()) ? ResManager.loadKDString((String)"\u5c06\u7ed9\u901a\u8fc7\u9884\u7f6e\u89d2\u8272\u7ed9\u6240\u6709\u5206\u5f55\u4e2d\u201c\u63d0\u62a5\u8d1f\u8d23\u4eba\u201d\u6388\u4e88\u5bf9\u5e94\u63d0\u62a5\u7ec4\u7ec7\u201c\u6570\u636e\u63d0\u62a5\u201d\u83dc\u5355\u6743\u9650\uff0c\u662f\u5426\u786e\u8ba4\u64cd\u4f5c\uff1f", (String)"ProjectDetailBase_8", (String)"imsc-dmw-platform", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5c06\u7ed9\u901a\u8fc7\u9884\u7f6e\u89d2\u8272\u7ed9\u9009\u4e2d\u5206\u5f55\u4e2d\u201c\u63d0\u62a5\u8d1f\u8d23\u4eba\u201d\u6388\u4e88\u5bf9\u5e94\u63d0\u62a5\u7ec4\u7ec7\u201c\u6570\u636e\u63d0\u62a5\u201d\u83dc\u5355\u6743\u9650\uff0c\u662f\u5426\u786e\u8ba4\u64cd\u4f5c\uff1f", (String)"ProjectDetailBase_9", (String)"imsc-dmw-platform", (Object[])new Object[0]);
                    String selectRowStr = SerializationUtils.toJsonString((Object)entryEntity.getSelectRows());
                    this.getView().getPageCache().put(CACHE_FAST_MANDATE_SELECT, selectRowStr);
                    this.getView().showConfirm(tip, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("taskpermission", (IFormPlugin)this));
                    break;
                }
            }
        }
    }

    private void doDownloadErrorFile() {
        EntryGrid entryEntity = (EntryGrid)this.getControl("importresultentry");
        int[] selectRows = entryEntity.getSelectRows();
        String errorFileUrl = (String)this.getModel().getValue("errorfile", selectRows[0]);
        if (StringUtils.isNotEmpty(errorFileUrl)) {
            IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            FileUtils.syncWriteFileBillMapping((String)"", (String)"dmw", (String)errorFileUrl, (String)"dmw_projectdetail", (String)"file", (String)this.getModel().getDataEntity().getString("id"), (String)"", (long)0L);
            proxy.addAction("download", (Object)errorFileUrl);
        }
    }

    private void doDownloadSrcFile() {
        EntryGrid entryEntity = (EntryGrid)this.getControl("importresultentry");
        int[] selectRows = entryEntity.getSelectRows();
        String fileName = (String)this.getModel().getValue("filename", selectRows[0]);
        if (StringUtils.isNotEmpty(fileName)) {
            MulBasedataDynamicObjectCollection fileCollection = (MulBasedataDynamicObjectCollection)this.getModel().getValue("file", selectRows[0]);
            DynamicObject file = (DynamicObject)fileCollection.get(0);
            DynamicObject fileBaseData = file.getDynamicObject("fbasedataid");
            String url = fileBaseData.getString("url");
            String downURL = UrlService.getDomainContextUrl() + "/attachment/download.do?path=" + url;
            IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            proxy.addAction("download", (Object)downURL);
        }
    }

    private void fastMandate() {
        String tips;
        String collectSelectRow = this.getView().getPageCache().get(CACHE_FAST_MANDATE_SELECT);
        List selectRowsList = (List)SerializationUtils.fromJsonString((String)collectSelectRow, List.class);
        DynamicObjectCollection collectEntryData = this.getModel().getEntryEntity("collectresultentry");
        HashMap<Long, List<Long>> assignInfo = new HashMap<Long, List<Long>>(8);
        HashMap<Long, Boolean> orgInfo = new HashMap<Long, Boolean>(8);
        if (selectRowsList.isEmpty()) {
            selectRowsList.addAll(IntStream.range(0, collectEntryData.size()).boxed().collect(Collectors.toList()));
        }
        for (Integer row : selectRowsList) {
            Long orgId = (Long)((DynamicObject)collectEntryData.get(row.intValue())).getDynamicObject("reportorgid").getPkValue();
            Long userId = (Long)((DynamicObject)collectEntryData.get(row.intValue())).getDynamicObject("reportorid").getPkValue();
            assignInfo.put(userId, Collections.singletonList(orgId));
            orgInfo.put(orgId, Boolean.FALSE);
        }
        boolean assignResult = PermissionServiceHelper.roleAssignUserOrg((String)"3RU2WV2ALFCE", assignInfo, orgInfo, (boolean)true);
        String string = tips = assignResult ? ResManager.loadKDString((String)"\u5feb\u901f\u6388\u6743\u6210\u529f\u3002", (String)"ProjectDetailBase_3", (String)"imsc-dmw-platform", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5feb\u901f\u6388\u6743\u5931\u8d25\u3002", (String)"ProjectDetailBase_4", (String)"imsc-dmw-platform", (Object[])new Object[0]);
        if (assignResult) {
            this.getView().showSuccessNotification(tips);
        } else {
            this.getView().showTipNotification(tips);
        }
    }

    private void showTaskUrgingConfirm(int[] selectRowIndexs) {
        if (CommonUtils.isNull(selectRowIndexs)) {
            int rowCount = this.getModel().getEntryRowCount("collectresultentry");
            selectRowIndexs = new int[rowCount];
            for (int i = 0; i < rowCount; ++i) {
                selectRowIndexs[i] = i;
            }
            int count = this.verifyReportStatus(selectRowIndexs);
            if (count > 0) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("taskurging", (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5c06\u63a8\u9001\u6d88\u606f\u81f3\u6240\u6709\u5f85\u63d0\u62a5\u72b6\u6001\u4efb\u52a1\u8d1f\u8d23\u4eba\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u53d1\u9001\u50ac\u529e\u901a\u77e5\uff1f", (String)"ProjectDetailBase_11", (String)"imsc-dmw-platform", (Object[])new Object[0]), "", MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
            }
        } else {
            int count = this.verifyReportStatus(selectRowIndexs);
            if (count > 0) {
                if (count == selectRowIndexs.length) {
                    ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("taskurging", (IFormPlugin)this);
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5c06\u63a8\u9001\u6d88\u606f\u81f3\u9009\u4e2d\u63d0\u62a5\u4efb\u52a1\u8d1f\u8d23\u4eba\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u53d1\u9001\u50ac\u529e\u901a\u77e5\uff1f", (String)"ProjectDetailBase_12", (String)"imsc-dmw-platform", (Object[])new Object[0]), "", MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u5206\u5f55\u884c\u9700\u5168\u90e8\u4e3a\u5f85\u63d0\u62a5\u72b6\u6001\u65f6\uff0c\u624d\u5141\u8bb8\u4efb\u52a1\u50ac\u529e\u3002", (String)"ProjectDetailBase_13", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                }
            }
        }
    }

    private int verifyReportStatus(int[] selectRowIndexs) {
        DynamicObjectCollection entryColl = this.getModel().getEntryEntity("collectresultentry");
        int statusCount = 0;
        for (int rowIndex : selectRowIndexs) {
            if (!"1".equals(((DynamicObject)entryColl.get(rowIndex)).getString("reportstatus"))) continue;
            ++statusCount;
        }
        if (statusCount == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5f85\u63d0\u62a5\u72b6\u6001\u4efb\u52a1\uff0c\u4e0d\u5141\u8bb8\u4efb\u52a1\u50ac\u529e\u3002", (String)"ProjectDetailBase_14", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        }
        return statusCount;
    }

    private void showUserF7TreeList() {
        ListShowParameter listParameter = ShowFormHelper.createShowListForm((String)"bos_user", (boolean)false);
        ArrayList<QFilter> rangeFilterList = new ArrayList<QFilter>();
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        rangeFilterList.add(enableFilter);
        listParameter.setListFilterParameter(new ListFilterParameter(rangeFilterList, null));
        listParameter.setCustomParam("externalUserType", (Object)"all");
        listParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "editreportor"));
        this.getView().showForm((FormShowParameter)listParameter);
    }

    private void editProjectDetailReportorUser(ListSelectedRowCollection rowColl) {
        if (CommonUtils.isNull(rowColl)) {
            return;
        }
        List idList = rowColl.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
        DynamicObjectType type = BusinessDataServiceHelper.newDynamicObject((String)"dmw_projectdetail").getDynamicObjectType();
        Object[] detailDynObjs = BusinessDataServiceHelper.load((Object[])new Object[]{this.getModel().getDataEntity().getPkValue()}, (DynamicObjectType)type);
        int[] selectRows = ((EntryGrid)this.getControl("collectresultentry")).getSelectRows();
        ArrayList<Long> resultIdList = new ArrayList<Long>(selectRows.length);
        for (int selectRow : selectRows) {
            resultIdList.add(this.getModel().getEntryRowEntity("collectresultentry", selectRow).getLong("id"));
        }
        String msg = "";
        for (DynamicObject dynamicObject : detailDynObjs) {
            if ("C".equals(DynamicObjectUtils.getString(dynamicObject.getDynamicObject("projectid"), "projectstatus"))) {
                msg = ResManager.loadKDString((String)"\u9879\u76ee\u72b6\u6001\u4e3a\u8ba1\u5212\u548c\u8fdb\u884c\u4e2d\u7684\u6570\u636e\u53ef\u4ee5\u4fee\u6539\u63d0\u62a5\u8d1f\u8d23\u4eba\u3002", (String)"ProjectDetailBase_17", (String)"imsc-dmw-platform", (Object[])new Object[0]);
                break;
            }
            DynamicObjectCollection entryColl = dynamicObject.getDynamicObjectCollection("collectresultentry");
            for (DynamicObject resultEntry : entryColl) {
                if (!resultIdList.contains(resultEntry.getLong("id"))) continue;
                DynamicObjectUtils.setDynamicObjectLPkValue(resultEntry, "reportorid", Long.parseLong(idList.get(0).toString()));
            }
        }
        if (StringUtil.isNotEmpty(msg)) {
            this.getView().showTipNotification(msg);
            return;
        }
        if (!CommonUtils.isNull(detailDynObjs)) {
            BusinessDataServiceHelper.loadRefence((Object[])detailDynObjs, (IDataEntityType)type);
            OperationResult opResult = SaveServiceHelper.saveOperate((String)"dmw_projectdetail", (DynamicObject[])detailDynObjs, (OperateOption)CommonUtils.getMutexOperateOption(false));
            if (!opResult.isSuccess()) {
                this.getView().showOperationResult(opResult);
            } else {
                this.getView().invokeOperation(REFRESH);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fee\u6539\u63d0\u62a5\u8d1f\u8d23\u4eba\u6210\u529f\u3002", (String)"ProjectDetailBase_15", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            }
        }
    }

    private void showDataUploadPanel() {
        EntryGrid entryEntity = (EntryGrid)this.getControl("collectresultentry");
        int[] selectRows = entryEntity.getSelectRows();
        long reportOrgId = 0L;
        DynamicObject projectDetail = BusinessDataServiceHelper.loadSingle((Object)this.getModel().getDataEntity().getPkValue(), (String)"dmw_projectdetail");
        DynamicObjectCollection importResultColl = projectDetail.getDynamicObjectCollection("collectresultentry");
        if (selectRows != null && selectRows.length == 1) {
            DynamicObject collectResult = this.getModel().getEntryRowEntity("collectresultentry", selectRows[0]);
            DynamicObject reportOrg = collectResult.getDynamicObject("reportorgid");
            long entryId = collectResult.getLong("id");
            DynamicObject dataBaseCollectResult = importResultColl.stream().filter(p -> p.getLong("id") == entryId).findFirst().orElseGet(DynamicObject::new);
            String reportStatus = dataBaseCollectResult.getString("reportstatus");
            if (reportOrg != null && "1".equals(reportStatus)) {
                reportOrgId = reportOrg.getLong("id");
            }
        }
        List allReportOrgIdList = importResultColl.stream().filter(p -> p.getDynamicObject("reportorgid") != null && "1".equals(p.getString("reportstatus"))).map(p -> p.getDynamicObject("reportorgid").getLong("id")).collect(Collectors.toList());
        long dataTemplateId = DynamicObjectUtils.getPkValue(projectDetail, "datatemplateid");
        String number = DynamicObjectUtils.getString(projectDetail.getDynamicObject("dataobjid"), "number");
        String dataType = DynamicObjectUtils.getString(projectDetail, "datatype");
        long schemeId = DynamicObjectUtils.getPkValue(projectDetail, "impscheme");
        long pkValue = (Long)this.getModel().getDataEntity().getPkValue();
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("dmw_fileupload");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("collectId", (Object)pkValue);
        formShowParameter.setCustomParam("BillFormId", (Object)number);
        formShowParameter.setCustomParam("datatemplateid", (Object)dataTemplateId);
        formShowParameter.setCustomParam("reportorgid", (Object)reportOrgId);
        formShowParameter.setCustomParam("filterOrgIdList", allReportOrgIdList);
        formShowParameter.setCustomParam("datatype", (Object)dataType);
        formShowParameter.setCustomParam("impscheme", (Object)schemeId);
        formShowParameter.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), "dataupload"));
        this.getView().showForm(formShowParameter);
    }

    private void showDataImportPanel() {
        DynamicObject collectObj = (DynamicObject)this.getView().getModel().getValue("dataobjid");
        long collectId = (Long)this.getModel().getDataEntity().getPkValue();
        EntryGrid entryEntity = (EntryGrid)this.getControl("importresultentry");
        int[] selectRows = entryEntity.getSelectRows();
        DynamicObjectCollection importResultEntryData = (DynamicObjectCollection)this.getModel().getValue("importresultentry");
        DynamicObject selectedData = (DynamicObject)importResultEntryData.get(selectRows[0]);
        MulBasedataDynamicObjectCollection fileCollection = (MulBasedataDynamicObjectCollection)selectedData.get("file");
        ArrayList<Map<String, Object>> fileList = new ArrayList<Map<String, Object>>(fileCollection.size());
        for (DynamicObject file : fileCollection) {
            HashMap<String, Object> fileMap = new HashMap<String, Object>(8);
            DynamicObject baseData = file.getDynamicObject("fbasedataid");
            fileMap.put("url", baseData.getString("url"));
            fileMap.put("name", baseData.getString("name"));
            fileMap.put("size", baseData.getInt("size"));
            fileMap.put("lastModified", baseData.getDate("modifytime"));
            fileMap.put("newFormat", Boolean.TRUE);
            fileList.add(fileMap);
        }
        ImportUtil.showDataImportPanel(this.getView(), collectId, selectedData.getLong("id"), collectObj, fileList, ((Object)((Object)this)).getClass().getName());
    }

    private void showDataImportLog() {
        Long logId;
        EntryGrid entryEntity = (EntryGrid)this.getControl("importresultentry");
        int[] selectRows = entryEntity.getSelectRows();
        Object dataType = this.getView().getModel().getValue("datatype");
        if (selectRows.length == 1 && (logId = (Long)this.getModel().getValue("logid", selectRows[0])) > 0L) {
            if ("2".equals(dataType)) {
                ImportUtil.showDataImportLogByScheme(this.getView(), logId);
                return;
            }
            ImportUtil.showDataImportLog(this.getView(), logId);
            return;
        }
        HashSet<Long> logIds = new HashSet<Long>();
        for (int selectRow : selectRows) {
            Long logId2 = (Long)this.getModel().getValue("logid", selectRow);
            if (logId2 <= 0L) continue;
            logIds.add(logId2);
        }
        if ("2".equals(dataType)) {
            ImportUtil.showDataImportLogListByScheme(this.getView(), new QFilter("id", "in", logIds));
        } else {
            DynamicObject collectObj = (DynamicObject)this.getView().getModel().getValue("dataobjid");
            String number = collectObj.getString("number");
            QFilter qFilter = new QFilter("sourceobj", "=", (Object)number);
            if (!logIds.isEmpty()) {
                qFilter.and(new QFilter("id", "in", logIds));
            }
            ImportUtil.showDataImportLogList(this.getView(), qFilter);
        }
    }

    private void setCollectResultLabel() {
        String resultMsg = ProjectAllBaseUtil.getCollectResultMsg(this.getModel().getDataEntity().getLong("id"));
        Label msgLabel = (Label)this.getControl("collectresult_label");
        msgLabel.setText(resultMsg);
    }

    private void hideViewLogOp() {
        EntryGrid importResultGrid = (EntryGrid)this.getControl("importresultentry");
        ArrayList<String> opeIds = new ArrayList<String>(2);
        opeIds.add("downloaderrorfile");
        opeIds.add("viewerrorlog");
        ArrayList errorFilelist = new ArrayList(1);
        errorFilelist.add(opeIds.get(0));
        DynamicObjectCollection importResultEntry = (DynamicObjectCollection)this.getModel().getValue("importresultentry");
        Object dataType = this.getModel().getValue("datatype");
        int index = 0;
        for (DynamicObject result : importResultEntry) {
            String dataStatus = result.getString("datastatus");
            if (!"4".equals(dataStatus)) {
                importResultGrid.hideOperateItems("operationcolumnap", index, opeIds);
            } else if ("2".equals(dataType)) {
                importResultGrid.hideOperateItems("operationcolumnap", index, errorFilelist);
            }
            ++index;
        }
    }

    private void taskUrging() {
        int[] selectRowIndexs = ((EntryGrid)this.getControl("collectresultentry")).getSelectRows();
        if (CommonUtils.isNull(selectRowIndexs)) {
            int rowCount = this.getModel().getEntryRowCount("collectresultentry");
            selectRowIndexs = new int[rowCount];
            for (int i = 0; i < rowCount; ++i) {
                selectRowIndexs[i] = i;
            }
        }
        DynamicObjectCollection entryColl = this.getModel().getEntryEntity("collectresultentry");
        ArrayList<Long> receiveUserIdList = new ArrayList<Long>(selectRowIndexs.length);
        for (int rowIndex : selectRowIndexs) {
            DynamicObject entryDynObj = (DynamicObject)entryColl.get(rowIndex);
            if (!"1".equals(entryDynObj.getString("reportstatus"))) continue;
            receiveUserIdList.add(DynamicObjectUtils.getPkValue(entryDynObj, "reportorid"));
        }
        if (!receiveUserIdList.isEmpty()) {
            String dataDescription = this.getModel().getDataEntity().getString("datadescription");
            Date endDatetime = this.getModel().getDataEntity().getDate("enddatetime");
            boolean success = ProjectAllBaseUtil.sendTaskUrgingMessage(this.getModel().getDataEntity().getLong("id"), receiveUserIdList, dataDescription, endDatetime);
            if (success) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u50ac\u529e\u53d1\u9001\u6d88\u606f\u6210\u529f\u3002", (String)"ProjectDetailBase_10", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            }
        }
    }

    private void checkCanUpload(BeforeDoOperationEventArgs e) {
        long projectDetailId = (Long)this.getModel().getDataEntity().getPkValue();
        boolean canUpload = UploadUtil.checkCanUpload(this.getView(), projectDetailId, 0L);
        if (!canUpload) {
            e.setCancel(true);
        }
    }

    private void checkCanImport(BeforeDoOperationEventArgs e) {
        EntryGrid entryEntity = (EntryGrid)this.getControl("importresultentry");
        int[] selectRows = entryEntity.getSelectRows();
        if (selectRows == null || selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u5bfc\u5165\u7684\u63d0\u62a5\u6570\u636e\u884c", (String)"ProjectDetailBase_5", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        if (selectRows.length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u53ea\u652f\u6301\u9009\u4e2d\u4e00\u6761", (String)"ProjectDetailBase_6", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        long projectDetailId = (Long)this.getModel().getDataEntity().getPkValue();
        long entryId = this.getModel().getEntryRowEntity("importresultentry", selectRows[0]).getLong("id");
        boolean canImport = ImportUtil.checkCanImport(this.getView(), projectDetailId, entryId);
        if (!canImport) {
            e.setCancel(true);
        }
    }

    private void dataImportByScheme() {
        Object impScheme = this.getModel().getValue("impscheme");
        long impSchemeId = DynamicObjectUtils.getPkValue((DynamicObject)impScheme);
        if (impSchemeId > 0L) {
            DynamicObject impTaskDynObj = BusinessDataServiceHelper.newDynamicObject((String)"dmw_imptask");
            OperationResult result = this.createImportTaskByScheme(impSchemeId, impTaskDynObj);
            long taskId = impTaskDynObj.getLong("id");
            if (result.isSuccess()) {
                DynamicObject selectedData = this.getSelectImportResultEntry();
                long detailResultId = selectedData.getLong("id");
                ProjectAllBaseUtil.setDataStatusToImporting(detailResultId, this.getModel().getDataEntity().getLong("id"));
                DynamicObjectCollection taskEntryEntity = impTaskDynObj.getDynamicObjectCollection("entryentity");
                Map<String, Object> jobParam = MultiImpTaskHelper.buildExecParams(taskId, (List<DynamicObject>)taskEntryEntity);
                jobParam.put("detailresult_id", detailResultId);
                ImportServiceManagerHelper.buildAndCommitJobFormInfo(this.getView(), taskId, this.getView().getFormShowParameter().getAppId(), "dmw_imptask", MultiImportServiceTaskImpl.class.getName(), null, jobParam, new CloseCallBack((IFormPlugin)this, "dataimport"));
            } else {
                String errorMsg = CommonUtils.buildOperationResultMessage(result, taskId);
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u81ea\u52a8\u521b\u5efa\u5bfc\u5165\u4efb\u52a1\u5931\u8d25\uff1a%s", (String)"ProjectDetailBase_18", (String)"imsc-dmw-platform", (Object[])new Object[0]), errorMsg));
            }
        }
    }

    private OperationResult createImportTaskByScheme(long impSchemeId, DynamicObject impTaskDynObj) {
        DynamicObject selectedData;
        MulBasedataDynamicObjectCollection fileCollection;
        DynamicObject schemeDynObj = BusinessDataServiceHelper.loadSingle((Object)impSchemeId, (String)"dmw_impscheme");
        String taskName = schemeDynObj.getString("name");
        if (StringUtils.isNotEmpty(taskName) && taskName.length() > 41) {
            taskName = taskName.substring(0, 41);
        }
        impTaskDynObj.set("name", (Object)String.join((CharSequence)"-", taskName, ResManager.loadKDString((String)"\u6570\u636e\u6536\u96c6\u5bfc\u5165\u521b\u5efa", (String)"ProjectDetailBase_19", (String)"imsc-dmw-platform", (Object[])new Object[0])));
        impTaskDynObj.set("impstatus", (Object)MultiImpTaskStatusEnum.SAVE.getStatus());
        impTaskDynObj.set("scheme", (Object)schemeDynObj);
        impTaskDynObj.set("schememodifytime", (Object)schemeDynObj.getDate("modifytime"));
        DynamicObjectCollection targetMetaColl = impTaskDynObj.getDynamicObjectCollection("tarmeta");
        targetMetaColl.clear();
        DynamicObjectCollection schemeTargetMetaColl = schemeDynObj.getDynamicObjectCollection("tarmeta");
        for (DynamicObject dy : schemeTargetMetaColl) {
            DynamicObject dynObj = targetMetaColl.addNew();
            dynObj.set("fbasedataid_id", dy.get("fbasedataid_id"));
        }
        long creatorId = UserServiceHelper.getCurrentUserId();
        long nowTime = KDDateUtils.now().getTime();
        impTaskDynObj.set("creator", (Object)creatorId);
        impTaskDynObj.set("createtime", (Object)nowTime);
        long taskId = DB.genLongId((String)impTaskDynObj.getDataEntityType().getAlias());
        impTaskDynObj.set("id", (Object)taskId);
        DynamicObjectCollection taskEntryEntity = impTaskDynObj.getDynamicObjectCollection("entryentity");
        MultiImpSchemeHelper.createEntryByScheme(schemeDynObj, taskEntryEntity);
        impTaskDynObj.set("modelinfo_tag", schemeDynObj.get("modelinfo_tag"));
        MultiImpAttachmentHelper.MultiImpAttachmentInfo srcAttachment = MultiImpAttachmentHelper.getSrcEntityAttachment("dmw_impscheme", impSchemeId, "attachmentpanelap");
        if (srcAttachment != null) {
            MultiImpAttachmentHelper.uploadByAttachUrl(srcAttachment.getName(), srcAttachment.getUrl(), taskId, "dmw_imptask", "tplpanelap");
        }
        if (!(fileCollection = (MulBasedataDynamicObjectCollection)(selectedData = this.getSelectImportResultEntry()).get("file")).isEmpty()) {
            DynamicObject file = (DynamicObject)fileCollection.get(0);
            DynamicObject baseData = file.getDynamicObject("fbasedataid");
            MultiImpAttachmentHelper.uploadByAttachUrl(baseData.getString("name"), baseData.getString("url"), taskId, "dmw_imptask", "attachmentpanelap");
        }
        return SaveServiceHelper.saveOperate((String)"dmw_imptask", (DynamicObject[])new DynamicObject[]{impTaskDynObj}, (OperateOption)CommonUtils.getOperateOption(false));
    }

    private DynamicObject getSelectImportResultEntry() {
        EntryGrid entryEntity = (EntryGrid)this.getControl("importresultentry");
        int[] importSelectRows = entryEntity.getSelectRows();
        DynamicObjectCollection importResultEntryData = (DynamicObjectCollection)this.getModel().getValue("importresultentry");
        return (DynamicObject)importResultEntryData.get(importSelectRows[0]);
    }
}

