/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.plugin.formplugin.datacollect;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.url.UrlService;
import kd.imsc.dmw.plugin.formplugin.datacollect.ProjectAllBaseUtil;
import kd.imsc.dmw.plugin.formplugin.datacollect.impt.ImportUtil;
import kd.imsc.dmw.utils.CommonUtils;
import kd.imsc.dmw.utils.DynamicObjectUtils;
import kd.imsc.dmw.utils.StringUtil;
import kd.imsc.dmw.utils.StringUtils;
import kd.imsc.imbd.formplugin.tpl.ImbdDymicTplEditPlugin;

public class ProjectReportForm
extends ImbdDymicTplEditPlugin
implements HyperLinkClickListener,
RowClickEventListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("importresultentry");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid taskEntry = (EntryGrid)this.getView().getControl("reporttasks");
        taskEntry.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid subEntryGrid = (EntryGrid)this.getControl("reporttasks");
        subEntryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setFormValue();
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        this.doDownloadSrcFile();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl("reporttasks");
        int[] selectRows = entryGrid.getSelectRows();
        int endIndex = entryGrid.getEntryData().getEndIndex();
        if (selectRows.length == 0 && endIndex > 0) {
            selectRows = new int[]{0};
            entryGrid.selectRows(selectRows[0], true);
        }
        this.updateContainerName(endIndex == 0 ? endIndex : selectRows[0]);
        String rowIndexStr = this.getView().getPageCache().get("refresh");
        int rowIndex = 0;
        if (StringUtils.isNotEmpty(rowIndexStr)) {
            rowIndex = Integer.parseInt(rowIndexStr);
        }
        this.hideViewLogOp(rowIndex);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String key = operate.getOperateKey();
        int[] selectTaskRows = ((EntryGrid)this.getControl("reporttasks")).getSelectRows();
        switch (key) {
            case "datacanel": 
            case "dataenable": 
            case "dataconfirm": 
            case "dataunconfirm": {
                if (selectTaskRows.length > 0) {
                    int[] subSelectRows = ((EntryGrid)this.getControl("importresultentry")).getSelectRows();
                    if (!CommonUtils.isNull(subSelectRows)) {
                        ArrayList<Long> importEntryIdList = new ArrayList<Long>(subSelectRows.length);
                        for (int rowIndex : subSelectRows) {
                            importEntryIdList.add(this.getModel().getEntryRowEntity("importresultentry", rowIndex).getLong("importresultentryid"));
                        }
                        operate.getOption().setVariableValue("importresultentryid", SerializationUtils.toJsonString(importEntryIdList));
                        ArrayList<Long> taskEntryIdList = new ArrayList<Long>(selectTaskRows.length);
                        for (int rowIndex : selectTaskRows) {
                            taskEntryIdList.add(this.getModel().getEntryRowEntity("reporttasks", rowIndex).getLong("collectresultentryid"));
                        }
                        operate.getOption().setVariableValue("collectresultentryid", SerializationUtils.toJsonString(taskEntryIdList));
                        operate.getOption().setVariableValue("operatetype", key);
                        break;
                    }
                    args.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u63d0\u62a5\u4efb\u52a1\u6e05\u5355\u5206\u5f55\u884c\u3002", (String)"ProjectReportForm_2", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                    break;
                }
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u63d0\u62a5\u4efb\u52a1\u6e05\u5355\u5206\u5f55\u884c\u3002", (String)"ProjectReportForm_2", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                break;
            }
            case "taskfinish": 
            case "canceltaskfinish": {
                if (selectTaskRows != null && selectTaskRows.length > 0) {
                    ArrayList<Long> taskEntryIdList = new ArrayList<Long>(selectTaskRows.length);
                    for (int rowIndex : selectTaskRows) {
                        taskEntryIdList.add(this.getModel().getEntryRowEntity("reporttasks", rowIndex).getLong("collectresultentryid"));
                    }
                    operate.getOption().setVariableValue("collectresultentryid", SerializationUtils.toJsonString(taskEntryIdList));
                    operate.getOption().setVariableValue("operatetype", key);
                    break;
                }
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u63d0\u62a5\u4efb\u52a1\u6e05\u5355\u5206\u5f55\u884c\u3002", (String)"ProjectReportForm_2", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                break;
            }
            case "excelupload": {
                this.checkCanUpload(args);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "excelupload": {
                this.showDataUploadPanel();
                break;
            }
            case "tpldownload": {
                int[] selectIndexs = ((EntryGrid)this.getControl("reporttasks")).getSelectRows();
                try {
                    if (CommonUtils.isNull(selectIndexs)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u63d0\u62a5\u4efb\u52a1\u6e05\u5355\u5206\u5f55\u884c\u3002", (String)"ProjectReportForm_2", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                        break;
                    }
                    if (selectIndexs.length != 1) break;
                    DynamicObject entryDynObj = this.getModel().getEntryRowEntity("reporttasks", selectIndexs[0]);
                    String dataType = DynamicObjectUtils.getString(entryDynObj, "datatype");
                    if ("1".equals(dataType)) {
                        String formId = DynamicObjectUtils.getStrPkValue(entryDynObj, "dataobjid");
                        long templateId = DynamicObjectUtils.getPkValue(entryDynObj, "datatemplateid");
                        ProjectAllBaseUtil.downloadImportTemplate(this.getView(), formId, templateId, selectIndexs[0] + 1);
                        break;
                    }
                    if (!"2".equals(dataType)) break;
                    long impSchemeId = DynamicObjectUtils.getPkValue(entryDynObj, "impscheme");
                    ProjectAllBaseUtil.downloadImportTemplateByScheme(this.getView(), impSchemeId, selectIndexs[0] + 1);
                    break;
                }
                catch (IOException ex) {
                    throw new KDBizException((Throwable)ex, new ErrorCode("", ex.getMessage()), new Object[0]);
                }
            }
            case "datacanel": 
            case "dataenable": 
            case "dataconfirm": 
            case "dataunconfirm": 
            case "taskfinish": 
            case "canceltaskfinish": 
            case "formrefresh": 
            case "subrefresh": {
                this.refreshAndSelectRow();
                break;
            }
            case "downloaderrorfile": {
                this.doDownloadErrorFile();
                break;
            }
            case "viewerrorlog": {
                this.showDataImportLog();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if ("dataupload".equals(actionId)) {
            this.refreshAndSelectRow();
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        this.updateContainerName(evt.getRow());
        this.hideViewLogOp(evt.getRow());
    }

    private void setFormValue() {
        long currentUserId = UserServiceHelper.getCurrentUserId();
        QFilter qFilter = new QFilter("collectresultentry.reportorid", "=", (Object)currentUserId).and(new QFilter("collectresultentry.reportstatus", "!=", (Object)"3")).and(new QFilter("projectid.projectstatus", "=", (Object)"B"));
        String fields = "id,projectid,entryseq,dataobjseq,datatype,impscheme,datatemplateid,dataobjid,enddatetime,datadescription,projectstatus,collectresultentry.reportorgid,collectresultentry.reportorid,collectresultentry.reportstatus,collectresultentry.finishuserid,finishdate,importresultentry.filename,importresultentry.datastatus,importresultentry.errormsg,importresultentry.reportorgid2,importresultentry.reportorid2,importresultentry.reportdate,importresultentry.confirmerid,importresultentry.confirmdate,importresultentry.importorid,importresultentry.importdate,importresultentry.errorfile,importresultentry.file,importresultentry.logid";
        long detaildId = CommonUtils.getLongCustomParamValue(this.getView(), "pkId");
        boolean isFromMsg = "wf_msg_center".equals(this.getView().getFormShowParameter().getParentFormId());
        if (isFromMsg && detaildId > 0L) {
            qFilter.and(new QFilter("id", "=", (Object)detaildId));
        }
        DynamicObject[] projectDetailCurUser = BusinessDataServiceHelper.load((String)"dmw_projectdetail", (String)fields, (QFilter[])qFilter.toArray(), (String)"dataobjseq");
        DynamicObjectCollection taskEntryColl = this.getModel().getEntryEntity("reporttasks");
        taskEntryColl.clear();
        int total = 0;
        int finish = 0;
        for (DynamicObject detail : projectDetailCurUser) {
            DynamicObjectCollection collectResultEntry = detail.getDynamicObjectCollection("collectresultentry");
            DynamicObjectCollection importResultEntry = detail.getDynamicObjectCollection("importresultentry");
            Map<Long, List<DynamicObject>> orgImportRowMapping = importResultEntry.stream().collect(Collectors.groupingBy(l -> l.getLong(String.join((CharSequence)"_", "reportorgid2", "id"))));
            DynamicObject projectId = detail.getDynamicObject("projectid");
            int seq = 1;
            for (DynamicObject entryRow : collectResultEntry) {
                long reportId = entryRow.getDynamicObject("reportorid").getLong("id");
                if (reportId == currentUserId && !StringUtils.equals(entryRow.getString("reportstatus"), "3")) {
                    ++total;
                    DynamicObject taskEntryDynObj = taskEntryColl.addNew();
                    taskEntryDynObj.set("seq", (Object)seq);
                    finish = this.setEntryValues(taskEntryDynObj, projectId, detail, entryRow, finish);
                    DynamicObjectCollection taskImportEntryColl = taskEntryDynObj.getDynamicObjectCollection("importresultentry");
                    taskImportEntryColl.clear();
                    Long reportOrg = (Long)entryRow.get("reportorgid_id");
                    List<DynamicObject> orgImportRows = orgImportRowMapping.get(reportOrg);
                    if (orgImportRows != null) {
                        this.setSubEntryValues(orgImportRows, taskImportEntryColl);
                    }
                }
                ++seq;
            }
        }
        String msg = ResManager.loadKDString((String)"\u63d0\u62a5\u5b8c\u6210\uff08%1$s/%2$s\uff09", (String)"ProjectReportForm_0", (String)"imsc-dmw-platform", (Object[])new Object[0]);
        Label msgLabel = (Label)this.getControl("cpmpleteinfo");
        msgLabel.setText(String.format(msg, finish, total));
    }

    private int setEntryValues(DynamicObject taskEntryDynObj, DynamicObject projectId, DynamicObject detail, DynamicObject entryRow, int finish) {
        taskEntryDynObj.set("id", detail.getPkValue());
        taskEntryDynObj.set("projectid", (Object)projectId);
        taskEntryDynObj.set("collecttasknumber", detail.get("dataobjseq"));
        Object dataType = detail.get("datatype");
        DynamicObject stdDataObj = detail.getDynamicObject("dataobjid");
        DynamicObject impScheme = detail.getDynamicObject("impscheme");
        if ("1".equals(dataType)) {
            taskEntryDynObj.set("dataobj", (Object)stdDataObj.getLocaleString("name").getLocaleValue());
        } else if ("2".equals(dataType)) {
            taskEntryDynObj.set("dataobj", (Object)impScheme.getLocaleString("name").getLocaleValue());
        }
        taskEntryDynObj.set("datatype", dataType);
        taskEntryDynObj.set("dataobjid", (Object)stdDataObj);
        taskEntryDynObj.set("datatemplateid", detail.get("datatemplateid"));
        taskEntryDynObj.set("impscheme", (Object)impScheme);
        String status = (String)entryRow.get("reportstatus");
        taskEntryDynObj.set("reportstatus", (Object)status);
        if (StringUtils.equals(status, "2")) {
            ++finish;
        }
        taskEntryDynObj.set("enddatetime", detail.get("enddatetime"));
        taskEntryDynObj.set("datadescription", detail.get("datadescription"));
        taskEntryDynObj.set("reportorgid", entryRow.get("reportorgid"));
        taskEntryDynObj.set("reportorid", entryRow.get("reportorid"));
        taskEntryDynObj.set("collectresultentryid", (Object)entryRow.getLong("id"));
        return finish;
    }

    private void setSubEntryValues(List<DynamicObject> orgImportRows, DynamicObjectCollection taskImportEntryColl) {
        int seq = 1;
        for (DynamicObject importRow : orgImportRows) {
            DynamicObject taskImportEntryDynObj = taskImportEntryColl.addNew();
            taskImportEntryDynObj.set("seq", (Object)seq);
            taskImportEntryDynObj.set("filename", importRow.get("filename"));
            DynamicObjectCollection fileCollection = importRow.getDynamicObjectCollection("file");
            if (!fileCollection.isEmpty()) {
                DynamicObject file = (DynamicObject)fileCollection.get(0);
                DynamicObject fileBaseData = file.getDynamicObject("fbasedataid");
                taskImportEntryDynObj.set("fileurl", (Object)fileBaseData.getString("url"));
            }
            String dataStatus = importRow.getString("datastatus");
            taskImportEntryDynObj.set("datastatus", (Object)dataStatus);
            taskImportEntryDynObj.set("errorfile", importRow.get("errorfile"));
            taskImportEntryDynObj.set("logid", importRow.get("logid"));
            taskImportEntryDynObj.set("errormsg", importRow.get("errormsg"));
            taskImportEntryDynObj.set("reportorgid2", importRow.get("reportorgid2"));
            taskImportEntryDynObj.set("reportorid2", importRow.get("reportorid2"));
            taskImportEntryDynObj.set("reportdate", importRow.get("reportdate"));
            taskImportEntryDynObj.set("confirmerid", importRow.get("confirmerid"));
            taskImportEntryDynObj.set("confirmdate", importRow.get("confirmdate"));
            taskImportEntryDynObj.set("importorid", importRow.get("importorid"));
            taskImportEntryDynObj.set("importdate", importRow.get("importdate"));
            taskImportEntryDynObj.set("importresultentryid", (Object)importRow.getLong("id"));
            ++seq;
        }
    }

    private void refreshAndSelectRow() {
        EntryGrid control = (EntryGrid)this.getControl("reporttasks");
        int[] selectRowIndexs = control.getSelectRows();
        if (!CommonUtils.isNull(selectRowIndexs)) {
            this.getView().getPageCache().put("refresh", String.valueOf(selectRowIndexs[0]));
        }
        this.getView().invokeOperation("refresh");
        int selectRow = Arrays.stream(selectRowIndexs).reduce(Integer::max).orElse(0);
        if (selectRowIndexs.length > 0 && control.getEntryData().getEndIndex() > 0 && selectRow <= control.getEntryData().getEndIndex()) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("reporttasks");
            entryGrid.selectRows(selectRowIndexs, selectRowIndexs[0]);
        }
    }

    private void showDataUploadPanel() {
        EntryGrid entryEntity = (EntryGrid)this.getControl("reporttasks");
        int[] selectRows = entryEntity.getSelectRows();
        long reportOrgId = 0L;
        DynamicObject entryDynObj = this.getModel().getEntryRowEntity("reporttasks", selectRows[0]);
        DynamicObject reportOrg = entryDynObj.getDynamicObject("reportorgid");
        if (reportOrg != null) {
            reportOrgId = reportOrg.getLong("id");
        }
        ArrayList<Long> allReportOrgIdList = new ArrayList<Long>(2);
        allReportOrgIdList.add(reportOrgId);
        DynamicObject dataTemplate = entryDynObj.getDynamicObject("datatemplateid");
        long pkValue = (Long)entryDynObj.getPkValue();
        long dataTemplateId = DynamicObjectUtils.getPkValue(dataTemplate);
        String number = DynamicObjectUtils.getString(entryDynObj.getDynamicObject("dataobjid"), "number");
        String dataType = DynamicObjectUtils.getString(entryDynObj, "datatype");
        long schemeId = DynamicObjectUtils.getPkValue(entryDynObj, "impscheme");
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("dmw_fileupload");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("collectId", (Object)pkValue);
        formShowParameter.setCustomParam("BillFormId", (Object)number);
        formShowParameter.setCustomParam("datatemplateid", (Object)dataTemplateId);
        formShowParameter.setCustomParam("reportorgid", (Object)reportOrgId);
        formShowParameter.setCustomParam("filterOrgIdList", allReportOrgIdList);
        formShowParameter.setCustomParam("datatype", (Object)dataType);
        formShowParameter.setCustomParam("impscheme", (Object)schemeId);
        formShowParameter.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), "dataupload"));
        this.getView().showForm(formShowParameter);
    }

    private void updateContainerName(int selectRow) {
        HashMap<String, LocaleString> props = new HashMap<String, LocaleString>(1);
        String suffix = (String)this.getModel().getValue("dataobj", selectRow);
        if (StringUtil.isNotEmpty(suffix)) {
            String containerName = ResManager.loadKDString((String)"\u63d0\u62a5\u6570\u636e\u5217\u8868", (String)"ProjectReportForm_3", (String)"imsc-dmw-platform", (Object[])new Object[0]);
            props.put("text", new LocaleString(String.join((CharSequence)"-", containerName, suffix)));
            this.getView().updateControlMetadata("advconap1", props);
        }
    }

    private void doDownloadErrorFile() {
        EntryGrid entryEntity = (EntryGrid)this.getControl("importresultentry");
        int[] selectRows = entryEntity.getSelectRows();
        String errorFileUrl = (String)this.getModel().getValue("errorfile", selectRows[0]);
        if (StringUtils.isNotEmpty(errorFileUrl)) {
            IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            proxy.addAction("download", (Object)errorFileUrl);
        }
    }

    private void doDownloadSrcFile() {
        EntryGrid entryEntity = (EntryGrid)this.getControl("importresultentry");
        int[] selectRows = entryEntity.getSelectRows();
        String fileName = (String)this.getModel().getValue("filename", selectRows[0]);
        if (StringUtils.isNotEmpty(fileName)) {
            String url = (String)this.getModel().getValue("fileurl", selectRows[0]);
            String downURL = UrlService.getDomainContextUrl() + "/attachment/download.do?path=" + url;
            IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            proxy.addAction("download", (Object)downURL);
        }
    }

    private void checkCanUpload(BeforeDoOperationEventArgs args) {
        EntryGrid entryEntity = (EntryGrid)this.getControl("reporttasks");
        int[] selectRows = entryEntity.getSelectRows();
        DynamicObject entryDynObj = this.getModel().getEntryRowEntity("reporttasks", selectRows[0]);
        long id = entryDynObj.getLong("id");
        long resultEntryId = entryDynObj.getLong("collectresultentryid");
        DynamicObject projectDetail = BusinessDataServiceHelper.loadSingle((Object)id, (String)"dmw_projectdetail");
        DynamicObjectCollection collectResultColl = projectDetail.getDynamicObjectCollection("collectresultentry");
        DynamicObject collectResult = collectResultColl.stream().filter(p -> p.getLong("id") == resultEntryId).findFirst().orElseGet(DynamicObject::new);
        DynamicObject collectProjectObj = projectDetail.getDynamicObject("projectid");
        String projectStatus = collectProjectObj.getString("projectstatus");
        if ("C".equals(projectStatus)) {
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6536\u96c6\u4efb\u52a1\u5df2\u5b8c\u6210\u73b0\u5df2\u65e0\u6cd5\u63d0\u62a5\uff0c\u8bf7\u8054\u7cfb\u6536\u96c6\u8d1f\u8d23\u4eba\u5904\u7406\u3002", (String)"ProjectReportForm_4", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            return;
        }
        String reportStatus = collectResult.getString("reportstatus");
        if (!"1".equals(reportStatus)) {
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u63d0\u62a5\u4efb\u52a1\u72b6\u6001\u4e3a\u5f85\u63d0\u62a5\u53ef\u4e0a\u4f20\u6587\u4ef6", (String)"ProjectReportForm_5", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            return;
        }
        Date now = new Date();
        Date endDateTime = projectDetail.getDate("enddatetime");
        if (endDateTime != null && now.after(endDateTime)) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(ResManager.loadKDString((String)"yyyy\u5e74MM\u6708dd\u65e5HH:mm:ss", (String)"ProjectReportForm_6", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            String tips = String.format(ResManager.loadKDString((String)"\u6536\u96c6\u4efb\u52a1\u622a\u6b62\u65f6\u95f4\u4e3a%s\uff0c\u73b0\u5df2\u65e0\u6cd5\u63d0\u62a5\uff0c\u8bf7\u8054\u7cfb\u6536\u96c6\u8d1f\u8d23\u4eba\u5904\u7406\u3002", (String)"ProjectReportForm_7", (String)"imsc-dmw-platform", (Object[])new Object[0]), dateFormat.format(endDateTime));
            this.getView().showTipNotification(tips);
            args.setCancel(true);
        }
        DynamicObject reportUser = collectResult.getDynamicObject("reportorid");
        DynamicObject org = collectResult.getDynamicObject("reportorgid");
        long userId = reportUser.getLong("id");
        if (UserServiceHelper.getCurrentUserId() != userId) {
            String tips = ResManager.loadKDString((String)"\u63d0\u62a5\u7ec4\u7ec7\u201c%1$s\u201d\uff0c\u63d0\u62a5\u8d1f\u8d23\u4eba\u5df2\u4fee\u6539\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u518d\u8bd5", (String)"ProjectReportForm_8", (String)"imsc-dmw-platform", (Object[])new Object[0]);
            this.getView().showTipNotification(String.format(tips, org.getLocaleString("name").getLocaleValue()));
            args.setCancel(true);
        }
    }

    private void showDataImportLog() {
        EntryGrid entryEntity = (EntryGrid)this.getControl("reporttasks");
        int[] selectRows = entryEntity.getSelectRows();
        Object dataType = this.getView().getModel().getValue("datatype", selectRows[0]);
        if (selectRows.length != 0) {
            Long logId;
            EntryGrid resultEntity = (EntryGrid)this.getControl("importresultentry");
            int[] resultRows = resultEntity.getSelectRows();
            if (selectRows.length == 1 && (logId = (Long)this.getModel().getValue("logid", resultRows[0])) > 0L) {
                if ("2".equals(dataType)) {
                    ImportUtil.showDataImportLogByScheme(this.getView(), logId);
                } else {
                    ImportUtil.showDataImportLog(this.getView(), logId);
                }
            }
        }
    }

    private void hideViewLogOp(int rowIndex) {
        Object dataType = this.getView().getModel().getValue("datatype", rowIndex);
        EntryGrid importResultGrid = (EntryGrid)this.getControl("importresultentry");
        ArrayList<String> opeIds = new ArrayList<String>(2);
        opeIds.add("downloaderrorfile");
        opeIds.add("viewerrorlog");
        ArrayList errorFilelist = new ArrayList(1);
        errorFilelist.add(opeIds.get(0));
        DynamicObject taskEntry = this.getModel().getEntryRowEntity("reporttasks", rowIndex);
        if (taskEntry == null) {
            return;
        }
        DynamicObjectCollection importResultEntry = taskEntry.getDynamicObjectCollection("importresultentry");
        int index = 0;
        for (DynamicObject result : importResultEntry) {
            String dataStatus = result.getString("datastatus");
            importResultGrid.hideOperateItems("operationcolumnap", index, null);
            if (!"4".equals(dataStatus)) {
                importResultGrid.hideOperateItems("operationcolumnap", index, opeIds);
            } else if ("2".equals(dataType)) {
                importResultGrid.hideOperateItems("operationcolumnap", index, errorFilelist);
            }
            ++index;
        }
    }
}

