/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.plugin.formplugin.datacollect.impt;

import com.alibaba.fastjson.JSON;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kd.bos.attachment.FileTypeEnum;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Operations;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.entity.property.PictureProp;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.export.util.ImpExpAttachmentUtil;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.BeforeUploadEvent;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.dto.ImportPermissionParam;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.ImportPermissionPlugin;
import kd.bos.form.plugin.ImportStartData;
import kd.bos.form.util.ImportOperationLog;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.form.control.AttachmentPanelAp;
import kd.bos.param.ParameterReader;
import kd.bos.service.attachment.extend.importdata.FileImportExtensionFactory;
import kd.bos.svc.util.FileHandlerUtil;
import kd.bos.utils.ImportPluginUtils;
import kd.imsc.dmw.plugin.formplugin.datacollect.ProjectAllBaseUtil;
import kd.imsc.dmw.plugin.formplugin.datacollect.impt.ImportUtil;
import kd.imsc.dmw.plugin.formplugin.datacollect.upload.ExcelDataChecker;
import kd.imsc.dmw.utils.CommonUtils;

public class ImportStartForm
extends ImportPermissionPlugin
implements UploadListener,
IConfirmCallBack {
    private static final Log logger = LogFactory.getLog(ImportStartForm.class);
    public static final String FLEXPANELAPIMGZIP = "flexpanelapimgzip";
    public static final String FLEXPANELAPATTZIP = "flexpanelapattzip";
    public static final String FILEIMGZIPTIP = "fileimgziptip";
    public static final String BTNIMGZIP = "btnimgzip";
    public static final String BTNATTZIP = "btnattzip";
    public static final String BTNIMGZIPDELETE = "btnimgzipdelete";
    public static final String BTNATTZIPDELETE = "btnattzipdelete";
    public static final String TEXTZIPFILENAME = "textzipfilename";
    public static final String TEXTZIPFILENAMEATT = "TEXTZIPFILENAMEATT";
    public static final String FILEPATHIMGZIP = "filepathimgzip";
    public static final String FILEPATHATTZIP = "filepathattzip";
    public static final String VECTORAPIMG = "vectorapimg";
    public static final String FILEPANELUPLOADSUCCESS = "filepaneluploadsuccess";
    public static final String FLEXAPIMGSUCCEED = "flexapimgsucceed";
    public static final String FLEXAPATTSUCCEED = "flexapattsucceed";
    public static final String BTNRESETFILE = "btnresetfile";
    private static final Log log = LogFactory.getLog(ImportStartForm.class);
    private static final String[] imgNameArrs = new String[]{".bmp", ".gif", ".jpg", ".png", ".jpeg"};
    private Map<Integer, String> allFieldNumber = new HashMap<Integer, String>(16);
    private static final String FILEPANEL = "filepanel";
    private static final String FLEXPANELAPTIP = "flexpanelaptip";
    private static final String OPTION_KEYFIELDS = "KeyFields";
    private static final String OPTION_OVERRIDEENTRY = "OverrideEntry";
    private static final String OPTION_SETNULL = "SetNULL";
    private static final String OPTION_SPLITSUBENTRIES = "SplitSubEntries";
    private static final String IMPORTTYPE = "importtype";
    private static final String IMPORTPLUGIN = "ImportPlugin";
    private static final String FILEPATH = "filepath";
    private static final String BTN_CLOSE_TIPS = "btnclosetips";
    private static final String FLEX_UPDATE_TIP = "updatetipspanel";
    private static final DistributeSessionlessCache redisCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("", new DistributeCacheHAPolicy(true, true));

    public void initialize() {
        this.addClickListeners(new String[]{"btnok", "btndownload", BTNRESETFILE, BTNIMGZIPDELETE, BTNATTZIPDELETE, BTN_CLOSE_TIPS});
        Image label = (Image)this.getControl("btnupload");
        Vector imgZipImageLabel = (Vector)this.getControl(BTNIMGZIP);
        Vector attZipImageLabel = (Vector)this.getControl(BTNATTZIP);
        label.addUploadListener((UploadListener)this);
        imgZipImageLabel.addUploadListener((UploadListener)this);
        attZipImageLabel.addUploadListener((UploadListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{FILEPANEL, FLEXPANELAPTIP, FLEXPANELAPIMGZIP, FLEXAPIMGSUCCEED, FLEXPANELAPATTZIP, FLEXAPATTSUCCEED, FLEX_UPDATE_TIP});
        ImportStartData.getInstance((AbstractFormPlugin)this, importStartData -> {
            Label title = (Label)this.getControl("title");
            if (Lang.en_US == RequestContext.get().getLang()) {
                title.setText("&nbsp;&nbsp;" + importStartData.getCustomParamData().getListName());
            } else {
                title.setText(importStartData.getCustomParamData().getListName());
            }
            this.init((ImportStartData)importStartData);
        });
    }

    private void init(ImportStartData importStartData) {
        List keyfieldItems;
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)importStartData.getCustomParamData().getBillFormId());
        String entityFormId = importStartData.getCustomParamData().getBillFormId();
        if (entityType instanceof QueryEntityType) {
            entityFormId = ((QueryEntityType)entityType).getEntityName();
        }
        if ((keyfieldItems = importStartData.getKeyfieldItems()).isEmpty()) {
            EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)entityFormId, (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
            List entityItems = entityMetadata.getItems();
            HashMap entityMap = new HashMap(entityItems.size());
            entityItems.forEach(item -> entityMap.put(item.getKey(), item.getName().getLocaleValue()));
            Set itemSet = ImportPluginUtils.getOverrideFields((List)entityItems);
            this.getPageCache().put("EntityMetadata", JSON.toJSONString(entityMap));
            for (IDataEntityProperty p : entityType.getProperties()) {
                if (!itemSet.contains(p.getName())) continue;
                keyfieldItems.add(new ComboItem(p.getDisplayName(), p.getName()));
            }
            if (entityType.getPrimaryKey() != null) {
                keyfieldItems.add(0, new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5185\u7801", (String)"ImportStartForm_2", (String)"imsc-dmw-platform", (Object[])new Object[0])), entityType.getPrimaryKey().getName()));
            }
        }
        if (!keyfieldItems.isEmpty()) {
            this.sortKeyfieldItems(keyfieldItems, entityType);
            ComboEdit combo = (ComboEdit)this.getControl("keyfields");
            combo.setComboItems(keyfieldItems);
        }
        if (importStartData.getImportTypeEnum() == ImportStartData.ImportStartTypeEnum.NEW) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"keyfields"});
        }
        String keyFields = this.getKeyFields(importStartData, entityFormId);
        this.getView().setEnable(Boolean.FALSE, importStartData.getLockKeys().toArray(new String[0]));
        this.getModel().setValue(IMPORTTYPE, (Object)importStartData.getImportTypeEnum().getType());
        if (importStartData.getImportTypeEnum() == ImportStartData.ImportStartTypeEnum.NEW) {
            this.getModel().setValue("keyfields", null);
        } else {
            this.getModel().setValue("keyfields", (Object)keyFields);
        }
    }

    private String getKeyFields(ImportStartData importStartData, String entityFormId) {
        String keyFields = importStartData.getKeyfields();
        if (StringUtils.isBlank((CharSequence)keyFields) && StringUtils.isNotBlank((CharSequence)(keyFields = this.getBillUniqueKeys(entityFormId)))) {
            importStartData.setFieldControl(ImportStartData.ImportStartFieldControlEnum.FORM_BILLPARAM);
            importStartData.setKeyfieldsFromBillParam(keyFields);
            if (!importStartData.getLockKeys().contains("keyfields")) {
                importStartData.getLockKeys().add("keyfields");
            }
        }
        return keyFields;
    }

    private void sortKeyfieldItems(List<ComboItem> keyfieldItems, MainEntityType entityType) {
        HashMap<String, Integer> sortMap = new HashMap<String, Integer>();
        String pk = entityType.getPrimaryKey().getName();
        sortMap.put(pk, 10);
        sortMap.put("billno", 8);
        if (entityType.getMainOrg() != null) {
            sortMap.put(entityType.getMainOrg(), 9);
        }
        Collections.sort(keyfieldItems, (o1, o2) -> {
            String v1 = o1.getValue();
            String v2 = o2.getValue();
            return sortMap.getOrDefault(v2, 0) - sortMap.getOrDefault(v1, 0);
        });
    }

    public void propertyChanged(PropertyChangedArgs e) {
        this.setImportStartTypeTip(e);
        ImportStartData.getInstance((AbstractFormPlugin)this, importStartData -> {
            String propertyName = e.getProperty().getName();
            if (IMPORTTYPE.equalsIgnoreCase(propertyName)) {
                String keyfields = (String)this.getModel().getValue("keyfields");
                String importtype = (String)this.getModel().getValue(propertyName);
                ImportStartData.ImportStartTypeEnum importStartTypeEnum = ImportStartData.ImportStartTypeEnum.getEnum((String)importtype);
                importStartData.setImportTypeEnum(importStartTypeEnum);
                if (ImportStartData.ImportStartTypeEnum.NEW == importStartTypeEnum) {
                    importStartData.setKeyfields(keyfields);
                    this.getModel().setValue("keyfields", null);
                    this.getView().setEnable(Boolean.FALSE, new String[]{"keyfields"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_UPDATE_TIP});
                } else {
                    this.getView().setVisible(Boolean.TRUE, new String[]{FLEX_UPDATE_TIP});
                    if (StringUtils.isBlank((CharSequence)keyfields)) {
                        keyfields = importStartData.getKeyfields();
                    }
                    if (StringUtils.isBlank((CharSequence)keyfields)) {
                        keyfields = importStartData.getKeyfieldsFromBillParam();
                    }
                    this.getModel().setValue("keyfields", (Object)keyfields);
                    if (ImportStartData.ImportStartFieldControlEnum.FORM_BILLPARAM == importStartData.getFieldControl()) {
                        this.getView().setEnable(Boolean.FALSE, new String[]{"keyfields"});
                    } else if (ImportStartData.ImportStartFieldControlEnum.FORM_BUSINESS == importStartData.getFieldControl() && importStartData.getLockKeys() != null && !importStartData.getLockKeys().isEmpty() && importStartData.getLockKeys().contains("keyfields")) {
                        this.getView().setEnable(Boolean.FALSE, new String[]{"keyfields"});
                    } else {
                        this.getView().setEnable(Boolean.TRUE, new String[]{"keyfields"});
                    }
                }
            }
        });
    }

    private void setImportStartTypeTip(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if (IMPORTTYPE.equalsIgnoreCase(propertyName)) {
            String importType = String.valueOf(this.getModel().getValue(propertyName));
            if (ImportStartData.ImportStartTypeEnum.NEW.getType().equals(importType)) {
                this.updateTipContent(ResManager.loadKDString((String)"\u5bfc\u5165\u65f6\u5728\u7cfb\u7edf\u4e2d\u6dfb\u52a0\u5168\u65b0\u7684\u6570\u636e\u3002", (String)"ImportStartForm_13", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            }
            if (ImportStartData.ImportStartTypeEnum.OVERRIDE.getType().equals(importType)) {
                this.updateTipContent(ResManager.loadKDString((String)"\u5bfc\u5165\u65f6\u6839\u636e\u6570\u636e\u66ff\u6362\u89c4\u5219\u7684\u552f\u4e00\u503c\u5b9a\u4e49\u7684\u5339\u914d\u5b57\u6bb5\uff0c\u505a\u552f\u4e00\u6027\u5339\u914d\uff0c\u5339\u914d\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\u7684\u552f\u4e00\u4e00\u6761\u6570\u636e\uff0c\u5bf9\u5176\u8fdb\u884c\u6570\u636e\u66f4\u65b0\u3002", (String)"ImportStartForm_14", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            }
            if (ImportStartData.ImportStartTypeEnum.OVERRIDENEW.getType().equals(importType)) {
                this.updateTipContent(ResManager.loadKDString((String)"\u5bfc\u5165\u65f6\u5148\u6839\u636e\u66f4\u65b0\u89c4\u5219\uff0c\u5339\u914d\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\u7684\u6570\u636e\u8fdb\u884c\u66f4\u65b0\uff0c\u672a\u5339\u914d\u5230\u7684\u6570\u636e\uff0c\u6309\u6dfb\u52a0\u65b0\u6570\u636e\u903b\u8f91\u6267\u884c\u3002", (String)"ImportStartForm_15", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            }
        }
    }

    private void updateTipContent(String content) {
        HashMap controlMap = new HashMap();
        HashMap<String, String> contentMap = new HashMap<String, String>();
        contentMap.put("content", content);
        controlMap.put("tips", contentMap);
        this.getView().updateControlMetadata("labelap", controlMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void click(EventObject evt) {
        FormShowParameter currShowParameter = this.getView().getFormShowParameter();
        OperationResult result = new OperationResult();
        String orgIdsStr = (String)currShowParameter.getCustomParam("MainOrgIds");
        ImportPermissionParam.Buidler importPermissionParamBuidler = new ImportPermissionParam.Buidler().setBizAppId((String)currShowParameter.getCustomParam("CheckRightAppId")).setMainOrgIds(StringUtils.isNotBlank((CharSequence)orgIdsStr) ? JSON.parseArray((String)orgIdsStr, Long.class) : new ArrayList(0)).setRealEntityId((String)currShowParameter.getCustomParam("RealPermissionEntityId")).setCurrentEntityId((String)currShowParameter.getCustomParam("BillFormId")).setOperateName((String)currShowParameter.getCustomParam("OperateName")).setPermissionItemId((String)currShowParameter.getCustomParam("PermissionItemId")).setResult(result);
        switch (((Control)evt.getSource()).getKey()) {
            case "btnok": {
                try {
                    if (!this.validatePermission(importPermissionParamBuidler.build())) {
                        this.doFailCheckRight(result);
                        this.createNoPermissionOperationLog(result);
                        return;
                    }
                    String url = this.checkAndReturnUrl();
                    String imgZipUrl = this.returnImgZipUrl();
                    String attZipUrl = this.returnAttZipUrl();
                    if (this.checkToImportNow()) {
                        this.importData(url, imgZipUrl, attZipUrl);
                    }
                    this.createOperationLogByStart(true);
                }
                catch (KDBizException e) {
                    this.createOperationLogByStart(false);
                    this.getView().showErrorNotification(e.getMessage());
                }
                break;
            }
            case "btndownload": {
                Boolean success = Boolean.FALSE;
                try {
                    if (!this.validatePermission(importPermissionParamBuidler.build())) {
                        this.doFailCheckRight(result);
                        return;
                    }
                    String billFormId = (String)currShowParameter.getCustomParam("BillFormId");
                    if (StringUtils.isBlank((CharSequence)billFormId)) {
                        this.getView().showMessage(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u7c7b\u578b", (String)"ImportStartForm_6", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                        return;
                    }
                    FormShowParameter showParameter = new FormShowParameter();
                    showParameter.setFormId("bos_downloadtemplate");
                    showParameter.getOpenStyle().setShowType(ShowType.Modal);
                    showParameter.setCustomParam("BillFormId", (Object)billFormId);
                    showParameter.setCustomParam("BillTypeId", currShowParameter.getCustomParam("BillTypeId"));
                    showParameter.setCustomParam(IMPORTPLUGIN, (Object)this.getImportPlugin(currShowParameter));
                    showParameter.setCustomParam("TemplateType", (Object)"IMPT");
                    showParameter.setCustomParam("ServiceAppId", (Object)this.getView().getFormShowParameter().getServiceAppId());
                    showParameter.setCustomParam("OperateKey", currShowParameter.getCustomParam("OperateKey"));
                    this.getView().showForm(showParameter);
                    success = Boolean.TRUE;
                    break;
                }
                finally {
                    this.createOperationLogByDownload(success);
                }
            }
            case "btnresetfile": {
                if (!StringUtils.isEmpty((CharSequence)this.getModel().getValue(FILEPATHIMGZIP).toString()) || !StringUtils.isEmpty((CharSequence)this.getModel().getValue(FILEPATHATTZIP).toString())) {
                    String msg = ResManager.loadKDString((String)"\u5220\u9664Excel\u6587\u4ef6\uff0c\u5c06\u540c\u65f6\u5220\u9664\u56fe\u7247/\u9644\u4ef6\u8d44\u6e90\u5305\uff0c\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ImportStartForm_37", (String)"imsc-dmw-platform", (Object[])new Object[0]);
                    this.getView().showConfirm(msg, MessageBoxOptions.YesNo, new ConfirmCallBackListener(BTNRESETFILE, (IConfirmCallBack)this));
                    break;
                }
                this.resetExcelFile();
                break;
            }
            case "btnimgzipdelete": {
                this.delImgZip();
                break;
            }
            case "btnattzipdelete": {
                this.delAttZip();
                break;
            }
            case "btnclosetips": {
                this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_UPDATE_TIP});
                break;
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String filePath = this.getModel().getValue(FILEPATH).toString();
        String filePathImgZip = this.getModel().getValue(FILEPATHIMGZIP).toString();
        String attPathImgZip = this.getModel().getValue(FILEPATHATTZIP).toString();
        FileHandlerUtil.tryDelFile((String)filePath);
        FileHandlerUtil.tryDelFile((String)filePathImgZip);
        FileHandlerUtil.tryDelFile((String)attPathImgZip);
    }

    private void resetExcelFile() {
        if (StringUtils.isNotEmpty((CharSequence)this.getPageCache().get("uoloading_btnattzip"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u6839\u636e\u662f\u5426\u51fa\u73b0\u201c\u538b\u7f29\u5305\u5185\u5305\u542b\u4e0d\u5141\u8bb8\u4e0a\u4f20\u7684\u6587\u4ef6\u7c7b\u578b\u3001\u65e0\u4e0a\u4f20\u6587\u4ef6\u6743\u9650\u201d\u7b49\u4e0d\u5141\u8bb8\u4e0a\u4f20\u538b\u7f29\u5305\u7684\u63d0\u793a\uff0c\u91c7\u53d6\u5bf9\u5e94\u64cd\u4f5c\uff1a1.\u5982\u679c\u51fa\u73b0\u4e0d\u5141\u8bb8\u4e0a\u4f20\u538b\u7f29\u5305\u7684\u63d0\u793a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6388\u4e88\u4e0a\u4f20\u6587\u4ef6\u6743\u9650\u6216\u91cd\u65b0\u6253\u5f00\u5bfc\u5165\u6570\u636e\u754c\u9762\uff0c\u7136\u540e\u91cd\u4f20\u65b0\u7684\u538b\u7f29\u5305\u30022.\u5982\u679c\u6ca1\u6709\u63d0\u793a\u4e0d\u5141\u8bb8\u4e0a\u4f20\u538b\u7f29\u5305\uff0c\u8bf7\u7b49\u5f85\u538b\u7f29\u5305\u4e0a\u4f20\u5b8c\u6210\u3002", (String)"ImportStartForm_40", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getPageCache().get("uoloading_btnimgzip"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u6839\u636e\u662f\u5426\u51fa\u73b0\u201c\u538b\u7f29\u5305\u5185\u5305\u542b\u4e0d\u5141\u8bb8\u4e0a\u4f20\u7684\u6587\u4ef6\u7c7b\u578b\u201d\u7b49\u4e0d\u5141\u8bb8\u4e0a\u4f20\u538b\u7f29\u5305\u7684\u63d0\u793a\uff0c\u91c7\u53d6\u5bf9\u5e94\u64cd\u4f5c\uff1a1.\u5982\u679c\u51fa\u73b0\u4e0d\u5141\u8bb8\u4e0a\u4f20\u538b\u7f29\u5305\u7684\u63d0\u793a\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u5bfc\u5165\u6570\u636e\u754c\u9762\uff0c\u7136\u540e\u91cd\u4f20\u65b0\u7684\u538b\u7f29\u5305\u30022.\u5982\u679c\u6ca1\u6709\u63d0\u793a\u4e0d\u5141\u8bb8\u4e0a\u4f20\u538b\u7f29\u5305\uff0c\u8bf7\u7b49\u5f85\u538b\u7f29\u5305\u4e0a\u4f20\u5b8c\u6210\u3002", (String)"ImportStartForm_41", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isNotBlank((Object)this.getModel().getValue(FILEPATHIMGZIP))) {
            this.delImgZip();
        }
        if (StringUtils.isNotBlank((Object)this.getModel().getValue(FILEPATHATTZIP))) {
            this.delAttZip();
        }
        FileHandlerUtil.tryDelFile((String)this.getModel().getValue(FILEPATH).toString());
        this.getModel().setValue("filename", (Object)"");
        this.getModel().setValue(FILEPATH, (Object)"");
        this.getView().setVisible(Boolean.FALSE, new String[]{FILEPANELUPLOADSUCCESS, FLEXAPIMGSUCCEED, FLEXPANELAPIMGZIP, FLEXPANELAPATTZIP, FLEXAPATTSUCCEED, FLEXPANELAPTIP});
        this.getView().setVisible(Boolean.TRUE, new String[]{"uploadpanel"});
    }

    private void delImgZip() {
        FileHandlerUtil.tryDelFile((String)this.getModel().getValue(FILEPATHIMGZIP).toString());
        this.getModel().setValue(TEXTZIPFILENAME, (Object)"");
        this.getModel().setValue(FILEPATHIMGZIP, (Object)"");
        this.getView().setVisible(Boolean.TRUE, new String[]{FLEXPANELAPIMGZIP});
        this.getView().setVisible(Boolean.FALSE, new String[]{FLEXAPIMGSUCCEED});
    }

    private void delAttZip() {
        FileHandlerUtil.tryDelFile((String)this.getModel().getValue(FILEPATHATTZIP).toString());
        this.getModel().setValue(TEXTZIPFILENAMEATT, (Object)"");
        this.getModel().setValue(FILEPATHATTZIP, (Object)"");
        this.getView().setVisible(Boolean.TRUE, new String[]{FLEXPANELAPATTZIP});
        this.getView().setVisible(Boolean.FALSE, new String[]{FLEXAPATTSUCCEED});
    }

    private boolean checkToImportNow() {
        long entryId = (Long)this.getView().getFormShowParameter().getCustomParam("entryid");
        long projectDetailId = (Long)this.getView().getFormShowParameter().getCustomParam("collectid");
        boolean canImport = ImportUtil.checkCanImport(this.getView(), projectDetailId, entryId);
        if (!canImport) {
            return false;
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getPageCache().get("uoloading_btnattzip"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u6839\u636e\u662f\u5426\u51fa\u73b0\u201c\u538b\u7f29\u5305\u5185\u5305\u542b\u4e0d\u5141\u8bb8\u4e0a\u4f20\u7684\u6587\u4ef6\u7c7b\u578b\u3001\u65e0\u4e0a\u4f20\u6587\u4ef6\u6743\u9650\u201d\u7b49\u4e0d\u5141\u8bb8\u4e0a\u4f20\u538b\u7f29\u5305\u7684\u63d0\u793a\uff0c\u91c7\u53d6\u5bf9\u5e94\u64cd\u4f5c\uff1a1.\u5982\u679c\u51fa\u73b0\u4e0d\u5141\u8bb8\u4e0a\u4f20\u538b\u7f29\u5305\u7684\u63d0\u793a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6388\u4e88\u4e0a\u4f20\u6587\u4ef6\u6743\u9650\u6216\u91cd\u65b0\u6253\u5f00\u5bfc\u5165\u6570\u636e\u754c\u9762\uff0c\u7136\u540e\u91cd\u4f20\u65b0\u7684\u538b\u7f29\u5305\u30022.\u5982\u679c\u6ca1\u6709\u63d0\u793a\u4e0d\u5141\u8bb8\u4e0a\u4f20\u538b\u7f29\u5305\uff0c\u8bf7\u7b49\u5f85\u538b\u7f29\u5305\u4e0a\u4f20\u5b8c\u6210\u3002", (String)"ImportStartForm_40", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            return false;
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getPageCache().get("uoloading_btnimgzip"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u6839\u636e\u662f\u5426\u51fa\u73b0\u201c\u538b\u7f29\u5305\u5185\u5305\u542b\u4e0d\u5141\u8bb8\u4e0a\u4f20\u7684\u6587\u4ef6\u7c7b\u578b\u201d\u7b49\u4e0d\u5141\u8bb8\u4e0a\u4f20\u538b\u7f29\u5305\u7684\u63d0\u793a\uff0c\u91c7\u53d6\u5bf9\u5e94\u64cd\u4f5c\uff1a1.\u5982\u679c\u51fa\u73b0\u4e0d\u5141\u8bb8\u4e0a\u4f20\u538b\u7f29\u5305\u7684\u63d0\u793a\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u5bfc\u5165\u6570\u636e\u754c\u9762\uff0c\u7136\u540e\u91cd\u4f20\u65b0\u7684\u538b\u7f29\u5305\u30022.\u5982\u679c\u6ca1\u6709\u63d0\u793a\u4e0d\u5141\u8bb8\u4e0a\u4f20\u538b\u7f29\u5305\uff0c\u8bf7\u7b49\u5f85\u538b\u7f29\u5305\u4e0a\u4f20\u5b8c\u6210\u3002", (String)"ImportStartForm_41", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            return false;
        }
        FormShowParameter currShowParameter = this.getView().getFormShowParameter();
        IPageCache cache = this.getView().getPageCache();
        String importtype = (String)this.getModel().getValue(IMPORTTYPE);
        String entryHasNoId = cache.get("EntryHasNoId");
        boolean overrideEntry = Boolean.parseBoolean(cache.get(OPTION_OVERRIDEENTRY));
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)((String)currShowParameter.getCustomParam("BillFormId")));
        if (!StringUtils.equals((CharSequence)"new", (CharSequence)importtype) && (overrideEntry || StringUtils.isNotBlank((CharSequence)entryHasNoId)) && !(entityType instanceof QueryEntityType)) {
            String msg = overrideEntry ? ResManager.loadKDString((String)"\u5df2\u5f00\u542f #OverrideEntry \u5173\u952e\u5b57\uff0c\u66f4\u65b0\u6a21\u5f0f\u4e0b\uff0c\u5339\u914d\u5230\u7684\u5355\u636e\u5c06\u8986\u76d6\u6240\u6709\u5206\u5f55\uff0c\u662f\u5426\u786e\u8ba4\uff1f", (String)"ImportStartForm_4", (String)"imsc-dmw-platform", (Object[])new Object[0]) : String.format(ResManager.loadKDString((String)"\u66f4\u65b0\u6a21\u5f0f\u4e0b\uff0c\u7531\u4e8e\u5bfc\u5165\u6a21\u677f\u7684%s\u5b9e\u4f53\u4e0d\u5305\u542b\u5206\u5f55id\uff0c\u5c06\u6267\u884c\u5206\u5f55\u65b0\u589e\uff0c\u662f\u5426\u786e\u8ba4\uff1f", (String)"ImportStartForm_5", (String)"imsc-dmw-platform", (Object[])new Object[0]), entryHasNoId);
            this.getView().showConfirm(msg, MessageBoxOptions.YesNo, new ConfirmCallBackListener("ImportConfirmCallBack", (IConfirmCallBack)this));
            return false;
        }
        return true;
    }

    private void createOpLogAndDelFileByUpload(boolean status, String url) {
        if (status) {
            ImportOperationLog.getInstance().createAppLog(this.getView(), (String)this.getView().getFormShowParameter().getCustomParam("BillFormId"), ImportOperationLog.OperationEnum.UPLOAD_FILE_SUCCESS.getOpName(), String.format(ImportOperationLog.OperationEnum.UPLOAD_FILE_SUCCESS.getOpDescFormat(), url.substring(url.lastIndexOf(47) + 1)));
            return;
        }
        FileHandlerUtil.tryDelFile((String)url);
        ImportOperationLog.getInstance().createAppLog(this.getView(), (String)this.getView().getFormShowParameter().getCustomParam("BillFormId"), ImportOperationLog.OperationEnum.UPLOAD_FILE_FAIL.getOpName(), String.format(ImportOperationLog.OperationEnum.UPLOAD_FILE_FAIL.getOpDescFormat(), url.substring(url.lastIndexOf(47) + 1)));
    }

    private void createOperationLogByStart(boolean status) {
        if (status) {
            ImportOperationLog.getInstance().createAppLog(this.getView(), (String)this.getView().getFormShowParameter().getCustomParam("BillFormId"), ImportOperationLog.OperationEnum.IMPORT_START_SUCCESS.getOpName(), ImportOperationLog.OperationEnum.IMPORT_START_SUCCESS.getOpDescFormat());
            return;
        }
        ImportOperationLog.getInstance().createAppLog(this.getView(), (String)this.getView().getFormShowParameter().getCustomParam("BillFormId"), ImportOperationLog.OperationEnum.IMPORT_START_FAIL.getOpName(), ImportOperationLog.OperationEnum.IMPORT_START_FAIL.getOpDescFormat());
    }

    private void createNoPermissionOperationLog(OperationResult result) {
        List errList = result.getValidateResult().getValidateErrors();
        StringBuilder sb = new StringBuilder();
        for (ValidateResult errResult : errList) {
            for (IOperateInfo errInfo : errResult.getAllErrorInfo()) {
                sb.append(errInfo.getMessage());
            }
        }
        String errorTips = sb.toString();
        ImportOperationLog.getInstance().createAppLog((String)this.getView().getFormShowParameter().getCustomParam("BillFormId"), ImportOperationLog.OperationEnum.IMPORT_NOPERMISSION_FAIL.getOpName(), errorTips);
    }

    private void createOperationLogByDownload(Boolean success) {
        if (success.booleanValue()) {
            ImportOperationLog.getInstance().createAppLog((String)this.getView().getFormShowParameter().getCustomParam("BillFormId"), ImportOperationLog.OperationEnum.DOWNLOAD_CLICK_SUCCESS.getOpName(), ImportOperationLog.OperationEnum.DOWNLOAD_CLICK_SUCCESS.getOpDescFormat());
            return;
        }
        ImportOperationLog.getInstance().createAppLog((String)this.getView().getFormShowParameter().getCustomParam("BillFormId"), ImportOperationLog.OperationEnum.DOWNLOAD_CLICK_FAIL.getOpName(), ImportOperationLog.OperationEnum.DOWNLOAD_CLICK_FAIL.getOpDescFormat());
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (messageBoxClosedEvent.getCallBackId().equals(BTNRESETFILE) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.resetExcelFile();
            return;
        }
        if (messageBoxClosedEvent.getResult() != MessageBoxResult.Yes) {
            return;
        }
        String url = this.checkAndReturnUrl();
        String imgZipUrl = this.returnImgZipUrl();
        String attZipUrl = this.returnAttZipUrl();
        this.importData(url, imgZipUrl, attZipUrl);
    }

    private String checkAndReturnUrl() {
        String url = (String)this.getModel().getValue(FILEPATH);
        if (StringUtils.isBlank((CharSequence)url)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u6570\u636e\u6587\u4ef6\u540e\u64cd\u4f5c\u3002", (String)"ImportStartForm_7", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        }
        if (!"new".equals(this.getModel().getValue(IMPORTTYPE)) && StringUtils.isBlank((Object)this.getModel().getValue("keyfields"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5339\u914d\u89c4\u5219\u3002", (String)"ImportStartForm_8", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        }
        return url;
    }

    private String returnImgZipUrl() {
        return (String)this.getModel().getValue(FILEPATHIMGZIP);
    }

    private String returnAttZipUrl() {
        return (String)this.getModel().getValue(FILEPATHATTZIP);
    }

    private void importData(String url, String imgZipUrl, String attZipUrl) {
        ImportStartData.getInstance((AbstractFormPlugin)this, importStartData -> {
            long entryId = CommonUtils.getLongCustomParamValue(this.getView(), "entryid");
            long collectId = CommonUtils.getLongCustomParamValue(this.getView(), "collectid");
            ProjectAllBaseUtil.setDataStatusToImporting(entryId, collectId);
            IFormView view = this.getView();
            FormShowParameter showParam = view.getFormShowParameter();
            Operations ops = EntityMetadataCache.getDataEntityOperations((String)FormMetadataCache.getFormConfig((String)importStartData.getCustomParamData().getBillFormId()).getEntityTypeId());
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("dmw_datacollect_importing");
            showParameter.getOpenStyle().setShowType(ShowType.InCurrentForm);
            HashMap<String, Object> params = new HashMap<String, Object>(16);
            String importType = (String)this.getModel().getValue(IMPORTTYPE);
            params.put("Type", importType);
            if (!"new".equals(importType)) {
                params.put(OPTION_KEYFIELDS, this.getModel().getValue("keyfields"));
                if ("override".equals(importType)) {
                    params.put("ForUpdateMultiLangFields", view.getPageCache().get("ForUpdateMultiLangFields"));
                }
                params.put(OPTION_OVERRIDEENTRY, view.getPageCache().get(OPTION_OVERRIDEENTRY));
            }
            params.put(OPTION_SETNULL, view.getPageCache().get(OPTION_SETNULL));
            params.put(OPTION_SPLITSUBENTRIES, view.getPageCache().get(OPTION_SPLITSUBENTRIES));
            params.put("ServiceAppId", importStartData.getCustomParamData().getServiceAppId());
            params.put("CheckRightAppId", importStartData.getCustomParamData().getCheckrightappid());
            params.put("BillFormId", importStartData.getCustomParamData().getBillFormId());
            params.put("ListName", importStartData.getCustomParamData().getListName());
            params.put("OpSave", ops.getSave());
            params.put("Url", url);
            params.put("imgZipUrl", imgZipUrl);
            params.put("attZipUrl", attZipUrl);
            params.put(IMPORTPLUGIN, this.getImportPlugin(showParam));
            params.put("OperateKey", showParam.getCustomParam("OperateKey"));
            params.put("OperateName", showParam.getCustomParam("OperateName"));
            params.put("RealPermissionEntityId", showParam.getCustomParam("RealPermissionEntityId"));
            params.put("PermissionItemId", showParam.getCustomParam("PermissionItemId"));
            params.put("MainOrgIds", showParam.getCustomParam("MainOrgIds"));
            params.put("entryid", entryId);
            params.put("collectid", collectId);
            showParameter.setCustomParams(params);
            showParameter.setParentPageId(showParam.getParentPageId());
            showParameter.setCloseCallBack(showParam.getCloseCallBack());
            view.showForm(showParameter);
        });
    }

    private String getImportPlugin(FormShowParameter showParam) {
        List plugins;
        String pluginName = (String)showParam.getCustomParam(IMPORTPLUGIN);
        if (StringUtils.isBlank((CharSequence)pluginName) && (plugins = (List)showParam.getCustomParam("plugins")) != null) {
            for (Map p : plugins) {
                if (!Boolean.TRUE.equals(p.get("Enabled"))) continue;
                return (String)p.get("ClassName");
            }
        }
        return pluginName;
    }

    public void beforeUpload(BeforeUploadEvent evt) {
        String uploadKey;
        FormShowParameter currShowParameter = this.getView().getFormShowParameter();
        OperationResult result = new OperationResult();
        String orgIdsStr = (String)currShowParameter.getCustomParam("MainOrgIds");
        ImportPermissionParam.Buidler importPermissionParamBuidler = new ImportPermissionParam.Buidler().setBizAppId((String)currShowParameter.getCustomParam("CheckRightAppId")).setMainOrgIds(StringUtils.isNotBlank((CharSequence)orgIdsStr) ? JSON.parseArray((String)orgIdsStr, Long.class) : new ArrayList(0)).setRealEntityId((String)currShowParameter.getCustomParam("RealPermissionEntityId")).setCurrentEntityId((String)currShowParameter.getCustomParam("BillFormId")).setOperateName((String)currShowParameter.getCustomParam("OperateName")).setPermissionItemId((String)currShowParameter.getCustomParam("PermissionItemId")).setResult(result);
        if (!this.validatePermission(importPermissionParamBuidler.build())) {
            HashMap<String, Integer> param = new HashMap<String, Integer>(1);
            param.put("status", 0);
            ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("beforeUploadResult", param);
            this.doFailCheckRight(result);
        }
        if (!StringUtils.equals((CharSequence)(uploadKey = ((Control)evt.getSource()).getKey()), (CharSequence)BTNATTZIP)) {
            redisCache.put("import_" + currShowParameter.getCustomParam("BillFormId") + "_" + currShowParameter.getPageId(), (Object)"true", 10000);
        }
        if (StringUtils.equals((CharSequence)uploadKey, (CharSequence)BTNATTZIP)) {
            this.getPageCache().put("uoloading_btnattzip", "true");
        }
        if (StringUtils.equals((CharSequence)uploadKey, (CharSequence)BTNIMGZIP)) {
            this.getPageCache().put("uoloading_btnimgzip", "true");
        }
    }

    public void upload(UploadEvent evt) {
        String uploadKey = ((Control)evt.getSource()).getKey();
        if (StringUtils.equals((CharSequence)uploadKey, (CharSequence)BTNATTZIP)) {
            this.getPageCache().remove("uoloading_btnattzip");
        }
        if (StringUtils.equals((CharSequence)uploadKey, (CharSequence)BTNIMGZIP)) {
            this.getPageCache().remove("uoloading_btnimgzip");
        }
        if (StringUtils.equals((CharSequence)uploadKey, (CharSequence)"btnupload")) {
            this.getPageCache().remove("uoloading_btnattzip");
            this.getPageCache().remove("uoloading_btnimgzip");
        }
        Object[] urls = evt.getUrls();
        String callbackKey = evt.getCallbackKey();
        if (urls.length > 0) {
            IFormView view = this.getView();
            String url = (String)urls[0];
            if (callbackKey.equals(BTNATTZIP)) {
                this.validZip(url, FileTypeEnum.ATTACHMENT);
            } else if (callbackKey.equals(BTNIMGZIP)) {
                this.validZip(url, FileTypeEnum.IMAGE);
            } else if ("btnupload".equals(callbackKey)) {
                Boolean hasAttPropOrPanel;
                FileService service = FileServiceFactory.getAttachmentFileService();
                try (InputStream in = FileImportExtensionFactory.getFileImportExtension().decode(url, service.getInputStream(url));){
                    ExcelDataChecker excelDataChecker = new ExcelDataChecker(this.getView(), in);
                    excelDataChecker.doCheck();
                    this.allFieldNumber = excelDataChecker.getAllFieldNumber();
                    if (!excelDataChecker.isRightEntity()) {
                        throw new KDBizException(ExcelDataChecker.getExcelFormatErrorTips());
                    }
                    if (!excelDataChecker.hasDataRow()) {
                        this.createOpLogAndDelFileByUpload(false, url);
                        view.showErrorNotification(ResManager.loadKDString((String)"\u672a\u89e3\u6790\u5230\u6709\u6548\u6570\u636e\uff0c\u8bf7\u5f55\u5165\u6570\u636e\u540e\u518d\u8bd5\u3002", (String)"ImportStartForm_16", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                        this.afterUploadFail();
                        return;
                    }
                    HashMap<String, String> tipsInfo = new HashMap<String, String>(2);
                    if (!excelDataChecker.validSensitiveFields(tipsInfo)) {
                        String title = tipsInfo.getOrDefault("title", "");
                        String content = tipsInfo.getOrDefault("content", "");
                        if (StringUtils.isNotEmpty((CharSequence)title)) {
                            view.showMessage(title, content, MessageTypes.Default);
                        } else {
                            view.showErrorNotification(content);
                        }
                        this.createOpLogAndDelFileByUpload(false, url);
                        this.afterUploadFail();
                        return;
                    }
                }
                catch (KDBizException e) {
                    ErrorCode code = e.getErrorCode();
                    if (code == null || !"ValidFile".equalsIgnoreCase(code.getCode())) {
                        view.showErrorNotification(e.getMessage());
                        this.createOpLogAndDelFileByUpload(false, url);
                        this.afterUploadFail();
                        return;
                    }
                    this.createOpLogAndDelFileByUpload(true, url);
                }
                catch (Exception e) {
                    this.createOpLogAndDelFileByUpload(false, url);
                    log.error((Throwable)e);
                    view.showErrorNotification(ExcelDataChecker.getExcelFormatErrorTips());
                    this.afterUploadFail();
                    return;
                }
                this.createOpLogAndDelFileByUpload(true, url);
                view.setVisible(Boolean.TRUE, new String[]{FILEPANEL, FILEPANELUPLOADSUCCESS});
                view.setVisible(Boolean.FALSE, new String[]{"uploadpanel"});
                IDataModel model = this.getModel();
                model.setValue("filename", (Object)url.substring(url.lastIndexOf(47) + 1));
                model.setValue(FILEPATH, (Object)url);
                Boolean hasImgProp = this.hasImgProp();
                if (hasImgProp.booleanValue()) {
                    view.setVisible(Boolean.TRUE, new String[]{FLEXPANELAPIMGZIP});
                }
                if ((hasAttPropOrPanel = this.hasAttPropOrPanel()).booleanValue()) {
                    view.setVisible(Boolean.TRUE, new String[]{FLEXPANELAPATTZIP});
                }
                if (!hasImgProp.booleanValue() && !hasAttPropOrPanel.booleanValue()) {
                    view.setVisible(Boolean.TRUE, new String[]{FLEXPANELAPTIP});
                }
            }
        }
    }

    private void afterUploadFail() {
        this.getView().setEnable(Boolean.FALSE, new String[]{"btnok"});
    }

    private void validZip(String url, FileTypeEnum fileTypeEnum) {
        try {
            FileService service = FileServiceFactory.getAttachmentFileService();
            InputStream in = FileImportExtensionFactory.getFileImportExtension().decode(url, service.getInputStream(url));
            BufferedInputStream buffInputStream = new BufferedInputStream(in, in.available() + 1);
            this.checkZipFile(buffInputStream, fileTypeEnum);
            IFormView view = this.getView();
            if (fileTypeEnum == FileTypeEnum.ATTACHMENT) {
                view.setVisible(Boolean.FALSE, new String[]{FLEXPANELAPATTZIP});
                this.getModel().setValue(FILEPATHATTZIP, (Object)url);
                view.getModel().setValue(TEXTZIPFILENAMEATT, (Object)url.substring(url.lastIndexOf(47) + 1));
                view.setVisible(Boolean.TRUE, new String[]{FLEXAPATTSUCCEED});
            } else {
                view.setVisible(Boolean.FALSE, new String[]{FLEXPANELAPIMGZIP});
                this.getModel().setValue(FILEPATHIMGZIP, (Object)url);
                view.getModel().setValue(TEXTZIPFILENAME, (Object)url.substring(url.lastIndexOf(47) + 1));
                view.setVisible(Boolean.TRUE, new String[]{FLEXAPIMGSUCCEED});
            }
        }
        catch (Exception e) {
            log.error("excelSecurityVerification create BufferedInputStream error is " + e);
            if (e instanceof KDBizException) {
                this.getView().showErrorNotification(e.getMessage());
                return;
            }
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u538b\u7f29\u5305\u89e3\u6790\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u5206\u6790", (String)"ImportStartForm_36", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkZipFile(BufferedInputStream in, FileTypeEnum fileTypeEnum) throws IOException {
        try (ZipInputStream zipIn = new ZipInputStream((InputStream)in, Charset.forName("GBK"));){
            ZipEntry zipEntry = zipIn.getNextEntry();
            if (zipEntry == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u538b\u7f29\u5305\u89e3\u6790\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u5206\u6790", (String)"ImportStartForm_36", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            }
            while (null != zipEntry) {
                if (zipEntry.isDirectory()) {
                    if (FileTypeEnum.IMAGE == fileTypeEnum) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u56fe\u7247\u538b\u7f29\u5305\u5185\u542b\u6709\u6587\u4ef6\u5939\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\u56fe\u7247\u538b\u7f29\u5305\u3002", (String)"ImportStartForm_34", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                    }
                    throw new KDBizException(ResManager.loadKDString((String)"\u9644\u4ef6\u538b\u7f29\u5305\u5185\u542b\u6709\u6587\u4ef6\u5939\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\u9644\u4ef6\u538b\u7f29\u5305\u3002", (String)"ImportStartForm_39", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                }
                if (fileTypeEnum == FileTypeEnum.IMAGE && !this.isImgName(zipEntry.getName())) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230%s\u6587\u4ef6\u4e0d\u5c5e\u4e8e\u56fe\u7247\u5b57\u6bb5\u5141\u8bb8\u4e0a\u4f20\u7c7b\u578b\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\u56fe\u7247\u538b\u7f29\u5305\u3002", (String)"ImportStartForm_35", (String)"imsc-dmw-platform", (Object[])new Object[0]), zipEntry.getName()));
                }
                zipEntry = zipIn.getNextEntry();
            }
        }
        finally {
            in.close();
        }
    }

    private boolean isImgName(String name) {
        for (String imgName : imgNameArrs) {
            if (!name.toLowerCase(Locale.ROOT).endsWith(imgName)) continue;
            return true;
        }
        return false;
    }

    private Boolean hasImgProp() {
        String billFormId = (String)this.getView().getFormShowParameter().getCustomParam("BillFormId");
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)billFormId);
        for (String field : this.allFieldNumber.values()) {
            if (!(entityType.getAllFields().get(field) instanceof PictureProp)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private Boolean hasAttPropOrPanel() {
        String billFormId = (String)this.getView().getFormShowParameter().getCustomParam("BillFormId");
        List attachmentPanelAps = ImpExpAttachmentUtil.getAttachmentPanelAps((String)billFormId);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)billFormId);
        for (String field : this.allFieldNumber.values()) {
            if (!(entityType.getAllFields().get(field) instanceof AttachmentProp)) continue;
            return Boolean.TRUE;
        }
        for (AttachmentPanelAp attachmentPanelAp : attachmentPanelAps) {
            if (!this.allFieldNumber.containsValue(attachmentPanelAp.getKey())) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private String getBillUniqueKeys(String billFormId) {
        DynamicObject obj = ParameterReader.getBillParameter((String)billFormId);
        if (obj != null) {
            return obj.getString("billuniquekeys");
        }
        return null;
    }
}

