/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.plugin.formplugin.datacollect.impt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class ImportUtil {
    private ImportUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static Map<String, Object> getImportOpInfo(String entityNumber) {
        List ops = EntityMetadataCache.getDataEntityOperate((String)entityNumber);
        Map importOp = Collections.emptyMap();
        for (Map op : ops) {
            String opType = (String)op.get("type");
            if (!"importdata".equals(opType)) continue;
            importOp = op;
            break;
        }
        return importOp;
    }

    public static String getImportPlugin(Map<String, Object> importOpMap) {
        int size;
        ArrayList plugins;
        String importPlugin = "";
        LinkedHashMap opParam = (LinkedHashMap)importOpMap.get("parameter");
        if (opParam != null && (plugins = (ArrayList)opParam.get("plugins")) != null && (size = plugins.size()) > 0) {
            for (int i = 0; i < size; ++i) {
                Map p = (Map)plugins.get(i);
                if (!Boolean.TRUE.equals(p.get("Enabled"))) continue;
                importPlugin = String.valueOf(p.get("ClassName"));
                break;
            }
        }
        return importPlugin;
    }

    public static List<Map<String, Object>> getPreinsFiles(Map<String, Object> importOpMap) {
        ArrayList preinsFiles = Collections.emptyList();
        LinkedHashMap opParam = (LinkedHashMap)importOpMap.get("parameter");
        if (opParam != null) {
            preinsFiles = (ArrayList)opParam.get("preinsfiles");
        }
        return preinsFiles;
    }

    public static void showDataImportPanel(IFormView view, long collectId, long entryId, DynamicObject collectObj, List<Map<String, Object>> fileList, String callBackClass) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("dmw_datacollect_import");
        FormShowParameter formShowParameter = view.getFormShowParameter();
        String number = collectObj.getString("number");
        FormConfig config = FormMetadataCache.getFormConfig((String)number);
        String billFormId = config.getEntityTypeId();
        String listName = config.getCaption().toString();
        Map<String, Object> importOpMap = ImportUtil.getImportOpInfo(number);
        showParameter.setCustomParam("ServiceAppId", (Object)formShowParameter.getServiceAppId());
        showParameter.setCustomParam("CheckRightAppId", (Object)formShowParameter.getCheckRightAppId());
        showParameter.setCustomParam("BillFormId", (Object)billFormId);
        showParameter.setCustomParam("ListName", (Object)listName);
        showParameter.setCustomParam("OperateKey", importOpMap.get("key"));
        Map nameMap = (Map)importOpMap.get("name");
        showParameter.setCustomParam("OperateName", nameMap.get(RequestContext.get().getLang().name()));
        showParameter.setCustomParam("PermissionItemId", importOpMap.get("permission"));
        showParameter.setCustomParam("RealPermissionEntityId", (Object)number);
        List<Map<String, Object>> preinsfiles = ImportUtil.getPreinsFiles(importOpMap);
        showParameter.setCustomParam("PreInsFiles", preinsfiles);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack(callBackClass, "importingCallBack");
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.setCustomParam("entryid", (Object)entryId);
        showParameter.setCustomParam("collectid", (Object)collectId);
        showParameter.setCustomParam("fileList", fileList);
        view.showForm(showParameter);
    }

    public static void showDataImportLogList(IFormView view, QFilter qFilter) {
        ImportUtil.showDataImportLogList(view, "bos_importlog", qFilter);
    }

    public static void showDataImportLogListByScheme(IFormView view, QFilter qFilter) {
        ImportUtil.showDataImportLogList(view, "dmw_task_excute_report", qFilter);
    }

    private static void showDataImportLogList(IFormView view, String formId, QFilter qFilter) {
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId(formId);
        parameter.setParentFormId(view.getFormShowParameter().getFormId());
        parameter.setParentPageId(view.getFormShowParameter().getPageId());
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.getListFilterParameter().setFilter(qFilter);
        view.showForm((FormShowParameter)parameter);
    }

    public static void showDataImportLog(IFormView view, long logId) {
        ImportUtil.showDataImportLog(view, "bos_importlog", logId);
    }

    public static void showDataImportLogByScheme(IFormView view, long logId) {
        ImportUtil.showDataImportLog(view, "dmw_task_excute_report", logId);
    }

    private static void showDataImportLog(IFormView view, String formId, long logId) {
        BillShowParameter parameter = new BillShowParameter();
        parameter.setFormId(formId);
        parameter.setParentFormId(view.getFormShowParameter().getFormId());
        parameter.setParentPageId(view.getFormShowParameter().getPageId());
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setPkId((Object)logId);
        view.showForm((FormShowParameter)parameter);
    }

    public static boolean checkCanImport(IFormView view, long projectDetailId, long importEntryId) {
        DynamicObject projectDetail = BusinessDataServiceHelper.loadSingle((Object)projectDetailId, (String)"dmw_projectdetail");
        DynamicObjectCollection importResultColl = projectDetail.getDynamicObjectCollection("importresultentry");
        DynamicObject importResult = importResultColl.stream().filter(p -> p.getLong("id") == importEntryId).findFirst().orElseGet(DynamicObject::new);
        String dataStatus = importResult.getString("datastatus");
        DynamicObject collectProjectObj = projectDetail.getDynamicObject("projectid");
        String projectStatus = collectProjectObj.getString("projectstatus");
        if (!"B".equals(projectStatus)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u9879\u76ee\u72b6\u6001\u4e3a\u8fdb\u884c\u4e2d\u624d\u5141\u8bb8\u5bfc\u5165\u7cfb\u7edf", (String)"ImportUtil_0", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            return false;
        }
        if (!"2".equals(dataStatus) && !"4".equals(dataStatus)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u4ec5\u5df2\u786e\u8ba4\u3001\u5bfc\u5165\u5931\u8d25\u6570\u636e\u53ef\u5bfc\u5165\u7cfb\u7edf", (String)"ImportUtil_1", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            return false;
        }
        return true;
    }
}

