/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.plugin.formplugin.eas;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.ShaSignUtils;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.imsc.dmw.errorcode.DmwBizException;
import kd.imsc.dmw.utils.HttpUtils;
import kd.imsc.dmw.utils.QFilterUtils;
import kd.imsc.dmw.utils.StringUtil;
import kd.imsc.imbd.formplugin.AbstractImbdDymicPlugin;
import org.apache.commons.collections.MapUtils;

public class DmwCloudSolutionEdit
extends AbstractImbdDymicPlugin
implements SearchEnterListener {
    private static final Log log = LogFactory.getLog((String)DmwCloudSolutionEdit.class.getName());
    private static final String[] fieldNames = new String[]{"id", "number", "name", "group_name", "version", "key_words", "modifytime"};
    public static final String KEY_SEARCH = "solution_search";
    public static final String ENTRY_ENTITY = "entryentity";
    public static final int PAGE_SIZE = 1000;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
        Search search = (Search)this.getControl(KEY_SEARCH);
        search.addEnterListener((SearchEnterListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initCloudSolData();
    }

    private void initCloudSolData() {
        Long schemeId = this.getView().getFormShowParameter().getCustomParams().getOrDefault("schemeid", 0L);
        JSONArray rows = this.getCloudSolPackageData();
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity(ENTRY_ENTITY);
        int row = -1;
        for (int i = 0; i < rows.size(); ++i) {
            JSONObject rowObj = (JSONObject)rows.get(i);
            DynamicObject entry = entryentity.addNew();
            Long id = rowObj.getLong("id");
            entry.set("schemeid", (Object)id);
            if (id.equals(schemeId)) {
                row = i;
            }
            entry.set("number", (Object)rowObj.getString("number"));
            entry.set("name", (Object)rowObj.getString("name"));
            entry.set("groupname", (Object)rowObj.getString("group_name"));
            entry.set("version", (Object)rowObj.getString("version"));
            entry.set("keywords", (Object)rowObj.getString("key_words"));
            entry.set("modifytime", (Object)rowObj.getDate("modifytime"));
        }
        this.getPageCache().put("row", String.valueOf(row));
        this.getModel().updateEntryCache(entryentity);
        this.getView().updateView(ENTRY_ENTITY);
    }

    private JSONArray getCloudSolPackageData() {
        DynamicObject[] centers;
        JSONArray rows = new JSONArray();
        this.getCloudResource(rows, 1);
        Set ids = rows.stream().map(n -> ((JSONObject)n).getLong("id")).collect(Collectors.toSet());
        QFilter[] idsQfilter = QFilterUtils.getEnableQFilter().and("id", "not in", ids).toArray();
        for (DynamicObject center : centers = BusinessDataServiceHelper.load((String)"isc_solution_center", (String)"id,number,name,key_words,version,group,modifytime", (QFilter[])idsQfilter)) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("id", center.get("id"));
            jsonObject.put("number", center.get("number"));
            jsonObject.put("name", center.get("name"));
            DynamicObject group = center.getDynamicObject("group");
            String groupName = group == null ? null : group.getString("name");
            jsonObject.put("group_name", (Object)groupName);
            jsonObject.put("version", center.get("version"));
            jsonObject.put("key_words", center.get("key_words"));
            jsonObject.put("modifytime", center.get("modifytime"));
            rows.add((Object)jsonObject);
        }
        return rows;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String row = this.getPageCache().get("row");
        if (StringUtils.isNotEmpty((String)row)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
            entryGrid.selectRows(Integer.parseInt(row));
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btnok".equals(key)) {
            this.okClick();
        }
    }

    private void okClick() {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows != null && selectRows.length > 0) {
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(ENTRY_ENTITY, this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY));
            map.put("schemeid", entryRowEntity.getLong("schemeid"));
            map.put("number", entryRowEntity.getString("number"));
            map.put("name", entryRowEntity.getString("name"));
        }
        this.getView().returnDataToParent(map);
        this.getView().close();
    }

    public void search(SearchEnterEvent evt) {
        String text = evt.getText();
        this.searchCloudSol(text);
    }

    private void searchCloudSol(String text) {
        JSONArray rows = this.getCloudSolPackageData();
        DataSet resultDataSet = this.buildDataSet(rows);
        QFilter qFilter = new QFilter("number", "like", (Object)("%" + text + "%"));
        qFilter.or("name", "like", (Object)("%" + text + "%"));
        DataSet searchDatas = resultDataSet.filter(qFilter.toString());
        this.CloudSolEntryDeal(searchDatas);
    }

    private void CloudSolEntryDeal(DataSet searchDatas) {
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity(ENTRY_ENTITY);
        entryentity.clear();
        while (searchDatas.hasNext()) {
            Row rowObj = searchDatas.next();
            DynamicObject entry = entryentity.addNew();
            entry.set("schemeid", (Object)rowObj.getLong("id"));
            entry.set("number", (Object)rowObj.getString("number"));
            entry.set("name", (Object)rowObj.getString("name"));
            entry.set("groupname", (Object)rowObj.getString("group_name"));
            entry.set("version", (Object)rowObj.getString("version"));
            entry.set("keywords", (Object)rowObj.getString("key_words"));
            entry.set("modifytime", (Object)rowObj.getDate("modifytime"));
        }
        this.getModel().updateEntryCache(entryentity);
        this.getView().updateView(ENTRY_ENTITY);
    }

    private DataSet buildDataSet(JSONArray rows) {
        DataType[] dataTypes = new DataType[]{DataType.LongType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.DateType};
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])fieldNames, (DataType[])dataTypes);
        DataSetBuilder builder = Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSetBuilder(rowMeta);
        for (Object row : rows) {
            JSONObject rowObj = (JSONObject)row;
            builder.append(new Object[]{rowObj.get((Object)"id"), rowObj.get((Object)"number"), rowObj.get((Object)"name"), rowObj.get((Object)"group_name"), rowObj.get((Object)"version"), rowObj.get((Object)"key_words"), rowObj.get((Object)"modifytime")});
        }
        return builder.build();
    }

    private void getCloudResource(JSONArray cloudSourceList, int pageNo) {
        Map<String, Object> res = this.doIscCloudService(pageNo, 1000);
        if (res == null) {
            return;
        }
        JSONObject data = (JSONObject)res.get("data");
        Boolean lastPage = data.getBoolean("lastPage");
        Integer totalCount = data.getInteger("totalCount");
        JSONArray rows = data.getJSONArray("rows");
        cloudSourceList.addAll((Collection)rows);
        int page = totalCount / 1000;
        if (!lastPage.booleanValue() && pageNo <= page) {
            this.getCloudResource(cloudSourceList, pageNo + 1);
        }
    }

    private Map<String, Object> doIscCloudService(int pageNo, int pageSize) {
        LinkedHashMap<String, Object> queryParam = new LinkedHashMap<String, Object>(16);
        Map<String, Object> appInfo = this.getAppInfo();
        String url = DmwCloudSolutionEdit.getServerUrl(appInfo);
        queryParam.put("pageNo", pageNo);
        queryParam.put("pageSize", pageSize);
        String queryString = this.getQueryString(queryParam);
        Map<String, Object> headData = DmwCloudSolutionEdit.getHeaders(appInfo, queryString);
        headData.put("Accept", "application/json");
        headData.putAll(queryParam);
        headData.put("parameters", StringUtil.join(queryParam.keySet(), ","));
        String result = null;
        try {
            result = HttpUtils.get(url, null, headData);
        }
        catch (Exception ex) {
            String errMsg = ResManager.loadKDString((String)"http\u8bf7\u6c42\u8c03\u7528\u5931\u8d25,", (String)"DmwCloudSolutionEdit_1", (String)"imsc-dmw-platform", (Object[])new Object[0]);
            log.error(errMsg, (Throwable)ex);
            throw new DmwBizException(errMsg + ex.getMessage());
        }
        Map res = (Map)JSONObject.parseObject((String)result, Map.class);
        if (res != null && StringUtils.isNotEmpty((String)((String)res.get("message")))) {
            String msg;
            String message = (String)res.get("message");
            if (message.contains(msg = ResManager.loadKDString((String)"\u8ba4\u8bc1\u4fe1\u606f\u4e0d\u6b63\u786e", (String)"DmwCloudSolutionEdit_2", (String)"imsc-dmw-platform", (Object[])new Object[0]))) {
                message = ResManager.loadKDString((String)"\u8ba4\u8bc1\u4fe1\u606f\u4e0d\u6b63\u786e\uff0c\u8bf7\u901a\u8fc7\u3010\u96c6\u6210\u670d\u52a1\u4e91\u3011\u2192\u3010\u8d44\u6e90\u4e2d\u5fc3\u3011\u2192\u3010\u5e94\u7528\u5bc6\u94a5\u7533\u8bf7\u3011\u7533\u8bf7\u516c\u5171\u8d44\u6e90\u4e91\u8d44\u6e90\u8bbf\u95ee\u6743\u9650", (String)"SolutionSyncCloudUtil_16", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
            }
            throw new DmwBizException(String.format(ResManager.loadKDString((String)"\u4e91\u7aefAPI\u8bf7\u6c42\u5931\u8d25\uff0c%s", (String)"SolutionSyncCloudUtil_10", (String)"isc-iscb-platform-core", (Object[])new Object[0]), message));
        }
        return res;
    }

    private String getQueryString(Map<String, Object> queryParam) {
        StringBuilder builder = new StringBuilder();
        if (MapUtils.isNotEmpty(queryParam)) {
            for (Map.Entry<String, Object> param : queryParam.entrySet()) {
                if (builder.length() > 0) {
                    builder.append('&');
                }
                builder.append(param.getKey()).append('=').append(param.getValue());
            }
        }
        return builder.toString();
    }

    public static Map<String, Object> getHeaders(Map<String, Object> appInfo, String queryString) {
        String signature;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String timestamp = sdf.format(new Date());
        String signatureNonce = UUID.randomUUID().toString();
        String value = queryString + timestamp + signatureNonce;
        try {
            signature = ShaSignUtils.HMACSHA256StrByKey((String)value, (String)((String)appInfo.get("publickey")));
        }
        catch (Exception e) {
            log.error("getHeaders change SHA256 error", (Throwable)e);
            throw new DmwBizException("getHeaders change SHA256 error" + e.getMessage());
        }
        LinkedHashMap<String, Object> header = new LinkedHashMap<String, Object>(16);
        String appNumber = (String)appInfo.get("number");
        header.put("appId", appNumber);
        header.put("timestamp", timestamp);
        header.put("signature", signature);
        header.put("signatureNonce", signatureNonce);
        header.put("user", appNumber);
        header.put("usertype", "UserName");
        header.put("Content-Type", "application/json");
        header.put("accountId", (String)appInfo.get("server_accountid"));
        return header;
    }

    private Map<String, Object> getAppInfo() {
        Map appInfo = DmwCloudSolutionEdit.checkNewAppInfoExist() ? DmwCloudSolutionEdit.getAppinfoBySdk() : DmwCloudSolutionEdit.getAppinfoByIscr();
        return appInfo;
    }

    public static boolean checkNewAppInfoExist() {
        return MetadataDao.getIdByNumber((String)"res_pub_thirdapp_apply", (MetaCategory)MetaCategory.Form) != null;
    }

    public static Map getAppinfoBySdk() {
        try {
            Class<?> clz = Class.forName("kd.bos.open.res.util.ResourceClientUtil");
            Method method = clz.getDeclaredMethod("findResourceClientInfo", new Class[0]);
            Object data = method.invoke(null, new Object[0]);
            return DmwCloudSolutionEdit.beanToMap(data);
        }
        catch (Exception e) {
            log.error("getAppinfoBySdk ERROR,", (Throwable)e);
            throw new KDBizException("getAppinfoBySdk ERROR," + e.getMessage());
        }
    }

    private static Map<String, Object> beanToMap(Object data) {
        HashMap<String, Object> appInfo = new HashMap<String, Object>(16);
        if (data == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e91\u8d44\u6e90\u5e94\u7528\u672a\u5f00\u901a\uff0c\u8bf7\u524d\u5f80\u3010\u8d44\u6e90\u4e2d\u5fc3\u3011-\u3010\u5e94\u7528\u5bc6\u94a5\u7533\u8bf7\u3011\u754c\u9762\u63d0\u4ea4\u4e91\u8d44\u6e90\u5bc6\u94a5\u5f00\u901a\u7533\u8bf7\u3002", (String)"PublicResourceUtil_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        try {
            Map<String, Object> keyMethodMap = DmwCloudSolutionEdit.getKeyMethodMap();
            for (Map.Entry<String, Object> entry : keyMethodMap.entrySet()) {
                Method method = data.getClass().getDeclaredMethod((String)entry.getValue(), new Class[0]);
                appInfo.put(entry.getKey(), method.invoke(data, new Object[0]));
            }
            if (appInfo.size() == 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e91\u8d44\u6e90\u5e94\u7528\u672a\u5f00\u901a\uff0c\u8bf7\u524d\u5f80\u3010\u8d44\u6e90\u4e2d\u5fc3\u3011-\u3010\u5e94\u7528\u5bc6\u94a5\u7533\u8bf7\u3011\u754c\u9762\u63d0\u4ea4\u4e91\u8d44\u6e90\u5bc6\u94a5\u5f00\u901a\u7533\u8bf7\u3002", (String)"PublicResourceUtil_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
            }
            return appInfo;
        }
        catch (Exception e) {
            log.error("beanToMap ERROR,", (Throwable)e);
            throw new KDBizException("beanToMap ERROR," + e.getMessage());
        }
    }

    private static Map<String, Object> getKeyMethodMap() {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("number", "getThirdcode");
        map.put("name", "getName");
        map.put("publickey", "getPublickey");
        map.put("status", "getBillstatus");
        map.put("fileserver", "getFileserver");
        map.put("server_accountid", "getTargetaccountid");
        map.put("phone", "getPhone");
        map.put("server_url", "getTargeturl");
        map.put("tenantid", "getTenantid");
        map.put("accountid", "getAccountid");
        return map;
    }

    public static Map getAppinfoByIscr() {
        String properties = "number,name,publickey,status,fileserver,server_accountid,phone,server_url,tenantid,accountid";
        DynamicObject apply = BusinessDataServiceHelper.loadSingle((String)"iscr_app_apply", (String)properties, (QFilter[])new QFilter[0]);
        if (apply == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e91\u8d44\u6e90\u5e94\u7528\u672a\u5f00\u901a\uff0c\u8bf7\u524d\u5f80\u3010\u8d44\u6e90\u4e2d\u5fc3\u3011-\u3010\u5e94\u7528\u5bc6\u94a5\u7533\u8bf7\u3011\u754c\u9762\u63d0\u4ea4\u4e91\u8d44\u6e90\u5bc6\u94a5\u5f00\u901a\u7533\u8bf7\u3002", (String)"PublicResourceUtil_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        if (!"B".equals(apply.get("status"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e91\u8d44\u6e90\u5e94\u7528\u672a\u5f00\u901a\uff0c\u8bf7\u524d\u5f80\u3010\u8d44\u6e90\u4e2d\u5fc3\u3011-\u3010\u5e94\u7528\u5bc6\u94a5\u7533\u8bf7\u3011\u754c\u9762\u63d0\u4ea4\u4e91\u8d44\u6e90\u5bc6\u94a5\u5f00\u901a\u7533\u8bf7\u3002", (String)"PublicResourceUtil_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        if (!DmwCloudSolutionEdit.isMatchEnvironment(apply)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u73af\u5883\u7684\u79df\u6237ID\u6216\u8d26\u5957ID\u4e0e\u7533\u8bf7\u4fe1\u606f\u4e0d\u5339\u914d\uff0c\u8bf7\u524d\u5f80\u3010\u8d44\u6e90\u4e2d\u5fc3\u3011-\u3010\u5e94\u7528\u5bc6\u94a5\u7533\u8bf7\u3011\u754c\u9762\u63d0\u4ea4\u4e91\u8d44\u6e90\u5bc6\u94a5\u5f00\u901a\u7533\u8bf7\u3002", (String)"PublicResourceUtil_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        return DmwCloudSolutionEdit.object2Map(apply);
    }

    public static Map<String, Object> object2Map(DynamicObject dynamicObject) {
        HashMap<String, Object> objectMap = new HashMap<String, Object>();
        if (dynamicObject != null) {
            objectMap.put("$id", dynamicObject.getPkValue());
            objectMap.put("$pk", "id");
            DataEntityPropertyCollection properties = dynamicObject.getDataEntityType().getProperties();
            for (IDataEntityProperty property : properties) {
                String name = property.getName();
                Object value = dynamicObject.get(name);
                if (value instanceof DynamicObject) {
                    value = ((DynamicObject)value).getPkValue();
                }
                objectMap.put(name, value);
            }
        }
        return objectMap;
    }

    public static boolean isMatchEnvironment(DynamicObject apply) {
        String curTenantId = RequestContext.get().getTenantId();
        String curAccountId = RequestContext.get().getAccountId();
        return curTenantId.equals(apply.getString("tenantid")) && curAccountId.equals(apply.getString("accountid"));
    }

    private static String getServerUrl(Map<String, Object> appInfo) {
        String serverUrl = (String)appInfo.get("server_url");
        serverUrl = serverUrl.endsWith("/") ? serverUrl : serverUrl + "/";
        return serverUrl + "kapi/v2/kdec/iscb/isc_solution_center/query_solution_list_portal";
    }
}

