/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.plugin.formplugin.eas;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kd.bos.base.BaseShowParameter;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.column.ListOperationColumnDesc;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imsc.dmw.errorcode.DmwBizException;
import kd.imsc.dmw.helper.eas.EasFinReportHelper;
import kd.imsc.dmw.utils.CommonUtils;
import kd.imsc.dmw.utils.DateUtils;
import kd.imsc.dmw.utils.FileUtils;
import kd.imsc.dmw.utils.StringUtil;

public class EasFinReportListPlugin
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(EasFinReportListPlugin.class);
    private static final String PAGE_CLOSE = "EASFIN_REPORT";

    public void initialize() {
        super.initialize();
        BillList billlist = (BillList)this.getView().getControl("billlistap");
        billlist.addPackageDataListener(pkEvent -> {
            int attachNum = (Integer)pkEvent.getRowData().get("attachnum");
            if (pkEvent.getSource() instanceof ListOperationColumnDesc && "opcolumn".equalsIgnoreCase(((ListOperationColumnDesc)pkEvent.getSource()).getKey())) {
                List operationColItems = (List)pkEvent.getFormatValue();
                for (OperationColItem operationColItem : operationColItems) {
                    if ("viewreport".equalsIgnoreCase(operationColItem.getOperationKey()) && (attachNum > 1 || attachNum == 0)) {
                        operationColItem.setLocked(true);
                        continue;
                    }
                    operationColItem.setLocked(false);
                }
            }
        });
        super.initialize();
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("viewdoc".equals(itemKey)) {
            this.viewDocument();
        } else if ("batch_import".equals(itemKey)) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("dmw_rptfileupload");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, PAGE_CLOSE));
            this.getView().showForm(showParameter);
        } else if ("batch_export".equals(itemKey)) {
            this.batchport();
        } else if ("batch_exportzip".equals(itemKey)) {
            this.batchExportZip();
        } else if ("batch_print".equals(itemKey)) {
            Object[] ids = this.getSelectedRows().getPrimaryKeyValues();
            Map attachments = AttachmentServiceHelper.getAttachments((String)"dmw_fi_report_eas", (Object[])ids, (String)"attachmentpanelap", (boolean)true);
            for (Map.Entry map : attachments.entrySet()) {
                List value = (List)map.getValue();
                CommonUtils.downPdfFile(value, this.getView());
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String key = operate.getOperateKey();
        if ("viewreport".equals(key)) {
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRow selectedRow = billList.getCurrentSelectedRowInfo();
            Object pkValue = selectedRow.getPrimaryKeyValue();
            EasFinReportHelper.viewAttachment((Object)pkValue, (IFormView)this.getView());
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        super.closedCallBack(closedCallBackEvent);
        String closeActionId = closedCallBackEvent.getActionId();
        if (PAGE_CLOSE.equals(closeActionId) && (returnData = closedCallBackEvent.getReturnData()) != null) {
            this.getView().showTipNotification(returnData.toString());
        }
    }

    private void batchport() {
        Object[] ids = this.getSelectedRows().getPrimaryKeyValues();
        Map attachments = AttachmentServiceHelper.getAttachments((String)"dmw_fi_report_eas", (Object[])ids, (String)"attachmentpanelap", (boolean)true);
        for (Map.Entry map : attachments.entrySet()) {
            List value = (List)map.getValue();
            for (Map valuemap : value) {
                String url = (String)valuemap.get("url");
                FileUtils.addDownloadPermission((String)((ListView)this.getView()).getBillFormId(), (String)url, (String)this.getView().getFormShowParameter().getAppId());
                this.getView().download(url);
            }
        }
    }

    private void batchExportZip() {
        Object[] ids = this.getSelectedRows().getPrimaryKeyValues();
        QFilter qFilter = new QFilter("id", "in", (Object)ids);
        Map reportEasMap = BusinessDataServiceHelper.loadFromCache((String)"dmw_fi_report_eas", (String)"org.name,reporttime,number,name", (QFilter[])qFilter.toArray());
        if (ids.length == 1) {
            this.singleDataDown(ids, reportEasMap);
            return;
        }
        ByteArrayOutputStream zipOutputStream = new ByteArrayOutputStream();
        try (ZipOutputStream zos = new ZipOutputStream(zipOutputStream);){
            Map attachments = AttachmentServiceHelper.getAttachments((String)"dmw_fi_report_eas", (Object[])ids, (String)"attachmentpanelap", (boolean)true);
            for (Map.Entry map : attachments.entrySet()) {
                Long key = Long.parseLong((String)map.getKey());
                DynamicObject repdata = (DynamicObject)reportEasMap.get(key);
                StringBuilder builder = this.getDownFileName(repdata);
                List value = (List)map.getValue();
                for (int i = 0; i < value.size(); ++i) {
                    Map valuemap = (Map)value.get(i);
                    String url = (String)valuemap.get("url");
                    String relativeUrl = (String)valuemap.get("relativeUrl");
                    FileUtils.addDownloadPermission((String)((ListView)this.getView()).getBillFormId(), (String)url, (String)this.getView().getFormShowParameter().getAppId());
                    String filename = builder.toString();
                    if (i > 0) {
                        filename = filename + "(" + i + ")";
                    }
                    filename = filename + ".xlsx";
                    EasFinReportListPlugin.toZip(relativeUrl, zos, filename);
                }
            }
        }
        catch (Exception e) {
            String msg = ResManager.loadKDString((String)"\u6279\u91cf\u5bfc\u51fa\u6267\u884c\u5931\u8d25\uff1a", (String)"EasFinReportListPlugin_3", (String)"imsc-dmw-platform", (Object[])new Object[0]);
            logger.error(msg, (Throwable)e);
            throw new DmwBizException(msg, (Throwable)e);
        }
        TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        String currTimeFormat = DateUtils.getCurrTimeFormat((String)"yyyyMMddHHmmss");
        String tempName = ResManager.loadKDString((String)"\u8d22\u52a1\u62a5\u8868", (String)"EasFinReportListPlugin_2", (String)"imsc-dmw-platform", (Object[])new Object[0]);
        String filename = tempName + currTimeFormat;
        String downPdfUrl = cache.saveAsUrl(filename + ".zip", zipOutputStream.toByteArray(), 5000);
        FileUtils.addDownloadPermission((String)((ListView)this.getView()).getBillFormId(), (String)downPdfUrl, (String)this.getView().getFormShowParameter().getAppId());
        this.getView().download(downPdfUrl);
    }

    private void singleDataDown(Object[] ids, Map<Object, DynamicObject> reportEasMap) {
        List attachments = AttachmentServiceHelper.getAttachments((String)"dmw_fi_report_eas", (Object)ids[0], (String)"attachmentpanelap", (boolean)true);
        DynamicObject dyo = reportEasMap.get(ids[0]);
        StringBuilder builder = this.getDownFileName(dyo);
        for (int i = 0; i < attachments.size(); ++i) {
            Map map = (Map)attachments.get(i);
            String relativeUrl = (String)map.get("relativeUrl");
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            FileServiceFactory.getAttachmentFileService().download(relativeUrl, (OutputStream)outputStream, null);
            String filename = builder.toString();
            if (i > 0) {
                filename = filename + "(" + i + ")";
            }
            filename = filename + ".xlsx";
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            String downPdfUrl = cache.saveAsUrl(filename, outputStream.toByteArray(), 5000);
            FileUtils.addDownloadPermission((String)((ListView)this.getView()).getBillFormId(), (String)downPdfUrl, (String)this.getView().getFormShowParameter().getAppId());
            this.getView().download(downPdfUrl);
        }
    }

    private StringBuilder getDownFileName(DynamicObject repdata) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getDynString(repdata, "org.name")).append(this.getDynString(repdata, "reporttime")).append(this.getDynString(repdata, "number")).append(this.getDynString(repdata, "name"));
        String currTimeFormat = DateUtils.getCurrTimeFormat((String)"yyyyMMddHHmmss");
        builder.append(currTimeFormat);
        return builder;
    }

    public static void toZip(String url, ZipOutputStream zos, String filename) throws IOException {
        InputStream inputStream = FileServiceFactory.getAttachmentFileService().getInputStream(url);
        zos.putNextEntry(new ZipEntry(filename));
        int n = 0;
        byte[] buf = new byte[1024];
        while ((n = inputStream.read(buf)) != -1) {
            zos.write(buf, 0, n);
        }
        zos.closeEntry();
    }

    private String getDynString(DynamicObject obj, String key) {
        String value = obj.getString(key);
        if (StringUtil.isEmpty(value)) {
            return "";
        }
        return value + "-";
    }

    private void viewDocument() {
        ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
        Object[] pkValues = selectedRows.getPrimaryKeyValues();
        if (pkValues.length < 1) {
            return;
        }
        if (pkValues.length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"EasFinReportListPlugin_1", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            return;
        }
        BaseShowParameter parameter = new BaseShowParameter();
        parameter.setFormId("dmw_fi_report_eas");
        parameter.setPkId(pkValues[0]);
        parameter.setPageId(this.getView().getPageId() + pkValues[0]);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setParentPageId(this.getView().getPageId());
        this.getView().showForm((FormShowParameter)parameter);
    }
}

