/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.plugin.formplugin.eas;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.mvc.form.FormView;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.imsc.dmw.helper.MultiImpAttachmentHelper;
import kd.imsc.dmw.helper.eas.EasFinReportHelper;
import kd.imsc.dmw.utils.CommonUtils;
import kd.imsc.dmw.utils.FileUtils;
import kd.imsc.imbd.formplugin.AbstractImbdBdEditPlugin;

public class EasFinReportPlugin
extends AbstractImbdBdEditPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"previewreport", "print"});
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    public void itemClick(ItemClickEvent evt) {
        String opKey;
        super.itemClick(evt);
        switch (opKey = evt.getItemKey()) {
            case "previewreport": {
                Object pkValue = this.getModel().getDataEntity(true).getPkValue();
                EasFinReportHelper.viewAttachment((Object)pkValue, (IFormView)this.getView());
                break;
            }
            case "downloadreport": {
                this.downLoadReport();
                break;
            }
            case "print": {
                this.pringReport();
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String opKey = args.getOperateKey();
        if ("delete".equals(opKey)) {
            IFormView parentView = this.getView().getParentView();
            parentView.invokeOperation("refresh");
            this.getView().sendFormAction(parentView);
            this.getView().close();
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        e.setCheckDataChange(false);
        this.getModel().setDataChanged(false);
    }

    private void downLoadReport() {
        AttachmentPanel attachment = (AttachmentPanel)this.getControl("attachmentpanelap");
        List attachmentData = attachment.getAttachmentData();
        int size = 0;
        for (Map item : attachmentData) {
            Object tempUrl = item.get("url");
            if (tempUrl.toString().contains("tempfile")) continue;
            ++size;
        }
        if (size != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9644\u4ef6\u6570\u91cf\u4e0d\u552f\u4e00\uff0c\u6682\u4e0d\u652f\u6301\u4e0b\u8f7d\u3002", (String)"EasFinReportPlugin_0", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        } else {
            Map<String, Object> tempMap = MultiImpAttachmentHelper.copyAttachmentToPage("dmw_fi_report_eas", this.getModel().getDataEntity(true).getPkValue(), "attachmentpanelap", "dmw_impscheme", "attachmentpanelap", this.getView());
            String url = ((StringBuilder)tempMap.get("url")).toString();
            FileUtils.addDownloadPermission((String)((FormView)this.getView()).getFormId(), (String)url, (String)this.getView().getFormShowParameter().getAppId());
            this.getView().openUrl(url);
        }
    }

    private void pringReport() {
        Long pkValue = (Long)this.getModel().getDataEntity().getPkValue();
        List attachments = AttachmentServiceHelper.getAttachments((String)"dmw_fi_report_eas", (Object)pkValue, (String)"attachmentpanelap", (boolean)true);
        CommonUtils.downPdfFile(attachments, this.getView());
    }
}

