/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.plugin.formplugin.eas;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imsc.imbd.formplugin.tpl.ImbdDymicTplEditPlugin;

public class ResImportOnlineEditPlugin
extends ImbdDymicTplEditPlugin
implements ProgresssListener {
    private static final String BTN_OK = "btnok";
    private static final String BTN_CANCEL = "btncancel";
    private static final String FLEX_STEPONE = "flexstepone";
    private static final String FLEX_STEPONE_CMP = "flexsteponecmp";
    private static final String SECRET_KEY_AFFECT = "secretkeyaffect";
    private static final String SECRET_KEY_AFFECT_CMP = "secretkeyaffectcmp";
    private static final String OPERATE_INSTRUCTION = "operateinstruction";
    private static final String BTN_ONLINE = "btnonline";
    private static final String TXT_PERCENT = "txtpercent";
    private static final String PROGRESSBAR = "progressbar";
    private static final String TXT_DETAILS = "txtdetails";
    private static final String IMG_ERROR = "imgerror";
    private static final String IMG_RIGHT = "imgright";
    private static final String IS_START = "isStart";
    private static final String SUCCESS = "SUCCESS";
    private static final String OMITTED = "OMITTED";
    private static final String READY = "READY";
    private static final String FAILED = "FAILED";
    private static final String NOTSTART = "notstart";
    private static final String START = "start";
    private static final String END = "end";
    private static final String OPWEBSITE = "opwebsite";
    private static final String GRAY = "#999999";
    private static final String BLACK = "#212121";
    private static final String JOB_ID_CACHE = "jobIdCache";
    private static final String DEPLOY_ERROR_MSG = "deployErrorMsg";
    private static final String SUM_CACHE = "sum_cache";
    private static final String COMP_CACHE = "comp_cache";
    private static final String SUBSCRIBE_CACHE = "subscribe_cache";
    private static final String SCHEME = "scheme";
    private static final String PACKAGE = "package";
    private static final Log logger = LogFactory.getLog(ResImportOnlineEditPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_OK, BTN_CANCEL, BTN_ONLINE, OPERATE_INSTRUCTION, SECRET_KEY_AFFECT, SECRET_KEY_AFFECT_CMP});
        ProgressBar progressBar = (ProgressBar)this.getControl(PROGRESSBAR);
        progressBar.addProgressListener((ProgresssListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map migObjEntryEntityMap = (Map)formShowParameter.getCustomParam("migobjentryentity");
        DynamicObjectCollection migObjEntryEntity = this.getModel().getEntryEntity("migobjentryentity");
        this.getView().getPageCache().put(IS_START, NOTSTART);
        for (Map.Entry entry : migObjEntryEntityMap.entrySet()) {
            DynamicObject migObjEntry = migObjEntryEntity.addNew();
            Map map = (Map)entry.getValue();
            migObjEntry.set("migrateobject_id", map.get("migrateobject"));
            migObjEntry.set("integrattype", map.get("integrattype"));
            migObjEntry.set("schemename", map.get("schemename"));
            migObjEntry.set("schemeid", map.get("schemeid"));
        }
        BusinessDataServiceHelper.loadRefence((Object[])migObjEntryEntity.toArray(), (IDataEntityType)migObjEntryEntity.getDynamicObjectType());
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        boolean keyStatus = (Boolean)formShowParameter.getCustomParam("keystatus");
        this.getView().setVisible(Boolean.valueOf(keyStatus), new String[]{FLEX_STEPONE_CMP});
        this.getView().setVisible(Boolean.valueOf(!keyStatus), new String[]{FLEX_STEPONE});
        this.getView().setVisible(Boolean.FALSE, new String[]{IMG_ERROR, IMG_RIGHT, TXT_PERCENT});
        HashMap<String, String> styleMap = new HashMap<String, String>(2);
        styleMap.put("fc", GRAY);
        this.getView().updateControlMetadata(TXT_DETAILS, styleMap);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btnok": 
            case "btncancel": {
                this.exit();
                break;
            }
            case "btnonline": {
                this.onlineDeployment();
                break;
            }
            case "operateinstruction": {
                this.openCommunityUrl();
                break;
            }
            case "secretkeyaffect": 
            case "secretkeyaffectcmp": {
                this.openKeyApplyPage();
                break;
            }
        }
    }

    public void onProgress(ProgressEvent evt) {
        ProgressBar progressBar = (ProgressBar)evt.getSource();
        String progressBarKey = progressBar.getKey();
        if (progressBarKey.equals(PROGRESSBAR)) {
            String jobIdCache = this.getView().getPageCache().get(JOB_ID_CACHE);
            List jobIdList = (List)JSON.parseObject((String)jobIdCache, List.class);
            if (jobIdList.isEmpty()) {
                this.seteployStatus(evt.getProgress(), this.getView().getPageCache().get(DEPLOY_ERROR_MSG), "#FB2323");
                progressBar.stop();
                this.getView().getPageCache().put(IS_START, END);
                return;
            }
            QFilter jobFilter = new QFilter("id", "in", (Object)jobIdList);
            DynamicObject[] jobArray = BusinessDataServiceHelper.load((String)"isc_job_inst", (String)"id,state,title,remark,remark_tag,job_owner", (QFilter[])new QFilter[]{jobFilter});
            ArrayList<Long> deployIdList = new ArrayList<Long>(8);
            for (DynamicObject job : jobArray) {
                Long id = job.getLong("job_owner");
                deployIdList.add(id);
            }
            QFilter deployFilter = new QFilter("id", "in", deployIdList);
            DynamicObjectCollection deployArray = QueryServiceHelper.query((String)"isc_dts_solution_deploy", (String)"main_resources.main_state,main_resources.main_res_number,main_resources.main_res_name", (QFilter[])new QFilter[]{deployFilter});
            int subscribeNum = Integer.parseInt(this.getView().getPageCache().get(SUBSCRIBE_CACHE));
            for (int i = 0; i < deployArray.size(); ++i) {
                DynamicObject deploy = (DynamicObject)deployArray.get(i);
                String state = deploy.getString("main_resources.main_state");
                if (SUCCESS.equals(state) || OMITTED.equals(state)) {
                    int successNum = Integer.parseInt(this.getView().getPageCache().get(COMP_CACHE));
                    if (successNum < deployArray.size() + subscribeNum) {
                        this.getView().getPageCache().put(COMP_CACHE, String.valueOf(++successNum));
                    }
                    int percent = this.getGrowthRate();
                    evt.setProgress(percent);
                    if (percent == 100) {
                        this.seteployStatus(percent, ResManager.loadKDString((String)"\u90e8\u7f72\u6210\u529f", (String)"ResImportOnlineEditPlugin_2", (String)"imsc-dmw-platform", (Object[])new Object[0]), "#1BA854");
                        progressBar.stop();
                        continue;
                    }
                    if (successNum == deployArray.size() + subscribeNum) {
                        this.seteployStatus(evt.getProgress(), this.getView().getPageCache().get(DEPLOY_ERROR_MSG), "#FB2323");
                        progressBar.stop();
                        continue;
                    }
                    this.seteployStatus(percent, ResManager.loadKDString((String)"\u6b63\u5728\u90e8\u7f72...", (String)"ResImportOnlineEditPlugin_3", (String)"imsc-dmw-platform", (Object[])new Object[0]), "#276FF5");
                    continue;
                }
                if (READY.equals(state)) {
                    this.seteployStatus(evt.getProgress(), ResManager.loadKDString((String)"\u6b63\u5728\u90e8\u7f72...", (String)"ResImportOnlineEditPlugin_3", (String)"imsc-dmw-platform", (Object[])new Object[0]), "#276FF5");
                    continue;
                }
                String msg = ResManager.loadKDString((String)"\u7f16\u7801\uff1a%1$s\uff0c\u540d\u79f0\uff1a%2$s\u7684\u4e3b\u8d44\u6e90\u90e8\u7f72\u5931\u8d25", (String)"ResImportOnlineEditPlugin_4", (String)"imsc-dmw-platform", (Object[])new Object[]{deploy.getString("main_resources.main_res_number"), deploy.getString("main_resources.main_res_name")});
                this.seteployStatus(evt.getProgress(), msg, "#FB2323");
                progressBar.stop();
            }
            this.getView().getPageCache().put(IS_START, END);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String isStart = this.getView().getPageCache().get(IS_START);
        HashMap map = new HashMap(2);
        if (!isStart.equals(NOTSTART) && !isStart.equals(END)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b63\u5728\u5728\u7ebf\u90e8\u7f72\uff0c\u4e0d\u5141\u8bb8\u5173\u95ed", (String)"ResImportOnlineEditPlugin_0", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            e.setCancel(true);
        }
        this.getView().returnDataToParent(map);
    }

    private void seteployStatus(int percent, String details, String color) {
        this.getView().setVisible(Boolean.TRUE, new String[]{TXT_DETAILS, TXT_PERCENT});
        HashMap<String, String> styleMap = new HashMap<String, String>(2);
        String percentStr = String.valueOf(percent) + '%';
        this.getModel().setValue(TXT_DETAILS, (Object)details);
        this.getModel().setValue(TXT_PERCENT, (Object)percentStr);
        styleMap.put("fc", color);
        if ("#FB2323".equals(color)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{IMG_ERROR});
            this.getView().setVisible(Boolean.FALSE, new String[]{IMG_RIGHT});
        } else if ("#1BA854".equals(color)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{IMG_RIGHT});
            this.getView().setVisible(Boolean.FALSE, new String[]{IMG_ERROR});
        }
        this.getView().updateControlMetadata(PROGRESSBAR, styleMap);
    }

    private void exit() {
        this.getView().close();
    }

    private void onlineDeployment() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        boolean keyStatus = (Boolean)formShowParameter.getCustomParam("keystatus");
        if (!keyStatus) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5b8c\u6210\u5e94\u7528\u79d8\u94a5\u7533\u8bf7\uff0c\u518d\u8fdb\u884c\u90e8\u7f72", (String)"ResImportOnlineEditPlugin_1", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection migObjEntryenties = this.getModel().getEntryEntity("migobjentryentity");
        ProgressBar progressBar = (ProgressBar)this.getView().getControl(PROGRESSBAR);
        Map<String, List<Long>> idListFilterMap = this.filterId(migObjEntryenties);
        List<Long> schemeIdListFilter = idListFilterMap.get(SCHEME);
        List<Long> packageIdListFilter = idListFilterMap.get(PACKAGE);
        int sum = schemeIdListFilter.size() + packageIdListFilter.size();
        this.getView().getPageCache().put(SUM_CACHE, String.valueOf(sum));
        this.getView().getPageCache().put(COMP_CACHE, String.valueOf(0));
        this.getView().getPageCache().put(SUBSCRIBE_CACHE, String.valueOf(packageIdListFilter.size()));
        HashMap<String, String> styleMap = new HashMap<String, String>(2);
        styleMap.put("fc", BLACK);
        this.getView().updateControlMetadata(TXT_DETAILS, styleMap);
        if (sum == 0) {
            progressBar.setPercent(100);
            this.seteployStatus(100, ResManager.loadKDString((String)"\u90e8\u7f72\u6210\u529f", (String)"ResImportOnlineEditPlugin_2", (String)"imsc-dmw-platform", (Object[])new Object[0]), "#1BA854");
            return;
        }
        Map<Long, List<String>> packSourceMap = this.getPackSourceMap(migObjEntryenties, schemeIdListFilter);
        Map<Long, List<String>> packEntryMap = this.getPackEntryMap(migObjEntryenties);
        this.getView().getPageCache().put(IS_START, START);
        progressBar.start();
        progressBar.setPercent(0);
        this.seteployStatus(0, ResManager.loadKDString((String)"\u6b63\u5728\u90e8\u7f72...", (String)"ResImportOnlineEditPlugin_3", (String)"imsc-dmw-platform", (Object[])new Object[0]), "#276FF5");
        for (Long id : packageIdListFilter) {
            try {
                Map subResult = (Map)DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"IscSolutionService", (String)"subscribe", (Object[])new Object[]{id});
                boolean success = (Boolean)subResult.get("success");
                int successNum = Integer.parseInt(this.getView().getPageCache().get(COMP_CACHE));
                if (success) {
                    this.getView().getPageCache().put(COMP_CACHE, String.valueOf(++successNum));
                    int percent = this.getGrowthRate();
                    progressBar.setPercent(this.getGrowthRate());
                    if (percent == 100) {
                        this.seteployStatus(percent, ResManager.loadKDString((String)"\u90e8\u7f72\u6210\u529f", (String)"ResImportOnlineEditPlugin_2", (String)"imsc-dmw-platform", (Object[])new Object[0]), "#1BA854");
                        continue;
                    }
                    this.seteployStatus(this.getGrowthRate(), ResManager.loadKDString((String)"\u6b63\u5728\u90e8\u7f72...", (String)"ResImportOnlineEditPlugin_3", (String)"imsc-dmw-platform", (Object[])new Object[0]), "#276FF5");
                    continue;
                }
                String beginMsg = ResManager.loadKDString((String)"\u65b9\u6848\u5305\u8ba2\u9605\u5931\u8d25\u7b2c%s\u884c\uff1a", (String)"ResImportOnlineEditPlugin_5", (String)"imsc-dmw-platform", (Object[])new Object[]{packEntryMap.get(id)});
                String msg = (String)subResult.get("msg");
                this.seteployStatus(this.getGrowthRate(), beginMsg + msg, "#FB2323");
                progressBar.setPercent(this.getGrowthRate());
                progressBar.stop();
                this.getView().getPageCache().put(IS_START, END);
                return;
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                this.getView().showErrorNotification(e.getMessage());
                this.getView().getPageCache().put(IS_START, END);
            }
        }
        ArrayList<Long> jobIdList = new ArrayList<Long>(8);
        ArrayList<String> rowList = new ArrayList<String>(8);
        ArrayList<String> errMsgList = new ArrayList<String>(8);
        for (Map.Entry<Long, List<String>> entry : packSourceMap.entrySet()) {
            Long packageId = entry.getKey();
            List<String> sourceIdList = entry.getValue();
            try {
                Long jobId = (Long)DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"IscSolutionService", (String)"selectDeploy", (Object[])new Object[]{packageId, sourceIdList});
                jobIdList.add(jobId);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                errMsgList.add(e.getMessage());
                rowList.addAll((Collection<String>)packEntryMap.get(packageId));
            }
        }
        this.getView().getPageCache().put(JOB_ID_CACHE, JSON.toJSONString(jobIdList));
        logger.info(JSON.toJSONString(jobIdList));
        this.buildDeployFailMsg(rowList, errMsgList);
    }

    private void buildDeployFailMsg(List<String> rowList, List<String> errMsgList) {
        StringBuilder msg = new StringBuilder();
        List rowIntList = rowList.stream().map(Integer::parseInt).sorted().collect(Collectors.toList());
        Iterator<Object> iterator = rowIntList.iterator();
        while (iterator.hasNext()) {
            int row = (Integer)iterator.next();
            msg.append(ResManager.loadKDString((String)"\u7b2c%s\u884c\u8d44\u6e90\u90e8\u7f72\u5931\u8d25\uff0c\u8be5\u8d44\u6e90\u53ef\u80fd\u4e0d\u5728\u5f53\u524d\u65b9\u6848\u5305", (String)"ResImportOnlineEditPlugin_6", (String)"imsc-dmw-platform", (Object[])new Object[]{row}));
            msg.append('\n');
        }
        msg.append(ResManager.loadKDString((String)"\u5f02\u5e38\u8be6\u60c5:", (String)"ResImportOnlineEditPlugin_7", (String)"imsc-dmw-platform", (Object[])new Object[0])).append('\n');
        for (String errMsg : errMsgList) {
            msg.append(errMsg);
            msg.append('\n');
        }
        this.getView().getPageCache().put(DEPLOY_ERROR_MSG, msg.toString());
    }

    private Map<Long, List<String>> getPackSourceMap(DynamicObjectCollection migObjEntryenties, List<Long> schemeIdListFilter) {
        HashMap<Long, List<String>> packSourceMap = new HashMap<Long, List<String>>(8);
        for (DynamicObject entry : migObjEntryenties) {
            DynamicObject migObj = entry.getDynamicObject("migrateobject");
            Long packageId = migObj.getLong("solutionpackageid");
            String sourceId = entry.getString("schemeid");
            if (!schemeIdListFilter.contains(Long.parseLong(sourceId))) continue;
            List<String> sourceIdList = new ArrayList<String>(8);
            if (packSourceMap.get(packageId) != null) {
                sourceIdList = (List)packSourceMap.get(packageId);
            }
            sourceIdList.add(sourceId);
            packSourceMap.put(packageId, sourceIdList);
        }
        return packSourceMap;
    }

    private Map<Long, List<String>> getPackEntryMap(DynamicObjectCollection migObjEntryenties) {
        HashMap<Long, List<String>> packEntryMap = new HashMap<Long, List<String>>(8);
        for (int i = 0; i < migObjEntryenties.size(); ++i) {
            DynamicObject migObj = ((DynamicObject)migObjEntryenties.get(i)).getDynamicObject("migrateobject");
            Long packageId = migObj.getLong("solutionpackageid");
            List<String> rowList = new ArrayList<String>(8);
            if (packEntryMap.get(packageId) != null) {
                rowList = (List)packEntryMap.get(packageId);
            }
            rowList.add(String.valueOf(i + 1));
            packEntryMap.put(packageId, rowList);
        }
        return packEntryMap;
    }

    private Map<String, List<Long>> filterId(DynamicObjectCollection migObjEntryenties) {
        ArrayList<Long> planIdListOld = new ArrayList<Long>(8);
        ArrayList<Long> flowIdListOld = new ArrayList<Long>(8);
        ArrayList<Long> packageIdListOld = new ArrayList<Long>(8);
        for (DynamicObject entry : migObjEntryenties) {
            DynamicObject migObj = entry.getDynamicObject("migrateobject");
            Long packageId = migObj.getLong("solutionpackageid");
            packageIdListOld.add(packageId);
            String initType = entry.getString("integrattype");
            if ("isc_data_copy_trigger".equals(initType)) {
                planIdListOld.add(entry.getLong("schemeid"));
                continue;
            }
            flowIdListOld.add(entry.getLong("schemeid"));
        }
        QFilter planFilter = new QFilter("id", "in", planIdListOld);
        QFilter flowFilter = new QFilter("id", "in", flowIdListOld);
        QFilter packageFilter = new QFilter("id", "in", packageIdListOld);
        List planIdListNew = QueryServiceHelper.queryPrimaryKeys((String)"isc_data_copy_trigger", (QFilter[])new QFilter[]{planFilter}, null, (int)-1);
        List flowIdListNew = QueryServiceHelper.queryPrimaryKeys((String)"isc_service_flow", (QFilter[])new QFilter[]{flowFilter}, null, (int)-1);
        List packageIdListNew = QueryServiceHelper.queryPrimaryKeys((String)"isc_solution_center", (QFilter[])new QFilter[]{packageFilter}, null, (int)-1);
        ArrayList<Long> schemeIdListFilter = new ArrayList<Long>(8);
        ArrayList<Long> packageIdListFilter = new ArrayList<Long>(8);
        for (DynamicObject entry : migObjEntryenties) {
            DynamicObject migObj = entry.getDynamicObject("migrateobject");
            Long packageId = migObj.getLong("solutionpackageid");
            Long sourceId = entry.getLong("schemeid");
            if (!packageIdListNew.contains(packageId) && !packageIdListFilter.contains(packageId)) {
                packageIdListFilter.add(packageId);
            }
            if (planIdListNew.contains(sourceId) || flowIdListNew.contains(sourceId)) continue;
            schemeIdListFilter.add(sourceId);
        }
        HashMap<String, List<Long>> idListFilterMap = new HashMap<String, List<Long>>(2);
        idListFilterMap.put(SCHEME, schemeIdListFilter);
        idListFilterMap.put(PACKAGE, packageIdListFilter);
        return idListFilterMap;
    }

    private int getGrowthRate() {
        int sum = Integer.parseInt(this.getView().getPageCache().get(SUM_CACHE));
        int success = Integer.parseInt(this.getView().getPageCache().get(COMP_CACHE));
        if (success == 0) {
            return 0;
        }
        if (success >= sum) {
            return 100;
        }
        return 100 * success / sum;
    }

    private void openCommunityUrl() {
        String url = (String)this.getModel().getValue(OPWEBSITE);
        this.getView().openUrl(url);
    }

    private void openKeyApplyPage() {
        BillShowParameter parameter = new BillShowParameter();
        parameter.setFormId("res_pub_thirdapp_apply");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm((FormShowParameter)parameter);
    }
}

