/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.plugin.formplugin.multiimport.scheme;

import java.util.Arrays;
import java.util.Comparator;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.designer.property.AbstractPropertyPlugin;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.EntryGrid;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.imsc.dmw.engine.multiimport.model.FieldMappingModel;
import kd.imsc.dmw.helper.TemplateMappingHelper;

public class EntityFieldsSelectPlugin
extends AbstractPropertyPlugin {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter param = this.getView().getFormShowParameter();
        if (param == null) {
            return;
        }
        String entityNumber = (String)param.getCustomParams().get("entity_number");
        if (StringUtils.isEmpty((String)entityNumber)) {
            return;
        }
        this.bindFieldsByEntityNumber(entityNumber);
        String entityFields = (String)param.getCustomParams().get("entity_fields");
        if (StringUtils.isNotEmpty((String)entityFields)) {
            this.setEntryRowSelected(entityFields.split(","));
        }
    }

    private void bindFieldsByEntityNumber(String entityNumber) {
        DynamicObjectCollection fieldsEntry = this.getModel().getEntryEntity("fieldsentry");
        fieldsEntry.clear();
        List<FieldMappingModel> formFieldsMapping = TemplateMappingHelper.getFormFieldsMapping(entityNumber);
        if (CollectionUtils.isEmpty(formFieldsMapping)) {
            return;
        }
        formFieldsMapping = formFieldsMapping.stream().sorted(Comparator.comparingInt(FieldMappingModel::getOrder)).collect(Collectors.toList());
        for (FieldMappingModel field : formFieldsMapping) {
            DynamicObject entry = fieldsEntry.addNew();
            entry.set("field_key", (Object)field.getStdFieldId());
            entry.set("field_name", (Object)field.getStdFieldName());
        }
        this.getView().updateView("fieldsentry");
    }

    private void setEntryRowSelected(String[] selectedFields) {
        EntryGrid eg = (EntryGrid)this.getControl("fieldsentry");
        int entryRowCount = this.getModel().getEntryRowCount("fieldsentry");
        if (entryRowCount <= 0) {
            return;
        }
        List<String> selectedFieldsList = Arrays.asList(selectedFields);
        DynamicObjectCollection entryFields = this.getModel().getEntryEntity("fieldsentry");
        int[] selectedRows = entryFields.stream().filter(f -> selectedFieldsList.contains(f.getString("field_key"))).mapToInt(arg_0 -> entryFields.indexOf(arg_0)).toArray();
        eg.selectRows(selectedRows, -1);
    }

    protected void returnData() {
        super.returnData();
        String fieldKeys = "";
        EntryGrid eg = (EntryGrid)this.getControl("fieldsentry");
        int[] selectRows = eg.getSelectRows();
        if (selectRows != null && selectRows.length > 0) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("fieldsentry");
            fieldKeys = entryEntity.stream().filter(e -> Arrays.stream(selectRows).anyMatch(i -> entryEntity.indexOf(e) == i)).map(e -> e.getString("field_key")).reduce((k1, k2) -> String.join((CharSequence)",", k1, k2)).orElse(null);
        }
        this.getView().returnDataToParent((Object)fieldKeys);
        this.getView().close();
    }
}

