/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.plugin.formplugin.multiimport.scheme;

import com.alibaba.fastjson.JSON;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ShowType;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.imsc.dmw.helper.MultiImpAttachmentHelper;
import kd.imsc.dmw.helper.MultiImpSchemeHelper;
import kd.imsc.dmw.helper.PermissionHelper;
import kd.imsc.dmw.helper.ShowFormHelper;
import kd.imsc.dmw.plugin.formplugin.multiimport.MultiImpBaseSchemeTplEdit;
import kd.imsc.dmw.utils.FileUtils;

public class ImptSchemeFormPlugin
extends MultiImpBaseSchemeTplEdit
implements UploadListener {
    private static final Log logger = LogFactory.getLog(ImptSchemeFormPlugin.class);
    private static final String ATTACHMENT = "attachmentpanelap";
    private static final String SCHEME_GUIDE_NEW = "scheme_guide_new";
    private static final String SCHEME_GUIDE_EDIT = "scheme_guide_edit";

    public void registerListener(EventObject e) {
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getControl(ATTACHMENT);
        attachmentPanel.addUploadListener((UploadListener)this);
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    public void upload(UploadEvent evt) {
        super.upload(evt);
        Object[] urls = evt.getUrls();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        operate.getOption().setVariableValue("operateType", "new");
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        if (!this.terminateIfNoPermission(e)) {
            return;
        }
        Object pkId = ((BaseShowParameter)e.getSource()).getPkId();
        if (pkId == null) {
            return;
        }
        DynamicObject schemeObj = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"dmw_impscheme");
        if (schemeObj == null) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u5220\u9664\u3002", (String)"ImptSchemeFormPlugin_7", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            return;
        }
        if (((Long)schemeObj.getDynamicObject("creator").getPkValue()).longValue() != RequestContext.get().getCurrUserId() && !"1".equals(schemeObj.getString("shared"))) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u4f60\u65e0\u8be5\u6570\u636e\u7684\u8bbf\u95ee\u6743\u9650\u3002", (String)"ImptSchemeFormPlugin_8", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        }
    }

    private boolean terminateIfNoPermission(PreOpenFormEventArgs e) {
        long currUserId = RequestContext.get().getCurrUserId();
        boolean hasPermResult = PermissionServiceHelper.checkPermission((Long)currUserId, (String)"dmw", (String)"dmw_impscheme", (String)"47150e89000000ac");
        if (!hasPermResult) {
            e.setCancel(true);
            FormMetadata formMetadata = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)"dmw_impscheme", (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
            e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u65e0\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ImptSchemeFormPlugin_9", (String)"imsc-dmw-platform", (Object[])new Object[0]), formMetadata.getName().getLocaleValue(), ResManager.loadKDString((String)"\u67e5\u8be2", (String)"ImptSchemeFormPlugin_10", (String)"imsc-dmw-platform", (Object[])new Object[0])));
            return false;
        }
        return true;
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        long creatorId = this.getModel().getDataEntity().getLong("creator.id");
        if (creatorId != RequestContext.get().getCurrUserId()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_delete", "bar_save", "bar_modify", "bar_submit", "bar_audit", "bar_disable", "bar_share"});
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setAttachmentVisible();
    }

    private void setAttachmentVisible() {
        AttachmentPanel attachControl = (AttachmentPanel)this.getControl(ATTACHMENT);
        List attachmentData = attachControl.getAttachmentData();
        if (ObjectUtils.isEmpty((Object)attachmentData)) {
            return;
        }
        Map map = (Map)attachmentData.get(0);
        String visiblePreview = "0";
        String visibleDownload = "1";
        String visibleRename = "0";
        String visibleDelete = "1";
        map.put("visible", visiblePreview + visibleDownload + visibleRename + visibleDelete);
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.setEntryProperty(ATTACHMENT, "data", (Object)attachmentData);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operationKey = args.getOperateKey();
        if ("share".equals(operationKey)) {
            boolean success = args.getOperationResult().isSuccess();
            if (success) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5171\u4eab\u6210\u529f\u3002", (String)"ImptSchemeFormPlugin_2", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            }
            return;
        }
        if ("tblexport".equals(operationKey) && operate.getOption().containsVariable("e_r")) {
            String result = operate.getOption().getVariableValue("e_r");
            if (StringUtils.isEmpty((CharSequence)result)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u5bfc\u51fa\u5931\u8d25\uff0c\u8bf7\u8fde\u7eed\u5f00\u53d1\u4eba\u5458\u67e5\u770b\u3002", (String)"ImptSchemeFormPlugin_11", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                return;
            }
            List resultArray = JSON.parseArray((String)result, String.class);
            if (resultArray == null || resultArray.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u5bfc\u51fa\u5931\u8d25\uff0c\u8bf7\u8fde\u7eed\u5f00\u53d1\u4eba\u5458\u67e5\u770b\u3002", (String)"ImptSchemeFormPlugin_11", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                return;
            }
            for (String url : resultArray) {
                FileUtils.addDownloadPermission((String)"dmw_impscheme", (String)url, (String)"dmw");
                this.getView().download(url);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        long orgId = RequestContext.get().getOrgId();
        this.getModel().setValue("createorg", (Object)orgId);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setSkipNoField(true);
        this.getModel().setDataChanged(false);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String operationKey = evt.getOperationKey();
        long id = this.getModel().getDataEntity().getLong("id");
        switch (operationKey) {
            case "newone": {
                boolean hasPermission = PermissionHelper.hasPermission("dmw_impscheme", "47156aff000000ac");
                if (!hasPermission) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u5bfc\u5165\u65b9\u6848\u8be6\u60c5\u201d\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ImptSchemeFormPlugin_12", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                    break;
                }
                this.showGuidePage(null, OperationStatus.ADDNEW, operationKey);
                break;
            }
            case "modifyone": {
                boolean hasPermission = PermissionHelper.hasPermission("dmw_impscheme", "4715a0df000000ac");
                if (!hasPermission) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u5bfc\u5165\u65b9\u6848\u8be6\u60c5\u201d\u7684\u201c\u4fee\u6539\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ImptSchemeFormPlugin_13", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                    break;
                }
                this.showGuidePage(id, OperationStatus.EDIT, operationKey);
                break;
            }
            case "createtask": {
                boolean hasPermission = PermissionHelper.hasPermission("dmw_imptask", "47156aff000000ac");
                if (!hasPermission) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u5bfc\u5165\u4efb\u52a1\u201d\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ImptSchemeFormPlugin_14", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                    break;
                }
                this.showNewTaskPage(id);
                break;
            }
            case "tblimport": {
                boolean hasPermission = PermissionHelper.hasPermission("dmw_impscheme", "47156aff000000ac");
                if (!hasPermission) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u5bfc\u5165\u65b9\u6848\u8be6\u60c5\u201d\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ImptSchemeFormPlugin_12", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                    break;
                }
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, SCHEME_GUIDE_NEW);
                MultiImpSchemeHelper.openMultiImportScheme(this.getView(), closeCallBack);
                break;
            }
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (formShowParameter == null) {
            return;
        }
        Object orginId = ((BaseShowParameter)formShowParameter).getPkId();
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)orginId, (String)"dmw_impscheme", (String)"name");
        if (dynamicObject != null) {
            String name = dynamicObject.getString("name") + "_copy";
            this.getModel().setValue("name", (Object)name);
        }
        MultiImpAttachmentHelper.copyAttachmentToPage("dmw_impscheme", orginId, ATTACHMENT, "dmw_impscheme", ATTACHMENT, this.getView());
        this.getView().updateView(ATTACHMENT);
        this.getView().setVisible(Boolean.TRUE, new String[]{"bar_modify", "bar_disable", "bar_share"});
        try {
            this.getView().invokeOperation("save");
        }
        catch (Exception ex) {
            logger.error("Scheme save exception : {} ", (Object)ex.getMessage());
            throw new KDBizException(ResManager.loadKDString((String)"\u65b9\u6848\u4fdd\u5b58\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"ImptSchemeFormPlugin_4", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        if (event.getReturnData() != null && ((Boolean)event.getReturnData()).booleanValue()) {
            if (SCHEME_GUIDE_NEW.equals(event.getActionId())) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)" \u65b0\u589e\u6210\u529f\uff0c\u8bf7\u5237\u65b0\u5217\u8868\u754c\u9762\u67e5\u770b\u65b9\u6848\u3002", (String)"ImptSchemeFormPlugin_5", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                return;
            }
            if (SCHEME_GUIDE_EDIT.equals(event.getActionId())) {
                this.getView().invokeOperation("refresh");
                this.getView().showSuccessNotification(ResManager.loadKDString((String)" \u4fee\u6539\u6210\u529f\u3002", (String)"ImptSchemeFormPlugin_6", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            }
        }
    }

    private void showNewTaskPage(Long id) {
        if (id == null) {
            return;
        }
        String enable = this.getModel().getDataEntity().getString("enable");
        if ("0".equals(enable)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u7981\u7528\uff0c\u65e0\u6cd5\u521b\u5efa\u4efb\u52a1\u3002", (String)"ImptSchemeFormPlugin_3", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            return;
        }
        this.getView().showForm((FormShowParameter)this.showForm(id));
    }

    private BillShowParameter showForm(Long schemeId) {
        HashMap<String, Object> params = new HashMap<String, Object>(1);
        params.put("scheme", schemeId);
        return ShowFormHelper.showForm("dmw_imptask", null, null, ShowType.MainNewTabPage, OperationStatus.ADDNEW, params);
    }

    private void showGuidePage(Long schemeId, OperationStatus option, String operationKey) {
        if (option == null || StringUtils.isEmpty((CharSequence)operationKey)) {
            return;
        }
        this.getView().showForm(this.showForm(schemeId, option, operationKey));
    }

    private FormShowParameter showForm(Long schemeId, OperationStatus option, String operationKey) {
        HashMap<String, Object> params = new HashMap<String, Object>(1);
        if (schemeId != null && schemeId != 0L) {
            params.put("s_g_id", schemeId);
        }
        CloseCallBack closeCallBack = null;
        if (OperationStatus.ADDNEW == option) {
            closeCallBack = new CloseCallBack((IFormPlugin)this, SCHEME_GUIDE_NEW);
        }
        if (OperationStatus.EDIT == option) {
            closeCallBack = new CloseCallBack((IFormPlugin)this, SCHEME_GUIDE_EDIT);
        }
        return ShowFormHelper.showFrom("dmw_importschemeguide", closeCallBack, ShowType.MainNewTabPage, option, params);
    }
}

