/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.plugin.formplugin.multiimport.scheme;

import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeUploadEvent;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imsc.dmw.errorcode.DmwImptException;
import kd.imsc.dmw.helper.IImportStepListener;
import kd.imsc.dmw.helper.MultiImpSchemeHelper;

public class ImptSchemeImportPlugin
extends AbstractFormPlugin
implements UploadListener,
IImportStepListener {
    private static final Log logger = LogFactory.getLog(ImptSchemeImportPlugin.class);
    private static final String BTNCANCEL = "btncancel";
    private static final String BTNOK = "btnok";
    private static final String ATTACHMENTPANELAP = "attachmentpanelap";
    private static final String BASE_CACHE = "b_k";
    private static final String MAP_CACHE = "m_k";
    private static final String TURL_CACHE = "t_k";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTNCANCEL, BTNOK});
        AttachmentPanel attachControl = (AttachmentPanel)this.getControl(ATTACHMENTPANELAP);
        attachControl.addUploadListener((UploadListener)this);
    }

    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setEnable(Boolean.FALSE, new String[]{BTNOK});
    }

    public void beforeUpload(BeforeUploadEvent evt) {
        super.beforeUpload(evt);
    }

    public void upload(UploadEvent evt) {
        super.upload(evt);
        Object[] urls = evt.getUrls();
        if (urls == null || urls.length == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0a\u4f20\u6a21\u677f\u5f02\u5e38\u6216\u5931\u8d25", (String)"ImptSchemeImportPlugin_1", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            return;
        }
        try {
            LinkedHashMap urlMap = (LinkedHashMap)urls[0];
            String url = (String)urlMap.get("url");
            MultiImpSchemeHelper.importMultiImpScheme(url, this);
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u65b9\u6848\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a[%1s]", (String)"ImptSchemeImportPlugin_3", (String)"imsc-dmw-platform", (Object[])new Object[0]), ex.getMessage()));
        }
    }

    public void afterUpload(UploadEvent evt) {
        super.afterUpload(evt);
        Object[] urls = evt.getUrls();
        if (urls == null || urls.length == 0) {
            return;
        }
        for (Object url : urls) {
            LinkedHashMap map = (LinkedHashMap)url;
            map.put("visible", "0101");
        }
        this.getView().updateView(ATTACHMENTPANELAP);
    }

    public void remove(UploadEvent evt) {
        super.remove(evt);
        this.getView().setEnable(Boolean.FALSE, new String[]{BTNOK});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)BTNOK)) {
            this.importScheme();
        }
    }

    @Override
    public void step(String step, boolean isAppend) {
        logger.info("step {} isAppend {} ", (Object)step, (Object)isAppend);
    }

    @Override
    public void fail(String reason) {
        this.getView().showErrorNotification(reason);
    }

    @Override
    public void success(String baseInfo, String mapInfo, String tMapInfo) {
        this.getPageCache().put(BASE_CACHE, baseInfo);
        this.getPageCache().put(MAP_CACHE, mapInfo);
        this.getPageCache().put(TURL_CACHE, tMapInfo);
        this.getView().setEnable(Boolean.TRUE, new String[]{BTNOK});
    }

    private void importScheme() {
        String base = this.getPageCache().get(BASE_CACHE);
        String map = this.getPageCache().get(MAP_CACHE);
        String tMapInfo = this.getPageCache().get(TURL_CACHE);
        Map urlMap = (Map)SerializationUtils.deSerializeFromBase64((String)tMapInfo);
        try {
            OperationResult operationResult = MultiImpSchemeHelper.executeSchemeDataImport(base, map, urlMap);
            if (operationResult != null && operationResult.isSuccess()) {
                this.getView().returnDataToParent((Object)Boolean.TRUE);
                this.getView().close();
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u65b9\u6848\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\u6392\u67e5\u3002", (String)"ImptSchemeImportPlugin_4", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            }
        }
        catch (DmwImptException e) {
            this.getView().showErrorNotification(e.getMessage());
        }
    }
}

