/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.plugin.formplugin.multiimport.scheme.list;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.GroupProp;
import kd.bos.entity.property.ParentBasedataProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.plugin.TemplateTreePlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class ImportTempListPlugin
extends TemplateTreePlugin {
    public static final String TEXTFORMAT_NAME = "{name}";
    public static final String TEXTFORMAT_CODE = "{code}";
    public static final String OP_OPEN = "btn_open";

    public void search(SearchEnterEvent evt) {
        List<Object> treeNodes;
        String searchText = evt.getText();
        ListShowParameter param = (ListShowParameter)this.getView().getFormShowParameter();
        String entity = param.getBillFormId();
        if ("rgc_pkgresource".equals(entity)) {
            entity = "rgc_classification";
        }
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        String searchNodesCacheKey = this.getView().getPageId() + "_searchNodes";
        String matchNodesCacheKey = this.getView().getPageId() + "_matchNodes";
        String oldSearchTextCacheKey = this.getView().getPageId() + "_oldSearchText";
        String searchIndexCacheKey = this.getView().getPageId() + "_searchIndex";
        String oldSearchText = pageCache.get(oldSearchTextCacheKey);
        pageCache.put(oldSearchTextCacheKey, searchText);
        String matchNodesCache = pageCache.get(matchNodesCacheKey);
        if (oldSearchText != null && !oldSearchText.equals(searchText) || StringUtils.isBlank((CharSequence)matchNodesCache)) {
            treeNodes = this.getSearchGroup(searchText, entity);
            pageCache.put(matchNodesCacheKey, SerializationUtils.toJsonString(treeNodes));
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchIndexCacheKey, String.valueOf(0));
        } else {
            String searchNodesCache = pageCache.get(searchNodesCacheKey);
            treeNodes = StringUtils.isBlank((CharSequence)searchNodesCache) ? SerializationUtils.fromJsonStringToList((String)matchNodesCache, TreeNode.class) : SerializationUtils.fromJsonStringToList((String)searchNodesCache, TreeNode.class);
        }
        if (treeNodes.isEmpty()) {
            treeNodes = this.getSearchGroup(searchText, entity);
            pageCache.put(matchNodesCacheKey, SerializationUtils.toJsonString(treeNodes));
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString(treeNodes));
            pageCache.put(searchIndexCacheKey, String.valueOf(0));
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22,\u6ca1\u6709\u627e\u5230\u641c\u7d22\u9879", (String)"ImportTempListPlugin_0", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        } else {
            TreeView treeView = this.getTreeListView().getTreeView();
            if (StringUtils.isNotEmpty((CharSequence)pageCache.get(searchIndexCacheKey))) {
                int indexCache = Integer.parseInt(pageCache.get(searchIndexCacheKey));
                if (indexCache < treeNodes.size()) {
                    TreeNode treeNode = treeNodes.get(indexCache);
                    String parentId = treeNode.getParentid();
                    List<String> parentIds = new ArrayList<String>();
                    if ("8609760E-EF83-4775-A9FF-CCDEC7C0B689".equals(parentId)) {
                        parentIds.add("0");
                    } else {
                        parentIds = this.getParentGroupId(parentId, parentIds, entity);
                    }
                    if (parentIds.size() <= 1) {
                        treeView.showNode(treeNodes.get(indexCache).getParentid());
                        treeView.focusNode(treeNodes.get(indexCache));
                        treeView.treeNodeClick(treeNodes.get(indexCache).getParentid(), treeNodes.get(indexCache).getId());
                        pageCache.put(searchIndexCacheKey, String.valueOf(++indexCache));
                    } else {
                        for (int i = parentIds.size(); i >= 1; --i) {
                            if (i == 1) {
                                treeView.showNode(parentIds.get(i - 1));
                                treeView.focusNode(treeNodes.get(indexCache));
                                treeView.treeNodeClick(treeNodes.get(indexCache).getParentid(), treeNodes.get(indexCache).getId());
                                break;
                            }
                            treeView.showNode(parentIds.get(i - 1));
                            treeView.treeNodeClick(parentIds.get(i - 1), parentIds.get(i - 2));
                        }
                        pageCache.put(searchIndexCacheKey, String.valueOf(++indexCache));
                    }
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22", (String)"ImportTempListPlugin_1", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                    pageCache.put(searchIndexCacheKey, String.valueOf(0));
                }
            } else {
                treeView.showNode(treeNodes.get(0).getParentid());
                treeView.focusNode(treeNodes.get(0));
                treeView.treeNodeClick(treeNodes.get(0).getParentid(), treeNodes.get(0).getId());
                pageCache.put(searchIndexCacheKey, String.valueOf(0));
            }
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString(treeNodes));
        }
    }

    private List<TreeNode> getSearchGroup(String searchText, String entity) {
        QFilter qFilter2 = new QFilter("name", "like", (Object)("%" + searchText + "%"));
        DynamicObjectCollection datas = QueryServiceHelper.query((String)entity, (String)"id,number,name,parent,longnumber,isleaf", (QFilter[])new QFilter[]{qFilter2}, (String)"number");
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(datas.size());
        for (DynamicObject group : datas) {
            if (group.getLong("id") == 0L) continue;
            TreeNode treeNode = new TreeNode();
            treeNode.setId(group.getString("id"));
            Long parent = group.getLong("parent");
            treeNode.setParentid(parent == 0L ? "8609760E-EF83-4775-A9FF-CCDEC7C0B689" : group.getString("parent"));
            treeNode.setLongNumber(group.getString("longnumber"));
            treeNode = this.getLocaleStringName(group, "", treeNode);
            treeNodes.add(treeNode);
        }
        return treeNodes;
    }

    protected void initTree() {
        TreeNode root = this.getTreeModel().createRootNode();
        if (root != null) {
            root.setChildren(new ArrayList(0));
            this.getTreeModel().setRoot(root);
            String rootId = root.getId();
            this.getTreeModel().setCurrentNodeId((Object)rootId);
        }
    }

    protected TreeNode getLocaleStringName(DynamicObject group, String textFormat, TreeNode treeNode) {
        String name = group.getString("name");
        String number = group.getString("number");
        if (StringUtils.isBlank((CharSequence)name)) {
            name = group.getString("name");
        }
        String text = textFormat;
        if (StringUtils.isNotBlank((CharSequence)textFormat)) {
            if (textFormat.contains(TEXTFORMAT_NAME) && StringUtils.isNotBlank((CharSequence)name)) {
                text = org.apache.commons.lang.StringUtils.replace((String)text, (String)TEXTFORMAT_NAME, (String)name);
            }
            if (textFormat.contains(TEXTFORMAT_CODE) && StringUtils.isNotBlank((CharSequence)number)) {
                text = org.apache.commons.lang.StringUtils.replace((String)text, (String)TEXTFORMAT_CODE, (String)number);
            }
        }
        if (StringUtils.isBlank((CharSequence)text)) {
            treeNode.setText(name);
        } else {
            treeNode.setText(text);
        }
        return treeNode;
    }

    private List<String> getParentGroupId(String groupId, List<String> parentIds, String entity) {
        DynamicObject group = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.valueOf(groupId), (String)entity, (String)"longnumber");
        String longNumberDlm = ".";
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entity);
        DynamicProperty property = dataEntityType.getProperty("parent");
        GroupProp grop = (GroupProp)property;
        if (grop instanceof ParentBasedataProp) {
            longNumberDlm = ((ParentBasedataProp)grop).getLongNumberDLM();
        }
        String longnumber = group.getString("longnumber");
        String[] numbers = longnumber.split(longNumberDlm);
        Map groups = BusinessDataServiceHelper.loadFromCache((String)entity, (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)numbers)}, (String)"level desc");
        for (DynamicObject parent : groups.values()) {
            String parentId = parent.getString("id");
            if (parentIds.contains(groupId)) continue;
            parentIds.add(parentId);
        }
        return parentIds;
    }

    protected List<QFilter> addQFilters(List<QFilter> parentQFilters, QFilter ... qFilter) {
        for (QFilter qf : qFilter) {
            parentQFilters.add(qf);
        }
        return parentQFilters;
    }
}

