/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.plugin.formplugin.multiimport.task;

import com.google.common.primitives.Ints;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleDynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.report.CellStyle;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.OperationColumn;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.imsc.dmw.engine.multiimport.MultiImportServiceTaskImpl;
import kd.imsc.dmw.engine.multiimport.helper.ImportServiceManagerHelper;
import kd.imsc.dmw.engine.multiimport.helper.MultiImpTaskHelper;
import kd.imsc.dmw.engine.multiimport.helper.StdImportLoggerHelper;
import kd.imsc.dmw.engine.multiimport.model.BizOperationResult;
import kd.imsc.dmw.enums.MultiImpTaskEntryStatusEnum;
import kd.imsc.dmw.enums.MultiImpTaskStatusEnum;
import kd.imsc.dmw.helper.MultiImpAttachmentHelper;
import kd.imsc.dmw.helper.MultiImpSchemeHelper;
import kd.imsc.dmw.plugin.formplugin.multiimport.MultiImpBaseSchemeTplEdit;
import kd.imsc.dmw.plugin.formplugin.multiimport.task.MergeImportTaskClick;
import kd.imsc.dmw.utils.CommonUtils;
import kd.imsc.dmw.utils.DynamicObjectUtils;
import kd.imsc.dmw.utils.FileUtils;
import kd.imsc.dmw.utils.StringUtil;

public class MultiImpTaskEdit
extends MultiImpBaseSchemeTplEdit
implements BeforeF7SelectListener,
UploadListener,
ProgresssListener {
    private static final Log logger = LogFactory.getLog(MultiImpTaskEdit.class);
    private static final String TBMAIN = "tbmain";
    private static final String TASK_SELECT_ROWINDEX = "task_select_rowindex";
    private static final String CACHE_SCHEMEINFO_CHANGED = "cache_schemeinfo_changed";
    private static final String CACHE_SAVEOP_INVOKER = "cache_saveop_invoker";
    private static final String ML_LOCALEID = "localeid";
    private static final String WHITE_SPACE = " ";
    private static final int NAME_MAXLENGTH = 50;
    private static final Map<String, String> entryStatusColorMap = new HashMap<String, String>();

    public void initialize() {
        super.initialize();
        this.setEntryOperationVisibleWhenPackageData();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Toolbar userToolbar = (Toolbar)this.getView().getControl(TBMAIN);
        userToolbar.addItemClickListener((ItemClickListener)this);
        Label taskTplDownload = (Label)this.getView().getControl("labeldownloadtpl");
        taskTplDownload.addClickListener((ClickListener)this);
        Button viewSchemeBtn = (Button)this.getView().getControl("viewschemebtn");
        Button updateSchemeBtn = (Button)this.getView().getControl("updateshemebtn");
        Button ignoreSchemeBtn = (Button)this.getView().getControl("ignoreschemebtn");
        viewSchemeBtn.addClickListener((ClickListener)this);
        updateSchemeBtn.addClickListener((ClickListener)this);
        ignoreSchemeBtn.addClickListener((ClickListener)this);
        BasedataEdit scheme = (BasedataEdit)this.getView().getControl("scheme");
        scheme.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ProgressBar progressBar = (ProgressBar)this.getView().getControl("progressbarap");
        progressBar.addProgressListener((ProgresssListener)this);
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getControl("attachmentpanelap");
        attachmentPanel.addUploadListener((UploadListener)this);
        TextEdit replaceKeyWord = (TextEdit)this.getControl("replacekeyword");
        replaceKeyWord.addClickListener((ClickListener)this);
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        if (!this.terminateIfNoPermission(e)) {
            return;
        }
        this.terminateIfNotAuthedData(e);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String prop = e.getProperty().getName();
        if ("scheme".equals(prop)) {
            ListShowParameter param = (ListShowParameter)e.getFormShowParameter();
            QFilter schemeFilter = new QFilter("creator", "=", (Object)RequestContext.get().getCurrUserId());
            schemeFilter.or("shared", "=", (Object)Boolean.TRUE);
            param.getListFilterParameter().setFilter(schemeFilter);
        }
    }

    public void click(EventObject e) {
        boolean isTplAttClick;
        super.click(e);
        Object source = e.getSource();
        boolean bl = isTplAttClick = source instanceof Label && "labeldownloadtpl".equals(((Label)source).getKey());
        if (isTplAttClick) {
            String tplUrl = (String)this.getModel().getValue("tasktplurl");
            if (StringUtils.isEmpty((CharSequence)tplUrl)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5bfc\u5165\u65b9\u6848\u672a\u914d\u7f6e\u6a21\u677f\uff0c\u8bf7\u5230\u5bfc\u5165\u65b9\u6848\u7ef4\u62a4\u3002", (String)"MultiImpTaskEdit_4", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                return;
            }
            FileUtils.addDownloadPermission((String)"dmw_imptask", (String)tplUrl, (String)"dmw");
            this.getView().download(tplUrl);
        } else if (source instanceof Button) {
            String btnKey;
            switch (btnKey = ((Button)source).getKey()) {
                case "updateshemebtn": {
                    this.refreshScheme();
                    break;
                }
                case "viewschemebtn": {
                    this.viewScheme();
                    break;
                }
                case "ignoreschemebtn": {
                    this.ignoreSchemeUpdating();
                    break;
                }
            }
        } else if (source instanceof TextEdit) {
            this.showEntityFieldsForm((TextEdit)source);
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initSetTaskTplUrl();
        this.setEntryStatusColor();
        this.setEntryMultiSelectWhenFailed();
        this.setSchemeFromShowParam();
        this.startProgressWhenExecuting();
        String taskStatus = MultiImpTaskHelper.getTaskStatusByEntryStatus(this.getModel().getDataEntity(true));
        boolean isCance = this.isCanceUpdateStatus(taskStatus);
        this.getView().setVisible(Boolean.valueOf(!isCance), new String[]{"bar_updateimpstatus"});
        this.setSchemeUpdateTipsVisible();
    }

    public void onProgress(ProgressEvent progressEvent) {
        Object impStatus = this.getModel().getValue("impstatus");
        String opStr = this.getPageCache().get("updateimpstatus");
        if (!"updateimpstatus".equals(opStr)) {
            if (MultiImpTaskStatusEnum.EXECUTING.getStatus().equals(impStatus)) {
                this.getView().invokeOperation("refresh");
            } else {
                progressEvent.setProgress(100);
                ProgressBar progressBar = (ProgressBar)this.getView().getControl("progressbarap");
                progressBar.stop();
                String msg = ResManager.loadKDString((String)"\u4efb\u52a1\u5bfc\u5165\u6210\u529f\u3002", (String)"MultiImpTaskEdit_13", (String)"imsc-dmw-platform", (Object[])new Object[0]);
                if (MultiImpTaskStatusEnum.SUCCESS.getStatus().equals(impStatus)) {
                    this.getView().showSuccessNotification(msg);
                } else if (MultiImpTaskStatusEnum.FAIL.getStatus().equals(impStatus)) {
                    String str = this.getPageCache().get(TASK_SELECT_ROWINDEX);
                    boolean isSuccess = false;
                    if (StringUtil.isNotEmpty(str)) {
                        List rowIndexList = (List)SerializationUtils.fromJsonString((String)str, List.class);
                        List<DynamicObject> entryEntities = this.getExecTaskEntryList(rowIndexList.stream().mapToInt(Integer::valueOf).toArray());
                        int[] successRowIndex = entryEntities.stream().filter(e -> MultiImpTaskEntryStatusEnum.SUCCESS.getStatus().equals(e.getString("execstatus"))).mapToInt(entryEntities::indexOf).toArray();
                        if (!CommonUtils.isNull(successRowIndex)) {
                            isSuccess = true;
                            int failCount = rowIndexList.size() - successRowIndex.length;
                            if (failCount > 0) {
                                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5b50\u4efb\u52a1\u5bfc\u5165\u6210\u529f%1$s\u6761\uff0c\u5931\u8d25%2$s\u6761\u3002", (String)"MultiImpTaskEdit_15", (String)"imsc-dmw-platform", (Object[])new Object[0]), successRowIndex.length, failCount));
                            } else {
                                this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u5b50\u4efb\u52a1\u5bfc\u5165\u6210\u529f%s\u6761\u3002", (String)"MultiImpTaskEdit_16", (String)"imsc-dmw-platform", (Object[])new Object[0]), successRowIndex.length));
                            }
                        }
                    }
                    if (!isSuccess) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5bfc\u5165\u5931\u8d25\u3002", (String)"MultiImpTaskEdit_14", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                    }
                }
            }
        }
    }

    public void upload(UploadEvent evt) {
        String sourceKey;
        super.afterUpload(evt);
        Object source = evt.getSource();
        String string = sourceKey = source instanceof AttachmentPanel ? ((AttachmentPanel)source).getKey() : null;
        if ("attachmentpanelap".equals(sourceKey)) {
            Object[] urls = evt.getUrls();
            if (urls == null || urls.length < 1) {
                return;
            }
            Map attachment = (Map)urls[0];
            String fileUrl = attachment == null ? null : (String)attachment.get("url");
            BizOperationResult checkResult = this.validateImportFile(fileUrl);
            if (!checkResult.getSuccess()) {
                evt.setCancelMsg(checkResult.getErrorDesc());
                evt.setCancel(true);
            }
        }
    }

    public void afterUpload(UploadEvent evt) {
        String sourceKey;
        super.afterUpload(evt);
        Object source = evt.getSource();
        String string = sourceKey = source instanceof AttachmentPanel ? ((AttachmentPanel)source).getKey() : null;
        if ("attachmentpanelap".equals(sourceKey)) {
            String impFileName = this.getImpFileName();
            if (StringUtils.isNotEmpty((CharSequence)impFileName) && impFileName.length() > 50) {
                impFileName = impFileName.substring(0, 50);
            }
            if (StringUtils.isEmpty((CharSequence)((OrmLocaleValue)this.getModel().getValue("name")).getLocaleValue())) {
                this.getModel().setValue("name", (Object)impFileName);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String prop = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet != null && changeSet.length > 0) {
            Object newValue = changeSet[0] == null ? null : changeSet[0].getNewValue();
            switch (prop) {
                case "scheme": {
                    long newSchemeId = !(newValue instanceof DynamicObject) ? 0L : ((DynamicObject)newValue).getLong("id");
                    this.loadSchemeInfoFromF7(newSchemeId);
                    break;
                }
                case "name": {
                    this.rTrimName(newValue);
                    break;
                }
                case "replacekeyword": {
                    boolean isValueCleaned;
                    boolean bl = isValueCleaned = newValue == null || newValue instanceof String && StringUtils.isEmpty((CharSequence)((String)newValue));
                    if (!isValueCleaned) break;
                    this.getModel().setValue("replacekeyfield", null);
                    break;
                }
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String opKey;
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        switch (opKey = source.getOperateKey()) {
            case "save": {
                Map<String, Object> importFile;
                boolean isSchemeInfoChanged = "1".equals(this.getPageCache().get(CACHE_SCHEMEINFO_CHANGED));
                if (isSchemeInfoChanged) {
                    this.deleteAttachment("tplpanelap", true);
                }
                if ((importFile = this.getImportFileInfo()) != null && !importFile.isEmpty() && importFile.containsKey("url")) break;
                args.setCancel(true);
                this.getPageCache().remove(CACHE_SAVEOP_INVOKER);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u5bfc\u5165\u6587\u4ef6\u3002", (String)"MultiImpTaskEdit_5", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                break;
            }
            case "exectask": 
            case "re_exectask": {
                this.getPageCache().put("updateimpstatus", "");
                this.getPageCache().put(CACHE_SAVEOP_INVOKER, opKey);
                OperationResult operationResult = this.getView().invokeOperation("save");
                if (!operationResult.isSuccess()) {
                    args.setCancel(true);
                    return;
                }
                this.setExecOpData(args);
                break;
            }
            case "updateimpstatus": {
                String taskStatus = MultiImpTaskHelper.getTaskStatusByEntryStatus(this.getModel().getDataEntity(true));
                boolean isCance = this.isCanceUpdateStatus(taskStatus);
                if (!isCance) {
                    if (MultiImpTaskStatusEnum.EXECUTING.getStatus().equals(taskStatus)) {
                        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
                        for (DynamicObject entryDynObj : entryEntity) {
                            if (!MultiImpTaskStatusEnum.EXECUTING.getStatus().equals(entryDynObj.getString("execstatus"))) continue;
                            this.getModel().setValue("execstatus", (Object)MultiImpTaskStatusEnum.FAIL.getStatus(), entryDynObj.getInt("seq") - 1);
                        }
                        taskStatus = MultiImpTaskHelper.getTaskStatusByEntryStatus(this.getModel().getDataEntity(true));
                        this.setEntryStatusColor();
                    }
                    this.getPageCache().put("updateimpstatus", opKey);
                    this.getModel().setValue("impstatus", (Object)taskStatus);
                    break;
                }
                args.setCancel(isCance);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String opKey;
        super.afterDoOperation(args);
        Object source = args.getSource();
        FormOperate op = (FormOperate)source;
        OperationResult operationResult = args.getOperationResult();
        boolean opSuccess = operationResult != null && operationResult.isSuccess();
        switch (opKey = op.getOperateKey()) {
            case "save": {
                this.afterSaveOp(op, operationResult);
                break;
            }
            case "expfaildata": {
                this.downloadCurrentRowFailData();
                break;
            }
            case "uploadentryimpfile": {
                this.clickCurrentRowAttachmentField();
                break;
            }
            case "exectask": 
            case "re_exectask": {
                if (!opSuccess) break;
                this.getView().invokeOperation("refresh");
                this.afterExecuteOp(op);
                break;
            }
            case "terminate": {
                if (!opSuccess) break;
                this.getView().invokeOperation("refresh");
                break;
            }
            case "updateimpstatus": {
                if (!opSuccess) break;
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_updateimpstatus"});
                this.setEntryMultiSelectWhenFailed();
                this.setSchemeUpdateTipsVisible();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("replacekeyword".equals(actionId) && closedCallBackEvent.getReturnData() instanceof String) {
            DynamicObject entry;
            String returnData = (String)closedCallBackEvent.getReturnData();
            if (StringUtils.isNotEmpty((CharSequence)returnData)) {
                returnData = "," + returnData + ",";
            }
            if ((entry = this.getCurrentRowEntry()) == null) {
                return;
            }
            entry.set("replacekeyfield", (Object)returnData);
            super.setEntryObjectPropName(entry);
            this.getView().updateView("entryentity");
            this.setEntryStatusColor();
        }
    }

    private void setSchemeUpdateTipsVisible() {
        boolean isVisible = false;
        Date schemeModifyTime = DynamicObjectUtils.getDate(this.getModel().getDataEntity(), "schememodifytime");
        Date schemeModifyTime2 = DynamicObjectUtils.getDate(this.getModel().getDataEntity().getDynamicObject("scheme"), "modifytime");
        if (schemeModifyTime != null && new Timestamp(schemeModifyTime.getTime()).compareTo(schemeModifyTime2) != 0 && MultiImpTaskStatusEnum.SAVE.getStatus().equals(this.getModel().getDataEntity().getString("impstatus"))) {
            isVisible = true;
        }
        this.getView().setVisible(Boolean.valueOf(isVisible), new String[]{"flexpanelap"});
    }

    private boolean terminateIfNotAuthedData(PreOpenFormEventArgs e) {
        boolean isCurrentUserData;
        super.preOpenForm(e);
        Object source = e.getSource();
        if (!(source instanceof BillShowParameter)) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u975e\u6cd5\u7684\u8bbf\u95ee\u53c2\u6570\u3002", (String)"MultiImpTaskEdit_0", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            return false;
        }
        Object pkId = ((BillShowParameter)e.getSource()).getPkId();
        DynamicObject taskObj = pkId != null ? MultiImpTaskHelper.getTaskById(Long.parseLong(pkId.toString())) : null;
        long currUserId = RequestContext.get().getCurrUserId();
        boolean bl = isCurrentUserData = taskObj != null && DynamicObjectUtils.getPkValue(taskObj, "creator") != currUserId;
        if (isCurrentUserData) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u4f60\u65e0\u8be5\u6570\u636e\u7684\u8bbf\u95ee\u6743\u9650\u3002", (String)"MultiImpTaskEdit_1", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean terminateIfNoPermission(PreOpenFormEventArgs e) {
        long currUserId = RequestContext.get().getCurrUserId();
        boolean hasPermResult = PermissionServiceHelper.checkPermission((Long)currUserId, (String)"dmw", (String)"dmw_imptask", (String)"47150e89000000ac");
        if (!hasPermResult) {
            e.setCancel(true);
            FormMetadata formMetadata = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)"dmw_imptask", (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
            e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u65e0\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"MultiImpTaskEdit_2", (String)"imsc-dmw-platform", (Object[])new Object[0]), formMetadata.getName().getLocaleValue(), ResManager.loadKDString((String)"\u67e5\u8be2", (String)"MultiImpTaskEdit_3", (String)"imsc-dmw-platform", (Object[])new Object[0])));
            return false;
        }
        return true;
    }

    private void setEntryOperationVisibleWhenPackageData() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addPackageDataListener(pkgEvent -> {
            boolean isOperationColumn;
            String entryStatus = pkgEvent.getRowData().getString("execstatus");
            Object source = pkgEvent.getSource();
            boolean bl = isOperationColumn = source instanceof OperationColumn && "operationcolumnap".equalsIgnoreCase(((OperationColumn)source).getKey());
            if (isOperationColumn) {
                List operationColItems = (List)pkgEvent.getFormatValue();
                long failLogId = pkgEvent.getRowData().getLong("faillogid");
                boolean operationVisible = failLogId > 0L && MultiImpTaskEntryStatusEnum.FAIL.getStatus().equals(entryStatus);
                for (OperationColItem operationColItem : operationColItems) {
                    operationColItem.setVisible(operationVisible);
                }
            }
        });
    }

    private void showEntityFieldsForm(TextEdit source) {
        String textKey = source.getKey();
        if (!"replacekeyword".equals(textKey)) {
            return;
        }
        DynamicObject currentRowEntry = this.getCurrentRowEntry();
        if (currentRowEntry == null) {
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("dmw_entity_fields");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, textKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        String formId = DynamicObjectUtils.getDynamicObjectStringValue(currentRowEntry, "billentity", "target_formid");
        String selectedFields = currentRowEntry.getString("replacekeyfield");
        showParameter.getCustomParams().put("entity_number", formId);
        showParameter.getCustomParams().put("entity_fields", selectedFields);
        this.getView().showForm(showParameter);
    }

    private void viewScheme() {
        Object scheme = this.getModel().getValue("scheme");
        long schemeId = scheme == null ? 0L : ((DynamicObject)scheme).getLong("id");
        BaseShowParameter param = new BaseShowParameter();
        param.setFormId("dmw_impscheme");
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.setPkId((Object)schemeId);
        param.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)param);
    }

    private void refreshScheme() {
        Object scheme = this.getModel().getValue("scheme");
        if (scheme != null) {
            DynamicObject dbScheme = this.loadSchemeInfoFromF7(((DynamicObject)scheme).getLong("id"));
            this.loadSchemeBaseInfoWhenRefresh(dbScheme);
            this.getPageCache().put(CACHE_SAVEOP_INVOKER, "updateshemebtn");
            this.getView().invokeOperation("save");
        }
    }

    private void ignoreSchemeUpdating() {
        Object scheme = this.getModel().getValue("scheme");
        if (scheme != null) {
            this.getModel().setValue("schememodifytime", (Object)((DynamicObject)scheme).getDate("modifytime"));
            this.getPageCache().put(CACHE_SAVEOP_INVOKER, "ignoreschemebtn");
            this.getView().invokeOperation("save");
        }
    }

    private void setEntryMultiSelectWhenFailed() {
        String impStatus = (String)this.getModel().getValue("impstatus");
        HashMap<String, Boolean> egType = new HashMap<String, Boolean>(1);
        egType.put("selchexkbox", MultiImpTaskStatusEnum.FAIL.getStatus().equals(impStatus));
        this.getView().updateControlMetadata("entryentity", egType);
    }

    private void initSetTaskTplUrl() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        long taskId = dataEntity.getLong("id");
        Map<String, Object> taskTpl = MultiImpTaskHelper.getTaskAttachment(taskId, "tplpanelap");
        if (taskTpl != null && !taskTpl.isEmpty()) {
            this.getModel().setValue("tasktplurl", taskTpl.get("url"));
        }
        this.getView().updateView("tasktplurl");
        this.getModel().setDataChanged(false);
    }

    private void setEntryStatusColor() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
        ArrayList<CellStyle> csList = new ArrayList<CellStyle>(entryEntity.size());
        int size = entryEntity.size();
        for (int i = 0; i < size; ++i) {
            DynamicObject entry = (DynamicObject)entryEntity.get(i);
            String entryStatus = entry.getString("execstatus");
            if (StringUtils.isEmpty((CharSequence)entryStatus)) {
                entryStatus = MultiImpTaskEntryStatusEnum.SAVE.getStatus();
            }
            CellStyle cs = new CellStyle();
            cs.setFieldKey("execstatus");
            cs.setRow(i);
            cs.setForeColor(entryStatusColorMap.get(entryStatus));
            csList.add(cs);
        }
        grid.setCellStyle(csList);
    }

    private void setSchemeFromShowParam() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (formShowParameter != null) {
            Map customParams = formShowParameter.getCustomParams();
            if (ObjectUtils.isEmpty((Object)customParams) || !customParams.containsKey("scheme")) {
                return;
            }
            Object schemeId = customParams.get("scheme");
            this.getModel().setValue("scheme", schemeId);
        }
    }

    private void startProgressWhenExecuting() {
        Object impStatus = this.getModel().getValue("impstatus");
        ProgressBar progressBar = (ProgressBar)this.getView().getControl("progressbarap");
        if (MultiImpTaskStatusEnum.EXECUTING.getStatus().equals(impStatus)) {
            progressBar.start();
        }
    }

    private void initProgressBar() {
        ProgressBar progressBar = (ProgressBar)this.getView().getControl("progressbarap");
        progressBar.setPercent(0);
    }

    private void loadSchemeBaseInfoWhenRefresh(DynamicObject scheme) {
        if (scheme != null) {
            this.getModel().setValue("tarmeta", scheme.get("tarmeta"));
            this.getModel().setValue("schememodifytime", scheme.get("modifytime"));
        }
    }

    private void setExecOpData(BeforeDoOperationEventArgs args) {
        FormOperate op = (FormOperate)args.getSource();
        String opKey = op.getOperateKey();
        EntryGrid eg = (EntryGrid)this.getView().getControl("entryentity");
        int[] selectRows = eg.getSelectRows();
        List<Object> entryEntities = this.getExecTaskEntryList(selectRows);
        if ("re_exectask".equals(opKey)) {
            if (selectRows == null || selectRows.length < 1) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u9700\u8981\u91cd\u65b0\u6267\u884c\u7684\u5b50\u4efb\u52a1\u3002", (String)"MultiImpTaskEdit_6", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                return;
            }
            List entryList = entryEntities.stream().filter(e -> !MultiImpTaskEntryStatusEnum.SUCCESS.getStatus().equals(e.getString("execstatus"))).collect(Collectors.toList());
            if (entryList.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\u7684\u5b50\u4efb\u52a1\uff0c\u4e0d\u80fd\u91cd\u65b0\u6267\u884c\u3002", (String)"MultiImpTaskEdit_7", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            entryEntities = entryList;
            int[] successRowIndex = entryList.stream().mapToInt(o -> o.getInt("seq") - 1).toArray();
            this.getView().getPageCache().put(TASK_SELECT_ROWINDEX, SerializationUtils.toJsonString((Object)Ints.asList((int[])successRowIndex)));
        }
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        List execBillEntityNumber = entryEntities.stream().map(e -> {
            DynamicObject billEntity = e.getDynamicObject("billentity");
            return billEntity == null ? null : billEntity.getString("target_formid");
        }).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
        HashMap execData = new HashMap(1);
        execData.put(dataEntity.getLong("id"), execBillEntityNumber);
        op.getOption().setVariableValue("cache_task_exec_data", SerializationUtils.toJsonString(execData));
    }

    private List<DynamicObject> getExecTaskEntryList(int[] selectRows) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (!CommonUtils.isNull(selectRows)) {
            return entryEntity.stream().filter(e -> Arrays.stream(selectRows).anyMatch(i -> i == entryEntity.indexOf(e))).collect(Collectors.toList());
        }
        return entryEntity;
    }

    private void clickCurrentRowAttachmentField() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        HashMap<String, Object> attClickParam = new HashMap<String, Object>(2);
        attClickParam.put("c", "impfile");
        attClickParam.put("r", this.getModel().getEntryCurrentRowIndex("entryentity"));
        entryGrid.attachmentClick(attClickParam);
    }

    private void downloadCurrentRowFailData() {
        DynamicObject currentEntry = this.getCurrentRowEntry();
        long logId = currentEntry.getLong("faillogid");
        String importLogResultToUrl = null;
        String errorMessage = currentEntry.getString("failreason");
        if (logId > 0L) {
            try {
                importLogResultToUrl = StdImportLoggerHelper.getImportLogResultToUrl(logId);
            }
            catch (Exception e) {
                errorMessage = e.getMessage();
            }
        }
        if (StringUtils.isEmpty(importLogResultToUrl)) {
            if (StringUtils.isEmpty((CharSequence)errorMessage)) {
                String entityName = DynamicObjectUtils.getDynamicObjectStringValue(currentEntry, "billentity", "name");
                MainEntityType executeReport = EntityMetadataCache.getDataEntityType((String)"dmw_task_excute_report");
                String executeReportName = executeReport == null ? ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u62a5\u544a", (String)"MultiImpTaskEdit_8", (String)"imsc-dmw-platform", (Object[])new Object[0]) : executeReport.getDisplayName().getLocaleValue();
                errorMessage = String.format(ResManager.loadKDString((String)"\u4e0b\u8f7d\u5931\u8d25\uff0c\u8bf7\u901a\u8fc7%1$s\u6216%2$s\u7684\u5bfc\u5165\u7ed3\u679c\u83b7\u53d6\u3002", (String)"MultiImpTaskEdit_9", (String)"imsc-dmw-platform", (Object[])new Object[0]), executeReportName, entityName);
            }
            this.getView().showErrorNotification(errorMessage);
            return;
        }
        FileUtils.syncWriteFileBillMapping((String)"", (String)"dmw", (String)importLogResultToUrl, (String)"dmw_imptask", (String)"attachmentpanelap", (String)this.getModel().getDataEntity().getString("id"), (String)"", (long)0L);
        this.getView().download(importLogResultToUrl);
    }

    private void afterExecuteOp(FormOperate op) {
        String opKey = op.getOperateKey();
        long pkValue = (Long)this.getModel().getDataEntity().getPkValue();
        Map opData = MultiImpTaskHelper.deserializeOpCacheValue(op.getOption(), "cache_task_exec_data", Map.class);
        List entityNumbers = (List)opData.get(String.valueOf(pkValue));
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        List<DynamicObject> entries = entryEntity.stream().filter(e -> entityNumbers.contains(DynamicObjectUtils.getDynamicObjectStringValue(e, "billentity", "target_formid"))).collect(Collectors.toList());
        Map<String, Object> jobParam = MultiImpTaskHelper.buildExecParams(pkValue, entries);
        if (jobParam.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f3a\u5c11\u6709\u6548\u7684\u5f85\u6267\u884c\u4efb\u52a1\u4fe1\u606f\uff0c\u8bf7\u5148\u4fdd\u5b58\uff0c\u6216\u52fe\u9009\u4efb\u52a1\u4fe1\u606f\u540e\u64cd\u4f5c\u3002", (String)"MultiImpTaskEdit_10", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            return;
        }
        ImportServiceManagerHelper.buildAndCommitJobFormInfo(this.getView(), pkValue, this.getView().getFormShowParameter().getAppId(), "dmw_imptask", MultiImportServiceTaskImpl.class.getName(), MergeImportTaskClick.class.getName(), jobParam, new CloseCallBack((IFormPlugin)this, opKey));
    }

    private void afterSaveOp(FormOperate op, OperationResult saveResult) {
        boolean invokeBySave;
        String saveOpInvoker = this.getPageCache().get(CACHE_SAVEOP_INVOKER);
        boolean bl = invokeBySave = saveOpInvoker == null || "save".equals(saveOpInvoker);
        if (saveResult != null && saveResult.isSuccess()) {
            if (!invokeBySave) {
                op.getOption().setVariableValue("isshowmessage", Boolean.FALSE.toString());
                String showMessage = "";
                if ("ignoreschemebtn".equals(saveOpInvoker)) {
                    showMessage = ResManager.loadKDString((String)"\u5df2\u5ffd\u7565\u3002", (String)"MultiImpTaskEdit_11", (String)"imsc-dmw-platform", (Object[])new Object[0]);
                } else if ("updateshemebtn".equals(saveOpInvoker)) {
                    showMessage = ResManager.loadKDString((String)"\u65b9\u6848\u5df2\u66f4\u65b0\u3002", (String)"MultiImpTaskEdit_12", (String)"imsc-dmw-platform", (Object[])new Object[0]);
                }
                if (!StringUtils.isEmpty((CharSequence)showMessage)) {
                    this.getView().showSuccessNotification(showMessage);
                }
            }
            if (!"re_exectask".equals(saveOpInvoker)) {
                this.getView().invokeOperation("refresh");
            } else {
                this.getView().updateView("impstatus");
                this.initProgressBar();
            }
            this.getView().getPageCache().remove(CACHE_SCHEMEINFO_CHANGED);
        }
        this.getPageCache().remove(CACHE_SAVEOP_INVOKER);
    }

    private void rTrimName(Object newValue) {
        if (newValue == null) {
            return;
        }
        if (newValue instanceof String) {
            String newName = (String)newValue;
            if (newName.endsWith(WHITE_SPACE)) {
                this.getModel().setValue("name", (Object)StringUtil.rtrim((String)newValue));
            }
        } else if (newValue instanceof LocaleDynamicObjectCollection) {
            LocaleDynamicObjectCollection newNameCol = (LocaleDynamicObjectCollection)newValue;
            LocaleString newName = new LocaleString();
            for (DynamicObject v : newNameCol) {
                String name = v.getString("name");
                if (!name.endsWith(WHITE_SPACE)) continue;
                newName.setItem(v.getString(ML_LOCALEID), (Object)StringUtil.rtrim(v.getString("name")));
            }
            if (CollectionUtils.isNotEmpty((Collection)newName.keySet())) {
                this.getModel().setValue("name", (Object)newName);
            }
        }
    }

    private DynamicObject loadSchemeInfoFromF7(long schemeId) {
        this.loadSchemeTplAttachment(schemeId);
        DynamicObject scheme = this.loadSchemeDetail(schemeId);
        this.getModel().setValue("modelinfo_tag", scheme == null ? null : scheme.get("modelinfo_tag"));
        this.getView().getPageCache().put(CACHE_SCHEMEINFO_CHANGED, "1");
        BizOperationResult checkResult = this.validateImportFile((String)this.getImportFileInfo().get("url"));
        if (!checkResult.getSuccess() && StringUtils.isNotEmpty((CharSequence)checkResult.getErrorDesc())) {
            this.getView().showTipNotification(checkResult.getErrorDesc());
        }
        return scheme;
    }

    private void loadSchemeTplAttachment(long schemeId) {
        try {
            Map<String, Object> attachment = MultiImpAttachmentHelper.copyAttachmentToPage("dmw_impscheme", schemeId, "attachmentpanelap", "t_dmw_mitask", "tplpanelap", this.getView());
            this.getModel().setValue("tasktplurl", attachment.get("url"));
            this.getView().updateView("tplpanelap");
        }
        catch (KDBizException e) {
            logger.error((Throwable)e);
        }
    }

    private void deleteAttachment(String attachmentPanelId, boolean reserveTempFile) {
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl(attachmentPanelId);
        List oldAttachments = attachmentPanel.getAttachmentData();
        for (Map old : oldAttachments) {
            boolean isTemp;
            String url = (String)old.get("url");
            boolean bl = isTemp = !StringUtils.isEmpty((CharSequence)url) && url.contains("tempfile/download.do?configKey");
            if (reserveTempFile && isTemp) continue;
            attachmentPanel.remove(old);
        }
    }

    private DynamicObject loadSchemeDetail(long schemeId) {
        DynamicObject scheme = null;
        DynamicObjectCollection taskEntryEntity = this.getModel().getEntryEntity("entryentity");
        for (DynamicObject entry : taskEntryEntity) {
            DynamicObjectCollection subEntryEntity = entry.getDynamicObjectCollection("subentryentity");
            subEntryEntity.clear();
        }
        taskEntryEntity.clear();
        if (schemeId > 0L) {
            List<DynamicObject> schemes = MultiImpSchemeHelper.getSchemeById(Stream.of(Long.valueOf(schemeId)).collect(Collectors.toList()));
            scheme = schemes.get(0);
            MultiImpSchemeHelper.createEntryByScheme(scheme, taskEntryEntity);
        }
        this.getModel().updateEntryCache(taskEntryEntity);
        this.getView().updateView("entryentity");
        return scheme;
    }

    private String getImpFileName() {
        String fileName = (String)this.getImportFileInfo().get("name");
        return StringUtils.isNotEmpty((CharSequence)fileName) && fileName.contains(".") ? fileName.substring(0, fileName.lastIndexOf(46)) : fileName;
    }

    private BizOperationResult validateImportFile(String importFileUrl) {
        BizOperationResult checkResult = new BizOperationResult(true);
        String modelInfo = (String)this.getModel().getValue("modelinfo_tag");
        if (StringUtils.isEmpty((CharSequence)modelInfo)) {
            return checkResult;
        }
        if (StringUtils.isNotEmpty((CharSequence)importFileUrl)) {
            checkResult = MultiImpAttachmentHelper.validateFileBySchemeTpl(importFileUrl, modelInfo);
        }
        return checkResult;
    }

    private Map<String, Object> getImportFileInfo() {
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("attachmentpanelap");
        List attachments = attachmentPanel.getAttachmentData();
        if (CollectionUtils.isEmpty((Collection)attachments)) {
            return new HashMap<String, Object>(0);
        }
        return (Map)attachments.get(0);
    }

    private boolean isCanceUpdateStatus(String taskStatus) {
        String oldTaskStatus = this.getStringValue("impstatus");
        boolean isCance = true;
        boolean isExcuting = MultiImpTaskStatusEnum.EXECUTING.getStatus().equals(taskStatus);
        if (!taskStatus.equals(oldTaskStatus) || isExcuting) {
            String serviceId = this.getStringValue("serviceid");
            if (StringUtil.isNotEmpty(serviceId)) {
                TaskInfo taskInfo = ImportServiceManagerHelper.getTaskInfoById(serviceId);
                String serviceStatus = taskInfo.getStatus();
                if (!StringUtils.equalsIgnoreCase((CharSequence)"RUNNING", (CharSequence)serviceStatus) && !StringUtils.equalsIgnoreCase((CharSequence)"BEGIN", (CharSequence)serviceStatus)) {
                    isCance = false;
                }
            } else if (!isExcuting) {
                isCance = false;
            }
        }
        return isCance;
    }

    static {
        entryStatusColorMap.put(MultiImpTaskEntryStatusEnum.SAVE.getStatus(), "#333333");
        entryStatusColorMap.put(MultiImpTaskEntryStatusEnum.EXECUTING.getStatus(), "#5E80EB");
        entryStatusColorMap.put(MultiImpTaskEntryStatusEnum.SUCCESS.getStatus(), "#18BC71");
        entryStatusColorMap.put(MultiImpTaskEntryStatusEnum.FAIL.getStatus(), "#FD6C6A");
        entryStatusColorMap.put(MultiImpTaskEntryStatusEnum.TERMINATE.getStatus(), "#CCCCCC");
    }
}

