/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.plugin.opplugin.datacollect;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.imsc.dmw.plugin.opplugin.datacollect.ProjectRpeportOpValidator;
import kd.imsc.dmw.utils.CommonUtils;
import kd.imsc.dmw.utils.StringUtils;

public class ProjectRpeportOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new ProjectRpeportOpValidator());
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        if (this.operateOption.containsVariable("operatetype")) {
            String operateType;
            switch (operateType = this.operateOption.getVariableValue("operatetype")) {
                case "datacanel": {
                    this.updateDataStatus("6");
                    break;
                }
                case "dataenable": {
                    this.updateDataStatus("1");
                    break;
                }
                case "dataconfirm": {
                    this.updateDataStatus("2");
                    break;
                }
                case "dataunconfirm": {
                    this.updateDataStatus("1");
                    break;
                }
                case "taskfinish": {
                    this.updateProjectStatus("2");
                    break;
                }
                case "canceltaskfinish": {
                    this.updateProjectStatus("1");
                    break;
                }
            }
        }
    }

    private void updateProjectStatus(String reportStatus) {
        List<Long> collectEntryIdList = this.getCollectResultEntryId();
        if (!CommonUtils.isNull(collectEntryIdList)) {
            long currentUserId = StringUtils.equals(reportStatus, "2") ? UserServiceHelper.getCurrentUserId() : 0L;
            Date finishDate = StringUtils.equals(reportStatus, "2") ? TimeServiceHelper.now() : null;
            StringBuilder updateSql = new StringBuilder();
            updateSql.append("UPDATE ").append("T_DMW_COLLECTRESULTENTRY").append(" SET FREPORTSTATUS='").append(reportStatus).append("', FFINISHUSERID = ").append(currentUserId).append(", FFINISHDATE = ? ").append(" WHERE FENTRYID IN ").append(CommonUtils.getSqlInStr(collectEntryIdList.size()));
            ArrayList<Comparable<Date>> list = new ArrayList<Comparable<Date>>(collectEntryIdList.size() + 1);
            list.add(finishDate);
            list.addAll(collectEntryIdList);
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>(1);
            paramsList.add(list.toArray());
            DB.executeBatch((DBRoute)DBRoute.of((String)"imsc"), (String)updateSql.toString(), paramsList);
        }
    }

    private void updateDataStatus(String dataStatus) {
        List<Long> importEntryIdList = this.getImportResultEntryId();
        if (!CommonUtils.isNull(importEntryIdList)) {
            StringBuilder updateSql = new StringBuilder();
            updateSql.append("UPDATE T_DMW_IMPORTRESULTENTRY SET FDATASTATUS=?,FCONFIRMERID=?,FCONFIRMDATE=?");
            long confirmerId = 0L;
            Date confirmDate = null;
            if ("2".equals(dataStatus)) {
                confirmerId = UserServiceHelper.getCurrentUserId();
                confirmDate = TimeServiceHelper.now();
            }
            updateSql.append(" WHERE FENTRYID IN ").append(CommonUtils.getSqlInStr(importEntryIdList.size()));
            ArrayList<Object> list = new ArrayList<Object>(importEntryIdList.size() + 3);
            list.add(dataStatus);
            list.add(confirmerId);
            list.add(confirmDate);
            list.addAll(importEntryIdList);
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>(1);
            paramsList.add(list.toArray());
            DB.executeBatch((DBRoute)DBRoute.of((String)"imsc"), (String)updateSql.toString(), paramsList);
        }
    }

    private List<Long> getCollectResultEntryId() {
        if (this.getOption().containsVariable("collectresultentryid")) {
            return (List)SerializationUtils.fromJsonString((String)this.getOption().getVariableValue("collectresultentryid"), List.class);
        }
        return new ArrayList<Long>(0);
    }

    private List<Long> getImportResultEntryId() {
        if (this.getOption().containsVariable("importresultentryid")) {
            return (List)SerializationUtils.fromJsonString((String)this.getOption().getVariableValue("importresultentryid"), List.class);
        }
        return new ArrayList<Long>(0);
    }
}

