/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.plugin.validator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imsc.dmw.helper.eas.OpValidatorHelper;
import kd.imsc.dmw.utils.CommonUtils;
import kd.imsc.dmw.utils.StringUtils;
import kd.imsc.imbd.validator.AbstractImbdValidator;

public class ConvAccountSaveValidator
extends AbstractImbdValidator {
    private final String opType;

    public ConvAccountSaveValidator() {
        this.opType = "save";
    }

    public ConvAccountSaveValidator(String opType) {
        this.opType = opType;
    }

    public Set<String> preparePropertys() {
        Set fields = super.preparePropertys();
        fields.add("id");
        fields.add("number");
        fields.add("org");
        fields.add("srcacctnum");
        fields.add("taracctnum");
        fields.add("entryentity");
        fields.add("entryentity.srcasst");
        fields.add("entryentity.tarasstval");
        fields.add("entryentity.tarasst");
        return fields;
    }

    public void validate() {
        ArrayList<Object> idList = new ArrayList<Object>(8);
        for (int i = 0; i < this.getDataEntities().length; ++i) {
            String enable;
            ExtendedDataEntity rowDataEntity = this.getDataEntities()[i];
            DynamicObject bill = rowDataEntity.getDataEntity();
            if ("save".equals(this.opType) && "0".equals(enable = bill.getString("enable"))) {
                return;
            }
            idList.add(bill.getPkValue());
            this.judgeIfEqual(rowDataEntity, new QFilter("enable", "=", (Object)"1"));
            this.judgeIfEqual(rowDataEntity, new QFilter("id", "in", idList));
            this.judgeAccDimension(rowDataEntity);
            this.judgeSrcDimension(rowDataEntity);
            this.judgeTarDimension(rowDataEntity);
            this.judgeAccountDimension(rowDataEntity);
        }
    }

    private void judgeIfEqual(ExtendedDataEntity rowDataEntity, QFilter qFilter) {
        DynamicObject bill = rowDataEntity.getDataEntity();
        DynamicObjectCollection easOrges = (DynamicObjectCollection)bill.get("org");
        Object srcId = bill.get("id");
        String srcAccNum = (String)bill.get("srcacctnum");
        HashMap<Object, String> map = new HashMap<Object, String>(8);
        StringBuilder errMsg = new StringBuilder();
        for (DynamicObject item : easOrges) {
            DynamicObject easOrg = item.getDynamicObject("fbasedataid");
            if (easOrg == null) continue;
            map.put(easOrg.getPkValue(), easOrg.getString("name"));
        }
        Map entryEntries = BusinessDataServiceHelper.loadFromCache((String)"dmw_acc_convert", (String)"id,number,org,srcacctnum", (QFilter[])new QFilter[]{qFilter}, (String)"");
        for (DynamicObject entry : entryEntries.values()) {
            String tempDocNum = entry.getString("number");
            DynamicObjectCollection tempEasOrges = entry.getDynamicObjectCollection("org");
            Object tempSrcId = entry.get("id");
            String tempSrcAccNum = entry.getString("srcacctnum");
            if (!srcAccNum.equals(tempSrcAccNum) || srcId.equals(tempSrcId)) continue;
            if (OpValidatorHelper.mulDyObjIsEmpty(tempEasOrges) && map.size() == 0) {
                String msg = ResManager.loadKDString((String)"\u8be5\u5355\u636e\u4e2d\u6e90\u79d1\u76ee\u7f16\u7801%1$s\u4e0e%2$s\u5355\u636e\u4e2d\u6570\u636e\u91cd\u590d\uff0c\u8bf7\u590d\u6838\u6570\u636e\u3002", (String)"ConvAccountMapPlugin_2", (String)"imsc-dmw-platform", (Object[])new Object[]{srcAccNum, tempDocNum});
                errMsg.append(msg).append('\n');
                continue;
            }
            if (tempEasOrges.isEmpty() || map.isEmpty()) continue;
            for (DynamicObject item : tempEasOrges) {
                Object tempEasOrgId;
                DynamicObject easOrg = item.getDynamicObject("fbasedataid");
                if (easOrg == null || !map.containsKey(tempEasOrgId = easOrg.getPkValue())) continue;
                String msg = ResManager.loadKDString((String)"\u8be5\u5355\u636e\u4e2d%1$s+\u6e90\u79d1\u76ee\u7f16\u7801%2$s\u4e0e%3$s\u5355\u636e\u4e2d\u6570\u636e\u91cd\u590d\uff0c\u8bf7\u590d\u6838\u6570\u636e\u3002", (String)"ConvAccountMapPlugin_0", (String)"imsc-dmw-platform", (Object[])new Object[]{map.get(tempEasOrgId), srcAccNum, tempDocNum});
                errMsg.append(msg).append('\n');
            }
        }
        if (errMsg.length() > 0) {
            errMsg.deleteCharAt(errMsg.length() - 1);
            this.addErrorMessage(rowDataEntity, errMsg.toString());
        }
    }

    private void judgeAccDimension(ExtendedDataEntity rowDataEntity) {
        DynamicObject bill = rowDataEntity.getDataEntity();
        DynamicObjectCollection entryEntries = bill.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entryEntries) {
            DynamicObject srcAsst = entry.getDynamicObject("srcasst");
            DynamicObject tarAsst = entry.getDynamicObject("tarasst");
            String accNum = entry.getString("tarasstval");
            if (srcAsst != null || tarAsst == null || !StringUtils.isBlank(accNum)) continue;
            String msg = ResManager.loadKDString((String)"\u5f53\u201c\u6e90\u6838\u7b97\u7ef4\u5ea6\u201d\u4e3a\u7a7a\uff0c\u201c\u76ee\u6807\u6838\u7b97\u7ef4\u5ea6\u201d\u4e0d\u4e3a\u7a7a\u65f6\uff0c\u201c\u76ee\u6807\u6838\u7b97\u7ef4\u5ea6\u503c-\u7f16\u7801\u201d\u5fc5\u5f55\u3002", (String)"ConvAccountMapPlugin_1", (String)"imsc-dmw-platform", (Object[])new Object[0]);
            this.addErrorMessage(rowDataEntity, msg);
        }
    }

    private void judgeSrcDimension(ExtendedDataEntity rowDataEntity) {
        DynamicObject bill = rowDataEntity.getDataEntity();
        DynamicObjectCollection entryEntries = bill.getDynamicObjectCollection("entryentity");
        String errMsg = OpValidatorHelper.judgeEntryDymDup(entryEntries, "srcasst", "ConvAccountMapPlugin_3", ResManager.loadKDString((String)"\u8be5\u5355\u636e\u4e2d\u6e90\u6838\u7b97\u7ef4\u5ea6\u7b2c%1$s\u884c\u4e0e\u7b2c%2$s\u884c\u91cd\u590d\uff0c\u8bf7\u590d\u6838\u6570\u636e\u3002", (String)"ConvAccountMapPlugin_3", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        if (errMsg.length() > 0) {
            this.addErrorMessage(rowDataEntity, errMsg);
        }
    }

    private void judgeTarDimension(ExtendedDataEntity rowDataEntity) {
        DynamicObject bill = rowDataEntity.getDataEntity();
        DynamicObjectCollection entryEntries = bill.getDynamicObjectCollection("entryentity");
        String errMsg = OpValidatorHelper.judgeEntryDymDup(entryEntries, "tarasst", "ConvAccountMapPlugin_4", ResManager.loadKDString((String)"\u8be5\u5355\u636e\u4e2d\u76ee\u6807\u6838\u7b97\u7ef4\u5ea6\u7b2c%1$s\u884c\u4e0e\u7b2c%2$s\u884c\u91cd\u590d\uff0c\u8bf7\u590d\u6838\u6570\u636e\u3002", (String)"ConvAccountMapPlugin_4", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        if (errMsg.length() > 0) {
            this.addErrorMessage(rowDataEntity, errMsg);
        }
    }

    private void judgeAccountDimension(ExtendedDataEntity rowDataEntity) {
        DynamicObject bill = rowDataEntity.getDataEntity();
        String tarAccNum = bill.getString("taracctnum");
        if (StringUtils.isNotBlank(tarAccNum)) {
            StringBuilder errMsg = new StringBuilder();
            QFilter qFilter = new QFilter("number", "=", (Object)tarAccNum);
            HashSet<String> originalNumList = new HashSet<String>(8);
            DynamicObjectCollection accountEntries = QueryServiceHelper.query((String)"bd_accountview", (String)"id,number,name,checkitementry,checkitementry.asstactitem.number,checkitementry.asstactitem.name", (QFilter[])new QFilter[]{qFilter});
            if (CommonUtils.isNull(accountEntries)) {
                return;
            }
            for (DynamicObject entry : accountEntries) {
                String tempNum;
                if (entry == null || (tempNum = entry.getString("checkitementry.asstactitem.number")) == null) continue;
                originalNumList.add(tempNum);
            }
            DynamicObjectCollection entryEntries = bill.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryEntries) {
                DynamicObject tarDimension;
                if (entry == null || (tarDimension = entry.getDynamicObject("tarasst")) == null) continue;
                String fillNum = tarDimension.getString("number");
                String fillName = tarDimension.getString("name");
                if (originalNumList.contains(fillNum)) continue;
                String msg = ResManager.loadKDString((String)"\u8be5\u5355\u636e\u4e2d\u76ee\u6807\u79d1\u76ee\u7684\u6838\u7b97\u7ef4\u5ea6\u65e0%s\u6838\u7b97\u7ef4\u5ea6\uff0c\u8bf7\u590d\u6838\u6570\u636e\u3002", (String)"ConvAccountMapPlugin_5", (String)"imsc-dmw-platform", (Object[])new Object[]{fillName});
                errMsg.append(msg).append('\n');
            }
            if (errMsg.length() > 0) {
                errMsg.deleteCharAt(errMsg.length() - 1);
                this.addErrorMessage(rowDataEntity, errMsg.toString());
            }
        }
    }
}

