/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.plugin.validator;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.imsc.imbd.validator.AbstractImbdValidator;

public class ConvGeneralSaveValidator
extends AbstractImbdValidator {
    private final String opType;

    public ConvGeneralSaveValidator() {
        this.opType = "save";
    }

    public ConvGeneralSaveValidator(String opType) {
        this.opType = opType;
    }

    public Set<String> preparePropertys() {
        Set fields = super.preparePropertys();
        fields.add("entryentity");
        fields.add("org");
        fields.add("entryentity.srcnum");
        return fields;
    }

    public void validate() {
        for (ExtendedDataEntity rowDataEntity : this.getDataEntities()) {
            String enable;
            DynamicObject bill = rowDataEntity.getDataEntity();
            if ("save".equals(this.opType) && "0".equals(enable = bill.getString("enable"))) continue;
            this.judgeEntryRowDup(rowDataEntity);
        }
    }

    private void judgeEntryRowDup(ExtendedDataEntity rowDataEntity) {
        DynamicObject bill = rowDataEntity.getDataEntity();
        DynamicObjectCollection entryEntries = bill.getDynamicObjectCollection("entryentity");
        HashMap<String, Integer> numRowMap = new HashMap<String, Integer>(8);
        for (int i = 0; i < entryEntries.size(); ++i) {
            DynamicObject entry = (DynamicObject)entryEntries.get(i);
            String number = entry.getString("srcnum");
            if (numRowMap.containsKey(number)) {
                this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u8be5\u5355\u636e\u4e2d\u6e90\u5bf9\u8c61\u7f16\u7801\u7b2c%1$s\u884c\u4e0e\u7b2c%2$s\u884c\u6570\u636e\u91cd\u590d\uff0c\u8bf7\u590d\u6838\u6570\u636e\u3002", (String)"ConvGeneralMapPlugin_0", (String)"imsc-dmw-platform", (Object[])new Object[]{(Integer)numRowMap.get(number) + 1, String.valueOf(i + 1)}));
                continue;
            }
            numRowMap.put(number, i);
        }
    }

    private Map<Object, String> getEasOrges(DynamicObjectCollection easOrges) {
        HashMap<Object, String> orgMap = new HashMap<Object, String>(8);
        for (DynamicObject item : easOrges) {
            DynamicObject easOrg = item.getDynamicObject("fbasedataid");
            if (easOrg == null) continue;
            orgMap.put(easOrg.getPkValue(), easOrg.getString("name"));
        }
        return orgMap;
    }
}

