/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.plugin.validator;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.util.CollectionUtils;
import kd.imsc.imbd.validator.AbstractImbdValidator;

public class DmwSchemeEasValidator
extends AbstractImbdValidator {
    public Set<String> preparePropertys() {
        Set fields = super.preparePropertys();
        fields.add("treeentryentity");
        fields.add("treeentryentity.migrateobject");
        return fields;
    }

    public void validate() {
        for (ExtendedDataEntity rowDataEntity : this.getDataEntities()) {
            this.checkMigrateObjEntry(rowDataEntity);
        }
    }

    private void checkMigrateObjEntry(ExtendedDataEntity rowDataEntity) {
        DynamicObject bill = rowDataEntity.getDataEntity();
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection("treeentryentity");
        if (CollectionUtils.isEmpty((Collection)entrys)) {
            this.tipMessage(rowDataEntity);
            return;
        }
        List migObj = entrys.stream().filter(n -> n.getDynamicObject("migrateobject") != null).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(migObj)) {
            this.tipMessage(rowDataEntity);
            return;
        }
    }

    private void tipMessage(ExtendedDataEntity rowDataEntity) {
        String msg = ResManager.loadKDString((String)"\u4e00\u4e2a\u65b9\u6848\u5fc5\u987b\u6709\u81f3\u5c11\u4e00\u4e2a\u8fc1\u79fb\u5bf9\u8c61\u3002", (String)"DmwSchemeEasValidator_0", (String)"imsc-dmw-platform", (Object[])new Object[0]);
        this.addMessage(rowDataEntity, msg);
    }
}

