/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.plugin.validator;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ObjectConverter;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.util.StringUtils;
import kd.imsc.dmw.engine.multiimport.helper.MultiImpTaskHelper;
import kd.imsc.dmw.engine.multiimport.model.BizOperationResult;
import kd.imsc.dmw.enums.MultiImpTaskStatusEnum;
import kd.imsc.dmw.helper.MultiImpAttachmentHelper;

public class MultiImpTaskExecuteValidator
extends AbstractValidator {
    public void validate() {
        this.validateImportData();
    }

    private void validateImportData() {
        ExtendedDataEntity[] dataEntities;
        Map execData = MultiImpTaskHelper.deserializeOpCacheValue(this.getOption(), "cache_task_exec_data", Map.class);
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            BizOperationResult checkResult;
            DynamicObject opData = dataEntity.getDataEntity();
            if (opData == null) continue;
            String pkValue = opData.getString("id");
            if (StringUtils.isEmpty((String)pkValue) || execData == null || !execData.containsKey(pkValue)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u6709\u6548\u7684\u6267\u884c\u6570\u636e\uff0c\u8bf7\u5148\u4fdd\u5b58\u4efb\u52a1\u3002", (String)"MultiImpTaskExecuteValidator_0", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                continue;
            }
            long taskId = (Long)ObjectConverter.convert((Object)pkValue, Long.class, (boolean)false);
            String importFileUrl = MultiImpTaskHelper.getImportFileUrl(taskId);
            String modelInfo = opData.getString("modelinfo_tag");
            if (StringUtils.isEmpty((String)importFileUrl)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u6709\u6548\u7684\u5bfc\u5165\u6587\u4ef6\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5df2\u4e0a\u4f20\u3002\u82e5\u5df2\u4e0a\u4f20\uff0c\u8bf7\u4fdd\u5b58\u540e\u91cd\u8bd5\u3002", (String)"MultiImpTaskExecuteValidator_1", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                continue;
            }
            if (!MultiImpTaskStatusEnum.SAVE.getStatus().equals(opData.getString("impstatus")) || (checkResult = MultiImpAttachmentHelper.validateFileBySchemeTpl(importFileUrl, modelInfo)).getSuccess()) continue;
            this.addErrorMessage(dataEntity, checkResult.getErrorDesc());
        }
    }
}

