/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.plugin.validator;

import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;

public class SchemeOperateAuthValidator
extends AbstractValidator {
    public Set<String> preparePropertys() {
        Set set = super.preparePropertys();
        set.add("creator");
        return set;
    }

    public void validate() {
        this.checkAuth();
    }

    private void checkAuth() {
        if (ObjectUtils.isEmpty((Object[])this.dataEntities)) {
            return;
        }
        long currUserId = RequestContext.get().getCurrUserId();
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            long creatorId = dynamicObject.getLong("creator.id");
            if (creatorId == 0L) {
                creatorId = dynamicObject.getLong("creator");
            }
            if (currUserId == creatorId) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u767b\u5f55\u8d26\u6237\u65e0\u6743\u64cd\u4f5c\u6b64\u6570\u636e\u3002", (String)"SchemeOperateAuthValidator_1", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        }
    }
}

