/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.utils;

import com.grapecity.documents.excel.IWorksheet;
import com.grapecity.documents.excel.OpenFileFormat;
import com.grapecity.documents.excel.SaveFileFormat;
import com.grapecity.documents.excel.Workbook;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.encrypt.EncrypterFactory;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.IFormView;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.imsc.dmw.errorcode.DmwBizException;

public class CommonUtils {
    private static final Log logger = LogFactory.getLog(CommonUtils.class);

    private CommonUtils() {
    }

    public static String getSqlInStr(int size) {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append(" (");
        for (int i = 0; i < size; ++i) {
            if (i == size - 1) {
                strBuilder.append("?)");
                continue;
            }
            strBuilder.append("?,");
        }
        return strBuilder.toString();
    }

    public static boolean getBooleanCustomParamValue(IFormView formView, String key) {
        Object obj = CommonUtils.getCustomParamValue(formView, key);
        if (obj instanceof Boolean) {
            return Boolean.parseBoolean(obj.toString());
        }
        return false;
    }

    public static long getLongCustomParamValue(IFormView formView, String key) {
        Object obj = CommonUtils.getCustomParamValue(formView, key);
        if (CommonUtils.isNull(obj)) {
            return 0L;
        }
        return Long.parseLong(obj.toString());
    }

    public static String getStringCustomParamValue(IFormView formView, String key) {
        Object obj = CommonUtils.getCustomParamValue(formView, key);
        if (CommonUtils.isNull(obj)) {
            return "";
        }
        return obj.toString();
    }

    public static Object getCustomParamValue(IFormView formView, String key) {
        Map customParams = formView.getFormShowParameter().getCustomParams();
        if (CommonUtils.isNull(customParams) || !customParams.containsKey(key)) {
            return null;
        }
        return customParams.get(key);
    }

    public static OperateOption getMutexOperateOption(boolean strictValidation) {
        OperateOption saveOption = OperateOption.create();
        saveOption.setVariableValue("ignorewarn", String.valueOf(true));
        saveOption.setVariableValue("ignoreinteraction", String.valueOf(true));
        saveOption.setVariableValue("strictvalidation", String.valueOf(strictValidation));
        saveOption.setVariableValue("ignoreValidation", String.valueOf(false));
        saveOption.setVariableValue("ishasright", String.valueOf(true));
        saveOption.setVariableValue("WF", "false");
        return saveOption;
    }

    public static OperateOption getOperateOption(boolean strictValidation) {
        OperateOption saveOption = OperateOption.create();
        saveOption.setVariableValue("ignorewarn", String.valueOf(true));
        saveOption.setVariableValue("ignoreinteraction", String.valueOf(true));
        saveOption.setVariableValue("strictvalidation", String.valueOf(strictValidation));
        saveOption.setVariableValue("ignoreValidation", String.valueOf(true));
        saveOption.setVariableValue("ishasright", String.valueOf(true));
        saveOption.setVariableValue("WF", "false");
        return saveOption;
    }

    public static String getErrDetail(OperationResult optResult) {
        StringBuilder errDetail = new StringBuilder();
        if (!CommonUtils.isNull(optResult.getMessage())) {
            errDetail.append(optResult.getMessage());
        }
        for (IOperateInfo errInfo : optResult.getAllErrorOrValidateInfo()) {
            if (CommonUtils.isNull(errInfo.getMessage())) continue;
            errDetail.append(errInfo.getMessage());
        }
        return errDetail.toString();
    }

    public static List<DynamicObject> getOperateSuccessDynObjList(OperationResult operationResult, OperationResult optResult, List<DynamicObject> billDynObjList) {
        if (CommonUtils.isNull(billDynObjList) || optResult == null) {
            return billDynObjList;
        }
        operationResult.mergeOperateResult(optResult);
        List faileBillIdList = optResult.getAllErrorOrValidateInfo().stream().map(IOperateInfo::getPkValue).collect(Collectors.toList());
        return billDynObjList.stream().filter(obj -> !faileBillIdList.contains(obj.getPkValue())).collect(Collectors.toList());
    }

    public static boolean isNull(Object o) {
        return o == null || o instanceof String && ((String)o).length() == 0 || o instanceof StringBuffer && ((StringBuffer)o).length() == 0 || o instanceof List && ((List)o).isEmpty() || o instanceof Collection && ((Collection)o).isEmpty() || o instanceof Object[] && ((Object[])o).length == 0 || o instanceof int[] && ((int[])o).length == 0 || o instanceof Map && ((Map)o).size() == 0 || o instanceof DynamicObjectCollection && ((DynamicObjectCollection)o).isEmpty() || o instanceof DynamicObject[] && ((DynamicObject[])o).length == 0;
    }

    public static MulBasedataDynamicObjectCollection createAttachmentField(DynamicObjectType dynamicObjectType, long fbasedataId) {
        MulBasedataDynamicObjectCollection fileList = new MulBasedataDynamicObjectCollection();
        DynamicObject dyFile = new DynamicObject(dynamicObjectType);
        dyFile.set("FPKID", (Object)ID.genLongId());
        dyFile.set("fbasedataid", (Object)fbasedataId);
        dyFile.set("fbasedataid_id", (Object)fbasedataId);
        fileList.add(dyFile);
        return fileList;
    }

    public static List<String> buildOperationResultMessage(OperationResult result, DynamicObject[] dataEntitys) {
        ArrayList<String> opMessages;
        block5: {
            opMessages = new ArrayList<String>(0);
            if (result == null || dataEntitys == null || dataEntitys.length <= 0) break block5;
            int batchSize = dataEntitys.length;
            opMessages = new ArrayList(batchSize);
            List successPkIds = result.getSuccessPkIds();
            if (!result.isSuccess() || successPkIds.size() < batchSize) {
                for (DynamicObject dataEntity : dataEntitys) {
                    if (successPkIds.contains(dataEntity.getPkValue())) {
                        opMessages.add("");
                        continue;
                    }
                    opMessages.add(CommonUtils.buildOperationResultMessage(result, dataEntity));
                }
            } else {
                for (int i = 0; i < batchSize; ++i) {
                    opMessages.add("");
                }
            }
        }
        return opMessages;
    }

    public static String buildOperationResultMessage(OperationResult result, DynamicObject entity) {
        return CommonUtils.buildOperationResultMessage(result, entity.getPkValue());
    }

    public static String buildOperationResultMessage(OperationResult result, Object pkValue) {
        ArrayList<String> errorMessages = null;
        if (result != null && pkValue != null) {
            errorMessages = new ArrayList<String>(5);
            int seq = 1;
            for (IOperateInfo operateInfo : result.getAllErrorOrValidateInfo()) {
                if (operateInfo.getPkValue() != null && !operateInfo.getPkValue().equals(pkValue)) continue;
                errorMessages.add(seq++ + ". " + operateInfo.getMessage());
            }
            if (CollectionUtils.isEmpty(errorMessages)) {
                errorMessages.add(result.getMessage());
            }
        }
        return errorMessages == null ? null : String.join((CharSequence)";", errorMessages);
    }

    public static void downPdfFile(List<Map<String, Object>> value, IFormView view) {
        if (CollectionUtils.isEmpty(value)) {
            return;
        }
        for (Map<String, Object> valuemap : value) {
            String filename = (String)valuemap.get("name");
            String type = "\\." + (String)valuemap.get("type");
            filename = filename.split(type)[0];
            String relativeUrl = (String)valuemap.get("relativeUrl");
            try {
                ByteArrayOutputStream outputStream2 = new ByteArrayOutputStream();
                FileServiceFactory.getAttachmentFileService().download(relativeUrl, (OutputStream)outputStream2, null);
                ByteArrayInputStream stream = new ByteArrayInputStream(outputStream2.toByteArray());
                Workbook workbook = CommonUtils.getWorkbook();
                workbook.setEnableCalculation(false);
                workbook.open((InputStream)stream, OpenFileFormat.Xlsx);
                IWorksheet iWorksheet = workbook.getWorksheets().get(0);
                iWorksheet.getUsedRange().setShrinkToFit(true);
                iWorksheet.getPageSetup().setIsPercentScale(false);
                iWorksheet.getPageSetup().setFitToPagesTall(1);
                iWorksheet.getPageSetup().setFitToPagesWide(1);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                workbook.save((OutputStream)out, SaveFileFormat.Pdf);
                TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
                String dowmPdfUrl = cache.saveAsUrl(filename + ".pdf", out.toByteArray(), 5000);
                view.download(dowmPdfUrl);
            }
            catch (Exception e) {
                String msg = ResManager.loadKDString((String)"\u8be5\u5355\u636e\u65e0\u62a5\u8868\u9644\u4ef6\u3002", (String)"CommonUtils_0", (String)"imsc-dmw-platform", (Object[])new Object[0]);
                logger.error(msg, (Throwable)e);
                throw new DmwBizException(msg, (Throwable)e);
            }
        }
    }

    private static Workbook getWorkbook() {
        CommonUtils.SetLicenseKey(false);
        return new Workbook();
    }

    private static void SetLicenseKey(boolean isDev) {
        if (isDev) {
            String dev_license = "F1ZDDh96rNsdBmzbFxlPNeOQWfCdpQTgUOSe7jO8uEuQYW0lQhbzhCOtwQkcWn3me07oqOKaBOhwFEmU9FYxoPZZor/CxKWxPV3/QNa0Pj4VLZbIXvCMrRF57ICt5wPnuf/dHCQo/h/P2XHXb1xyTkmgtMy2wznPJ8WAdn6LA7NRlgpQ5i+Pxw5XFlwFigoPeqT/XCWW06j/EZavFu+bSeVx+bApXKas7wLShOVu+eDq5hG8KOHTzOBkYrTli2G23+YUDqE1CDRVBN13+K1NkY39fDXdpQPecD6HJZSecR6WQXco5n9SrnOl7OuyZTT+pi16InIv+3wqJVWY761xPC/lKlh8/QaTSDiadIha+GAhphb3fXRONDvM9g4WgLi1LriNEtIvApweEBS3vo84+ZJmOuthe03018U7FSDRLHcjrloUgqLjNIuqO3ZpB+WA3g/+LDlZx3mm58Xzm65HSPtk8mPUO3pZQJMzMcax5kVenULAlQZdv3WQQG0yLlwxXcUOHzZNp4r1ww1Xq8D2dg==";
            dev_license = EncrypterFactory.getAesEncrypter().decrypt(dev_license);
            Workbook.SetLicenseKey((String)dev_license);
        } else {
            String deploy_licensestr = "s6cb0lCuZwk4iemdyhz8K2FmyuoET9bAKjVWA8ucCYP+F7fpMK2cJoJHhCBYKoOGNuAoi0dVgzqINPsx82101M9Fft0HYL4uAeHbGcRo5XhwsiIMnMSuxo/cxVRVjJjx1zk6P68bCsfx+xxt26pqAzx72fc5R27YiHI8aHKjr6VZm1LE2cXplf0z2kq43RO+trfciq2XSnPfdCf33L9fND0hR3emHl9pCzifW8HswSz/IPclS7VZ2isZYDOimjuvdkGEgWD2IiIdzp6pASvLcU8jSb9m1rMyzq+RpZLRKySq5qROU725Ia6PWqJP22lW/sFSULKKqzw7pKwCqowYVAizgKubc+R6ZivvcJZSLtL1LqyBO0KUf4Cf/bKkQ/30BR/PB/EAm0xoA4TjNMg02vetxvbAxMAtf/6fJ+rlDsOdq1LDrFwdwqLDVihY2AYJR2wOqy8dpJvORl8JQmePn4EyiOy2pAjqf39Bmlb2a5xo4Vmv/2Nrq/hHzUq5kLM0";
            deploy_licensestr = EncrypterFactory.getAesEncrypter().decrypt(deploy_licensestr);
            Workbook.SetLicenseKey((String)deploy_licensestr);
        }
    }
}

