/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.utils;

import kd.bos.dataentity.resource.ResManager;
import kd.bos.isc.util.except.IscBizException;
import kd.imsc.dmw.errorcode.DmwBizException;
import kd.imsc.dmw.utils.StringUtils;

public class DbUtil {
    public static final String FROM_FIELD = "FROM";
    public static final String SELECT_FIELD = "SELECT";
    public static final String WHERE_FIELD = "WHERE";

    public static String changeCountSql(String sql) {
        int i = DbUtil.findSelect(sql);
        int j = DbUtil.findFrom(sql);
        String countSql = sql.substring(i - 6, i) + " COUNT(1) as c " + sql.substring(j - FROM_FIELD.length());
        return countSql;
    }

    public static String changePageSql(String sql, int pageSize, Object pageStartValue, String pageField) {
        int i = DbUtil.findSelect(sql);
        int w = DbUtil.findWhere(sql);
        int k = DbUtil.findOrderyBy(sql);
        String whereFilter = " " + pageField + " > '" + pageStartValue + "' ";
        if (pageStartValue == null) {
            String pageSql = DbUtil.pageStartValIsNull(sql, pageSize, pageField, i, k);
            return pageSql;
        }
        String pageSql = w > 0 ? DbUtil.hasWhereDeal(sql, pageSize, pageField, i, w, k, whereFilter + "and") : DbUtil.notWhereDeal(sql, pageSize, pageField, i, k, whereFilter);
        return pageSql;
    }

    private static String notWhereDeal(String sql, int pageSize, String pageField, int i, int k, String whereFilter) {
        String pageSql = k < 0 ? sql.substring(i - 6, i) + " top " + pageSize + " " + sql.substring(i) + " where" + whereFilter + " order by " + pageField : sql.substring(i - 6, i) + " top " + pageSize + " " + sql.substring(i, k - 5) + " where" + whereFilter + sql.substring(k - 5) + pageField + ", " + sql.substring(k);
        return pageSql;
    }

    private static String hasWhereDeal(String sql, int pageSize, String pageField, int i, int w, int k, String whereFilter) {
        String pageSql = k < 0 ? sql.substring(i - 6, i) + " top " + pageSize + " " + sql.substring(i, w) + whereFilter + sql.substring(w) + " order by " + pageField : sql.substring(i - 6, i) + " top " + pageSize + " " + sql.substring(i, w) + whereFilter + sql.substring(w, k) + pageField + ", " + sql.substring(k);
        return pageSql;
    }

    private static String pageStartValIsNull(String sql, int pageSize, String pageField, int i, int k) {
        String pageSql = k < 0 ? sql.substring(i - 6, i) + " top " + pageSize + " " + sql.substring(i) + " order by " + pageField : sql.substring(i - 6, i) + " top " + pageSize + " " + sql.substring(i, k) + " " + pageField + "," + sql.substring(k);
        return pageSql;
    }

    private static int findSelect(String sql) {
        int index = DbUtil.findMinIndex(sql, "SELECT ", 0);
        if (index < 0) {
            String errMsg = ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230SELECT\u5173\u952e\u5b57. sql=", (String)"DbUtil_0", (String)"imsc-dmw-platform", (Object[])new Object[0]);
            throw new IscBizException(errMsg + sql);
        }
        return index + SELECT_FIELD.length();
    }

    private static int findOrderyBy(String sql) {
        return DbUtil.findMinIndex(sql, "ORDER BY ", 0);
    }

    public static int findFrom(String sql) {
        int i = DbUtil.findFrom0(sql, 0);
        while (sql.charAt(i - 1) > ' ') {
            i = DbUtil.findFrom0(sql, i + 1);
        }
        return i + FROM_FIELD.length();
    }

    public static int findWhere(String sql) {
        int i = DbUtil.findWhere0(sql, 0);
        if (i < 0) {
            return i;
        }
        while (sql.charAt(i - 1) > ' ') {
            i = DbUtil.findWhere0(sql, i + 1);
        }
        return i + WHERE_FIELD.length();
    }

    public static int findMinIndex(String sql, String key, int start) {
        int i = sql.indexOf(key.toUpperCase(), start) & 0xFFFF;
        int j = sql.indexOf(key.toLowerCase(), start) & 0xFFFF;
        if (i == 65535 && j == 65535) {
            return -1;
        }
        return Math.min(i, j);
    }

    private static int findFrom0(String sql, int start) {
        int j = DbUtil.findMinIndex(sql, "FROM ", start);
        if (j < 0) {
            String errMsg = ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230FROM\u5173\u952e\u5b57. sql=", (String)"DbUtil_1", (String)"imsc-dmw-platform", (Object[])new Object[0]);
            throw new DmwBizException(errMsg + sql);
        }
        return j;
    }

    private static int findWhere0(String sql, int start) {
        return DbUtil.findMinIndex(sql, "WHERE ", start);
    }

    public static String buildPaginationSql(String sql) {
        String lowerCase = sql.toLowerCase();
        int selectIndex = lowerCase.indexOf("select");
        StringBuilder sqlBuild = new StringBuilder(sql);
        sqlBuild.insert(selectIndex + 6, " top 1000");
        int whereIndex = lowerCase.indexOf(" where");
        if (whereIndex == -1) {
            sqlBuild.insert(sqlBuild.length(), " where a.FID >%s order by a.fid");
        } else {
            sqlBuild.insert(sqlBuild.length(), " and a.FID >%s order by a.fid");
        }
        return sqlBuild.toString();
    }

    public static String buildCountSql(String sql) {
        String lowerCase = sql.toLowerCase();
        return StringUtils.replaceBetween(lowerCase, "select", " from", " count(1) as c ");
    }
}

