/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.utils;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.entity.EntryType;
import kd.bos.entity.property.TextProp;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.TextEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.metadata.form.control.EntryFieldGroupAp;
import org.apache.commons.lang3.StringUtils;

public class EntryDynamicFieldUtil {
    private static Log logger = LogFactory.getLog(EntryDynamicFieldUtil.class);

    public static EntryAp createDynamicEntryAp(List<Map<String, Object>> fields) {
        String entityId = MetadataDao.getIdByNumber((String)"dmw_userguide_eas", (MetaCategory)MetaCategory.Entity);
        EntryAp entryAp = new EntryAp();
        FormMetadata formmeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Form);
        EntityMetadata entitymeta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        formmeta.bindEntityMetadata(entitymeta);
        for (ControlAp ap : formmeta.getItems()) {
            if (!StringUtils.equals((CharSequence)ap.getKey(), (CharSequence)"entryentity")) continue;
            entryAp = (EntryAp)ap;
            break;
        }
        LinkedHashMap<String, EntryFieldGroupAp> groupApMap = new LinkedHashMap<String, EntryFieldGroupAp>(16);
        for (Map<String, Object> map : fields) {
            String groupFieldKey = (String)map.get("groupFieldKey");
            String groupFieldName = (String)map.get("groupFieldName");
            EntryFieldGroupAp entryFieldGroupAp = (EntryFieldGroupAp)groupApMap.get(groupFieldKey);
            if (entryFieldGroupAp == null && StringUtils.isNotEmpty((CharSequence)groupFieldKey)) {
                entryFieldGroupAp = EntryDynamicFieldUtil.createGroupField(groupFieldKey, groupFieldName);
                groupApMap.put(groupFieldKey, entryFieldGroupAp);
            }
            EntryFieldAp fieldAp = new EntryFieldAp();
            fieldAp.setLock("new,edit,submit,audit");
            fieldAp.setId((String)map.get("fieldKey"));
            fieldAp.setKey((String)map.get("fieldKey"));
            fieldAp.setName(new LocaleString((String)map.get("fieldCaption")));
            fieldAp.setFireUpdEvt(true);
            fieldAp.setParentId(entryAp.getId());
            TextField textField = new TextField();
            textField.setId((String)map.get("fieldKey"));
            textField.setKey((String)map.get("fieldKey"));
            fieldAp.setField((Field)textField);
            fieldAp.createControl();
            if (entryFieldGroupAp == null) {
                entryAp.getItems().add(fieldAp);
                continue;
            }
            entryFieldGroupAp.getItems().add(fieldAp);
        }
        for (Map.Entry entry : groupApMap.entrySet()) {
            if (entry.getValue() == null) continue;
            entryAp.getItems().add(entry.getValue());
        }
        return entryAp;
    }

    public static void registDynamicProps(EntryType entryType, List<Map<String, Object>> fields) {
        for (Map<String, Object> field : fields) {
            TextProp textProp = new TextProp();
            textProp.setName((String)field.get("fieldKey"));
            textProp.setDisplayName(new LocaleString((String)field.get("fieldCaption")));
            textProp.setDbIgnore(true);
            textProp.setAlias("");
            entryType.registerSimpleProperty((DynamicSimpleProperty)textProp);
        }
    }

    private static EntryFieldGroupAp createGroupField(String key, String value) {
        EntryFieldGroupAp supplierFieldGroupAp = new EntryFieldGroupAp();
        supplierFieldGroupAp.setId(key);
        supplierFieldGroupAp.setKey(key);
        supplierFieldGroupAp.setName(new LocaleString(value));
        return supplierFieldGroupAp;
    }

    public static void buildFieldEdit(String entryKey, Map<String, Object> field, OnGetControlArgs e, IFormView formView) {
        String fieldName = (String)field.get("fieldKey");
        if (!e.getKey().equals(fieldName)) {
            return;
        }
        Map allFields = formView.getModel().getDataEntityType().getAllFields();
        IDataEntityProperty property = (IDataEntityProperty)allFields.get(fieldName);
        if (property == null || StringUtils.isEmpty((CharSequence)property.getAlias())) {
            return;
        }
        TextEdit textEdit = new TextEdit();
        textEdit.setKey(e.getKey());
        textEdit.setEntryKey(entryKey);
        textEdit.setView(formView);
        e.setControl((Control)textEdit);
    }
}

