/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.utils;

import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Button;
import kd.bos.form.control.Label;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.imsc.dmw.utils.StringUtils;

public class FormUtil {
    public static void addF7Listener(BeforeF7SelectListener form, String ... f7Name) {
        if (!(form instanceof AbstractFormPlugin)) {
            String msg = ResManager.loadKDString((String)"%s\u63d2\u4ef6\u4e0d\u662fkd.bos.form.plugin.AbstractFormPlugin\u5b50\u7c7b\uff0c\u4e0d\u80fd\u4f7f\u7528FormUtils.addF7Listener", (String)"FormUtil_0", (String)"imsc-dmw-platform", (Object[])new Object[]{form.getClass().getSimpleName()});
            throw new KDBizException(msg);
        }
        AbstractFormPlugin localForm = (AbstractFormPlugin)form;
        int len = f7Name.length;
        for (int i = 0; i < len; ++i) {
            BasedataEdit f7 = (BasedataEdit)localForm.getControl(f7Name[i]);
            if (f7 == null) continue;
            f7.addBeforeF7SelectListener(form);
        }
    }

    public static void updateView(IFormView view, String ... fields) {
        for (String field : fields) {
            view.updateView(field);
        }
    }

    public static void setLabValue(IFormView view, String labKey, String value) {
        Label labelnum = (Label)view.getControl(labKey);
        labelnum.setText(value);
    }

    public static void setButtonValueAndUrl(IFormView view, String key, String value, String url) {
        Button checkStatus = (Button)view.getControl(key);
        checkStatus.setUrl(url);
        HashMap<String, LocaleString> map = new HashMap<String, LocaleString>(4);
        map.put("text", new LocaleString(value));
        view.updateControlMetadata(key, map);
    }

    public static void setLabelStyle(IFormView view, String key, String value, String bgColor, String fgColor) {
        Label label = (Label)view.getControl(key);
        label.setText(value);
        HashMap<String, String> map = new HashMap<String, String>(4);
        map.put("bc", bgColor);
        map.put("fc", fgColor);
        view.updateControlMetadata(key, map);
    }

    public static void openF7Page(AbstractFormPlugin form, String entityName, String formId, String callBackName, List<Object> selectedIds, boolean isMultiSelect) {
        ListShowParameter parameter = new ListShowParameter();
        ListSelectedRowCollection rows = new ListSelectedRowCollection();
        for (Object selectedId : selectedIds) {
            if (selectedId == null || selectedId.equals(0L)) continue;
            if (selectedId instanceof String) {
                if (!StringUtils.isNotEmpty((String)selectedId)) continue;
                rows.add((Object)new ListSelectedRow((Object)Long.valueOf((String)selectedId)));
                continue;
            }
            rows.add((Object)new ListSelectedRow(selectedId));
        }
        parameter.setListSelectedRowCollection(rows);
        parameter.setBillFormId(entityName);
        parameter.setLookUp(true);
        parameter.setFormId(formId);
        parameter.setMultiSelect(isMultiSelect);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)form, callBackName));
        StyleCss inlineStyleCss = new StyleCss();
        inlineStyleCss.setHeight("550");
        inlineStyleCss.setWidth("1000");
        parameter.getOpenStyle().setInlineStyleCss(inlineStyleCss);
        form.getView().showForm((FormShowParameter)parameter);
    }
}

