/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipInputStream;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import org.apache.commons.codec.digest.DigestUtils;

public final class ImptFileUtils {
    public static final String SHA_256 = "SHA-256";
    private static final Set<String> FILE_SUFFIX = new HashSet<String>(12);

    private ImptFileUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static final String getFileNameWithOutExtension(String fileName) {
        if (kd.bos.util.StringUtils.isEmpty((String)fileName)) {
            return "";
        }
        if (fileName.indexOf(46) == -1) {
            return fileName;
        }
        return fileName.substring(0, fileName.lastIndexOf(46));
    }

    public static boolean isFileExistWithFilePath(String filePath) {
        if (kd.bos.util.StringUtils.isEmpty((String)filePath)) {
            return false;
        }
        File file = new File(filePath);
        return file.exists();
    }

    public static boolean isFileZipFormatWithFileName(String fileName) {
        if (kd.bos.util.StringUtils.isEmpty((String)fileName)) {
            return false;
        }
        return fileName.endsWith(".zip") || fileName.endsWith(".ZIP");
    }

    public static File createTempDir(String dir) throws IOException {
        return Files.createTempDirectory(dir, new FileAttribute[0]).toFile();
    }

    public static File createTempFile(String dir, String fileName, String fileFormat) throws IOException {
        return Files.createTempFile(ImptFileUtils.createTempDir(dir).toPath(), fileName, fileFormat, new FileAttribute[0]).toFile();
    }

    public static File createTempFile(File dir, String fileName, String fileFormat) throws IOException {
        return Files.createTempFile(dir.toPath(), fileName, fileFormat, new FileAttribute[0]).toFile();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getFileMd5(File file) {
        if (!file.exists()) {
            return "";
        }
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            String string = DigestUtils.md5Hex((InputStream)fileInputStream);
            return string;
        }
        catch (IOException iOException) {
            return "";
        }
    }

    public static String getInputMd5(byte[] contentBytes) {
        if (contentBytes == null) {
            return "";
        }
        return DigestUtils.md5Hex((byte[])contentBytes);
    }

    public static String checkUrl(String url) {
        if (!StringUtils.isEmpty((CharSequence)url) && url.contains("path=")) {
            url = url.split("path=")[1];
        }
        return url;
    }

    public static String getExceptionDetailInfo(Throwable exception) {
        String retMsg;
        if (exception == null) {
            return "exception is null";
        }
        try (StringWriter sw = new StringWriter();
             PrintWriter pw = new PrintWriter(sw);){
            exception.printStackTrace(pw);
            pw.flush();
            sw.flush();
            retMsg = sw.toString();
        }
        catch (IOException e) {
            String msgTpl = ResManager.loadKDString((String)"exception \u89e3\u6790\u5931\u8d25\uff01%s", (String)"ImptFileUtils_0", (String)"imsc-dmw-platform", (Object[])new Object[0]);
            retMsg = String.format(msgTpl, e.getMessage());
        }
        return retMsg;
    }

    public static int getDynamicSleepSecond(int beginSecond, int maxSecond) {
        if (beginSecond >= maxSecond) {
            return maxSecond;
        }
        return beginSecond * 13 / 10;
    }

    public static byte[] getZipFileContent(ZipInputStream zipIn) throws IOException {
        if (zipIn == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        int len = 0;
        while ((len = zipIn.read(buffer)) > 0) {
            out.write(buffer, 0, len);
        }
        return out.toByteArray();
    }

    public static File createFile(String path) {
        ImptFileUtils.checkFilePath(path);
        ImptFileUtils.checkFileType(path);
        return new File(path);
    }

    private static void checkFilePath(String filePath) {
        if (filePath.indexOf(37) >= 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u8def\u5f84\u4e2d\u7981\u6b62\u5305\u542b%", (String)"ImptFileUtils_1", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        }
        if (filePath.contains("/../") || filePath.contains("\\..\\")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u8def\u5f84\u4e2d\u7981\u6b62\u5305\u542b\u53cc\u5c0f\u6570\u70b9\u3002", (String)"ImptFileUtils_2", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        }
    }

    private static void checkFileType(String path) {
        int i = path.lastIndexOf(46);
        if (i < 0) {
            return;
        }
        String suffix = path.substring(i + 1);
        if (!FILE_SUFFIX.contains(suffix.toLowerCase())) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u7c7b\u578b\uff1a%s", (String)"ImptFileUtils_3", (String)"imsc-dmw-platform", (Object[])new Object[0]), suffix));
        }
    }

    static {
        FILE_SUFFIX.add("zip");
        FILE_SUFFIX.add("json");
        FILE_SUFFIX.add("xlsx");
        FILE_SUFFIX.add("wbx");
        FILE_SUFFIX.add("xml");
        FILE_SUFFIX.add("wb");
        FILE_SUFFIX.add("bur");
        FILE_SUFFIX.add("burx");
        FILE_SUFFIX.add("cr");
        FILE_SUFFIX.add("crx");
        FILE_SUFFIX.add("sch");
    }
}

