/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.util.StringUtils;

public class DateUtils {
    private static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";

    public static Date getThisWeekMonday() {
        Calendar cal = Calendar.getInstance();
        int dayWeek = cal.get(7);
        if (1 == dayWeek) {
            cal.add(5, -1);
        }
        cal.setFirstDayOfWeek(2);
        int day = cal.get(7);
        cal.add(5, cal.getFirstDayOfWeek() - day);
        return cal.getTime();
    }

    public static Date getThisWeekSunday() {
        Calendar cal = Calendar.getInstance();
        Date thisWeekMonday = DateUtils.getThisWeekMonday();
        cal.setTime(thisWeekMonday);
        cal.add(5, 6);
        return cal.getTime();
    }

    public static Date getLastWeekMonday() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtils.getThisWeekMonday());
        cal.add(5, -7);
        return cal.getTime();
    }

    public static Date getLastWeekSunday() {
        Calendar cal = Calendar.getInstance();
        Date thisWeekMonday = DateUtils.getLastWeekMonday();
        cal.setTime(thisWeekMonday);
        cal.add(5, 6);
        return cal.getTime();
    }

    public static Date getLastMonthFirstDay() {
        Calendar cal_1 = Calendar.getInstance();
        cal_1.add(2, -1);
        cal_1.set(5, 1);
        return cal_1.getTime();
    }

    public static Date getLastMonthEndDay() {
        Calendar cal = Calendar.getInstance();
        cal.add(2, -1);
        cal.set(5, cal.getActualMaximum(5));
        return cal.getTime();
    }

    public static Date getLastMonthEndDayByDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(2, -1);
        cal.set(5, cal.getActualMaximum(5));
        return cal.getTime();
    }

    public static Date getThisMonthFirstDay() {
        Calendar c = Calendar.getInstance();
        c.set(5, 1);
        return c.getTime();
    }

    public static Date getThisMonthEndDay() {
        Calendar ca = Calendar.getInstance();
        ca.set(5, ca.getActualMaximum(5));
        return ca.getTime();
    }

    public static Date getDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(10, 0);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date addDay(Date date, int amount) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, amount);
        return calendar.getTime();
    }

    public static Date addMonth(Date date, int month) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, month);
        return calendar.getTime();
    }

    public static Date addYear(Date date, int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(1, year);
        return calendar.getTime();
    }

    public static Date reduceOneDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(6, -1);
        return calendar.getTime();
    }

    public static Date addOneDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(6, 1);
        return calendar.getTime();
    }

    public static String getDateString(Date date) {
        String result = "";
        if (date != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            result = dateFormat.format(date);
        }
        return result;
    }

    public static Date getDayEndTime(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public static Date getDayStartTime(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static long dataReduce(Date dateOne, Date dateTwo) {
        if (dateOne == null || dateTwo == null) {
            return 0L;
        }
        long time = dateOne.getTime();
        long timeTwo = dateTwo.getTime();
        return Math.abs(time - timeTwo);
    }

    public static Date getFirstDayOfMonthByDate(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(calendar.get(1), calendar.get(2), 1, 0, 0, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getMonthEndDayByDate(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(calendar.get(1), calendar.get(2), calendar.getActualMaximum(5), 23, 59, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public static Date getDateBySpecifyValue(int year, int month, int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month - 1, day, 0, 0, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static String format(Date date, String fmt) {
        return DateUtils.format(date, fmt, null, null);
    }

    public static String format(Date date, String fmt, TimeZone timezone, Locale locale) {
        if (fmt == null) {
            fmt = YYYY_MM_DD_HH_MM_SS;
        }
        SimpleDateFormat df = locale == null ? new SimpleDateFormat(fmt) : new SimpleDateFormat(fmt, locale);
        if (timezone == null) {
            df.setTimeZone(TimeZone.getDefault());
        } else {
            df.setTimeZone(timezone);
        }
        return df.format(date);
    }

    public static Date parseDate(String dateStr) {
        Date date;
        if (StringUtils.isEmpty((String)dateStr)) {
            return null;
        }
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd");
        try {
            date = sd.parse(dateStr);
        }
        catch (ParseException e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e5\u671f\u8f6c\u6362\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\uff01", (String)"DateUtils_0", (String)"scmc-im-common", (Object[])new Object[0]));
        }
        return date;
    }

    public static String getCurrTimeFormat(String format) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format);
        return simpleDateFormat.format(TimeServiceHelper.now());
    }
}

