/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dts.replica;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.id.ID;
import kd.isc.iscb.platform.core.dts.replica.ConvertResult;
import kd.isc.iscb.platform.core.dts.replica.CurrentEntryInfo;
import kd.isc.iscb.platform.core.dts.replica.ResourceRoute;
import kd.isc.iscb.platform.core.dts.replica.RouteMapping;
import kd.isc.iscb.platform.core.util.CollectionUtils;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.Pair;

public class DefaultRoute
implements ResourceRoute {
    protected final MainEntityType _entityType;
    protected final String _entity;
    protected final Map<String, Object> _data;
    protected final Object srcId;
    protected volatile boolean changed = false;
    protected final RouteMapping route;
    protected final Map<String, Object> relyAllDataSource;
    protected CurrentEntryInfo currentEntry;
    protected List<Pair<Map<String, Object>, IDataEntityType>> noConvertEntryRow;
    private final String suffix;
    private final boolean autoSuffix;

    public DefaultRoute(String entity, Map<String, Object> data, RouteMapping route, String suffix, boolean autoSuffix) {
        this._entity = entity;
        this._entityType = EntityMetadataCache.getDataEntityType((String)entity);
        this._data = data;
        this.route = route;
        this.srcId = this.formatBillId(data.remove("id"));
        this.relyAllDataSource = new HashMap<String, Object>(16);
        this.currentEntry = new CurrentEntryInfo();
        this.noConvertEntryRow = new ArrayList<Pair<Map<String, Object>, IDataEntityType>>();
        this.suffix = suffix;
        this.autoSuffix = autoSuffix;
    }

    @Override
    public ConvertResult convert() {
        Map<String, Object> data = this.copyMap();
        this.doConvert((IDataEntityType)this._entityType, data);
        this.setBillId(data);
        this.ensureUnique(data);
        return new ConvertResult(this.changed, data);
    }

    protected Map<String, Object> copyMap() {
        HashMap<String, Object> data = new HashMap<String, Object>(this._data.size());
        data.putAll(this._data);
        return data;
    }

    protected void doConvert(IDataEntityType entityType, Map<String, Object> data) {
        for (IDataEntityProperty p : entityType.getProperties()) {
            if (p instanceof MulBasedataProp) {
                this.convertMulBaseData(data, (MulBasedataProp)p);
                continue;
            }
            if (p instanceof BasedataProp) {
                this.convertBaseData(data, (BasedataProp)p);
                continue;
            }
            if (!(p instanceof EntryProp)) continue;
            this.convertEntry(data, (EntryProp)p);
        }
        this.convertEntryId();
    }

    private void convertMulBaseData(Map<String, Object> data, MulBasedataProp p) {
        String name = p.getName();
        Object value = data.get(name);
        if (value == null) {
            return;
        }
        List list = CollectionUtils.toList((Object)value);
        ArrayList<Object> values = new ArrayList<Object>(list.size());
        String entity = p.getComplexType().getName();
        boolean isLong = p.getComplexType().getPrimaryKey() instanceof LongProp;
        for (Object v : list) {
            Object src = DefaultRoute.formatId(isLong, v);
            Object tar = this.route.getTargetValue(entity, src);
            if (tar != null) {
                this.changed = true;
                values.add(tar);
            } else {
                values.add(src);
            }
            this.recordRelyDatasourceId((IBasedataField)p, p.getBaseEntityId(), src, tar);
        }
        data.put(name, values);
    }

    private void convertBaseData(Map<String, Object> data, BasedataProp p) {
        String bdEntity;
        if (p instanceof ItemClassProp) {
            ItemClassProp itemClassProp = (ItemClassProp)p;
            bdEntity = D.s((Object)data.get(itemClassProp.getTypePropName()));
        } else {
            bdEntity = p.getBaseEntityId();
        }
        String propIdName = p.getRefIdPropName();
        Object originalId = data.get(propIdName);
        boolean isLong = p.getRefIdProp() instanceof LongProp;
        Object src = DefaultRoute.formatId(isLong, originalId);
        Object tar = this.route.getTargetValue(bdEntity, src);
        if (tar != null) {
            this.changed = true;
            data.put(propIdName, tar);
            if (data.containsKey(p.getName())) {
                data.put(p.getName(), tar);
            }
        }
        this.recordRelyDatasourceId((IBasedataField)p, bdEntity, src, tar);
    }

    private void recordRelyDatasourceId(IBasedataField p, String entityNumber, Object src, Object tar) {
        if ("isc_data_source".equals(entityNumber)) {
            Object id;
            Object object = id = tar == null ? src : tar;
            if (this.currentEntry.isEntry()) {
                this.relyAllDataSource.put(p.getName() + "[" + this.currentEntry.getSeq() + "]", id);
            } else {
                this.relyAllDataSource.put(p.getName(), id);
            }
        }
    }

    private void convertEntry(Map<String, Object> data, EntryProp p) {
        String name = p.getName();
        List list = (List)data.get(name);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (int i = 0; i < list.size(); ++i) {
                Map map = (Map)list.get(i);
                this.currentEntry.putName(name, i);
                IDataEntityType type = p.getItemType();
                this.doConvert(type, map);
                if (this.changed) {
                    Object id = this.generateNewId();
                    map.put("id", id);
                    map.put("$id", id);
                    continue;
                }
                this.noConvertEntryRow.add((Pair<Map<String, Object>, IDataEntityType>)new Pair((Object)map, (Object)type));
            }
        }
        this.currentEntry.popName();
    }

    private void convertEntryId() {
        if (!this.currentEntry.isEntry() && !this.noConvertEntryRow.isEmpty() && this.changed) {
            for (Pair<Map<String, Object>, IDataEntityType> pair : this.noConvertEntryRow) {
                Map row = (Map)pair.getA();
                IDataEntityType type = (IDataEntityType)pair.getB();
                Object id = this.generateNewId();
                row.put("id", id);
                row.put("$id", id);
            }
        }
    }

    protected Object generateEntryId(Map<String, Object> row, IDataEntityType type) {
        ArrayList<String> keyList = new ArrayList<String>(this.relyAllDataSource.size());
        for (String string : this.relyAllDataSource.keySet()) {
            keyList.add(string);
        }
        Collections.sort(keyList);
        StringBuilder hashString = new StringBuilder();
        for (String key : keyList) {
            hashString.append(this.relyAllDataSource.get(key)).append('\n');
        }
        hashString.append(D.s((Object)this.srcId)).append('\n');
        hashString.append(D.s((Object)row.get("id")));
        Long l = Math.abs(Hash.mur64((byte[])hashString.toString().getBytes(StandardCharsets.UTF_8)));
        return type.getPrimaryKey() instanceof LongProp ? l : D.s((Object)l);
    }

    protected void setBillId(Map<String, Object> data) {
        if (this.changed) {
            Object target = this.generateNewId();
            this.setIds(data, target);
            this.route.addRoute(this._entity, this.srcId, target);
        } else {
            data.put("id", this.srcId);
        }
    }

    protected Object generateHashId() {
        ArrayList<String> keyList = new ArrayList<String>(this.relyAllDataSource.size());
        for (String string : this.relyAllDataSource.keySet()) {
            keyList.add(string);
        }
        Collections.sort(keyList);
        StringBuilder hashString = new StringBuilder();
        for (String key : keyList) {
            hashString.append(this.relyAllDataSource.get(key)).append('\n');
        }
        hashString.append(D.s((Object)this.srcId));
        Long l = Math.abs(Hash.mur64((byte[])hashString.toString().getBytes(StandardCharsets.UTF_8)));
        boolean isLong = this._entityType.getProperty("id") instanceof LongProp;
        return isLong ? l : D.s((Object)l);
    }

    public void setIds(Map<String, Object> data, Object target) {
        data.put("id", target);
        data.put("$id", target);
        if (data.containsKey("masterid")) {
            data.put("masterid", target);
        }
    }

    protected void ensureUnique(Map<String, Object> data) {
        if (!this.changed) {
            return;
        }
        if (!this.autoSuffix) {
            return;
        }
        Set<String> fields = this.getUniqueFields();
        for (String field : fields) {
            DynamicProperty property = this._entityType.getProperty(field);
            if (property == null) continue;
            this.setFieldValue(data, property.getName());
        }
    }

    protected Set<String> getUniqueFields() {
        HashSet<String> set = new HashSet<String>();
        set.add("number");
        set.add("name");
        return set;
    }

    private void setFieldValue(Map<String, Object> map, String field) {
        String suffix;
        Object value = map.get(field);
        String string = suffix = this.suffix == null ? this.generateRandValue() : this.suffix;
        if (value instanceof Map) {
            Map temp = (Map)value;
            temp.replaceAll((k, v) -> this.trim(v, 45) + "_" + suffix);
        } else if (value != null) {
            map.put(field, this.trim(value, 45) + "_" + suffix);
        }
    }

    private String trim(Object v, int maxLength) {
        if (v == null) {
            return "";
        }
        String s = v.toString();
        if ((s = s.trim()).length() <= maxLength) {
            return s;
        }
        return s.substring(0, maxLength);
    }

    private String generateRandValue() {
        String name = Hash.mur16((Object[])new Object[]{UUID.randomUUID()});
        char c = name.charAt(0);
        if (c < 'A') {
            name = (char)(c + 23) + name.substring(1);
        }
        return name;
    }

    private static Object formatId(boolean isLong, Object id) {
        return isLong ? Long.valueOf(D.l((Object)id)) : D.s((Object)id);
    }

    private Object generateNewId() {
        boolean isLong = this._entityType.getProperty("id") instanceof LongProp;
        return isLong ? Long.valueOf(ID.genLongId()) : ID.genStringId();
    }

    private Object formatBillId(Object id) {
        boolean isLong = this._entityType.getProperty("id") instanceof LongProp;
        return isLong ? Long.valueOf(D.l((Object)id)) : D.s((Object)id);
    }
}

