/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dts.route;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.property.LongProp;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.dts.replica.ConvertMode;
import kd.isc.iscb.platform.core.dts.replica.ConvertResult;
import kd.isc.iscb.platform.core.dts.replica.ResourceRoute;
import kd.isc.iscb.platform.core.dts.replica.ResourceRouteFactory;
import kd.isc.iscb.platform.core.dts.replica.RouteMapping;
import kd.isc.iscb.platform.core.dts.route.DataSourceConvertJobFactory;
import kd.isc.iscb.platform.core.dts.route.DtsFileResourceUtil;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobFactory;
import kd.isc.iscb.platform.core.task.SignalManager;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.except.TaskCancelException;
import kd.isc.iscb.util.misc.Json;

public class DataSourceConvertJob
implements Job {
    public static final JobFactory FACTORY = new DataSourceConvertJobFactory();
    private String title;
    private long id;
    private final String mode;
    private final String suffix;
    private final boolean autoSuffix;
    private final Map<String, Object> resetInfo;
    private int total = 0;
    private AtomicInteger success = new AtomicInteger(0);
    private AtomicInteger failed = new AtomicInteger(0);
    private AtomicInteger omitted = new AtomicInteger(0);
    private RouteMapping routeMapping = new RouteMapping();
    private String current;

    public DataSourceConvertJob(String param, String title) {
        Map paramMap = (Map)Json.toObject((String)param);
        this.title = title;
        this.id = D.l(paramMap.get("id"));
        this.mode = D.s(paramMap.get("mode"));
        this.suffix = D.s(paramMap.get("suffix"));
        this.autoSuffix = D.x(paramMap.get("autoSuffix"));
        this.resetInfo = (Map)paramMap.get("resetInfo");
    }

    public final long getOwnerId() {
        return this.id;
    }

    public final long getId() {
        return this.id;
    }

    public final String getParam() {
        return String.valueOf(this.id);
    }

    public final String getTitle() {
        return this.title;
    }

    public final JobFactory getFactory() {
        return FACTORY;
    }

    public void run() {
        long id = this.getId();
        if (ConvertMode.valueOf(this.mode) != ConvertMode.reset_trace) {
            this.parseMappingDataSource();
        }
        try {
            DtsFileResourceUtil.setConverting(id);
            List<Map<String, Object>> resources = this.loadParsedResources();
            this.total = resources.size();
            for (Map<String, Object> res : resources) {
                SignalManager.checkCancelSignal();
                String table = D.s((Object)res.get("table"));
                long entryId = D.l((Object)res.get("fentryid"));
                this.convertOne(res, table, entryId);
            }
            DtsFileResourceUtil.setConverted(id, this.success.get(), this.failed.get(), this.omitted.get(), this.total);
        }
        catch (TaskCancelException e) {
            DtsFileResourceUtil.setCanceled(id);
            throw D.e((Throwable)e);
        }
        catch (Exception e) {
            DtsFileResourceUtil.setFailed(id);
            throw D.e((Throwable)e);
        }
    }

    private void convertOne(Map<String, Object> res, String table, long entryId) {
        try {
            this.tryConverting(res, table, entryId);
        }
        catch (Exception e) {
            this.failed.incrementAndGet();
            DtsFileResourceUtil.setEntryState(table, entryId, "FAILED", e);
            throw D.e((Throwable)e);
        }
    }

    private void tryConverting(Map<String, Object> res, String table, long entryId) {
        String state = D.s((Object)res.get("fstate"));
        if (this.isReadyState(state)) {
            this.doConverting(table, entryId, res);
        }
    }

    private void doConverting(String entryTable, long entryId, Map<String, Object> res) {
        String entity = D.s((Object)res.get("ftype"));
        DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((Object)entity, (String)"bos_objecttype", (String)"name");
        String entityTitle = obj.getString("name") + '(' + entity + ')';
        String title = ResManager.loadKDString((String)"\u8f6c\u6362\uff1a%1$s-%2$s...", (String)"DataSourceConvertJob_0", (String)"isc-iscb-ds-convert", (Object[])new Object[0]);
        this.current = String.format(title, entityTitle, res.get("fnumber"));
        String json = this.loadRes(entryTable, entryId);
        Map data = (Map)Json.toObject((String)json);
        ResourceRoute handler = ResourceRouteFactory.getHandler(data, this.routeMapping, this.mode, this.suffix, this.resetInfo, this.autoSuffix);
        ConvertResult result = handler.convert();
        Map<String, Object> resultData = result.getData();
        String newName = DtsFileResourceUtil.getResName(resultData);
        String newNumber = DtsFileResourceUtil.getNumber(resultData);
        String resPk = D.s((Object)resultData.get("id"));
        if (result.isChanged()) {
            DtsFileResourceUtil.setEntrySuccess(entryTable, entryId, newName, newNumber, resPk, Json.toString(resultData));
            this.success.incrementAndGet();
        } else {
            DtsFileResourceUtil.setEntryOmitted(entryTable, entryId);
            this.omitted.incrementAndGet();
        }
    }

    private String loadRes(String table, long entryid) {
        Connection cn = TX.getConnection((String)"ISCB", (boolean)true);
        try {
            String sql = "SELECT fcontent FROM " + table + " WHERE FENTRYID = ?";
            DataRow row = DbUtil.executeRow((Connection)cn, (String)sql, Collections.singletonList(entryid), Collections.singletonList(-5));
            if (row != null) {
                String string = (String)row.get((Object)"fcontent");
                return string;
            }
            String s = ResManager.loadKDString((String)"[%1$s]\u8868entryId=[%2$s]\u7684fcontent\u5b57\u6bb5\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u8f6c\u6362", (String)"DataSourceConvertJob_1", (String)"isc-iscb-ds-convert", (Object[])new Object[0]);
            throw new IscBizException(String.format(s, table, entryid));
        }
        finally {
            DbUtil.close((Connection)cn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Map<String, Object>> loadParsedResources() {
        Connection cn = TX.getConnection((String)"ISCB", (boolean)true);
        try {
            ArrayList<Map<String, Object>> resources = new ArrayList<Map<String, Object>>();
            this.loadParsedResources(cn, "T_ISCB_DTS_CONV_RRS2", resources);
            ArrayList<Map<String, Object>> arrayList = resources;
            return arrayList;
        }
        finally {
            DbUtil.close((Connection)cn);
        }
    }

    private void loadParsedResources(Connection cn, String table, List<Map<String, Object>> resources) {
        String sql = "SELECT fseq, fentryid, ftype, fres_pk, fstate, fname, fnumber,fnew_res_pk FROM " + table + " WHERE fid=? ORDER BY fseq";
        for (DataRow row : DbUtil.executeList((Connection)cn, (String)sql, Collections.singletonList(this.getId()), Collections.singletonList(-5))) {
            Map item = row.toMap();
            item.put("table", table);
            if ("SUCCESS".equals(item.get("fstate"))) {
                this.addRoute(item);
            }
            resources.add(item);
        }
    }

    private void addRoute(Map<String, Object> item) {
        String entity = D.s((Object)item.get("ftype"));
        ISimpleProperty p = EntityMetadataCache.getDataEntityType((String)entity).getPrimaryKey();
        String oldPk = D.s((Object)item.get("fres_pk"));
        String newPk = D.s((Object)item.get("fnew_res_pk"));
        boolean isLong = p instanceof LongProp;
        this.routeMapping.addRoute(entity, isLong ? Long.valueOf(D.l((Object)oldPk)) : oldPk, isLong ? Long.valueOf(D.l((Object)newPk)) : newPk);
    }

    private boolean isReadyState(String state) {
        switch (state) {
            case "SUCCESS": {
                this.success.incrementAndGet();
                return false;
            }
            case "OMITTED": {
                this.omitted.incrementAndGet();
                return false;
            }
            case "FAILED": {
                this.failed.incrementAndGet();
                return true;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseMappingDataSource() {
        String sql = "SELECT fsrc_pk as src, ftar_pk as tar FROM T_ISCB_DTS_DS_MAPPING WHERE fid=? and ftar_pk != ' '";
        Connection cn = TX.getConnection((String)"ISCB", (boolean)true);
        try {
            for (DataRow row : DbUtil.executeList((Connection)cn, (String)sql, Collections.singletonList(this.getId()), Collections.singletonList(-5))) {
                long src = D.l((Object)row.get((Object)"src"));
                long tar = D.l((Object)row.get((Object)"tar"));
                this.routeMapping.addRoute("isc_data_source", src, tar);
            }
        }
        finally {
            DbUtil.close((Connection)cn);
        }
        if (ConvertMode.valueOf(this.mode) != ConvertMode.copy && !this.routeMapping.hasRoute()) {
            DtsFileResourceUtil.setCanceled(this.id);
            String s = ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u6570\u636e\u6e90\u6620\u5c04\u5173\u7cfb\uff0c\u65e0\u9700\u8f6c\u6362\u3002", (String)"DataSourceConvertJob_2", (String)"isc-iscb-ds-convert", (Object[])new Object[0]);
            throw new IscBizException(s);
        }
    }

    public Job.Progress getRealtimeProgress() {
        String s = ResManager.loadKDString((String)"\u603b\u8ba1\u5904\u7406\uff1a%1$s\uff0c\u6210\u529f\uff1a%2$s\uff0c\u5ffd\u7565\uff1a%3$s\uff1b\u5931\u8d25\uff1a%4$s", (String)"DataSourceConvertJob_3", (String)"isc-iscb-ds-convert", (Object[])new Object[0]);
        String remark = String.format(s, this.total, this.success.get(), this.omitted.get(), this.failed.get());
        return new Job.Progress((long)this.total, (long)(this.success.get() + this.omitted.get()), remark);
    }

    public String getJobSummary() {
        String s = ResManager.loadKDString((String)"\u603b\u5171%1$s\u4e2a\u8d44\u6e90\uff0c\u8f6c\u6362\u6210\u529f%2$s\u4e2a\uff0c\u5ffd\u7565%3$s\u4e2a\uff0c\u5931\u8d25%4$s\u4e2a", (String)"DataSourceConvertJob_4", (String)"isc-iscb-ds-convert", (Object[])new Object[0]);
        return String.format(s, this.total, this.success.get(), this.omitted.get(), this.failed.get());
    }

    public String refreshProgress() {
        return this.success.get() + this.omitted.get() + "/" + this.total + '\n' + this.current;
    }
}

