/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dts.route;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.id.IDService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.connector.self.AttachmentUtil;
import kd.isc.iscb.platform.core.dts.route.DtsFileResourceParseJobFactory;
import kd.isc.iscb.platform.core.dts.route.DtsFileResourceUtil;
import kd.isc.iscb.platform.core.imp.AbstractFileResourceJob;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobFactory;
import kd.isc.iscb.platform.core.task.SignalManager;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.NetUtil;
import kd.isc.iscb.util.misc.Pair;
import kd.isc.iscb.util.misc.StringUtil;

public class DtsFileResourceParseJob
extends AbstractFileResourceJob {
    public static final JobFactory FACTORY = new DtsFileResourceParseJobFactory();
    private int total_files = 0;
    private AtomicInteger completed_files = new AtomicInteger(0);
    private AtomicInteger omitted_files = new AtomicInteger(0);
    private List<String> omitted_file_names = new ArrayList<String>();
    private volatile String current_file;
    private AtomicInteger current_count = new AtomicInteger(-1);
    private AtomicInteger current_completed = new AtomicInteger(0);
    private HashSet<String> ref_imported = new HashSet(256);
    private HashSet<Long> ds_imported = new HashSet(4);
    private HashSet<String> res_file_imported = new HashSet(128);

    public DtsFileResourceParseJob(long id, String title) {
        super(id, title);
    }

    public JobFactory getFactory() {
        return FACTORY;
    }

    public String refreshProgress() {
        return this.completed_files + "/" + this.total_files;
    }

    public String getJobSummary() {
        String s = ResManager.loadKDString((String)"\u89e3\u6790%1$s\u4e2a\u6587\u4ef6\uff0c\u6709\u6548\u6587\u4ef6\uff1a%2$s\u4e2a\uff0c\u5ffd\u7565\u6587\u4ef6\uff1a%3$s\u4e2a\u3002", (String)"DtsFileResourceParseJob_0", (String)"isc-iscb-ds-convert", (Object[])new Object[0]);
        return String.format(s, this.total_files, this.completed_files.get(), this.omitted_files.get());
    }

    private String getDetailedSummary() {
        String s = ResManager.loadKDString((String)"\u89e3\u6790%1$s\u4e2a\u6587\u4ef6\uff0c\u6709\u6548\u6587\u4ef6\uff1a%2$s\u4e2a", (String)"DtsFileResourceParseJob_1", (String)"isc-iscb-ds-convert", (Object[])new Object[0]);
        String sb = String.format(s, this.total_files, this.completed_files.get());
        if (!this.omitted_file_names.isEmpty()) {
            sb = sb + '\uff0c';
            String s1 = ResManager.loadKDString((String)"\u5ffd\u7565\u6587\u4ef6\uff1a%1$s\u4e2a\u3002\u5ffd\u7565\u539f\u56e0\uff1a\u6587\u4ef6\u7c7b\u578b\u4e3a\u975e\u4e3b\u8d44\u6e90\u6587\u4ef6\u7c7b\u578b\u3002\u5ffd\u7565\u7684\u6587\u4ef6\u662f\uff1a%2$s", (String)"DtsFileResourceParseJob_2", (String)"isc-iscb-ds-convert", (Object[])new Object[0]);
            sb = sb + String.format(s1, this.omitted_files.get(), StringUtil.join(this.omitted_file_names, (String)","));
        }
        return sb;
    }

    public void run() {
        long id = this.getId();
        try {
            List files = AttachmentUtil.getAttachmentList((String)FACTORY.getOwnerEntity(), (Object)id);
            SignalManager.checkCancelSignal();
            this.loadParsedResources();
            this.parseResourceFiles(files);
            DtsFileResourceUtil.setParsed(id, this.getDetailedSummary());
        }
        catch (Exception e) {
            DtsFileResourceUtil.setFailed(id);
            throw D.e((Throwable)e);
        }
    }

    private String loadMainResEntity() {
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)this.getId(), (String)FACTORY.getOwnerEntity(), (String)"res_type");
        Object resType = obj.get("res_type");
        if (resType == null) {
            return "isc_metadata_schema";
        }
        return String.valueOf(((DynamicObject)resType).get("number"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadParsedResources() {
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)this.getId(), (String)FACTORY.getOwnerEntity(), (String)"ref_resources.ref_res_type,ref_resources.ref_res_pk,data_source_entry.src_pk");
        DynamicObjectCollection refResources = obj.getDynamicObjectCollection("ref_resources");
        for (Object res : refResources) {
            String entity = res.getDynamicObject("ref_res_type").getString("number");
            String refResPk = res.getString("ref_res_pk");
            this.ref_imported.add(this.generateResKey(entity, refResPk));
        }
        DynamicObjectCollection dataSources = obj.getDynamicObjectCollection("data_source_entry");
        for (DynamicObject ds : dataSources) {
            this.ds_imported.add(D.l((Object)ds.getString("src_pk")));
        }
        Connection cn = TX.getConnection((String)"ISCB", (boolean)true);
        try {
            String sql = "SELECT fres_pk, ffileid FROM T_ISCB_DTS_CONV_RES_FILE WHERE fid=?";
            for (DataRow row : DbUtil.executeList((Connection)cn, (String)sql, Collections.singletonList(this.getId()), Collections.singletonList(-5))) {
                Map map = row.toMap();
                this.res_file_imported.add(this.generateResFileKey(D.s(map.get("ffileid")), map.get("fres_pk")));
            }
        }
        finally {
            DbUtil.close((Connection)cn);
        }
    }

    private String generateResKey(String entity, Object resPk) {
        return resPk + "@" + entity;
    }

    private String generateResFileKey(String fileid, Object resPk) {
        return resPk + "@" + fileid;
    }

    private void parseResourceFiles(List<Map<String, Object>> files) {
        this.total_files = files.size();
        for (Map<String, Object> file : files) {
            SignalManager.checkCancelSignal();
            this.current_count.set(-1);
            String[] jsons = this.readDtsFile(file);
            String fileId = D.s((Object)file.get("srcAttachId"));
            String fileName = this.getFileName(file);
            Pair fileInfo = new Pair((Object)fileId, (Object)fileName);
            this.resetProgress(jsons, fileName);
            if (this.isValid(jsons)) {
                this.parseResourceFile(jsons, (Pair<String, String>)fileInfo);
                this.completed_files.incrementAndGet();
                continue;
            }
            this.omitted_file_names.add(fileName);
            this.omitted_files.incrementAndGet();
        }
    }

    private boolean isValid(String[] jsons) {
        for (int i = jsons.length - 1; i >= 0; --i) {
            boolean isMainRes;
            String json = jsons[i];
            Map data = (Map)Json.toObject((String)json);
            if (data == null) continue;
            String realEntity = (String)data.get("$entityname");
            boolean bl = isMainRes = !D.x(data.get("$isref"));
            if (!isMainRes) continue;
            return true;
        }
        return false;
    }

    private void parseResourceFile(String[] jsons, Pair<String, String> file) {
        for (String json : jsons) {
            SignalManager.checkCancelSignal();
            this.current_completed.incrementAndGet();
            Map data = (Map)Json.toObject((String)json);
            if (data == null) continue;
            this.saveResourceData(data, file);
        }
    }

    private void saveResourceData(Map<String, Object> data, Pair<String, String> file) {
        Object resPk;
        String json = Json.toString(data);
        String entity = D.s((Object)data.get("$entityname"));
        if (this.ref_imported.add(this.generateResKey(entity, resPk = data.get("id")))) {
            this.saveRefResource(json, data, entity);
        }
        if (this.res_file_imported.add(this.generateResFileKey((String)file.getA(), resPk))) {
            this.saveResFile(data, file, entity);
        }
        if ("isc_data_source".equals(entity) && this.ds_imported.add(D.l((Object)resPk))) {
            this.saveDataSourceEntries(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveResFile(Map<String, Object> data, Pair<String, String> file, String entity) {
        int seq = this.res_file_imported.size();
        long entryId = IDService.get().genLongId();
        String resPk = D.s((Object)data.get("id"));
        String isref = D.s((Object)data.get("$isref"));
        String sql = "INSERT INTO T_ISCB_DTS_CONV_RES_FILE(FID, FENTRYID, FSEQ,FTYPE, FRES_PK, FISREF,FFILE, FFILEID, FIS_NEED) VALUES(?,?,?,  ?,?,?,  ?,?,?)";
        List<Integer> types = Arrays.asList(-5, -5, 4, 12, 12, 12, 12, 12, 12);
        List<Object> values = Arrays.asList(this.getId(), entryId, seq, entity, resPk, isref, file.getB(), file.getA(), "true");
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false);
        try {
            DbUtil.executeUpdate((Connection)cn, (String)sql, values, types);
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveRefResource(String json, Map<String, Object> data, String entity) {
        int seq = this.ref_imported.size();
        long entryId = IDService.get().genLongId();
        String name = DtsFileResourceUtil.getResName(data);
        String number = DtsFileResourceUtil.getNumber(data);
        String resPk = D.s((Object)data.get("id"));
        Timestamp resTime = D.t((Object)data.get(DtsFileResourceUtil.getTimeField(entity)));
        String sql = "INSERT INTO T_ISCB_DTS_CONV_RRS2(FID,FENTRYID, FSEQ, FTYPE,FSTATE,FNAME,FNUMBER,FRES_PK,FRES_TIME,FCONTENT) VALUES(?,?,?,?,?,   ?,?,?,   ?,?)";
        List<Integer> types = Arrays.asList(-5, -5, 4, 12, 12, 12, 12, 12, 93, 12);
        List<Object> values = Arrays.asList(this.getId(), entryId, seq, entity, "READY", name, number, resPk, resTime, json);
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false);
        try {
            DbUtil.executeUpdate((Connection)cn, (String)sql, values, types);
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveDataSourceEntries(Map<String, Object> data) {
        int seq = this.ds_imported.size();
        String name = DtsFileResourceUtil.getResName(data);
        String number = DtsFileResourceUtil.getNumber(data);
        String resPk = D.s((Object)data.get("id"));
        long entryId = IDService.get().genLongId();
        String sql = "INSERT INTO T_ISCB_DTS_DS_MAPPING(FID,FENTRYID, FSEQ,FSRC_NAME,FSRC_NUMBER,FSRC_PK)  VALUES(?,?,?,   ?,?,?) ";
        List<Integer> types = Arrays.asList(-5, -5, 4, 12, 12, 12);
        List<Object> values = Arrays.asList(this.getId(), entryId, seq, name, number, resPk);
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false);
        try {
            DbUtil.executeUpdate((Connection)cn, (String)sql, values, types);
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    private String getFileName(Map<String, Object> file) {
        return file.get("name") + "." + file.get("type");
    }

    private String[] readDtsFile(Map<String, Object> file) {
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        String content = NetUtil.readText((InputStream)fileService.getInputStream((String)file.get("srcUrl")));
        return content.split("\\n");
    }

    private void resetProgress(String[] jsons, String file) {
        this.current_file = file;
        this.current_count.set(jsons.length);
        this.current_completed.set(0);
    }

    public Job.Progress getRealtimeProgress() {
        int currentCount = this.current_count.get();
        int completedFiles = this.completed_files.get();
        if (currentCount < 0) {
            String s = ResManager.loadKDString((String)"\u8bfb\u53d6\u7b2c%s\u4e2a\u6587\u4ef6...", (String)"DtsFileResourceParseJob_3", (String)"isc-iscb-ds-convert", (Object[])new Object[0]);
            return new Job.Progress((long)this.total_files, (long)completedFiles, String.format(s, completedFiles + 1));
        }
        String description = this.current_file + "(" + this.current_completed + "/" + currentCount + ") ...";
        return new Job.Progress((long)this.total_files, (long)completedFiles, description);
    }
}

