/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.iscb.platform.core.cache.data.DataCopyTrigger;
import kd.isc.iscb.platform.core.connector.ConnectorUtil;
import kd.isc.iscb.platform.core.dc.DataCopyOpenApi;
import kd.isc.iscb.platform.core.dc.DataCopyTaskUtil;
import kd.isc.iscb.platform.core.dc.mq.TriggerRouter;
import kd.isc.iscb.platform.core.license.IscLicenseUtil;
import kd.isc.iscb.platform.core.trace.Caller;
import kd.isc.iscb.platform.core.trace.TraceStack;
import kd.isc.iscb.service.ISCDataCopyService;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.trace.TraceTask;

public class ISCDataCopyServiceImpl
implements ISCDataCopyService {
    private static final String _TRIGGERS = "triggers";
    private static final String _RESULT = "result";
    private static final String _START_TIME = "start_time";
    private static final String _CALLBACK = "callback";
    private static final String _PARAMS = "params";
    private static final String _TRIGGER_NUMBER = "trigger_number";
    private static Log logger = LogFactory.getLog(ISCDataCopyServiceImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> execute(final String trigger_number, final Map<String, Object> params, final Map<String, Object> callback) {
        final LinkedHashMap<String, Object> des = new LinkedHashMap<String, Object>();
        des.put(_TRIGGER_NUMBER, trigger_number);
        des.put(_PARAMS, params);
        des.put(_CALLBACK, callback);
        des.put(_START_TIME, new Date());
        try {
            Map map = (Map)TraceStack.trace((Caller)Caller.MicroSVC, (TraceTask)new TraceTask(){

                public Object invoke() {
                    Map result = DataCopyOpenApi.doCopy((String)trigger_number, (Map)params, (Map)callback);
                    des.put(ISCDataCopyServiceImpl._RESULT, result);
                    return result;
                }
            });
            return map;
        }
        finally {
            logger.info(Json.toString(des));
        }
    }

    public Map<String, Object> start(String trigger_number, Map<String, Object> params, Map<String, Object> callback) {
        return this.execute(trigger_number, params, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> execute(final String trigger_number, final Map<String, Object> callback) {
        final LinkedHashMap<String, Object> des = new LinkedHashMap<String, Object>();
        des.put(_TRIGGER_NUMBER, trigger_number);
        des.put(_CALLBACK, callback);
        des.put(_START_TIME, new Date());
        try {
            Map map = (Map)TraceStack.trace((Caller)Caller.MicroSVC, (TraceTask)new TraceTask(){

                public Object invoke() {
                    Map result = DataCopyOpenApi.doCopy((String)trigger_number, null, (Map)callback);
                    des.put(ISCDataCopyServiceImpl._RESULT, result);
                    return result;
                }
            });
            return map;
        }
        finally {
            logger.info(Json.toString(des));
        }
    }

    public Map<String, Object> start(String trigger_number, Map<String, Object> callback) {
        return this.execute(trigger_number, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeById(final Object id, final Map<String, Object> params) {
        final LinkedHashMap<String, Object> des = new LinkedHashMap<String, Object>();
        des.put(_TRIGGERS, params);
        des.put(_START_TIME, new Date());
        try {
            String string = (String)TraceStack.trace((Caller)Caller.MicroSVC, (TraceTask)new TraceTask(){

                public Object invoke() {
                    String result = DataCopyOpenApi.doCopyById((Object)id, (Map)params, null, null);
                    des.put(ISCDataCopyServiceImpl._RESULT, result);
                    return result;
                }
            });
            return string;
        }
        finally {
            logger.info(Json.toString(des));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> executeBatch(final List<Map<String, Object>> triggers) {
        final LinkedHashMap<String, Object> des = new LinkedHashMap<String, Object>();
        des.put(_TRIGGERS, triggers);
        des.put(_START_TIME, new Date());
        try {
            List list = (List)TraceStack.trace((Caller)Caller.MicroSVC, (TraceTask)new TraceTask(){

                public Object invoke() {
                    List result = DataCopyOpenApi.doCopyBatch((List)triggers);
                    des.put(ISCDataCopyServiceImpl._RESULT, result);
                    return result;
                }
            });
            return list;
        }
        finally {
            logger.info(Json.toString(des));
        }
    }

    public List<Map<String, Object>> startBatch(List<Map<String, Object>> triggers) {
        return this.executeBatch(triggers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> executeBatchCallBackOnce(final List<Map<String, Object>> triggers, final Map<String, Object> callback) {
        final LinkedHashMap<String, Object> des = new LinkedHashMap<String, Object>();
        des.put(_TRIGGERS, triggers);
        des.put(_CALLBACK, callback);
        des.put(_START_TIME, new Date());
        try {
            Map map = (Map)TraceStack.trace((Caller)Caller.MicroSVC, (TraceTask)new TraceTask(){

                public Object invoke() {
                    Map result = DataCopyOpenApi.doCopyBatchCallBackOnce((List)triggers, (Map)callback);
                    des.put(ISCDataCopyServiceImpl._RESULT, result);
                    return result;
                }
            });
            return map;
        }
        finally {
            logger.info(Json.toString(des));
        }
    }

    public Map<String, Object> startBatchCallBackOnce(List<Map<String, Object>> triggers, Map<String, Object> callback) {
        return this.executeBatchCallBackOnce(triggers, callback);
    }

    public Map<String, Object> getExecutionState(String execution_number) {
        logger.info("invoke_params: " + execution_number);
        return DataCopyOpenApi.getExecutionState((String)execution_number);
    }

    public Map<String, Object> getExecutionStateById(long executionId) {
        logger.info("invoke_params: " + executionId);
        return DataCopyOpenApi.getExecutionState((long)executionId);
    }

    public List<Map<String, Object>> getExecutionStateList(List<String> executions) {
        logger.info("invoke_params: " + executions);
        ArrayList<Map<String, Object>> executionStates = new ArrayList<Map<String, Object>>(executions.size());
        for (String execution : executions) {
            executionStates.add(this.getExecutionState(execution));
        }
        return executionStates;
    }

    public Map<String, Object> lookupTargetOid(String src_oid, String src_cn_number, String src_table, String target_cn_number, String tar_table) {
        return DataCopyOpenApi.lookupTargetOid((String)src_oid, (String)src_cn_number, (String)src_table, (String)target_cn_number, (String)tar_table);
    }

    public Map<String, Object> findLastLog(String cn_number, String table_name, String oid) {
        return DataCopyOpenApi.findLastLog((String)cn_number, (String)table_name, (String)oid);
    }

    public Map<String, Object> pull(final String trigger_number, final Map<String, Object> filter_params) {
        return (Map)TraceStack.trace((Caller)Caller.MicroSVC, (TraceTask)new TraceTask(){

            public Object invoke() {
                return DataCopyOpenApi.query((String)trigger_number, (Map)filter_params, (boolean)false);
            }
        });
    }

    public Map<String, Object> pullAndTranslate(String trigger_number, Map<String, Object> filter_params) {
        return DataCopyOpenApi.query((String)trigger_number, filter_params, (boolean)true);
    }

    public Map<String, Object> translate(String trigger_number, List<Map<String, Object>> src_data) {
        return DataCopyOpenApi.translate((String)trigger_number, src_data);
    }

    public Map<String, Object> translateX(String trigger_number, DynamicObject[] objects) {
        return DataCopyOpenApi.translate((String)trigger_number, (DynamicObject[])objects);
    }

    public Map<String, Object> push(final String trigger_number, final List<Map<String, Object>> dataSet) {
        return (Map)TraceStack.trace((Caller)Caller.MicroSVC, (TraceTask)new TraceTask(){

            public Object invoke() {
                return DataCopyOpenApi.push((String)trigger_number, (List)dataSet);
            }
        });
    }

    public Map<String, Object> pushX(final String trigger_number, final DynamicObject[] objects) {
        return (Map)TraceStack.trace((Caller)Caller.MicroSVC, (TraceTask)new TraceTask(){

            public Object invoke() {
                return DataCopyOpenApi.push((String)trigger_number, (DynamicObject[])objects);
            }
        });
    }

    public Map<String, Object> submit(final String trigger_number, final List<Map<String, Object>> dataSet, final Map<String, Object> callback) {
        return (Map)TraceStack.trace((Caller)Caller.MicroSVC, (TraceTask)new TraceTask(){

            public Object invoke() {
                return DataCopyOpenApi.submit((String)trigger_number, (List)dataSet, (Map)callback);
            }
        });
    }

    public Map<String, Object> submitX(final String trigger_number, final DynamicObject[] objects, final Map<String, Object> callback) {
        return (Map)TraceStack.trace((Caller)Caller.MicroSVC, (TraceTask)new TraceTask(){

            public Object invoke() {
                return DataCopyOpenApi.submit((String)trigger_number, (DynamicObject[])objects, (Map)callback);
            }
        });
    }

    public Map<String, Object> queryExecutionLogs(String executionId, int limit) {
        return DataCopyOpenApi.queryExecutionLogs((String)executionId, (int)limit);
    }

    public Map<String, Object> retryLog(final String logId) {
        return (Map)TraceStack.trace((Caller)Caller.MicroSVC, (TraceTask)new TraceTask(){

            public Object invoke() {
                return DataCopyOpenApi.retryLog((String)logId);
            }
        });
    }

    public Map<String, Object> findMappingValue(String ruleNumber, String value, int extendType) {
        return DataCopyOpenApi.findMappingValue((String)ruleNumber, (String)value, (int)extendType);
    }

    public Map<String, Object> callExtendService(Map<String, Object> response) {
        return DataCopyOpenApi.callExtendService(response);
    }

    public Map<String, Object> syncExecute(final String trigger_number, final Map<String, Object> filter_params) {
        return (Map)TraceStack.trace((Caller)Caller.MicroSVC, (TraceTask)new TraceTask(){

            public Object invoke() {
                return DataCopyOpenApi.syncExecute((String)trigger_number, (Map)filter_params);
            }
        });
    }

    public DynamicObject getConnInfoByTriggerNumber(String trigger_number, boolean isSrc) {
        return DataCopyOpenApi.getConnInfoByTriggerNumber((String)trigger_number, (boolean)isSrc);
    }

    @Deprecated
    public Object callFacadeService(String cn_number, String service, Map<String, Object> params) {
        return DataCopyOpenApi.callService((String)cn_number, (String)service, params, null);
    }

    public Map<String, Object> testConnection(String number) {
        return DataCopyOpenApi.testConnection((String)number);
    }

    public void refreshConnectionCache() {
        IscLicenseUtil.refreshCache();
    }

    public Map<String, Object> deployConnection(final Map<String, Object> request) {
        return (Map)TraceStack.trace((Caller)Caller.MicroSVC, (TraceTask)new TraceTask(){

            public Object invoke() {
                return DataCopyOpenApi.deployConnection((Map)request);
            }
        });
    }

    public Map<String, Object> redoExecution(final long id) {
        return (Map)TraceStack.trace((Caller)Caller.MicroSVC, (TraceTask)new TraceTask(){

            public Object invoke() {
                return DataCopyOpenApi.redoExecution((long)id);
            }
        });
    }

    public Map<String, Object> cancelExecution(long id) {
        return DataCopyOpenApi.cancelExecution((long)id);
    }

    @Deprecated
    public List<Map<String, Object>> pullBySchema(String schema, Map<String, Object> filter, long limit) {
        return DataCopyOpenApi.pullBySchema((String)schema, filter, (long)limit, (boolean)false);
    }

    public List<Map<String, Object>> transferBySchema(String schema, List<Map<String, Object>> list) {
        return DataCopyOpenApi.transferBySchema((String)schema, list);
    }

    @Deprecated
    public List<Map<String, Object>> pushBySchema(String schema, List<Map<String, Object>> list) {
        return DataCopyOpenApi.pushBySchema((String)schema, list, (boolean)false);
    }

    @Deprecated
    public List<Map<String, Object>> executeBySchema(String schema, Map<String, Object> filter) {
        return DataCopyOpenApi.executeBySchema((String)schema, filter, (int)1000000, (boolean)false);
    }

    public Object callService(String cn_number, String service, Map<String, Object> params, String proxyUser) {
        return DataCopyOpenApi.callService((String)cn_number, (String)service, params, (String)proxyUser);
    }

    public Object executeQuerySQL(String cn_number, String sql, List<Object> values, List<Integer> types, long limit) {
        return DataCopyOpenApi.executeQuerySQL((String)cn_number, (String)sql, values, types, (long)limit);
    }

    public Object syncMetaData(String dsNumber, String metaType, String fullName) {
        return DataCopyOpenApi.syncMetaData((String)dsNumber, (String)metaType, (String)fullName);
    }

    public Map<String, Object> executeWithRealDataSource(String trigger_number, Map<String, Object> params, String realDataSource, String realDataTarget) {
        return DataCopyOpenApi.executeX((String)trigger_number, params, null, (String)realDataSource, (String)realDataTarget);
    }

    public Map<String, Object> submitWithRealDataSource(String trigger_number, List<Map<String, Object>> data, String realDataSource, String realDataTarget) {
        return DataCopyOpenApi.executeX((String)trigger_number, null, data, (String)realDataSource, (String)realDataTarget);
    }

    public Map<String, Object> synExecuteWithRealDataSource(String trigger_number, Map<String, Object> params, String realDataSource, String realDataTarget) {
        return DataCopyOpenApi.syncExecuteX((String)trigger_number, params, (String)realDataSource, (String)realDataTarget);
    }

    public void enableTrigger(String number) {
        DynamicObject trigger = DataCopyTrigger.getByNumber((String)number);
        if ("auto".equals(trigger.get("trigger_type"))) {
            DataCopyTaskUtil.createJobSchedule((DynamicObject)trigger);
        } else if ("event".equals(trigger.get("trigger_type"))) {
            DataCopyTaskUtil.attachEvents((DynamicObject)trigger);
        }
        ConnectorUtil.enable((DynamicObject)trigger);
        TriggerRouter.clearCache();
        logger.warn("trigger " + number + " enabled.");
    }

    public void disableTrigger(String number) {
        DynamicObject trigger = DataCopyTrigger.getByNumber((String)number);
        if ("auto".equals(trigger.get("trigger_type"))) {
            DataCopyTaskUtil.disableJobSchedule((DynamicObject)trigger);
        } else if ("event".equals(trigger.get("trigger_type"))) {
            DataCopyTaskUtil.detachEvents((DynamicObject)trigger);
        }
        ConnectorUtil.disable((DynamicObject)trigger);
        TriggerRouter.clearCache();
        logger.warn("trigger " + number + " disabled.");
    }
}

