/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.cache.data.ConnectionConfig;
import kd.isc.iscb.platform.core.cache.data.DataSource;
import kd.isc.iscb.platform.core.cache.data.MetaDataSchema;
import kd.isc.iscb.platform.core.connector.ConnectionManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.dc.DataCopyOpenApi;
import kd.isc.iscb.platform.core.dc.e.SQLUtil;
import kd.isc.iscb.platform.core.meta.MetaSchemaUtil;
import kd.isc.iscb.platform.core.util.CollectionUtils;
import kd.isc.iscb.platform.core.util.CommonUtil;
import kd.isc.iscb.service.IscMetaSchemaService;
import kd.isc.iscb.util.connector.s.QueryList;
import kd.isc.iscb.util.db.Column;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.db.Table;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.io.ObjectReader;
import kd.isc.iscb.util.misc.SimpleFC;

public class IscMetaSchemaServiceImpl
implements IscMetaSchemaService {
    private static final String TPS_KEY = "ISC_QUERY_SERVICE_MAX_TPS";

    public Object syncMetaData(String dsNumber, String metaType, String fullName) {
        return DataCopyOpenApi.syncMetaData((String)dsNumber, (String)metaType, (String)fullName);
    }

    public Object callService(String dsNumber, String service, Map<String, Object> params, String proxy_user) {
        return MetaSchemaUtil.callService((String)dsNumber, (String)service, params, (String)proxy_user);
    }

    public Object callServiceX(String formalDataSource, String realDataSource, String service, Map<String, Object> params, String proxy_user) {
        return MetaSchemaUtil.callService((String)formalDataSource, (String)realDataSource, (String)service, params, (String)proxy_user);
    }

    public List<Map<String, Object>> executeEntityQuery(String cn_number, String entity, String requireStr, List<Map<String, Object>> filter, List<Map<String, String>> orderBy) {
        SimpleFC.visitByKey((String)TPS_KEY);
        long dbLink = this.queryConnIdByNumber(cn_number);
        return this.innerExecuteEntityQuery(dbLink, entity, requireStr, filter, orderBy);
    }

    public List<Map<String, Object>> executeEntityQuery(long metaSchemaId, String requires, List<Map<String, Object>> filter, List<Map<String, String>> orderBy) {
        SimpleFC.visitByKey((String)TPS_KEY);
        DynamicObject meta = this.getMeta(metaSchemaId);
        long dbLink = this.getDbLink(meta);
        String entity = D.s((Object)meta.get("full_name"));
        return this.innerExecuteEntityQuery(dbLink, entity, requires, filter, orderBy);
    }

    public List<Map<String, Object>> executeTableQuery(String cn_number, String tableName, String requireStr, List<Map<String, Object>> filter, List<Map<String, String>> orderBy) {
        SimpleFC.visitByKey((String)TPS_KEY);
        long dbLink = this.queryConnIdByNumber(cn_number);
        return this.innerExecuteTableQuery(dbLink, tableName, requireStr, filter, orderBy);
    }

    public List<Map<String, Object>> executeTableQuery(long metaSchemaId, String requires, List<Map<String, Object>> filter, List<Map<String, String>> orderBy) {
        SimpleFC.visitByKey((String)TPS_KEY);
        DynamicObject meta = this.getMeta(metaSchemaId);
        long dbLink = this.getDbLink(meta);
        String tableName = D.s((Object)meta.get("table_name"));
        return this.innerExecuteTableQuery(dbLink, tableName, requires, filter, orderBy);
    }

    public List<Map<String, Object>> executeSqlQuery(String cn_number, String sql, List<Object> values, List<Integer> types) {
        SimpleFC.visitByKey((String)TPS_KEY);
        try (ConnectionWrapper cn = ConnectionManager.getConnection((long)this.queryConnIdByNumber(cn_number));){
            List<Map<String, Object>> list = this.innerQueryList(sql, values, types, cn);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Map<String, Object>> innerExecuteEntityQuery(long dbLink, String entity, String requireStr, List<Map<String, Object>> filter, List<Map<String, String>> orderBy) {
        Map<String, Object> requires = this.buildRequireMap(requireStr);
        Throwable throwable = null;
        try (ConnectionWrapper cn = ConnectionManager.getConnection((long)dbLink);){
            List<Map<String, Object>> list;
            ObjectReader reader = ConnectionManager.query((ConnectionWrapper)cn, (String)entity, requires, filter, orderBy);
            try {
                list = this.toList((ObjectReader<Map<String, Object>>)reader);
            }
            catch (Throwable throwable2) {
                try {
                    DbUtil.close((ObjectReader)reader);
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            DbUtil.close((ObjectReader)reader);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Map<String, Object>> innerQueryList(String sql, List<Object> values, List<Integer> types, ConnectionWrapper cn) {
        ObjectReader reader = cn.executeQuery(sql, values == null ? Collections.emptyList() : values, types == null ? Collections.emptyList() : types);
        try {
            List<Map<String, Object>> list = this.dataRowsToList((ObjectReader<DataRow>)reader);
            return list;
        }
        finally {
            DbUtil.close((ObjectReader)reader);
        }
    }

    private List<Map<String, Object>> innerExecuteTableQuery(long dbLink, String tableName, String requireStr, List<Map<String, Object>> filter, List<Map<String, String>> orderBy) {
        try (ConnectionWrapper cn = ConnectionManager.getConnection((long)dbLink);){
            Table schema = ConnectionManager.getTable((ConnectionWrapper)cn, (String)tableName);
            ArrayList<Integer> types = new ArrayList<Integer>();
            ArrayList<Object> values = new ArrayList<Object>();
            String where = this.createWhere(schema, filter, types, values);
            String sort = this.createOrderBy(schema, orderBy);
            String sql = this.prepareQuerySQL(schema.getQuotedName(), requireStr, where, sort);
            List<Map<String, Object>> list = this.innerQueryList(sql, values, types, cn);
            return list;
        }
    }

    private DynamicObject getMeta(long metaSchemaId) {
        DynamicObject meta = MetaDataSchema.get((long)metaSchemaId);
        if (meta == null) {
            String info = String.format(ResManager.loadKDString((String)"\u6839\u636eid\u3010%s\u3011\u627e\u4e0d\u5230\u96c6\u6210\u5bf9\u8c61", (String)"IscMetaSchemaServiceImpl_0", (String)"isc-api-msservice", (Object[])new Object[0]), metaSchemaId);
            throw new IscBizException(info);
        }
        return meta;
    }

    private long getDbLink(DynamicObject meta) {
        long groupId = D.l((Object)meta.getLong("group_id"));
        if (groupId == 0L) {
            throw new IscBizException(ResManager.loadKDString((String)"\u96c6\u6210\u5bf9\u8c61\u7684\u6570\u636e\u6e90\u4e3a\u7a7a", (String)"IscMetaSchemaServiceImpl_1", (String)"isc-api-msservice", (Object[])new Object[0]));
        }
        DataSource dataSource = DataSource.get((long)groupId);
        long dbLink = dataSource.getDbLink();
        if (dbLink == 0L) {
            throw new IscBizException(ResManager.loadKDString((String)"\u96c6\u6210\u5bf9\u8c61\u7684\u6570\u636e\u6e90\u672a\u914d\u7f6e\u8fde\u63a5\u914d\u7f6e", (String)"IscMetaSchemaServiceImpl_2", (String)"isc-api-msservice", (Object[])new Object[0]));
        }
        return dbLink;
    }

    private String createOrderBy(Table schema, List<Map<String, String>> orderBy) {
        StringBuilder sort = new StringBuilder();
        if (!CollectionUtils.isEmpty(orderBy)) {
            for (Map<String, String> item : orderBy) {
                if (sort.length() > 0) {
                    sort.append(", ");
                }
                String sortField = item.get("sort_field");
                String sortMode = item.get("sort_mode");
                Column field = schema.getField(sortField);
                sort.append(field.getBinding());
                sort.append(' ');
                sort.append(sortMode);
            }
        }
        return sort.toString();
    }

    private String createWhere(Table schema, List<Map<String, Object>> filter, List<Integer> types, List<Object> values) {
        StringBuilder where = new StringBuilder();
        if (!CollectionUtils.isEmpty(filter)) {
            for (int i = 0; i < filter.size(); ++i) {
                Map<String, Object> item = filter.get(i);
                this.appendFilterItem(schema, types, values, where, item);
                if (i >= filter.size() - 1) continue;
                where.append("OR".equals(item.get("filter_link")) ? " OR " : " AND ");
            }
        }
        return where.toString();
    }

    private void appendFilterItem(Table schema, List<Integer> types, List<Object> values, StringBuilder where, Map<String, Object> item) {
        where.append(this.trim(item.get("filter_left_bracket")));
        Column field = this.getColumn(schema, item);
        where.append(field.getBinding());
        Object value = item.get("filter_value");
        if (value instanceof List) {
            this.handleListTypeParam(where, values, field, (List)value, types, D.s((Object)item.get("filter_compare")));
        } else {
            CommonUtil.filterCompareHandle((StringBuilder)where, values, item, (Column)field, (Object)value, types);
        }
        where.append(this.trim(item.get("filter_right_bracket")));
    }

    private String trim(Object value) {
        String s = D.s((Object)value);
        if (s == null) {
            return "";
        }
        return s;
    }

    private Column getColumn(Table schema, Map<String, Object> item) {
        String filterColumn = D.s((Object)item.get("filter_column"));
        return schema.getField(filterColumn);
    }

    private void handleListTypeParam(StringBuilder filter, List<Object> values, Column field, List<?> list, List<Integer> types, String filter_compare) {
        String com = "not in".equalsIgnoreCase(filter_compare) ? "not in" : "in";
        filter.append(com);
        filter.append(" (");
        for (int i = 0; i < list.size(); ++i) {
            if (i > 0) {
                filter.append(',');
            }
            filter.append('?');
            types.add(field.getSqlType());
            values.add(field.toSqlParam(list.get(i)));
        }
        filter.append(')');
    }

    private String prepareQuerySQL(String table, String select, String where, String sort) {
        StringBuilder sb = new StringBuilder();
        sb.append("select ");
        sb.append(select);
        sb.append(" from ");
        sb.append(table);
        if (where.length() > 0) {
            sb.append(" where ");
            sb.append(where);
        }
        if (sort.length() > 0) {
            sb.append(" order by ");
            sb.append(sort);
        }
        return sb.toString();
    }

    private List<Map<String, Object>> toList(ObjectReader<Map<String, Object>> reader) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        int totalBytes = 0;
        Map item = (Map)reader.read();
        while (item != null) {
            totalBytes = (int)((long)totalBytes + DbUtil.getObjectSize((Object)item));
            this.check(totalBytes, list.size());
            list.add(item);
            item = (Map)reader.read();
        }
        return list;
    }

    private Map<String, Object> buildRequireMap(String requireStr) {
        if (requireStr == null) {
            throw new IscBizException(ResManager.loadKDString((String)"\u5fc5\u987b\u6307\u5b9a\u67e5\u8be2\u5b57\u6bb5", (String)"IscMetaSchemaServiceImpl_3", (String)"isc-api-msservice", (Object[])new Object[0]));
        }
        String[] selectors = requireStr.split(",");
        if (selectors.length == 0) {
            throw new IscBizException(ResManager.loadKDString((String)"\u5fc5\u987b\u6307\u5b9a\u67e5\u8be2\u5b57\u6bb5", (String)"IscMetaSchemaServiceImpl_3", (String)"isc-api-msservice", (Object[])new Object[0]));
        }
        TreeMap<String, Object> requires = new TreeMap<String, Object>();
        for (String selector : selectors) {
            String prop = D.s((Object)selector);
            if (prop == null) continue;
            this.innerAddProp(requires, prop);
        }
        return requires;
    }

    private void innerAddProp(Map<String, Object> requires, String prop) {
        if (prop.indexOf(46) < 0) {
            requires.put(prop, 1);
        } else {
            String[] path = prop.split("\\.");
            SQLUtil.addEntryProperty(requires, (String[])path);
        }
    }

    private List<Map<String, Object>> dataRowsToList(ObjectReader<DataRow> reader) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        int totalBytes = 0;
        DataRow item = (DataRow)reader.read();
        while (item != null) {
            this.check(totalBytes += DbUtil.calcBytes((DataRow)item), list.size());
            list.add(item.toMap());
            item = (DataRow)reader.read();
        }
        return list;
    }

    private void check(long totalBytes, int listSize) {
        int maxSize = QueryList.getResultSetMaxSize();
        if (totalBytes > (long)maxSize) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u7ed3\u679c\u8d85\u8fc7\u4e86\u201c%s\u201d\u5b57\u8282\uff0c\u6b64\u63aa\u65bd\u662f\u4e3a\u4e86\u9650\u5236\u67e5\u8be2\u7ed3\u679c\u96c6\u7684\u5927\u5c0f\u4ee5\u964d\u4f4e\u7cfb\u7edfOOM\u7684\u98ce\u9669\u3002\u5efa\u8bae\u89e3\u51b3\u529e\u6cd5\uff1a\u8c03\u6574\u4e1a\u52a1\u5b9e\u73b0\u4e3a\u5206\u6279\u5904\u7406\u907f\u514d\u4e00\u6b21\u67e5\u8be2\u592a\u591a\u6570\u636e\uff0c\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u8c03\u6574JVM\u7cfb\u7edf\u53c2\u6570 ISC_QUERY_MAX_SIZE \u63d0\u9ad8\u4e0a\u9650\u3002", (String)"IscMetaSchemaServiceImpl_5", (String)"isc-api-msservice", (Object[])new Object[0]), maxSize));
        }
        if (listSize > 10000) {
            throw new IscBizException(ResManager.loadKDString((String)"\u5fae\u670d\u52a1\u67e5\u8be2\u7684\u7ed3\u679c\u96c6\u884c\u6570\u6700\u5927\u4e3a10000\u884c\uff0c\u6b64\u63aa\u65bd\u662f\u4e3a\u4e86\u9650\u5236\u67e5\u8be2\u7ed3\u679c\u96c6\u7684\u5927\u5c0f\u4ee5\u964d\u4f4e\u7cfb\u7edfOOM\u7684\u98ce\u9669\u3002\u5efa\u8bae\u89e3\u51b3\u529e\u6cd5\uff1a\u8c03\u6574\u4e1a\u52a1\u5b9e\u73b0\u4e3a\u8c03\u6574\u8fc7\u6ee4\u6761\u4ef6\u6216\u5206\u6279\u5904\u7406\u907f\u514d\u4e00\u6b21\u67e5\u8be2\u592a\u591a\u6570\u636e\u3002", (String)"IscMetaSchemaServiceImpl_6", (String)"isc-api-msservice", (Object[])new Object[0]));
        }
    }

    private long queryConnIdByNumber(String cn_number) {
        DynamicObject connection = ConnectionConfig.getByNumber((String)cn_number);
        if (connection == null) {
            String info = String.format(ResManager.loadKDString((String)"\u6839\u636e\u7f16\u7801\u3010%s\u3011\u65e0\u6cd5\u627e\u5230\u8fde\u63a5\u914d\u7f6e", (String)"IscMetaSchemaServiceImpl_7", (String)"isc-api-msservice", (Object[])new Object[0]), cn_number);
            throw new IscBizException(info);
        }
        return D.l((Object)connection.get("id"));
    }

    static {
        int maxTps = D.i((Object)System.getProperty(TPS_KEY, "32"));
        SimpleFC.setMaxTpsByKey((String)TPS_KEY, (int)maxTps);
    }
}

