/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.opplugin.api;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.ShowStackTraceUtil;
import kd.isc.iscb.platform.core.api.openapi.OpenApi;
import kd.isc.iscb.platform.core.apis.ApiInvokeStat;
import kd.isc.iscb.platform.core.apis.ApiState;
import kd.isc.iscb.platform.core.cache.CacheableObjectManager;

public class CommonApiOp
extends AbstractOperationServicePlugIn {
    private static final String OPENAPI_APILIST = "openapi_apilist";
    private static final String NUMBER = "number";
    private static final String ENABLE = "enable";
    private static final String DISABLE = "disable";
    private static final String DELETE = "delete";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("not_publish");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        String operationKey = e.getOperationKey();
        try {
            this.executeOperation(e, operationKey);
        }
        catch (Exception ex) {
            e.setCancel(true);
            e.setCancelMessage(ShowStackTraceUtil.getErrorMsg((Throwable)ex));
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        CacheableObjectManager.clearCache();
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        String operationKey = e.getOperationKey();
        if (operationKey.equals(DELETE) || operationKey.equals(ENABLE) || operationKey.equals(DISABLE)) {
            DynamicObject[] dataEntities;
            for (DynamicObject apiObject : dataEntities = e.getDataEntities()) {
                ApiInvokeStat.createOrUpdateInvokeStat((DynamicObject)apiObject, (ApiState)ApiState.valueOf((String)operationKey));
            }
        }
    }

    private void executeOperation(BeforeOperationArgs e, String operationKey) {
        DynamicObject[] dataEntities = e.getDataEntities();
        if (ENABLE.equals(operationKey)) {
            this.enable(dataEntities);
        } else if (DISABLE.equals(operationKey)) {
            this.disable(dataEntities);
        } else if (DELETE.equals(operationKey)) {
            this.delete(dataEntities);
        }
    }

    private void delete(DynamicObject[] objects) {
        for (DynamicObject api : objects) {
            api = BusinessDataServiceHelper.loadSingle((Object)api.getPkValue(), (String)api.getDataEntityType().getName());
            OpenApi openApi = new OpenApi(api);
            openApi.delete();
        }
    }

    private void enable(DynamicObject[] objects) {
        for (DynamicObject api : objects) {
            if ((api = BusinessDataServiceHelper.loadSingle((Object)api.getPkValue(), (String)api.getDataEntityType().getName())).getBoolean("not_publish")) continue;
            OpenApi openApi = new OpenApi(api);
            openApi.buildOpenApiAndSave();
        }
    }

    private void disable(DynamicObject[] objects) {
        for (DynamicObject api : objects) {
            api = BusinessDataServiceHelper.loadSingle((Object)api.getPkValue(), (String)api.getDataEntityType().getName());
            OpenApi openApi = new OpenApi(api);
            openApi.disable();
        }
    }
}

