/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.opplugin.dc;

import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.isc.iscb.platform.core.util.CollectionUtils;
import kd.isc.iscb.platform.core.util.CommonUtil;
import kd.isc.iscb.util.dt.D;

public class DataCopyTriggerDeleteOp
extends AbstractOperationServicePlugIn {
    private static final String OP_DELETE = "delete";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("enable");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        String original = "isc_bill_log_relation,isc_data_copy_exec_log,isc_data_copy_execution,isc_data_copy_taskstage";
        String variables = D.s(this.getOption().getVariables().get("ignorerefentityids"));
        if (variables != null) {
            original = original + "," + variables;
        }
        this.getOption().setVariableValue("ignorerefentityids", original);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        if (OP_DELETE.equals(e.getOperationKey()) || "batch_delete".equals(e.getOperationKey())) {
            for (DynamicObject trigger : e.getDataEntities()) {
                this.deleteRelations(trigger);
            }
        }
    }

    private void deleteRelations(DynamicObject trigger) {
        try (TXHandle handler = TX.requiresNew();){
            Object pkValue = trigger.getPkValue();
            DataCopyTriggerDeleteOp.delete("isc_bill_log_relation", new QFilter[]{new QFilter("trigger", "=", pkValue)});
            DataCopyTriggerDeleteOp.delete("isc_data_copy_exec_log", new QFilter[]{new QFilter("data_copy_trigger", "=", pkValue)});
            DataCopyTriggerDeleteOp.delete("isc_data_copy_execution", new QFilter[]{new QFilter("data_copy_trigger", "=", pkValue)});
            this.deleteByDB("isc_data_copy_taskstage", new QFilter[]{new QFilter("data_trigger", "=", pkValue)});
        }
        try (TXHandle txHandle = TX.requiresNew();){
            trigger = BusinessDataServiceHelper.loadSingle((Object)trigger.getPkValue(), (String)"isc_data_copy_trigger");
            if ("auto".equalsIgnoreCase(trigger.getString("trigger_type"))) {
                DataCopyTriggerDeleteOp.deleteJob(trigger);
            }
        }
    }

    private void deleteByDB(String entity, QFilter[] data_triggers) {
        DeleteServiceHelper.delete((String)entity, (QFilter[])data_triggers);
    }

    public static void delete(String entity, QFilter[] filters) {
        List pks = QueryServiceHelper.queryPrimaryKeys((String)entity, (QFilter[])filters, null, (int)Integer.MAX_VALUE);
        if (CollectionUtils.isEmpty((Collection)pks)) {
            return;
        }
        OperationResult result = OperationServiceHelper.executeOperate((String)OP_DELETE, (String)entity, (Object[])pks.toArray(), (OperateOption)OperateOption.create());
        CommonUtil.check((OperationResult)result);
    }

    public static void deleteIgnoreReference(String entity, QFilter[] filters, String ignoreIds) {
        List pks = QueryServiceHelper.queryPrimaryKeys((String)entity, (QFilter[])filters, null, (int)Integer.MAX_VALUE);
        if (CollectionUtils.isEmpty((Collection)pks)) {
            return;
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("checkrefentityids", ignoreIds);
        OperationResult result = OperationServiceHelper.executeOperate((String)OP_DELETE, (String)entity, (Object[])pks.toArray(), (OperateOption)option);
        CommonUtil.check((OperationResult)result);
    }

    private static void deleteJob(DynamicObject trigger) {
        String scheduleId = D.s((Object)trigger.get("job_schedule_id"));
        String jobId = D.s((Object)trigger.get("job_define_id"));
        ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        if (scheduleId != null) {
            scheduleManager.disableSchedule(scheduleId);
        }
        if (jobId != null) {
            scheduleManager.disableJob(jobId);
        }
        if (scheduleId != null) {
            DataCopyTriggerDeleteOp.deleteIgnoreReference("sch_schedule", new QFilter[]{new QFilter("id", "=", (Object)scheduleId)}, "all");
        }
        if (jobId != null) {
            DataCopyTriggerDeleteOp.deleteIgnoreReference("sch_job", new QFilter[]{new QFilter("id", "=", (Object)jobId)}, "all");
        }
    }
}

