/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.opplugin.ext;

import java.sql.Timestamp;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.isc.iscb.opplugin.ext.AbstractEnableDisableOp;
import kd.isc.iscb.platform.core.connector.self.ExecutionData;
import kd.isc.iscb.platform.core.ext.InterfaceCenterUtil;
import kd.isc.iscb.util.except.IscBizException;

public class ExtCnConfigEnableOp
extends AbstractEnableDisableOp {
    @Override
    public void beforePublish(DynamicObject icObject, DynamicObject iscObject) {
        this.checkDuplicateNumber(icObject);
        this.setDataBaseType(icObject);
        this.copyObjectFromIc2Isc(icObject, iscObject);
    }

    private void copyObjectFromIc2Isc(DynamicObject icObj, DynamicObject iscObj) {
        DataEntityPropertyCollection properties = iscObj.getDataEntityType().getProperties();
        DataEntityPropertyCollection icProperties = icObj.getDataEntityType().getProperties();
        for (IDataEntityProperty property : properties) {
            String propertyName = property.getName();
            if ("multilanguagetext".equals(propertyName) || !icProperties.containsKey((Object)propertyName)) continue;
            if (propertyName.equals("name")) {
                iscObj.set(propertyName, (Object)icObj.getString(propertyName));
                continue;
            }
            iscObj.set(propertyName, icObj.get(propertyName));
        }
    }

    private void checkDuplicateNumber(DynamicObject icObj) {
        String number = icObj.getString("number");
        if (InterfaceCenterUtil.checkDuplicateNumber((String)"t_isc_database_link", (String)icObj.getString("id"), (String)number)) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58%s:\u7f16\u7801\u5728\u3010\u96c6\u6210\u7ba1\u7406\u3011->\u3010\u8fde\u63a5\u7ba1\u7406\u3011->\u3010\u8fde\u63a5\u914d\u7f6e\u3011\u4e2d\u5df2\u5b58\u5728", (String)"ExtCnConfigEnableOp_0", (String)"isc-iscb-platform-opplugin", (Object[])new Object[0]), number));
        }
    }

    private void setDataBaseType(DynamicObject icObj) {
        String database_type_id = icObj.getString("database_type_id");
        if (database_type_id == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u64cd\u4f5c\u7684\u8fde\u63a5\u914d\u7f6e\u6ca1\u6709\u3010\u8fde\u63a5\u7c7b\u578b\u3011\u53c2\u6570\u3002", (String)"ExtCnConfigEnableOp_2", (String)"isc-iscb-platform-opplugin", (Object[])new Object[0]));
        }
        DynamicObject cnType = BusinessDataServiceHelper.loadSingle((String)"isc_connection_type_x", (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)database_type_id)});
        if (cnType == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u3010\u8fde\u63a5\u914d\u7f6e\u3011\u5f15\u7528\u7684\u3010\u8fde\u63a5\u7c7b\u578b\u3011\u4e0d\u5b58\u5728\u3002", (String)"ExtCnConfigEnableOp_3", (String)"isc-iscb-platform-opplugin", (Object[])new Object[0]));
        }
        icObj.set("database_type", (Object)cnType.getString("number"));
    }

    @Override
    public void beforeDisable(DynamicObject dynamicObject) {
        dynamicObject.set("server_ip", (Object)"******");
        dynamicObject.set("name", (Object)String.format(ResManager.loadKDString((String)"[\u7981\u7528] %s", (String)"ExtCnConfigEnableOp_4", (String)"isc-iscb-platform-opplugin", (Object[])new Object[0]), dynamicObject.getString("name")));
    }

    @Override
    public void publish2Isc(DynamicObject icObj, DynamicObject iscObject, String iscEntity) {
        try (TXHandle handler = TX.requiresNew();){
            this.publishCnConfig2Isc(icObj, iscObject, iscEntity);
            this.publishDataSource2Isc(icObj);
        }
    }

    private void publishCnConfig2Isc(DynamicObject icObj, DynamicObject iscObject, String iscEntity) {
        List<String> actions = this.getOperationType(icObj, iscEntity);
        for (int i = 0; i < actions.size(); ++i) {
            Object id = ExecutionData.execute((String)iscEntity, (DynamicObject)iscObject, (String)actions.get(i));
            if (id == null || i >= actions.size() - 1) continue;
            iscObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)iscEntity);
        }
    }

    private void publishDataSource2Isc(DynamicObject icObj) {
        DynamicObject dataSource;
        long id = icObj.getLong("id");
        if (QueryServiceHelper.exists((String)"isc_data_source", (Object)id)) {
            dataSource = BusinessDataServiceHelper.loadSingle((Object)id, (String)"isc_data_source");
        } else {
            dataSource = BusinessDataServiceHelper.newDynamicObject((String)"isc_data_source");
            dataSource.set("id", (Object)id);
            dataSource.set("createtime", (Object)new Timestamp(System.currentTimeMillis()));
            dataSource.set("creator", (Object)RequestContext.get().getUserId());
        }
        dataSource.set("number", (Object)icObj.getString("number"));
        dataSource.set("name", (Object)icObj.getString("name"));
        dataSource.set("status", (Object)"C");
        dataSource.set("enable", (Object)"1");
        dataSource.set("modifier", (Object)RequestContext.get().getUserId());
        dataSource.set("modifytime", (Object)new Timestamp(System.currentTimeMillis()));
        dataSource.set("dblink", (Object)id);
        dataSource.set("connection_type", (Object)icObj.getString("database_type"));
        dataSource.set("preset", (Object)"1");
        OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"isc_data_source", (DynamicObject[])new DynamicObject[]{dataSource}, (OperateOption)OperateOption.create());
        if (!result.isSuccess()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u3010\u8fde\u63a5\u7ba1\u7406\u3011->\u3010\u6570\u636e\u6e90\u7ba1\u7406\u3011\uff1a%s", (String)"ExtCnConfigEnableOp_6", (String)"isc-iscb-platform-opplugin", (Object[])new Object[0]), InterfaceCenterUtil.getErrorMessage((OperationResult)result)));
        }
    }
}

