/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.opplugin.ext;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.isc.iscb.opplugin.ext.AbstractEnableDisableOp;
import kd.isc.iscb.platform.core.connector.self.ExecutionData;
import kd.isc.iscb.platform.core.ext.InterfaceCenterUtil;
import kd.isc.iscb.util.except.IscBizException;

public class ExtScriptApiEnableOp
extends AbstractEnableDisableOp {
    @Override
    public void beforePublish(DynamicObject icObj, DynamicObject iscObj) {
        this.checkDuplicateNumber(icObj);
        this.setResCategory(icObj);
        this.copyObjectFromIc2Isc(icObj, iscObj);
    }

    private void checkDuplicateNumber(DynamicObject icObj) {
        String number = icObj.getString("number");
        if (InterfaceCenterUtil.checkDuplicateNumber((String)"t_iscb_apic_script", (String)icObj.getString("id"), (String)number)) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58%s:\u7f16\u7801\u5728\u3010\u96c6\u6210\u7ba1\u7406\u3011->\u3010\u81ea\u5b9a\u4e49API\u3011\u4e2d\u5df2\u5b58\u5728", (String)"ExtScriptApiEnableOp_0", (String)"isc-iscb-platform-opplugin", (Object[])new Object[0]), number));
        }
    }

    private void setResCategory(DynamicObject icObj) {
        DynamicObjectCollection resources = icObj.getDynamicObjectCollection("resources");
        for (DynamicObject resource : resources) {
            String res_category = resource.getString("res_category");
            if (!"isc_cn_config".equals(res_category)) continue;
            resource.set("res_category", (Object)"isc_data_source");
        }
    }

    private void copyObjectFromIc2Isc(DynamicObject icObj, DynamicObject iscObj) {
        DataEntityPropertyCollection iscEntityProperties = iscObj.getDataEntityType().getProperties();
        DataEntityPropertyCollection icProperties = icObj.getDataEntityType().getProperties();
        for (IDataEntityProperty entityProperty : iscEntityProperties) {
            String entityPropertyName = entityProperty.getName();
            if ("multilanguagetext".equals(entityPropertyName) || !icProperties.containsKey((Object)entityPropertyName)) continue;
            Object o = icObj.get(entityPropertyName);
            if (o instanceof OrmLocaleValue) {
                iscObj.set(entityPropertyName, (Object)icObj.getString(entityPropertyName));
                continue;
            }
            if (o instanceof DynamicObjectCollection) {
                iscObj.set(entityPropertyName, (Object)this.getIscEntries(entityPropertyName, icObj, iscObj));
                continue;
            }
            iscObj.set(entityPropertyName, icObj.get(entityPropertyName));
        }
    }

    private DynamicObjectCollection getIscEntries(String entityPropertyName, DynamicObject icObj, DynamicObject iscObj) {
        DynamicObjectCollection iscEnters = iscObj.getDynamicObjectCollection(entityPropertyName);
        DataEntityPropertyCollection iscEntryProperties = iscEnters.getDynamicObjectType().getProperties();
        iscEnters.clear();
        DynamicObjectCollection icEnters = icObj.getDynamicObjectCollection(entityPropertyName);
        DataEntityPropertyCollection icEntryProperties = icEnters.getDynamicObjectType().getProperties();
        for (DynamicObject icEntry : icEnters) {
            this.setProperties(iscEnters, iscEntryProperties, icEntryProperties, icEntry);
        }
        return iscEnters;
    }

    private void setProperties(DynamicObjectCollection iscEnters, DataEntityPropertyCollection iscEntryProperties, DataEntityPropertyCollection icEntryProperties, DynamicObject icEntry) {
        DynamicObject iscEntry = iscEnters.addNew();
        for (IDataEntityProperty iscProperties : iscEntryProperties) {
            String entryPropertiesName = iscProperties.getName();
            if (!icEntryProperties.containsKey((Object)entryPropertiesName)) continue;
            Object value = icEntry.get(entryPropertiesName);
            if (value instanceof DynamicObject) {
                this.setBaseData(iscEntry, entryPropertiesName, (DynamicObject)value);
                continue;
            }
            iscEntry.set(entryPropertiesName, value);
        }
    }

    private void setBaseData(DynamicObject iscEntry, String entryPropertiesName, DynamicObject value) {
        long cn_config_id = value.getLong("id");
        if (!QueryServiceHelper.exists((String)"isc_data_source", (Object)cn_config_id)) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\uff1a%s\u7684\u6570\u636e\u6e90\u6ca1\u6709\u53d1\u5e03\u5230\u96c6\u6210\u7ba1\u7406\uff0c\u8bf7\u901a\u8fc7\u542f\u7528\u7b2c\u4e09\u65b9\u63a5\u53e3\u7684\u5916\u90e8\u7cfb\u7edf\u53d1\u5e03\u6570\u636e\u3002", (String)"ExtScriptApiEnableOp_2", (String)"isc-iscb-platform-opplugin", (Object[])new Object[0]), value.getString("number")));
        }
        iscEntry.set(entryPropertiesName + "_id", (Object)cn_config_id);
    }

    @Override
    public void publish2Isc(DynamicObject icObj, DynamicObject iscObject, String iscEntity) {
        List<String> actions = this.getOperationType(icObj, iscEntity);
        for (String action : actions) {
            ExecutionData.execute((String)iscEntity, (DynamicObject)iscObject, (String)action);
        }
    }
}

