/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.opplugin.ext;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.isc.iscb.opplugin.ext.AbstractEnableDisableOp;
import kd.isc.iscb.platform.core.ext.InterfaceCenterUtil;

public class InterfaceCenterDataDeleteOp
extends AbstractOperationServicePlugIn {
    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        String entityName = dataEntities[0].getDataEntityType().getName();
        if ("delete".equals(e.getOperationKey())) {
            this.deleteIscData(e, dataEntities, entityName);
        }
    }

    private void deleteIscData(BeforeOperationArgs e, DynamicObject[] dataEntities, String entityName) {
        String entity = AbstractEnableDisableOp.getEntity(entityName);
        if (null != entity) {
            int length = dataEntities.length;
            ArrayList<Object> icIds = new ArrayList<Object>(length);
            for (DynamicObject dataEntity : dataEntities) {
                icIds.add(dataEntity.getPkValue());
            }
            if (icIds.size() < 1) {
                return;
            }
            if (entity.equals("isc_database_link")) {
                this.executeDelete(e, icIds, "isc_data_source");
            }
            this.executeDelete(e, icIds, entity);
        }
    }

    private void executeDelete(BeforeOperationArgs e, List<Object> icIds, String entity) {
        QFilter filter = new QFilter("id", "in", icIds);
        List iscIds = QueryServiceHelper.queryPrimaryKeys((String)entity, (QFilter[])new QFilter[]{filter}, null, (int)icIds.size());
        if (iscIds.size() < 1) {
            return;
        }
        OperationResult result = OperationServiceHelper.executeOperate((String)"delete", (String)entity, (Object[])iscIds.toArray(), (OperateOption)OperateOption.create());
        if (!result.isSuccess()) {
            String message = InterfaceCenterUtil.getErrorMessage((OperationResult)result);
            OperateErrorInfo info = new OperateErrorInfo("", ErrorLevel.Error, (Object)"");
            info.setMessage(String.format(ResManager.loadKDString((String)"\u96c6\u6210\u7ba1\u7406\uff1a%s", (String)"InterfaceCenterDataDeleteOp_0", (String)"isc-iscb-platform-opplugin", (Object[])new Object[0]), message));
            this.operationResult.addErrorInfo(info);
            e.setCancel(true);
        }
    }
}

