/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.opplugin.job;

import java.util.UUID;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.isc.iscb.platform.core.job.c.JobMutexLoader;
import kd.isc.iscb.platform.core.task.LightTask;
import kd.isc.iscb.platform.core.task.ScheduleManager;
import kd.isc.iscb.platform.core.task.Task;

public class JobMutexSaveOp
extends AbstractOperationServicePlugIn {
    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        for (DynamicObject o : e.getDataEntities()) {
            DynamicObjectCollection c = o.getDynamicObjectCollection("instances");
            if ("LOCAL".equals(o.get("scope"))) {
                c.clear();
                continue;
            }
            int maxThreads = o.getInt("max_threads");
            while (c.size() < maxThreads) {
                c.addNew();
            }
            while (c.size() > maxThreads) {
                c.remove(c.size() - 1);
            }
            int seq = 0;
            for (DynamicObject i : c) {
                i.set("seq", (Object)(++seq));
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        ScheduleManager.submit((Task)new LightTask(){
            private final String id = UUID.randomUUID().toString();

            public void run() {
                JobMutexLoader.refreshAll();
            }

            public String getId() {
                return this.id;
            }
        }, (int)1);
    }
}

