/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.opplugin.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.ShortMessageInfo;
import kd.bos.servicehelper.message.MessageServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.StringUtils;

public class SendMsgUtil {
    private static Log log = LogFactory.getLog(SendMsgUtil.class);
    private static final String ISC_DATA_COPY_EXECUTION = "isc_data_copy_execution";

    public static String getStrContainData(DynamicObject log, String str, String start, String end, boolean isSpecial) {
        String result = "";
        if (isSpecial) {
            start = "\\" + start;
            end = "\\" + end;
        }
        String regex = start + "(.*?)" + end;
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(str);
        String value = "";
        while (matcher.find()) {
            String key = matcher.group(1);
            if (key.contains(start) || key.contains(end)) continue;
            value = log.getString(key) == null ? " " : log.getString(key);
            str = str.replaceAll("\\{" + key + "\\}", value);
        }
        result = str.trim();
        if (result.length() > 2000) {
            result = result.substring(0, 2000);
        }
        return result;
    }

    public static String getUrlInfo(String pkId) {
        StringBuilder url = new StringBuilder();
        String domain = UrlService.getDomainContextUrl();
        url.append(domain).append("formId=isc_data_copy_execution&formId=isc_data_copy_execution&pkId=").append(pkId).append("#/dform?formId=").append(ISC_DATA_COPY_EXECUTION).append("&pkId=").append(pkId);
        return url.toString();
    }

    public static void sendShortMesagge(String personInfo, String content) {
        if (StringUtils.isEmpty((String)personInfo)) {
            return;
        }
        try {
            ShortMessageInfo shortMessageInfo = new ShortMessageInfo();
            shortMessageInfo.setMessage(content);
            ArrayList phones = new ArrayList();
            String[] persons = personInfo.split(";");
            Arrays.asList(persons).forEach(person -> phones.add(person.split(",")[1]));
            shortMessageInfo.setPhone(phones);
            log.info(String.format("\u77ed\u4fe1\u670d\u52a1\uff1a\u53d1\u9001\u6d88\u606f:message:%s,phones:%s", content, phones));
            MessageServiceHelper.sendShortMessage((ShortMessageInfo)shortMessageInfo);
            log.info(String.format("[%s-%s]\u53d1\u9001\u77ed\u4fe1\u6d88\u606f\u6210\u529f", RequestContext.get().getTraceId(), shortMessageInfo.getMessage()));
        }
        catch (Throwable e) {
            log.warn("\u77ed\u4fe1\u670d\u52a1\u53d1\u9001\u77ed\u4fe1\u5931\u8d25:" + e.getMessage());
        }
    }
}

