/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.email;

import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.connector.ConnectionFactory;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.email.EmailUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Json2;
import kd.isc.iscb.util.misc.StringUtil;

public class SmtpConnectionWrapper
extends ConnectionWrapper {
    private static final String DEFAULT_CHARSET = "utf-8";
    private static final int DEFAULT_TIMEOUT = 3000;
    private static final String PROTOCOL = "smtp";

    public SmtpConnectionWrapper(ConnectionFactory factory, DynamicObject cfg) {
        super(factory, cfg);
    }

    public void test() {
        Transport ts = null;
        DynamicObject cfg = this.getConfig();
        Session session = EmailUtil.getSession(this.getProps(), cfg);
        try {
            ts = session.getTransport();
            ts.connect();
        }
        catch (MessagingException e) {
            throw new IscBizException(ResManager.loadKDString((String)"\u90ae\u4ef6\u8fde\u63a5\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a", (String)"SmtpConnectionWrapper_test", (String)"isc-iscb-connector-email", (Object[])new Object[0]), (Throwable)e);
        }
        finally {
            this.closeTransport(ts);
        }
    }

    public boolean send(Map<String, Object> toEmailMap, Map<String, String> billMap) {
        DynamicObject cfg = this.getConfig();
        Session session = EmailUtil.getSession(this.getProps(), cfg);
        Transport ts = null;
        try {
            MimeMessage message = this.buildMessage(session, toEmailMap, billMap);
            ts = session.getTransport();
            ts.connect(cfg.getString("user"), cfg.getString("newpwd"));
            ts.sendMessage((Message)message, message.getAllRecipients());
            boolean bl = true;
            this.closeTransport(ts);
            return bl;
        }
        catch (MessagingException e) {
            try {
                throw new IscBizException(ResManager.loadKDString((String)"\u90ae\u4ef6\u53d1\u9001\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a", (String)"SmtpConnectionWrapper_send", (String)"isc-iscb-connector-email", (Object[])new Object[0]), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.closeTransport(ts);
                throw throwable;
            }
        }
    }

    private MimeMessage buildMessage(Session session, Map<String, Object> toEmailMap, Map<String, String> billMap) throws MessagingException {
        DynamicObject cfg = this.getConfig();
        String charset = StringUtil.isEmpty((String)cfg.getString("charset")) ? DEFAULT_CHARSET : cfg.getString("charset");
        MimeMessage message = new MimeMessage(session);
        message.setFrom((Address)new InternetAddress(cfg.getString("user")));
        String to = D.s((Object)toEmailMap.get("to"));
        if (StringUtil.isEmpty((String)to)) {
            throw new IscBizException(ResManager.loadKDString((String)"\u90ae\u4ef6\u53d1\u9001\uff0c\u6536\u4ef6\u4eba\u90ae\u7bb1\u4e3a\u7a7a\u3002", (String)"SmtpConnectionWrapper_cc", (String)"isc-iscb-connector-email", (Object[])new Object[0]));
        }
        String cc = D.s((Object)toEmailMap.get("cc"));
        try {
            message.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)to));
            if (!StringUtil.isEmpty((String)cc)) {
                message.setRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)cc));
            }
            message.setSubject(MimeUtility.encodeText((String)D.s((Object)toEmailMap.get("subject")), (String)charset, null), charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new IscBizException(ResManager.loadKDString((String)"\u90ae\u4ef6\u6807\u9898encode\u5931\u8d25\u662f\uff1a", (String)"SmtpConnectionWrapper_encode", (String)"isc-iscb-connector-email", (Object[])new Object[0]), (Throwable)e);
        }
        String type = EmailUtil.getType(charset);
        MimeBodyPart content = new MimeBodyPart();
        content.setContent((Object)Json2.toString((Object)toEmailMap.get("content")), type);
        MimeMultipart multipart = new MimeMultipart();
        multipart.addBodyPart((BodyPart)content);
        if (!billMap.isEmpty()) {
            EmailUtil.buildMultipart(multipart, billMap, charset);
        }
        message.setContent((Multipart)multipart);
        message.setSentDate(new Date());
        message.saveChanges();
        return message;
    }

    private Properties getProps() {
        DynamicObject cfg = this.getConfig();
        int timeout = D.i((Object)cfg.get("attr1")) <= 0 ? 3000 : D.i((Object)cfg.get("attr1")) * 1000;
        Properties props = new Properties();
        props.setProperty("mail.transport.protocol", PROTOCOL);
        props.setProperty("mail.smtp.host", D.s((Object)cfg.get("server_ip")));
        props.setProperty("mail.smtp.port", D.s((Object)cfg.get("server_port")));
        props.setProperty("mail.smtp.auth", "true");
        props.setProperty("mail.smtp.connectiontimeout", D.s((Object)timeout));
        props.setProperty("mail.smtp.timeout", D.s((Object)timeout));
        if (D.x((Object)cfg.get("attr2"))) {
            props.setProperty("mail.smtp.starttls.enale", "true");
            props.setProperty("mail.smtp.ssl.enable", "true");
            props.setProperty("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            props.setProperty("mail.smtp.socketFactory.fallback", "false");
            props.setProperty("mail.smtp.socketFactory.port", D.s((Object)cfg.get("server_port")));
        }
        return props;
    }

    private void closeTransport(Transport ts) {
        if (ts != null) {
            try {
                ts.close();
            }
            catch (MessagingException e) {
                throw new IscBizException(ResManager.loadKDString((String)"\u5173\u95ed\u90ae\u4ef6\u53d1\u9001\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a", (String)"SmtpConnectionWrapper_sendClose", (String)"isc-iscb-connector-email", (Object[])new Object[0]), (Throwable)e);
            }
        }
    }
}

