/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.formplugin.plugin;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.param.AppParam;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.FloatMenu;
import kd.bos.form.control.Label;
import kd.bos.form.control.TreeMenu;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.TreeMenuClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.util.StringUtils;
import kd.isc.iscb.platform.core.app.AppParameterServiceHelper;
import kd.isc.iscb.platform.core.license.n.LicenseCache;
import kd.isc.iscb.platform.core.license.n.TenantInfo;
import kd.isc.iscb.platform.core.solution.PublicResourceUtil;
import kd.isc.iscb.util.dt.D;

public class ApphomeGridPlugin
extends AbstractFormPlugin
implements TreeMenuClickListener,
TabSelectListener {
    private static Log logger = LogFactory.getLog(ApphomeGridPlugin.class);

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        boolean visibleNewFeature = true;
        try {
            HashMap<String, Integer> param = new HashMap<String, Integer>();
            param.put("pageNo", 1);
            param.put("pageSize", 1);
            Map data = PublicResourceUtil.queryDataByGet((String)"kapi/v2/kdec/kdec_eip_resource/kdec_isc_new_feature/query_isc_new_feature", param, (int)1500);
            if (D.i(data.get("totalCount")) <= 0) {
                visibleNewFeature = false;
            }
        }
        catch (Throwable t) {
            logger.warn("\u9996\u9875\u83b7\u53d6\u65b0\u589e\u7279\u6027\u6570\u636e\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a", t);
            visibleNewFeature = false;
        }
        this.getView().setVisible(Boolean.valueOf(RequestContext.get().getLang() == Lang.zh_CN), new String[]{"flex_card_solution"});
        visibleNewFeature = RequestContext.get().getLang() == Lang.zh_CN && visibleNewFeature;
        this.getView().setVisible(Boolean.valueOf(visibleNewFeature), new String[]{"flex_new_feature"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.tipLicenseExpireInfo();
    }

    private void tipLicenseExpireInfo() {
        long daysBetween;
        String expiredDateStr;
        TenantInfo tenantInfo = LicenseCache.getTenant();
        String expiredDateStrX = expiredDateStr = tenantInfo.getExpiredDate();
        Date expiredDate = this.string2date(expiredDateStr, "yyyy-MM-dd");
        if (D.getDateFormat((String)expiredDateStr).equals("yyyy-MM-dd")) {
            expiredDateStrX = expiredDateStr + " 23:59:59";
        }
        if ((daysBetween = this.getDaysBetween(expiredDateStrX)) <= 30L) {
            String tipText = String.format(ResManager.loadKDString((String)"%1$s\u8bb8\u53ef\u5728\uff08%2$s\uff09\u5230\u671f\uff0c\u8bf7\u5c3d\u5feb\u7eed\u8d39\u3002", (String)"ApphomeGridPlugin_9", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), tenantInfo.getGroupName(), expiredDateStrX);
            this.getView().setVisible(Boolean.TRUE, new String[]{"license_flex"});
            Control control = this.getView().getControl("tip_label");
            if (control instanceof Label) {
                Label label = (Label)control;
                label.setText(tipText);
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"license_flex"});
        }
    }

    private long getDaysBetween(String expiredDate) {
        return (D.t((Object)expiredDate).getTime() - System.currentTimeMillis()) / 86400000L;
    }

    private Date string2date(String str, String pattern) {
        SimpleDateFormat format = null;
        format = StringUtils.isNotEmpty((String)pattern) ? new SimpleDateFormat(pattern) : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = null;
        if (StringUtils.isNotEmpty((String)str)) {
            try {
                date = format.parse(str);
            }
            catch (ParseException e) {
                throw new KDException(new ErrorCode("00", "Date Parse Error"), new Object[]{str});
            }
        }
        return date;
    }

    private String date2str(Date date, String pattern) {
        if (null == date) {
            return null;
        }
        SimpleDateFormat format = null;
        format = StringUtils.isNotEmpty((String)pattern) ? new SimpleDateFormat(pattern) : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return format.format(date);
    }

    public void registerListener(EventObject event) {
        TreeMenu tree = (TreeMenu)this.getView().getControl("navigationbar");
        tree.addTreeMenuClickListener((TreeMenuClickListener)this);
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
        FloatMenu floatMenu = (FloatMenu)this.getControl("floatmenu");
        if (floatMenu != null) {
            floatMenu.addItemClickListener((ItemClickListener)this);
        }
    }

    public void treeMenuClick(TreeNodeEvent treeNodeEvent) {
        String nodeId = D.s((Object)treeNodeEvent.getNodeId());
        if ("1660736548527688704".equals(nodeId)) {
            String devPortalUrl = D.s((Object)SystemParamServiceHelper.loadAppParameterFromCache((AppParam)AppParameterServiceHelper.getAppParam(), (String)"dev_portal_url"));
            if (StringUtils.isEmpty((String)devPortalUrl)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u53d1\u8005\u95e8\u6237url\u672a\u914d\u7f6e\u3002\u8bf7\u524d\u5f80\u7cfb\u7edf\u670d\u52a1\u4e91-\u914d\u7f6e\u5de5\u5177-\u53c2\u6570\u914d\u7f6e-\u3010\u96c6\u6210\u7ba1\u7406\u7cfb\u7edf\u53c2\u6570\u3011\u754c\u9762\u8fdb\u884c\u5f00\u53d1\u8005\u95e8\u6237url\u914d\u7f6e\u3002", (String)"ApphomeGridPlugin_8", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                treeNodeEvent.setCancel(true);
                return;
            }
            this.getView().openUrl(devPortalUrl);
        }
    }

    public void treeMenuDoubleClick(TreeNodeEvent treeNodeEvent) {
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if ("refresh".equals(key)) {
            this.setCurrentTabCard("isc_monitortab_card", "tabpageap");
        }
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String value;
        if (tabSelectEvent.getTabKey().equals("tabpageap")) {
            String value2 = this.getView().getPageCache().get("monitor_page");
            if (value2 == null) {
                this.getView().getPageCache().put("monitor_page", "monitor_page");
                this.setCurrentTabCard("isc_monitortab_card", "tabpageap");
            }
        } else if (tabSelectEvent.getTabKey().equals("tabpageap1") && (value = this.getView().getPageCache().get("devops_page")) == null) {
            this.getView().getPageCache().put("devops_page", "devops_page");
            this.setCurrentTabCard("isc_devopstab_card", "tabpageap1");
        }
    }

    private void setCurrentTabCard(String isc_monitortab_card, String tabpageap) {
        HashMap params = new HashMap();
        FormShowParameter param = new FormShowParameter();
        param.setFormId(isc_monitortab_card);
        param.setAppId("iscb");
        param.setCustomParams(params);
        param.setParentPageId(this.getView().getPageId());
        param.setStatus(OperationStatus.VIEW);
        param.getOpenStyle().setShowType(ShowType.InContainer);
        param.getOpenStyle().setTargetKey(tabpageap);
        StyleCss css = new StyleCss();
        css.setWidth("100%");
        param.getOpenStyle().setInlineStyleCss(css);
        this.getView().showForm(param);
    }
}

